# WhatsApp Bildirim Sistemi ve notification_log Rehberi

## Genel Bakış

`notification_log` sistemi, WhatsApp bildirimlerinin düzgün çalışmasını sağlamak ve tekrarlayan bildirimleri önlemek için geliştirilmiştir. Bu sistem, bildirim gönderimlerini izler ve aynı bildirimin tekrar gönderilmesini engeller.

## notification_log Tablosu

```sql
CREATE TABLE IF NOT EXISTS notification_log (
    id INT AUTO_INCREMENT PRIMARY KEY,
    appointment_id INT NOT NULL,
    phone VARCHAR(20) NOT NULL,
    notification_type VARCHAR(20) NOT NULL,
    sent_at DATETIME NOT NULL,
    success TINYINT(1) DEFAULT 1
);
```

### Tablo Alanları

- **id**: Otomatik artan benzersiz ID
- **appointment_id**: Randevu ID'si
- **phone**: Alıcı telefon numarası 
- **notification_type**: Bildirim tipi
- **sent_at**: Gönderim zamanı
- **success**: Başarı durumu (1=başarılı, 0=başarısız)

## Çalışma Prensibi

1. **Tekrarlayan Bildirim Kontrolü**
   - Her bildirim gönderilmeden önce son 2 dakika içinde aynı randevu, telefon ve tip için başka bir bildirim gönderilip gönderilmediği kontrol edilir
   - Eğer gönderilmişse, bildirim atlanır
   
2. **Bildirim Kaydı**
   - Bildirim gönderiminden önce success=0 olarak bir kayıt oluşturulur
   - Gönderim başarılı olursa kayıt success=1 olarak güncellenir
   - Böylece eş zamanlı istekler sırasında bile bildirim sadece bir kez gönderilir

3. **Randevu Oluşturma Kaydı**
   - Yeni bir randevu oluşturulduğunda 'randevu_olusturma' tipi ile bir kayıt oluşturulur
   - Bu, diğer bildirim kontrolleri için başlangıç noktası olarak kullanılır

## Bildirim Tipleri

1. **alindi**: Randevu alındığında müşteriye gönderilen bildirim (notification_settings tablosunda ID: 1)
2. **calisan_bildirim**: Randevu alındığında çalışana gönderilen bildirim (notification_settings tablosunda ID: 8)
3. **guncelleme**: Randevu güncellendiğinde gönderilen bildirim (notification_settings tablosunda ID: 4)
4. **iptal**: Randevu iptal edildiğinde gönderilen bildirim (notification_settings tablosunda ID: 7)
5. **randevu_olusturma**: Randevu oluşturulduğunda oluşturulan işlem kaydı (bildirim değil)

## Bakım

Eski kayıtları temizlemek için `notification_log_cleanup.php` dosyası oluşturulmuştur. Bu dosyayı düzenli aralıklarla çalıştırmak için bir cron görevi ekleyebilirsiniz:

```bash
# Her gün gece yarısı çalıştır
0 0 * * * php /yol/admin/system/settings/notification_log_cleanup.php
```

## Şablon Kontrolleri

Şablonlarınızda değişken sorunlarını önlemek için:

1. `notification_settings` tablosunda her bildirim tipinin şablonunu kontrol edin
2. Kullanılan tüm değişkenlerin (`{uyeAdi}`, `{tarih}`, vb.) ilgili mesaj gönderimlerinde sağlandığından emin olun
3. İd 1 - alindi, Id 8 - calisan_bildirim tiplerinin doğru olduğundan emin olun

## Hata Ayıklama

WhatsApp bildirimleri ile ilgili sorunları izlemek için:

1. `/whatsapp_debug.txt`: Genel WhatsApp işlemleri logu
2. `/randevu_debug.txt`: Detaylı hata ayıklama logu

## Ek Notlar

1. Bildirim kontrolü şu an 2 dakika olarak ayarlanmıştır; ihtiyaç halinde bu süre ayarlanabilir.
2. Şablonlarda değiştirilmemiş değişkenler (`{uyeAdi}` gibi) varsa mesaj gönderilmez.
3. Boş değişkenler her zaman loglanır.
4. notification_log tablosunda performans için `appointment_id` ve `phone` üzerinde indeks oluşturulabilir.