# WhatsApp Bildirim Sorunu Çözümü

## Sorun

WhatsApp bildirimleri randevu oluşturulduğunda müşteriye 5 kez tekrar tekrar gönderiliyor. Bu sorunun nedenleri:

1. Aynı bildirim farklı yöntemlerle birden fazla kez çağırılıyor
2. Kontrol mekanizması sadece randevuID üzerinden çalışıyor, farklı tiplerdeki mesajlar kontrol edilmiyor
3. Hem doğrudan mesaj hem de şablon mesajı ayrı ayrı gönderiliyor

## Yapılan Değişiklikler

### 1. whatsapp_functions.php Değişiklikleri

- **Gelişmiş Kontrol Mekanizması**: Artık bildirimler hem randevuID hem telefon numarası hem de mesaj tipine göre kontrol ediliyor
- **Önceden Log Kaydı**: Mesaj gönderilmeden önce bir kayıt oluşturuluyor, böylece eş zamanlı istekler engelleniyor
- **Echo Kullanımını Kaldırma**: Ekrana yazdırma işlemleri global değişkene alındı
- **Tablo Oluşturma**: Tablo yoksa otomatik oluşturma desteği eklendi
- **İyileştirilmiş Log**: Daha detaylı hata ayıklama logları eklendi

### 2. eral.php Değişiklikleri

- **Doğrudan Mesaj İyileştirmesi**: Artık randevuID ile gönderiliyor
  ```php
  $whatsapp_message_vars = array(
      'randevuID' => $eklenenRandevu,
      'musteriAdi' => $musteriAd,
      'telefon' => $number
  );
  $whatsapp_result = sendWhatsAppMessage($number, $message, 'dogrudan', $whatsapp_message_vars);
  ```

- **Şablon Mesajı Kontrolü**: Önceden doğrudan mesaj gönderildiyse şablonu gönderme
  ```php
  if ($whatsappBildirimGonderildi) {
      file_put_contents($debug_log_file, "Müşteriye zaten doğrudan WhatsApp mesajı gönderilmiş, şablon gönderilmiyor\n", FILE_APPEND);
      $wa_result = true; // Zaten gönderilmiş kabul edilsin
  } else {
      $wa_result = sendWhatsAppMessage($number, "", "alindi", $messageVars);
      if ($wa_result) {
          $whatsappBildirimGonderildi = true;
      }
  }
  ```

- **Çalışan Bildirimlerinde Farklı Tip**: Çalışan bildirimlerinde farklı mesaj tipi kullanılıyor
  ```php
  $wa_result = sendWhatsAppMessage($calisanNumber, "", "calisan_bildirim", $calisanVars);
  ```

- **randevuID Ekleme**: Tüm gönderim fonksiyonlarına randevuID eklendi
  ```php
  if (!isset($messageVars['randevuID']) && isset($id)) {
      $messageVars['randevuID'] = $id;
  }
  ```

## Nasıl Çalışıyor?

1. Bildirim gönderilmeden önce telefon, randevuID ve tip kontrolü yapılır
2. Aynı türde bir bildirim son 5 dakika içinde gönderilmişse işlem atlanır
3. Gönderim başlamadan önce notification_log tablosuna success=0 olarak kayıt atılır
4. Gönderim işlemi başarılı olursa success=1 olarak güncellenir
5. Farklı bildirim türleri ('dogrudan', 'alindi', 'calisan_bildirim', vb.) ile çakışmalar önlenir

Bu sistem artık tüm bildirim kanallarını izleyip, mükerrer bildirimleri önleyecektir.

## İleriye Dönük Tavsiyeler

1. Tüm bildirim yönetimini tek bir yerden yapın
2. Doğrudan/şablon ayrımını kaldırın, hepsini şablonla gönderin
3. SMS ve WhatsApp kanalları için ortak bir loglama sistemi oluşturun
4. Arka planda çalışan işlemleri kaldırın veya asenkron işleme değiştirin
5. notification_log tablosunu düzenli olarak temizleyin (örn. 30 gün önceki kayıtları sil)