# WhatsApp Bildirim Sorunları Çözümü - Final

## Sorun

Randevu oluşturulduğunda müşteriye aynı WhatsApp mesajı birden fazla kere gönderiliyor:

1. Farklı kod bölümlerinde aynı bildirim tekrar tekrar gönderiliyor
2. notification_log tablosuna rağmen işlem kontrolü yeterli değil
3. Farklı formatlarda aynı mesaj gönderiliyor (saniyeli/saniyesiz tarih, değişken/değer, vb.)

## Yapılan Değişiklikler

### 1. Tek Bildirim Kaynağı

En önemli değişiklik: **WhatsApp bildirimleri artık tek bir kod bloğundan gönderiliyor**

```php
// notification_log tablosunda bu randevu için bildirim gönderilip gönderilmediğini kontrol et
if (function_exists('sendWhatsAppMessage') && $settings['whatsappSystem'] == '1') {
    // Randevu ID'ye göre son 30 saniyede gönderilmiş bildirim var mı kontrol et
    try {
        $check_query = $DB->prepare("SELECT COUNT(*) FROM notification_log WHERE 
            appointment_id = ? AND notification_type = ? AND 
            sent_at > DATE_SUB(NOW(), INTERVAL 30 SECOND)");
        $check_query->execute(array($eklenenRandevu, 'alindi'));
        $notification_count = $check_query->fetchColumn();
        
        if ($notification_count > 0) {
            file_put_contents($debug_log_file, "Son 30 saniyede zaten bildirim gönderilmiş, tekrar gönderilmeyecek\n", FILE_APPEND);
            $whatsappBildirimGonderildi = true;
        } else {
            // Müşteriye WhatsApp gönder
            file_put_contents($debug_log_file, "Müşteriye WhatsApp gönderiliyor: " . $number . "\n", FILE_APPEND);
            $wa_result = sendWhatsAppMessage($number, "", "alindi", $messageVars);
            // Başarılı olursa bayrak set et
            if ($wa_result) {
                $whatsappBildirimGonderildi = true;
            }
        }
    } catch (Exception $e) {
        file_put_contents($debug_log_file, "Bildirim kontrolünde hata: " . $e->getMessage() . "\n", FILE_APPEND);
    }
}
```

### 2. Eski Bildirim Kodlarının Devre Dışı Bırakılması

1. **Doğrudan mesaj gönderme kaldırıldı**
   ```php
   // WhatsApp bildirimi artık burada gönderilmiyor
   // Bildirimler tek bir yerden, sonraki kod bloğunda gönderiliyor
   if ($settings['whatsappSystem'] == '1') {
       file_put_contents($debug_log_file, "WhatsApp bildirimi sonraki blokta gönderilecek\n", FILE_APPEND);
   }
   ```

2. **Çalışan SMS bildirimi kaldırıldı**
   ```php
   // BU BLOK DEVRE DIŞI BIRAKILDI - çift bildirim sorunu yaratıyor
   if (false && function_exists('sendWhatsAppMessage')) {
       file_put_contents($debug_log_file, "Çalışan için sendWhatsAppMessage fonksiyonu devre dışı bırakıldı\n", FILE_APPEND);
       // $whatsapp_result = sendWhatsAppMessage($calisanNumber, $calisanMessage);
       $whatsapp_result = false;
   }
   ```

### 3. Daha Sıkı Bildirim Kontrolü

1. **30 saniyelik kontrol** - Hızlı işlemlerde çift bildirimi engeller
   ```php
   $check_query = $DB->prepare("SELECT COUNT(*) FROM notification_log WHERE 
       appointment_id = ? AND notification_type = ? AND 
       sent_at > DATE_SUB(NOW(), INTERVAL 30 SECOND)");
   ```

2. **Çalışana bildirimde benzer kontrol**
   ```php
   $check_query = $DB->prepare("SELECT COUNT(*) FROM notification_log WHERE 
       appointment_id = ? AND notification_type = ? AND phone LIKE ? AND
       sent_at > DATE_SUB(NOW(), INTERVAL 30 SECOND)");
   $check_query->execute(array($eklenenRandevu, 'calisan_bildirim', '%' . $calisanNumber . '%'));
   ```

## Şablonların İyileştirilmesi

WhatsApp bildirimlerinin sorunsuz gönderilmesi için:

1. Şablon kontrolü iyileştirildi - Değiştirilmemiş veya boş değişkenleri tespit eder
2. Tüm şablonlar önceden notification_settings tablosunda doğru ayarlandı
3. Değişkenler her zaman doğru atar (örneğin uyeAdi değişkeni boşsa musteriAd kullanılır)

## Nasıl Çalışıyor?

1. Randevu oluştuğunda notification_log tablosuna bir kayıt oluşturulur
2. WhatsApp bildirimi göndermeden önce son 30 saniyede aynı tipteki bildirimler kontrol edilir 
3. Bildirim yoksa gönderilir, varsa atlanır
4. Şablon içindeki değişkenleri doldururken, boş değişkenler kontrol edilir ve doldurulur
5. Şablonda hala değiştirilmemiş değişken varsa bildirim gönderilmez

Bu sistem sayesinde:
- Artık bir randevu için sadece bir kez bildirim gönderilir
- Şablonlardaki değişken sorunları önceden tespit edilir
- Hem müşteri hem çalışan bildirimleri düzgün şekilde ayrılır

## Dikkat Edilmesi Gerekenler

1. notification_settings tablosunda şablonları kontrol edin:
   - Id 1: Müşteri Bildirimi (alindi)
   - Id 8: Çalışan Bildirimi (calisan_bildirim)

2. Değişken kontrolü:
   - Kullanılan tüm değişkenlerin değerleri dolu olmalı
   - Şablonda kullanılan değişkenler eral.php'de tanımlanmalı

3. Bildirim zaman aralığı:
   - Şu anda 30 saniye olarak ayarlı, gerekirse artırılabilir