# WhatsApp Bildirim Sorunu Çözümü - Güncelleme

## Sorun

WhatsApp bildirimleri randevu oluşturulduğunda müşteriye 3 farklı mesaj gönderiliyor:
1. **Hatalı Mesaj 1**: Saniye bilgisi içeren ve doğrudan gönderilen mesaj
2. **Hatalı Mesaj 2**: Değişkenleri (`{uyeAdi}` gibi) dönüştürülmemiş şablon mesajı
3. **Doğru Mesaj**: Sadece bu mesajın gönderilmesi gerekiyor

## Yapılan Değişiklikler

### 1. whatsapp_functions.php Değişiklikleri

1. **Şablon Değişken Kontrolü**:
   - Artık şablonda değiştirilmemiş değişkenler (`{uyeAdi}` gibi) varsa mesaj gönderilmiyor
   - Boş değişkenler algılanıp log dosyasına kaydediliyor

2. **Mesaj Tipi Yönetimi**:
   - Doğrudan mesaj tipi artık "alindi" olarak işleniyor
   - Çalışan bildirimleri için "calisan_bildirim" tipi eklendi (ID: 8)

3. **Boş Değişken Kontrolü**:
   ```php
   if (strpos($message, '{' . $key . '}') !== false && empty($value)) {
       $has_empty_vars = true;
       $empty_vars[] = $key;
       file_put_contents($whatsapp_log_file, "UYARI: {" . $key . "} değişkeni boş!\n", FILE_APPEND);
   }
   ```

4. **Şablon Kontrolü**:
   ```php
   if (preg_match('/\{[a-zA-Z0-9_]+\}/', $message, $matches)) {
       $has_empty_vars = true;
       file_put_contents($whatsapp_log_file, "UYARI: Şablonda değiştirilmemiş değişken var: " . implode(', ', $matches) . "\n", FILE_APPEND);
   }
   ```

### 2. eral.php Değişiklikleri

1. **Doğrudan Mesaj İşlemini Kaldırma**:
   ```php
   // Artık doğrudan mesaj göndermiyoruz, sadece şablonu kullanacağız
   // $whatsapp_result = sendWhatsAppMessage($number, $message, 'dogrudan', $whatsapp_message_vars);
   $whatsapp_result = false; // Doğrudan mesaj gönderme işlemi kapalı
   ```

2. **Şablon Kontrolü İyileştirme**:
   ```php
   // Değişkenleri kontrol et - özellikle uyeAdi'nin doğru olduğundan emin ol
   if (empty($messageVars['uyeAdi']) || $messageVars['uyeAdi'] == '{uyeAdi}') {
       $messageVars['uyeAdi'] = $musteriAd;
       file_put_contents($debug_log_file, "uyeAdi değişkeni düzeltildi: " . $musteriAd . "\n", FILE_APPEND);
   }
   ```

3. **Çalışan Bildirimi Ayrı Tip Olarak Kullanma**:
   ```php
   // Çalışan için farklı bildirim tipi kullan ki karışmasın
   $wa_result = sendWhatsAppMessage($calisanNumber, "", "calisan_bildirim", $calisanVars);
   ```

4. **Diğer Bildirimlere randevuID Ekleme**: Tüm bildirim fonksiyonlarına randevuID parametresi eklendi

### 3. Yeni SQL İşlemleri - whatsapp_calisan_bildirim.sql

```sql
-- Notification_settings tablosuna çalışan bildirimi için yeni kayıt ekle
INSERT INTO notification_settings (id, name, description, type, template, status)
SELECT 8, 'Çalışan Bildirim', 'Randevu alındığında çalışana gönderilecek bildirim', 'whatsapp', 
       'Sayın {calisan}, {uyeAdi} adlı müşteri tarafından {tarih} tarihinde saat {saat} için {hizmet} randevusu alınmıştır. İyi çalışmalar dileriz.', 1
FROM dual
WHERE NOT EXISTS (
    SELECT 1 FROM notification_settings WHERE id = 8
);

-- Notification_settings tablosunu kontrol et ve boş şablonları düzelt
UPDATE notification_settings 
SET template = REPLACE(template, '{uyeAdi}', 'Müşteri')
WHERE template LIKE '%{uyeAdi}%' AND status = 1;
```

## Kurulum

1. **whatsapp_functions.php ve eral.php dosyalarını güncelleyin**
2. **Çalışan bildirimi için notification_settings tablosunu güncelleyin**:
   ```
   mysql -u kullanici -p veritabani < whatsapp_calisan_bildirim.sql
   ```
3. **notification_settings tablosundaki tüm şablonları kontrol edin**:
   - Tüm şablonlarda değişkenlerin doğru kullanıldığından emin olun
   - `{uyeAdi}`, `{tarih}`, `{saat}` gibi değişkenlerin karşılığı olduğundan emin olun
   - Çalışan şablonlarının farklı olduğunu doğrulayın (ID: 8)

## Nasıl Çalışıyor?

1. Doğrudan mesaj gönderimi artık tamamen kapatıldı
2. Şablonlarda değişken değişimi öncesinde ve sonrasında kontrol yapılıyor
3. Değiştirilmemiş değişkenler (`{uyeAdi}` gibi) kalmışsa mesaj gönderilmiyor
4. Her bildirim tipi ayrı bir ID ile takip ediliyor
5. Müşteri ve çalışan bildirimleri farklı tiplerle ayrılıyor

Bu değişiklikler sayesinde artık sadece tek ve doğru formatlı mesaj gönderilecektir.