# CLAUDE.md for Randevu Sistemi

## Development Commands
- **Local Server**: `php -S localhost:8000` (from project root)
- **Debug Logs**: Check `/admin/system/logs/` for debug files
  - `ajax_debug_YYYY-MM-DD.log` - AJAX operation logs
  - `provider_ajax_YYYY-MM-DD.log` - Provider API logs
  - `randevu_alg_YYYY-MM-DD.log` - Appointment algorithm logs
  - `error.log` - General PHP errors

## Code Guidelines
- **Backend**: PHP with PDO for MySQL operations (prepared statements required)
- **Frontend**: jQuery, Bootstrap 5, SweetAlert2, FullCalendar, Flatpickr
- **File Naming**: CamelCase for PHP files (e.g., `RandevuAlgoritma.php`)
- **DB Fields**: snake_case for database columns
- **Error Handling**: Use `logRandevu()` or `logDebug()` functions for server logging
- **AJAX Responses**: JSON format with status and message properties
- **Validation**: Always validate input parameters server-side
- **Service Providers**: "Provider" prefix for service provider files
- **Date Formats**: Store as MySQL datetime (Y-m-d H:i:s), display using user locale
- **Overnight Shifts**: Add 24 hours when end time is before start time
- **Special Days**: Special calendar handling for holidays/custom business hours
- **Time Slots**: Use 15 minute increments as base time unit
- **Cache**: Store computed time slots in `/admin/system/cache/` with 5 minute TTL
- **Modal Design**: Use custom CSS in `/admin/app-assets/css/custom/` for UI elements