/**
 * App Calendar
 */

/**
 * ! If both start and end dates are same Full calendar will nullify the end date value.
 * ! Full calendar will end the event on a day before at 12:00:00AM thus, event won't extend to the end date.
 * ! We are getting events from a separate file named app-calendar-events.js. You can add or remove events from there.
 **/

'use-strict';

// RTL Support
var direction = 'ltr',
  assetPath = '../../../assets/';
if ($('html').data('textdirection') == 'rtl') {
  direction = 'rtl';
}

if ($('body').attr('data-framework') === 'laravel') {
  assetPath = $('body').attr('data-asset-path');
}

$(document).on('click', '.fc-sidebarToggle-button', function (e) {
  $('.app-calendar-sidebar, .body-content-overlay').addClass('show');
});

$(document).on('click', '.body-content-overlay', function (e) {
  $('.app-calendar-sidebar, .body-content-overlay').removeClass('show');
});

document.addEventListener('DOMContentLoaded', function () {
  try {
    var calendarEl = document.getElementById('calendar');
    
    // Takvim elementi mevcut değilse işlemi durdur
    if (!calendarEl) {
      console.log("Takvim elementi bulunamadı, işlem durduruldu.");
      return;
    }
    
    var eventToUpdate,
      sidebar = $('.event-sidebar'),
      calendarsColor = {
        Business: 'primary',
        Holiday: 'success',
        Family: 'warning',
        ETC: 'info'
      },
      eventForm = $('.event-form'),
      addEventBtn = $('.add-event-btn'),
      cancelBtn = $('.btn-cancel'),
      updateEventBtn = $('.update-event-btn'),
      toggleSidebarBtn = $('.btn-toggle-sidebar'),
      eventTitle = $('#title'),
      eventLabel = $('#select-label'),
      startDate = $('#start-date'),
      endDate = $('#end-date'),
      eventUrl = $('#event-url'),
      eventGuests = $('#event-guests'),
      eventLocation = $('#event-location'),
      allDaySwitch = $('.allDay-switch'),
      selectAll = $('.select-all'),
      calEventFilter = $('.calendar-events-filter'),
      filterInput = $('.input-filter'),
      btnDeleteEvent = $('.btn-delete-event'),
      calendarEditor = $('#event-description-editor');

    // --------------------------------------------
    // On add new item, clear sidebar-right field fields
    // --------------------------------------------
    $('.add-event button').on('click', function (e) {
      $('.event-sidebar').addClass('show');
      $('.sidebar-left').removeClass('show');
      $('.app-calendar .body-content-overlay').addClass('show');
    });

    $('#randevuEkleButton').on('click', function (e) {
      document.getElementById("randevuOlustur").reset();
      $('#secimEkran').show();
      $('#mevcutMusteri').hide();
      $('#musteriDuzenle').hide();
      $('#adSoyad').hide();
      $('#telefon').hide();
      $('#email').hide();
      $('#timeSelect').html("");
      $('#randevuDuzenle').val('0');
      $('#randevuEkleDurum').val('1');
      $('#inlineRadio1').attr('checked', false);
      $("#providerList").html("");
      $('#note').remove();
      $("#noteDiv").html('<div class="mb-1" id="note"><label class="form-label">Randevu Notu</label><input type="text" class="form-control" name="note" id="note" placeholder="Not yazınız" "/></div>');
      $('#sendSmsDiv').hide();
    });
    
    // Tüm Randevuları Göster butonuna tıklandığında
    $('#tumRandevularButton').on('click', function (e) {
      // Doğrudan AJAX ile tüm randevuları getir
      $.ajax({
        url: '/json',
        type: 'GET',
        data: { view: 'allAppointmentsList' },
        success: function(data) {
          try {
            if (typeof window.calendar !== 'undefined' && window.calendar) {
              // Güvenli şekilde takvim operasyonlarını dene
              try {
                // Kullanıcıya bildirim
                Swal.fire({
                  title: 'Bilgi',
                  text: 'Tüm randevular listeleniyor...',
                  icon: 'info',
                  timer: 1500,
                  showConfirmButton: false
                });
                
                // Listview modunu dene
                if (window.calendar.hasOwnProperty('changeView')) {
                  window.calendar.changeView('listWeek');
                  
                  // Başlığı değiştir
                  setTimeout(function() {
                    $('.fc-toolbar-title').text('TÜM RANDEVULAR');
                  }, 150);
                  
                  // Takvimi yenile
                  window.calendar.refetchEvents();
                }
              } catch (e) {
                console.log("Takvim görünüm değiştirme hatası: " + e.message);
              }
            } else {
              // Takvim yüklenmemiş durumda
              console.log("Takvim yüklenmemiş, manuel yeniden yükleme yapılıyor");
              location.reload();
            }
          } catch (e) {
            console.log("Takvim işleme hatası: " + e.message);
          }
        },
        error: function(xhr, status, error) {
          console.log("AJAX hatası: " + error);
        }
      });
    });

    // Label select
    if (eventLabel.length) {
      function renderBullets(option) {
        if (!option.id) {
          return option.text;
        }
        var $bullet =
          "<span class='bullet bullet-" +
          $(option.element).data('label') +
          " bullet-sm me-50'> " +
          '</span>' +
          option.text;

        return $bullet;
      }
      eventLabel.wrap('<div class="position-relative"></div>').select2({
        placeholder: 'Select value',
        dropdownParent: eventLabel.parent(),
        templateResult: renderBullets,
        templateSelection: renderBullets,
        minimumResultsForSearch: -1,
        escapeMarkup: function (es) {
          return es;
        }
      });
    }

    // Guests select
    if (eventGuests.length) {
      eventGuests.wrap('<div class="position-relative"></div>').select2({
        placeholder: 'Müşteri Seçin',
        dropdownParent: eventGuests.parent(),
        closeOnSelect: true,
        escapeMarkup: function (es) {
          return es;
        }
      });
    }

    // End date picker
    if (endDate.length) {
      var end = endDate.flatpickr({
        altFormat: 'd-m-YTH:i',
        onReady: function (selectedDates, dateStr, instance) {
          if (instance.isMobile) {
            $(instance.mobileInput).attr('step', null);
          }
        }
      });
    }

    // Event click function
    function eventClick(info) {
      try {
        eventToUpdate = info.event;
        if (eventToUpdate.url) {
          info.jsEvent.preventDefault();
          window.open(eventToUpdate.url, '_blank');
        }
        $('#edit').val(eventToUpdate.extendedProps.location);
        $("#service option").prop("selected", false);
        $('#service'+eventToUpdate.id).prop('selected', true);
        $('#randevuDuzenle').val('1');
        $('#randevuEkleDurum').val('0');
        $('#musteriDuzenle').show();
        $('#sendSmsDiv').show();
        $.ajax({
          type: "POST",
          url: "../admin/system/ajax/ProviderAjax.php",
          data: {
            "serviceID": eventToUpdate.id
          },
          success: function(e) {
            $("#providerList").html(e);
            $("#timeSelect").html("");
            $('#provider'+eventToUpdate.extendedProps.calendar).attr('selected', true);
            if(eventToUpdate.extendedProps.paymentStatus=='0'){
              $('#odemeyapmadi').attr('selected', true);
            }else if(eventToUpdate.extendedProps.paymentStatus=='1' && eventToUpdate.extendedProps.payment=='Nakit'){
              $('#nakit').attr('selected', true);
            }else if(eventToUpdate.extendedProps.paymentStatus=='1' && eventToUpdate.extendedProps.payment=='Havale'){
              $('#havale').attr('selected', true);
            }else if(eventToUpdate.extendedProps.paymentStatus=='1' && eventToUpdate.extendedProps.payment=='Kredi'){
              $('#kredi').attr('selected', true);
            }
            if(eventToUpdate.extendedProps.coming=='1'){
              $('#geldi').attr('selected', true);
            }else{
              $('#gelmedi').attr('selected', true);
            }
          }
        });

        $('#providerID').val(eventToUpdate.extendedProps.description);
        $('#inlineRadio1').attr('checked', true);
        $('#secimEkran').hide();
        $('#mevcutMusteri').hide();
        $('#adSoyad').hide();
        $('#telefon').hide();
        $('#email').hide();
        $('#note').remove();
        $("select[name='musteri']").val(eventToUpdate.extendedProps.guests).prop('selected', true);
        var note = info.event.extendedProps.note;
        $("#musteriDuzenle").html('<label for="mevcutMusteriAd" class="form-label">Müşteri</label><input type="text" class="form-control" id="mevcutMusteriAd" name="mevcutMusteriAd" value="'+eventToUpdate.extendedProps.musteriAd+'" disabled/><br><label for="telefonara" class="form-label">Telefon</label><br><a id="telefonara" href="tel:'+eventToUpdate.extendedProps.musteriTel+'">'+eventToUpdate.extendedProps.musteriTel+'</a><br><br><label for="mailat" class="form-label">E-Mail</label><br><a id="mailat" href="mailto:'+eventToUpdate.extendedProps.musteriMail+'">'+eventToUpdate.extendedProps.musteriMail+'</a><br><br><div class="mb-1"><label for="appPayment" class="form-label">Ödeme Durumu</label><select class="select2 select-label form-select w-100" id="appPayment" name="appPayment"><option selected="" disabled="" value="">Seçin</option><option id="odemeyapmadi" value="0">Ödeme Yapmadı</option><option id="havale" value="Havale">Havale</option><option id="nakit" value="Nakit">Nakit</option><option id="kredi" value="Kredi">Kredi Kartı</option></select></div><div class="mb-1"><label for="appComing" class="form-label">Gelme Durumu</label><select class="select2 select-label form-select w-100" id="appComing" name="appComing"><option selected="" disabled="" value="">Seçin</option><option id="geldi" value="1">Geldi</option><option id="gelmedi" value="0">Gelmedi</option></select></div><div class="mb-1" id="note"><label class="form-label">Randevu Notu</label><input type="text" class="form-control" name="note" id="note" placeholder="Not yazınız" value="'+note+'"/></div>');

        sidebar.modal('show');
        addEventBtn.addClass('d-none');
        cancelBtn.addClass('d-none');
        updateEventBtn.removeClass('d-none');
        btnDeleteEvent.removeClass('d-none');

        if (startDate.length) {
          var start = startDate.flatpickr({
            enableTime: true,
            altFormat: 'Y-m-dTH:i:S',
            onReady: function (selectedDates, dateStr, instance) {
              if (instance.isMobile) {
                $(instance.mobileInput).attr('step', null);
              }
            }
          });
        }
        
        start.setDate(eventToUpdate.start, true, 'd-m-Y');
        eventToUpdate.allDay === true ? allDaySwitch.prop('checked', true) : allDaySwitch.prop('checked', false);
        eventToUpdate.end !== null
          ? end.setDate(eventToUpdate.end, true, 'd-m-Y')
          : end.setDate(eventToUpdate.start, true, 'd-m-Y');
          
        // Saati otomatik seçme işlemi için bilgileri sakla
        var startDateTime = new Date(eventToUpdate.start);
        var startTimeString = startDateTime.getHours().toString().padStart(2, '0') + ':' + 
                            startDateTime.getMinutes().toString().padStart(2, '0');
        
        // Saat seçimi için biraz bekle (saatler yüklendikten sonra)
        setTimeout(function() {
          // Radio butonları arasında eşleşen saati bul ve seç
          $('input[name="customOptionsCheckableRadiosWithIcon"]').each(function() {
            var radioValue = $(this).val().substring(0, 5);
            if (radioValue === startTimeString) {
              $(this).prop('checked', true);
              // Label'ı aktif hale getir
              $(this).next('label').addClass('active');
              console.log("Takvimden düzenleme - Saat otomatik seçildi: " + startTimeString);
            }
          });
        }, 1500); // Saatlerin yüklenmesi için 1.5 saniye bekle

        sidebar.find(eventTitle).val(eventToUpdate.title).trigger('change');  
        sidebar.find(eventLabel).val(eventToUpdate.extendedProps.calendar).trigger('change');
        eventToUpdate.extendedProps.location !== undefined ? eventLocation.val(eventToUpdate.extendedProps.location) : null;
        eventToUpdate.extendedProps.guests !== undefined
          ? eventGuests.val(eventToUpdate.extendedProps.guests).trigger('change')
          : null;
        eventToUpdate.extendedProps.guests !== undefined
          ? calendarEditor.val(eventToUpdate.extendedProps.description)
          : null;

        //  Delete Event
        btnDeleteEvent.on('click', function () {
          eventToUpdate.remove();
          // removeEvent(eventToUpdate.id);
          sidebar.modal('hide');
          $('.event-sidebar').removeClass('show');
          $('.app-calendar .body-content-overlay').removeClass('show');
        });
      } catch (e) {
        console.log("Event click hatası: " + e.message);
      }
    }

    // Modify sidebar toggler
    function modifyToggler() {
      try {
        $('.fc-sidebarToggle-button')
          .empty()
          .append(feather.icons['menu'].toSvg({ class: 'ficon' }));
      } catch (e) {
        console.log("modifyToggler hatası: " + e.message);
      }
    }

    // Selected Checkboxes
    function selectedCalendars() {
      try {
        var selected = [];
        $('.calendar-events-filter input:checked').each(function () {
          selected.push($(this).attr('data-value'));
        });
        return selected;
      } catch (e) {
        console.log("selectedCalendars hatası: " + e.message);
        return [];
      }
    }

    // --------------------------------------------------------------------------------------------------
    // AXIOS: fetchEvents
    // * This will be called by fullCalendar to fetch events. Also this can be used to refetch events.
    // --------------------------------------------------------------------------------------------------
    function fetchEvents(info, successCallback) {
      try {
        var calendars = selectedCalendars();
        // We are reading event object from app-calendar-events.js file directly by including that file above app-calendar file.
        // You should make an API call, look into above commented API call for reference
        selectedEvents = events.filter(function (event) {
          return calendars.includes(event.extendedProps.calendar.toLowerCase());
        });
        successCallback(selectedEvents);
      } catch (e) {
        console.log("fetchEvents hatası: " + e.message);
        successCallback([]);
      }
    }

    var settings = "";
    try {
      $.ajax({
        url: '/admin/settingsjson',
        type: 'GET',
        async: false,
        data: { format: 'json' },
        success: function (data) {
          settings = JSON.parse(data);
        }
      });
    } catch (e) {
      console.log("Settings ajax hatası: " + e.message);
    }

    try {
      // Kalenderi global değişken olarak tanımla
      window.calendar = new FullCalendar.Calendar(calendarEl, {
        locale: 'tr',
        allDayText: 'Saat',
        buttonText: {
          resourceTimeGridDay: 'Günlük Liste',
          today: 'Bugün',
          month: 'Ay',
          week: 'Hafta',
          list: 'Tüm Randevular'
        },
        firstDay: 1,
        slotMinTime: settings.timeStart || '08:00:00',
        slotMaxTime: settings.timeEnd || '19:00:00',
        eventTimeFormat: {
          hour: '2-digit',
          minute: '2-digit',
          hour12: false
        },
        slotLabelFormat: {
          hour: '2-digit',
          minute: '2-digit',
          hour12: false
        },
        initialView: 'resourceTimeGridDay', // Başlangıçta günlük liste görünümü kullan
        schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',
        resourceOrder: 'sira', // Kaynakları sıralamak için sira sütununu kullanıyoruz
        resources: '/admin/providerjson',
        resourceLabelContent: function (arg) {
          return { html: arg.resource.extendedProps.html + " " + arg.resource.title };
        },
        eventDidMount: function (info, element) {
          try {
            var musteriAd = info.event.extendedProps.musteriAd;
            var paymentStatus = info.event.extendedProps.paymentStatus;
            var paytrSystem = info.event.extendedProps.paytrSystem;
            if (paytrSystem == '1') {
              if (paymentStatus == '1') {
                $(info.el).find('.fc-event-title').append("<br/>Müşteri: <b>" + musteriAd + "</b><br/>Ödeme:<a style='color: #fff;background-color: green;padding: 2px;border-radius: 5px;margin-left: 5px;'>Ödendi</a>");
                $(info.el).find('.fc-list-event-title').append("<br/>Müşteri: <b>" + musteriAd + "</b><br/>Ödeme:<a style='color: #fff;background-color: green;padding: 2px;border-radius: 5px;margin-left: 5px;'>Ödendi</a>");
              } else {
                $(info.el).find('.fc-event-title').append("<br/>Müşteri: <b>" + musteriAd + "</b><br/>Ödeme:<a style='color: #fff;background-color: red;padding: 2px;border-radius: 5px;margin-left: 5px;'>Ödenmedi</a>");
                $(info.el).find('.fc-list-event-title').append("<br/>Müşteri: <b>" + musteriAd + "</b><br/>Ödeme:<a style='color: #fff;background-color: red;padding: 2px;border-radius: 5px;margin-left: 5px;'>Ödenmedi</a>");
              }
            } else {
              $(info.el).find('.fc-event-title').append("<br/>Müşteri: <b>" + musteriAd + "</b>");
              $(info.el).find('.fc-list-event-title').append("<br/>Müşteri: <b>" + musteriAd + "</b>");
            }
          } catch (e) {
            console.log("eventDidMount hatası: " + e.message);
          }
        },
        events: {
          url: '/json',
          extraParams: function(info) {
            try {
              var params = {};
              
              // View bilgisi
              if (typeof info.view !== 'undefined' && info.view !== null) {
                if (info.view.type === 'listWeek') {
                  // Liste görünümü için özel parametreler
                  params.view = 'allAppointmentsList';
                } else {
                  params.view = info.view.type;
                }
              }
              
              // Tarih bilgisi
              if (typeof info.start !== 'undefined' && info.start !== null) {
                params.date = info.start.toISOString().split('T')[0];
              } else {
                // Tarih bilgisi yoksa bugünü kullan
                params.date = new Date().toISOString().split('T')[0];
              }
              
              console.log("Takvim eventi request parametreleri:", params);
              return params;
            } catch (e) {
              console.log("events extraParams hatası: " + e.message);
              // Hiçbir şey belirlenemezse, varsayılan olarak tüm randevuları göster
              return {view: 'allAppointmentsList'};
            }
          }
        },
        editable: false,
        dragScroll: true,
        dayMaxEvents: 2,
        eventResizableFromStart: true,
        customButtons: {
          sidebarToggle: {
            text: 'Randevu Ekle',
            click: function() {
              try {
                $('#randevuEkleButton').click(); // Randevu ekle butonunu otomatik olarak tıklar
              } catch (e) {
                console.log("Sidebar toggle hatası: " + e.message);
              }
            }
          },
          allAppointmentsButton: {
            text: 'Tüm Randevular',
            click: function() {
              try {
                // tumRandevularButton event'ini çağır 
                $('#tumRandevularButton').trigger('click');
              } catch (e) {
                console.log("All appointments button hatası: " + e.message);
              }
            }
          }
        },
        headerToolbar: {
          start: 'sidebarToggle,prev,next,title',
          center: '',
          end: 'allAppointmentsButton,dayGridMonth,timeGridWeek,resourceTimeGridDay'
        },
        views: {
          allAppointmentsList: {
            buttonText: 'Tüm Randevular',
            type: 'list',
            duration: { years: 5 }, // 5 yıllık geniş bir süre
            visibleRange: function() {
              // Çok geniş bir tarih aralığı (geçmiş 2 yıl, gelecek 3 yıl)
              var startDate = new Date();
              startDate.setFullYear(startDate.getFullYear() - 2);
              
              var endDate = new Date();
              endDate.setFullYear(endDate.getFullYear() + 3);
              
              return {
                start: startDate,
                end: endDate
              };
            },
            titleFormat: { year: 'numeric' },
            noEventsMessage: 'Görüntülenecek randevu bulunamadı',
            displayEventTime: true,
            displayEventEnd: true,
            listDayFormat: { month: 'long', day: 'numeric', year: 'numeric' },
            listDaySideFormat: { weekday: 'long' },
            eventTimeFormat: {
              hour: '2-digit',
              minute: '2-digit',
              hour12: false
            }
          },
          dayGridMonth: {
            buttonText: 'Aylık',
            dayMaxEventRows: true, // Günlük maksimum etkinlik sayısı
            dayHeaderFormat: { weekday: 'short' }
          },
          timeGridWeek: {
            buttonText: 'Haftalık',
            slotDuration: '00:30:00', // 30 dakikalık slotlar
            slotLabelInterval: '01:00',
            allDaySlot: false
          },
          resourceTimeGridDay: {
            buttonText: 'Bugün',
            dayHeaderFormat: { weekday: 'long', month: 'long', day: 'numeric', year: 'numeric' },
            slotDuration: '00:15:00', // 15 dakikalık slotlar
            slotLabelInterval: '01:00',
            allDaySlot: false
          }
        },
        datesSet: function(info) {
          try {
            // Her view değişiminde modifyToggler çağrılsın
            modifyToggler();
            
            // Sadece log amaçlı
            console.log("View değişti: " + info.view.type);
            
            // Özel view için başlık güncelleme
            if (info.view.type === 'allAppointmentsList' || info.view.type === 'listWeek') {
              setTimeout(function() {
                $('.fc-toolbar-title').text('TÜM RANDEVULAR');
              }, 150);
            }
          } catch (e) {
            console.log("datesSet hatası: " + e.message);
          }
        },
        
        // View butonları için özel eylemler
        viewDidMount: function(arg) {
          try {
            modifyToggler();
            
            if (arg.view.type === 'allAppointmentsList' || arg.view.type === 'listWeek') {
              // "Tüm Randevular" görünümü yüklendiğinde başlığı değiştir
              setTimeout(function() {
                $('.fc-toolbar-title').text('TÜM RANDEVULAR');
              }, 150);
              
              // Özel parametre ile AJAX isteği yap
              $.ajax({
                url: '/json',
                data: { view: 'allAppointmentsList' },
                success: function(response) {
                  try {
                    if (window.calendar) {
                      window.calendar.refetchEvents();
                    }
                  } catch (e) {
                    console.log("Takvim yenileme hatası: " + e.message);
                  }
                }
              });
            }
          } catch (e) {
            console.log("viewDidMount hatası: " + e.message);
          }
        },
        direction: direction,
        initialDate: new Date(),
        navLinks: true, // can click day/week names to navigate views
        eventClassNames: function ({ event: calendarEvent }) {
          try {
            const colorName = calendarsColor[calendarEvent._def.extendedProps.calendar];
            return ['bg-light-' + colorName];
          } catch (e) {
            console.log("eventClassNames hatası: " + e.message);
            return [];
          }
        },
        dateClick: function (info) {
          try {
            document.getElementById("randevuOlustur").reset();
            $('#secimEkran').show();
            $('#mevcutMusteri').hide();
            $('#musteriDuzenle').hide();
            $('#adSoyad').hide();
            $('#telefon').hide();
            $('#timeSelect').html("");
            $('#randevuDuzenle').val('0');
            $('#randevuEkleDurum').val('1');
            $('#inlineRadio1').attr('checked', false);
            $("#providerList").html("");
            var date = moment(info.date).format('YYYY-MM-DD');
            resetValues();
            sidebar.modal('show');
            addEventBtn.removeClass('d-none');
            updateEventBtn.addClass('d-none');
            btnDeleteEvent.addClass('d-none');
            startDate.val(date);
            endDate.val(date);
          } catch (e) {
            console.log("dateClick hatası: " + e.message);
          }
        },
        eventClick: function (info) {
          try {
            eventClick(info);
          } catch (e) {
            console.log("eventClick hatası: " + e.message);
          }
        },
        datesSet: function () {
          try {
            modifyToggler();
          } catch (e) {
            console.log("datesSet modifyToggler hatası: " + e.message);
          }
        },
        viewDidMount: function () {
          try {
            modifyToggler();
          } catch (e) {
            console.log("viewDidMount modifyToggler hatası: " + e.message);
          }
        },
        dayMinWidth: 170,
        stickyFooterScrollbar: true
      });
      
      // Takvim render işlemini güvenli bir şekilde gerçekleştir
      try {
        calendar.render();
        // Modify sidebar toggler
        modifyToggler();
      } catch (e) {
        console.log("Takvim render hatası: " + e.message);
      }
    } catch (e) {
      console.log("Takvim oluşturma hatası: " + e.message);
    }

    // Reset sidebar input values
    function resetValues() {
      try {
        endDate.val('');
        eventUrl.val('');
        startDate.val('');
        eventTitle.val('');
        eventLocation.val('');
        allDaySwitch.prop('checked', false);
        eventGuests.val('').trigger('change');
        calendarEditor.val('');
      } catch (e) {
        console.log("resetValues hatası: " + e.message);
      }
    }

    // When modal hides reset input values
    sidebar.on('hidden.bs.modal', function () {
      resetValues();
    });

    // Hide left sidebar if the right sidebar is open
    $('.btn-toggle-sidebar').on('click', function () {
      btnDeleteEvent.addClass('d-none');
      updateEventBtn.addClass('d-none');
      addEventBtn.removeClass('d-none');
      $('.app-calendar-sidebar, .body-content-overlay').removeClass('show');
    });

    // Select all & filter functionality
    if (selectAll.length) {
      selectAll.on('change', function () {
        var $this = $(this);
        if ($this.prop('checked')) {
          calEventFilter.find('input').prop('checked', true);
        } else {
          calEventFilter.find('input').prop('checked', false);
        }
        calendar.refetchEvents();
      });
    }

    if (filterInput.length) {
      filterInput.on('change', function () {
        $('.input-filter:checked').length < calEventFilter.find('input').length
          ? selectAll.prop('checked', false)
          : selectAll.prop('checked', true);
        calendar.refetchEvents();
      });
    }
    
  } catch (e) {
    console.log("Global takvim hatası: " + e.message);
  }
});