<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/db.php';
function id($text) {
    $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
    $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
    $text = strtolower(str_replace($find, $replace, $text));
    $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
    $text = trim(preg_replace('/\s+/', ' ', $text));
    $text = str_replace(' ', '', $text);

    return $text;
}

session_start();
$user_id = $_SESSION['memberId'];
$providerCheckSite= $DB->prepare("select * from provider where id=?");
$providerCheckSite->execute(array($user_id));
$providerChk = $providerCheckSite->fetch(PDO::FETCH_ASSOC);

// URL parametrelerini kontrol et
$view = isset($_GET['view']) ? $_GET['view'] : '';
$filteredDate = isset($_GET['date']) ? $_GET['date'] : '';

// Debug logları
$logFile = $_SERVER['DOCUMENT_ROOT'].'/admin/system/logs/calendar_debug_'.date('Y-m-d').'.log';
file_put_contents($logFile, date('Y-m-d H:i:s') . " - Gelen istek: view=$view, date=$filteredDate\n", FILE_APPEND);

// Kontrol et - bu bir "tüm randevular" isteği mi?
$showAllAppointments = ($view === 'allAppointmentsList' || $view === 'listWeek');

// Tam süreç için debug bilgisi
file_put_contents($logFile, date('Y-m-d H:i:s') . " - showAllAppointments değeri: " . ($showAllAppointments ? 'true' : 'false') . "\n", FILE_APPEND);

try {
    // Randevu sayısını kontrol etmek için sorgulama
    $countQuery = $DB->query("SELECT COUNT(*) as total FROM appointments");
    $totalCount = $countQuery->fetch(PDO::FETCH_ASSOC)['total'];
    file_put_contents($logFile, date('Y-m-d H:i:s') . " - Veritabanında toplam randevu sayısı: " . $totalCount . "\n", FILE_APPEND);
    
    if ($providerChk['isAdmin'] == '1') {
        // Admin ise tüm randevuları görebilir
        if ($showAllAppointments) {
            // Tüm randevular için tarih filtresiz sorgu
            $sql = "SELECT * FROM appointments ORDER BY appDate DESC, startTime ASC";
            file_put_contents($logFile, date('Y-m-d H:i:s') . " - Admin için tüm randevular sorgusu: " . $sql . "\n", FILE_APPEND);
            $appointments = $DB->query($sql)->fetchAll(PDO::FETCH_ASSOC);
        } else if (!empty($filteredDate)) {
            // Belirli bir tarih için filtreli sorgu
            $sql = "SELECT * FROM appointments WHERE appDate = :filtered_date ORDER BY startTime ASC";
            file_put_contents($logFile, date('Y-m-d H:i:s') . " - Admin için tarih filtreli sorgu: " . $sql . " (tarih: " . $filteredDate . ")\n", FILE_APPEND);
            $appointments = $DB->prepare($sql);
            $appointments->execute(['filtered_date' => $filteredDate]);
            $appointments = $appointments->fetchAll(PDO::FETCH_ASSOC);
        } else {
            // Normal sorgu - default davranış
            $sql = "SELECT * FROM appointments ORDER BY id DESC";
            file_put_contents($logFile, date('Y-m-d H:i:s') . " - Admin için normal sorgu: " . $sql . "\n", FILE_APPEND);
            $appointments = $DB->query($sql)->fetchAll(PDO::FETCH_ASSOC);
        }
    } else {
        // Normal kullanıcı - sadece kendi randevularını görebilir
        if ($showAllAppointments) {
            // Tüm kişisel randevular
            $sql = "SELECT * FROM appointments WHERE providerID = :user_id ORDER BY appDate DESC, startTime ASC";
            file_put_contents($logFile, date('Y-m-d H:i:s') . " - Normal kullanıcı için tüm randevular sorgusu: " . $sql . " (user_id: " . $user_id . ")\n", FILE_APPEND);
            $appointments = $DB->prepare($sql);
            $appointments->execute(['user_id' => $user_id]);
            $appointments = $appointments->fetchAll(PDO::FETCH_ASSOC);
        } else if (!empty($filteredDate)) {
            // Belirli bir tarih için kişisel randevular
            $sql = "SELECT * FROM appointments WHERE providerID = :user_id AND appDate = :filtered_date ORDER BY startTime ASC";
            file_put_contents($logFile, date('Y-m-d H:i:s') . " - Normal kullanıcı için tarih filtreli sorgu: " . $sql . " (user_id: " . $user_id . ", tarih: " . $filteredDate . ")\n", FILE_APPEND);
            $appointments = $DB->prepare($sql);
            $appointments->execute(['user_id' => $user_id, 'filtered_date' => $filteredDate]);
            $appointments = $appointments->fetchAll(PDO::FETCH_ASSOC);
        } else {
            // Normal sorgu - default davranış
            $sql = "SELECT * FROM appointments WHERE providerID = :user_id ORDER BY id DESC";
            file_put_contents($logFile, date('Y-m-d H:i:s') . " - Normal kullanıcı için normal sorgu: " . $sql . " (user_id: " . $user_id . ")\n", FILE_APPEND);
            $appointments = $DB->prepare($sql);
            $appointments->execute(['user_id' => $user_id]);
            $appointments = $appointments->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    
    // Sorgu sonuçlarını loglama
    file_put_contents($logFile, date('Y-m-d H:i:s') . " - Sorgu sonucunda " . count($appointments) . " randevu bulundu\n", FILE_APPEND);
} catch (Exception $e) {
    // Hata durumunda loglama
    file_put_contents($logFile, date('Y-m-d H:i:s') . " - HATA: " . $e->getMessage() . "\n", FILE_APPEND);
    
    // Boş dizi ile devam et
    $appointments = [];
}

$settings = $DB->query("select * from settings where id=1")->fetch(PDO::FETCH_ASSOC);

$deger = [];

// Debug logları (devam)
file_put_contents($logFile, date('Y-m-d H:i:s') . " - Sorgu sonucu: " . count($appointments) . " randevu bulundu\n", FILE_APPEND);

// Bugünün tarihini al
$today = date('Y-m-d');
$thisMonth = date('Y-m');
$thisWeek = date('Y-W');

foreach ($appointments as $appointmentsVeri) {
    $serviceID = $appointmentsVeri['service'];
    $providerID= $appointmentsVeri['providerID']; 
    $memberID = $appointmentsVeri['member']; 
    $appointmentDate = $appointmentsVeri['appDate'];
    
    // Kategori belirleme (bugün, bu hafta, bu ay, tüm randevular)
    $isToday = ($appointmentDate === $today);
    $isThisMonth = (substr($appointmentDate, 0, 7) === $thisMonth);
    $appointmentWeek = date('Y-W', strtotime($appointmentDate));
    $isThisWeek = ($appointmentWeek === $thisWeek);
    
    // Tarih/Zaman görüntüleme formatı ayarları
    $viewDateFormat = date('d/m/Y', strtotime($appointmentDate));
    
    $services = $DB->query("SELECT * from services where id='$serviceID'")->fetch(PDO::FETCH_ASSOC);
    $provider= $DB->query("SELECT * from provider where id='$providerID'")->fetch(PDO::FETCH_ASSOC);
    $member= $DB->query("SELECT * from members where id='$memberID'")->fetch(PDO::FETCH_ASSOC);

    // Başlık formatını zenginleştir
    $titlePrefix = '';
    if ($isToday) {
        $titlePrefix = '📅 ';
    }
    
    // Randevu durumunu kontrol et
    $statusClass = '';
    $statusText = '';
    if ($appointmentsVeri['coming'] == 1) {
        $statusClass = 'success';
        $statusText = 'Geldi';
    } elseif ($appointmentsVeri['coming'] == 2) {
        $statusClass = 'warning';
        $statusText = 'Beklemede';
    } elseif ($appointmentsVeri['coming'] == 3) {
        $statusClass = 'danger';
        $statusText = 'Gelmedi';
    } elseif ($appointmentsVeri['coming'] == 4) {
        $statusClass = 'secondary';
        $statusText = 'İptal Edildi';
    }

    $deger[] = array(
        "id" => $services['id'],
        "resourceId" => $provider['id'],
        "url" => '',
        "color"=> $provider['renk'],
        "textColor" => $provider['yazirenk'], 
        "title" => $titlePrefix . $services['serviceName'], 
        "start" => $appointmentsVeri['appDate'].'T'.$appointmentsVeri['startTime'],
        "end" => $appointmentsVeri['appDate'].'T'.$appointmentsVeri['endTime'],
        "allDay" => false,
        "isUnavailable" => false, // Randevu olduğunu belirtir
        "classNames" => ["appointment-status-" . $statusClass],
        "extendedProps" => array(
            "calendar"=> id($provider['name']),
            "guests"=>  $appointmentsVeri['member'],
            "location"=> $appointmentsVeri['id'],
            "description"=> $appointmentsVeri['providerID'],
            "musteriAd"=> $member['name'],
            "musteriTel"=> $member['phone'],
            "musteriMail"=> $member['email'],
            "calisanAd" => $provider['name'],
            "payment" => $appointmentsVeri['payment'],
            "paymentStatus" => $appointmentsVeri['paymentStatus'],
            "coming" => $appointmentsVeri['coming'],
            "paytrSystem" => $settings['paytrSystem'],
            "note" => $appointmentsVeri['note'],
            "isToday" => $isToday,
            "isThisWeek" => $isThisWeek,
            "isThisMonth" => $isThisMonth,
            "statusText" => $statusText,
            "viewDateFormat" => $viewDateFormat
        )
    );
}


// Çalışılmayacak saatleri daha düzgün bir şekilde takvime eklemek için
// önce tüm saatleri zamanlarına göre sıralayıp gruplayalım
$unavailableHours = [];

// Tüm çalışılmayacak saatleri getir ve sırala
$unavailableQuery = $DB->prepare("SELECT * FROM saatler WHERE provid = :provid ORDER BY tarih, saat");
$unavailableQuery->execute(['provid' => $providerChk['id']]);
$unavailableRows = $unavailableQuery->fetchAll(PDO::FETCH_ASSOC);

// Çalışılmayacak saatleri log dosyasına yazalım
file_put_contents($logFile, date('Y-m-d H:i:s') . " - Çalışılmayacak saatler sorgusu: " . count($unavailableRows) . " kayıt bulundu\n", FILE_APPEND);

// Her saat için uygun süre hesapla (varsayılan 30 dakika)
foreach ($unavailableRows as $i => $unavailable) {
    $startTime = $unavailable['tarih'].'T'.$unavailable['saat'];
    
    // Saatin formatını kontrol et
    $timeFormat = (strlen($unavailable['saat']) > 5) ? "H:i:s" : "H:i";
    $startDateTime = new DateTime($startTime);
    
    // Sonraki saati kontrol et ve saat aralığını hesapla
    if (isset($unavailableRows[$i+1]) && 
        $unavailableRows[$i+1]['tarih'] === $unavailable['tarih']) {
        
        // Sonraki saat aynı gün içindeyse
        $nextTime = $unavailableRows[$i+1]['tarih'].'T'.$unavailableRows[$i+1]['saat'];
        $nextDateTime = new DateTime($nextTime);
        
        // İki saat arasındaki fark 30 dakika mı yoksa 1 saat mı kontrol et
        $interval = $startDateTime->diff($nextDateTime);
        $minutesDiff = ($interval->h * 60) + $interval->i;
        
        // Sıralı iki saat arasında 25-40 dakika varsa yarım saatlik süre kullan
        if ($minutesDiff >= 25 && $minutesDiff <= 40) {
            $endDateTime = clone $startDateTime;
            $endDateTime->add(new DateInterval('PT30M'));
            $endTime = $endDateTime->format('Y-m-d\TH:i:s');
        } else {
            // Bilinmeyen süre veya standart 1 saatlik blok için
            $endDateTime = clone $startDateTime;
            $endDateTime->add(new DateInterval('PT30M'));
            $endTime = $endDateTime->format('Y-m-d\TH:i:s');
        }
    } else {
        // Son kayıt veya farklı gün, standart 30 dakikalık süre kullan
        $endDateTime = clone $startDateTime;
        $endDateTime->add(new DateInterval('PT30M'));
        $endTime = $endDateTime->format('Y-m-d\TH:i:s'); 
    }
    
    // Log
    file_put_contents($logFile, date('Y-m-d H:i:s') . " - Çalışılmayacak saat: " . $startTime . " - " . $endTime . "\n", FILE_APPEND);
    
    // Takvime ekle
    $deger[] = array(
        "id" => "unavailable_" . $i, // Benzersiz ID
        "resourceId" => $providerChk['id'],
        "url" => '',
        "color" => '#FF0000',
        "textColor" => '#FFFFFF',
        "title" => 'Çalışılamaz',
        "start" => $startTime,
        "end" => $endTime,
        "allDay" => false,
        "isUnavailable" => true,
        "display" => "block", // Blok şeklinde göster, çakışmaları daha iyi yönetir
        "classNames" => ["unavailable-time-block"], // Özel CSS sınıfı
        "extendedProps" => array(
            "musteriAd" => "-",
            "calisanAd" => $providerChk['name'],
            "unavailableHour" => true
        )
    );
}

// Sonuç dizisini logla
file_put_contents($logFile, date('Y-m-d H:i:s') . " - JSON dizisi oluşturuldu, toplam " . count($deger) . " öğe içeriyor\n", FILE_APPEND);
file_put_contents($logFile, date('Y-m-d H:i:s') . " - JSON yanıtı gönderiliyor...\n", FILE_APPEND);

// JSON yanıtını gönder
echo json_encode($deger);
?>
