<?php
require $_SERVER['DOCUMENT_ROOT'].'/admin/system/includes/Header.php';
?>
<!-- Custom styles for appointment calendar and modal -->
<link rel="stylesheet" type="text/css" href="./app-assets/css/custom/randevu-modal.css">
<style>
/* Takvim güncelleme stilleri */
.appointment-status-success {
  border-left: 3px solid #28c76f !important;
}

.appointment-status-warning {
  border-left: 3px solid #ff9f43 !important;
}

.appointment-status-danger {
  border-left: 3px solid #ea5455 !important;
}

.appointment-status-secondary {
  border-left: 3px solid #82868b !important;
  opacity: 0.7;
}

/* Bugün için özel stil */
.fc-event.today-appointment {
  background-color: rgba(115, 103, 240, 0.15) !important;
  box-shadow: 0 0 5px rgba(115, 103, 240, 0.5);
}

/* Randevu Ekle butonu özelleştirme */
.fc-sidebarToggle-button {
  background-color: #7367f0 !important;
  border-color: #7367f0 !important;
  color: white !important;
  font-weight: 500 !important;
}

.fc-sidebarToggle-button:hover {
  background-color: #5e50ee !important;
  border-color: #5e50ee !important;
}

/* Çalışılmayacak saatler için özel stil */
.unavailable-time-block {
  border-radius: 4px !important;
  border: none !important;
  opacity: 0.9 !important;
  font-size: 0.85rem !important;
  overflow: hidden !important;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1) !important;
}

/* Çalışılmayacak saatler yarım saatlik gösterim için */
.fc-timegrid-event-harness .unavailable-time-block {
  border-left: 3px solid #ff0000 !important;
  background-color: #ff0000 !important;
  color: #ffffff !important;
  font-weight: bold !important;
  height: auto !important;
}

/* Çalışılmayacak saatlerin yazısını ayarla */
.unavailable-time-block .fc-event-title {
  font-size: 0.75rem !important;
  padding: 2px 0 !important;
  white-space: nowrap !important;
  overflow: hidden !important;
  text-overflow: ellipsis !important;
}

/* Çakışan çalışılmayacak saatler için stilleri düzelt */
.fc-timegrid-col-events {
  margin: 0 1px 0 1px !important;
}

/* Mobil görünümde takvim butonları düzenleme */
@media (max-width: 767.98px) {
  .fc-toolbar-chunk {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    margin-bottom: 0.5rem;
  }

  .fc-toolbar-title {
    font-size: 1.2rem !important;
    text-align: center;
    width: 100%;
    margin-bottom: 0.5rem;
  }

  .fc-header-toolbar.fc-toolbar {
    flex-direction: column;
  }
}
</style>
<!-- BEGIN: Content-->
<div class=" app-content content ">
  <div class=" content-overlay">
  </div>
  <div class="header-navbar-shadow"></div>
  <div class="content-wrapper container-xxl p-0">
    <div class="content-header row">
    </div>
    <div class="content-body">
      <!-- Full calendar start -->
      <section>
        <div class="app-calendar overflow-hidden border">
          <div class="row g-0">
            <!-- Sidebar -->
            <div class="col app-calendar-sidebar flex-grow-0 overflow-hidden d-flex flex-column"
              id="app-calendar-sidebar">
              <div class="sidebar-wrapper">
                <div class="card-body d-flex justify-content-center">
                  <button id="randevuEkleButton" class="btn btn-primary btn-toggle-sidebar w-100" data-bs-toggle="modal"
                    data-bs-target="#add-new-sidebar">
                    <i class="fas fa-plus-circle me-1"></i>
                    <span class="align-middle">Randevu Ekle</span>
                  </button>
                </div>

                <div class="card-body d-flex justify-content-center">
                  <button id="tumRandevularButton" class="btn btn-info btn-toggle-sidebar w-100">
                    <i class="fas fa-calendar-alt me-1"></i>
                    <span class="align-middle">Tüm Randevuları Göster</span>
                  </button>
                </div>

                <div class="card-body pb-0">
                  <h5 class="section-label mb-1">
                    <span class="align-middle">Görünümler</span>
                  </h5>
                  <div class="list-group">
                    <a href="#" class="list-group-item list-group-item-action" id="viewMonthBtn">
                      <i class="fas fa-calendar me-1"></i> Aylık Görünüm
                    </a>
                    <a href="#" class="list-group-item list-group-item-action" id="viewWeekBtn">
                      <i class="fas fa-calendar-week me-1"></i> Haftalık Görünüm
                    </a>
                    <a href="#" class="list-group-item list-group-item-action" id="viewDayBtn">
                      <i class="fas fa-calendar-day me-1"></i> Günlük Görünüm
                    </a>
                  </div>
                </div>
              </div>
              <div class="mt-auto">
                <img
                  src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/images/pages/calendar-illustration.png"
                  alt="Calendar illustration" class="img-fluid" />
              </div>
            </div>
            <!-- /Sidebar -->

            <!-- Calendar -->
            <div class="col position-relative">
              <div class="card shadow-none border-0 mb-0 rounded-0">
                <div class="card-body pb-0">
                  <div id="calendar"></div>
                </div>
              </div>
            </div>
            <!-- /Calendar -->
            <div class="body-content-overlay"></div>
          </div>
        </div>
        <!-- Calendar Add/Update/Delete event modal-->
        <div class="modal modal-slide-in event-sidebar fade" id="add-new-sidebar">
          <div class="modal-dialog sidebar-lg">
            <div class="modal-content p-0">
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
              <div class="modal-header mb-1">
                <h5 class="modal-title">Randevu İşlemleri</h5>
              </div>
              <div class="modal-body flex-grow-1 pb-sm-0 pb-3">
                <form class="event-form needs-validation" id="randevuOlustur" action="#">
                  <div class="mb-1">
                    <label for="hizmet" class="form-label">Hizmet</label>
                    <select class="select2 select-label form-select w-100" id="service" name="service">
                      <option selected="" disabled="" value="">Seçin</option>

                      <?php $services = $DB->query("select * from services order by sira ASC")->fetchAll(PDO::FETCH_ASSOC);
                    foreach ($services as $service) {
                      ?>
                      <option id="service<?=$service['id']?>" data-label="<?=id($service['serviceName'])?>"
                        value="<?=$service['id']?>"><?=$service['serviceName']?></option>
                      <?php } ?>
                    </select>

                  </div>
                  <div class="mb-1">
                    <label for="select-label" class="form-label">Çalışan</label>
                    <select class="select2 select-label form-select w-100" id="providerList" name="provider">

                    </select>
                  </div>
                  <script
                    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/jquery-3.5.1.min.js">
                  </script>
                  <script type="text/javascript">
                  $(document).ready(function() {
                    $("#service").change(function() {
                      var serviceID = $(this).val();
                      $.ajax({
                        type: "POST",
                        url: "../admin/system/ajax/ProviderAjax.php",
                        data: {
                          "serviceID": serviceID
                        },
                        success: function(e) {
                          $("#providerList").html(e);
                          $("#timeSelect").html("");
                        }
                      });
                    })
                  });
                  </script>
                  <script type="text/javascript">
                  $(document).ready(function() {
                    $("#providerList").change(function() {
                      var date = $('#start-date').val();
                      var providerID = $(this).val();
                      var hizmetID = $('#service').val();
                      $.ajax({
                        type: "POST",
                        url: "../admin/system/ajax/AvailableTimeAjax.php", // RandevuAlgoritma.php yerine AvailableTimeAjax.php kullanılıyor
                        data: {
                          "date": date,
                          "providerID": providerID,
                          "hizmet": hizmetID
                        },
                        success: function(e) {
                          $("#timeSelect").html(e);

                        }
                      });
                    })
                  });
                  </script>

                  <div class="mb-1 position-relative">
                    <label for="start-date" class="form-label">Tarih Seçin</label>
                    <input type="text" class="form-control" id="start-date" name="start-date"
                      placeholder="Randevu Tarihi" />
                  </div>
                  <div class="row custom-options-checkable g-1" id="timeSelect">
                  </div>
                  <script type="text/javascript">
                  $(document).ready(function() {
                    $("#start-date").change(function() {
                      // Tarih formatını dönüştür
                      var inputDate = $(this).val();
                      var date = '';

                      // Eğer orijinal tarih saklanmışsa onu kullan (veritabanı formatı)
                      if ($('#original-date').length > 0 && $('#original-date').val()) {
                        date = $('#original-date').val();
                        console.log("AvailableTimeAjax için orijinal tarih kullanılıyor:", date);
                      } else if (inputDate.indexOf('/') !== -1) {
                        // Tarih gün/ay/yıl (DD/MM/YYYY) formatındaysa, veritabanı için yıl-ay-gün (YYYY-MM-DD) formatına dönüştür
                        try {
                          var dateParts = inputDate.split('/');
                          if (dateParts.length === 3) {
                            date = dateParts[2] + '-' + dateParts[1] + '-' + dateParts[0];
                            console.log("Tarih formatı dönüştürüldü:", inputDate, "->", date);
                          } else {
                            date = inputDate; // Dönüştürme başarısız olursa orijinal değeri kullan
                          }
                        } catch (e) {
                          console.error("Tarih formatı dönüştürme hatası:", e);
                          date = inputDate; // Hata durumunda orijinal değeri kullan
                        }
                      } else {
                        date = inputDate; // Başka bir formattaysa orijinal değeri kullan
                      }

                      if ($('#providerList').val() == undefined) {
                        var providerID = $('#providerID').val();
                      } else {
                        var providerID = $('#providerList').val();
                      }
                      var edit = $('#edit').val();
                      var hizmetID = $('#service').val();
                      $.ajax({
                        type: "POST",
                        url: "../admin/system/ajax/AvailableTimeAjax.php", // RandevuAlgoritma.php yerine AvailableTimeAjax.php kullanılıyor
                        data: {
                          "date": date,
                          "providerID": providerID,
                          "edit": edit,
                          "hizmet": hizmetID
                        },
                        success: function(e) {
                          $("#timeSelect").html(e);
                        }
                      });
                    })
                  });
                  </script>
                  <br>
                  <input type="hidden" id="providerID" value="">
                  <div class="mb-1" id="secimEkran">
                    <div class="form-check form-check-inline">
                      <input class="form-check-input musteriTipi" type="radio" name="musteriSec" id="inlineRadio1"
                        value="mevcut">
                      <label class="form-check-label" for="inlineRadio1">Mevcut Müşteri</label>
                    </div>
                    <div class="form-check form-check-inline">
                      <input class="form-check-input musteriTipi" type="radio" name="musteriSec" id="inlineRadio2"
                        value="yeni">
                      <label class="form-check-label" for="inlineRadio2">Yeni Müşteri</label>
                    </div>
                  </div>

                  <div id="mevcutMusteri" class="mb-1 select2-primary">
                    <label for="event-guests" class="form-label">Müşteri</label>
                    <select class="select2 select-add-guests form-select w-100" id="event-guests" name="musteri">
                      <option selected="" disabled="" value="">Seçin</option>
                      <?php $members = $DB->query("select * from members order by id desc")->fetchAll(PDO::FETCH_ASSOC);
                    foreach ($members as $member) {
                      ?>
                      <option id="member<?=$member['id']?>" value="<?=$member['id']?>">
                        <?=$member['name']?></option>
                      <?php } ?>
                    </select>
                  </div>

                  <div id="musteriDuzenle"></div>


                  <div class="mb-1" id="adSoyad">
                    <label for="event-location" n class="form-label">Ad Soyad</label>
                    <input type="text" class="form-control" name="musteriAd" id="musteriAd"
                      placeholder="Hasan Gendigül" />
                  </div>
                  <div class="mb-1" id="telefon">
                    <label class="form-label">Telefon</label>
                    <input type="phone" class="form-control" name="musteriTelefon" id="musteriTelefon"
                      placeholder="05459548706" />
                  </div>
                  <div class="mb-1" id="email">
                    <label class="form-label">Mail Adresi</label>
                    <input type="email" class="form-control" name="musteriMail" id="musteriMail"
                      placeholder="john@example.com" />
                  </div>
                  <div class="mb-1" id="note">
                    <label class="form-label">Randevu Notu</label>
                    <input type="text" class="form-control" name="note" id="note" placeholder="Not yazınız" />
                  </div>
                  <div id="noteDiv"></div>

                  <div id="sendSmsDiv" class="col-12 col-sm-6 mb-1">
                    <label class="form-label" for="smsSendSystem">Sms Gönder</label>
                    <div class="form-check form-switch form-check-primary">
                      <input type="checkbox" class="form-check-input" id="smsSendSystem" name="smsSendSystem">
                      <label class="form-check-label" for="smsSendSystem">
                        <span class="switch-icon-left"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round" class="feather feather-check">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg></span>
                        <span class="switch-icon-right"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round" class="feather feather-x">
                            <line x1="18" y1="6" x2="6" y2="18"></line>
                            <line x1="6" y1="6" x2="18" y2="18"></line>
                          </svg></span>
                      </label>
                    </div>
                  </div>



                  <script type="text/javascript">
                  $(document).ready(function() {
                    $('#mevcutMusteri').hide();
                    $('#adSoyad').hide();
                    $('#telefon').hide();
                    $('#email').hide();
                    $('#sendSmsDiv').hide();

                    $("input[type='radio']").click(function() {
                      var radioValue = $("input[name='musteriSec']:checked")
                        .val();
                      if (radioValue == 'mevcut') {
                        $('#mevcutMusteri').show();
                        $('#adSoyad').hide();
                        $('#telefon').hide();
                        $('#email').hide();
                      } else if (radioValue == 'yeni') {
                        $('#adSoyad').show();
                        $('#telefon').show();
                        $('#email').show();
                        $('#mevcutMusteri').hide();
                      }
                    });


                  });
                  </script>

                  <div class="mb-1 d-flex">
                    <input type="hidden" value="0" name="randevuDuzenle" id="randevuDuzenle">
                    <input type="hidden" value="1" name="randevuEkle" id="randevuEkleDurum">
                    <input type="hidden" value="0" name="edit" id="edit">
                    <button id="randevuEkle" type="button" name="randevuEkle"
                      class="btn btn-primary add-event-btn me-1">Ekle</button>
                    <button type="button" class="btn btn-outline-secondary btn-cancel"
                      data-bs-dismiss="modal">Vazgeç</button>
                    <button id="randevuDuzen" type="button"
                      class="btn btn-primary update-event-btn d-none me-1">Kaydet</button>
                    <button id="randevuSil" type="button"
                      class="btn btn-outline-danger btn-delete-event d-none">Sil</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
        <!--/ Calendar Add/Update/Delete event modal-->
      </section>
      <!-- Full calendar end -->

    </div>
  </div>
</div>
<!-- END: Content-->
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$("#randevuDuzen").click(function() {
  if ($('#randevuDuzenle').val() == '1') {
    if ($('#service').val() == undefined) {
      Swal.fire({
        title: "Hata",
        text: "Lütfen hizmet seçiniz.",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "Tamam"
      });
    } else if ($('#providerList').val() == undefined) {
      Swal.fire({
        title: "Hata",
        text: "Lütfen çalışan seçiniz.",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "Tamam"
      });
    } else if ($('#start-date').val() == '') {
      Swal.fire({
        title: "Hata",
        text: "Lütfen randevu tarihi seçiniz.",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "Tamam"
      });
    } else if ($(".custom-option-item-check:checked").val() == undefined) {
      Swal.fire({
        title: "Hata",
        text: "Lütfen randevu saati seçiniz.",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "Tamam"
      });
    } else {
      var title = "Tebrikler!";
      var text = "Randevu başarıyla düzenlendi!";
      var form = $('#randevuOlustur')[0];
      var data = new FormData(form);

      // Tarih formatını kontrol et ve gerekirse dönüştür
      var dateInput = $('#start-date').val();
      // Tarih gün/ay/yıl (DD/MM/YYYY) formatındaysa, veritabanı için yıl-ay-gün (YYYY-MM-DD) formatına dönüştür
      if (dateInput.indexOf('/') !== -1) {
        try {
          var dateParts = dateInput.split('/');
          if (dateParts.length === 3) {
            var dbFormatDate = dateParts[2] + '-' + dateParts[1] + '-' + dateParts[0];
            console.log("Tarih formatı dönüştürüldü:", dateInput, "->", dbFormatDate);

            // Orijinal formatta bir tarih varsa onu kullan
            if ($('#original-date').length > 0 && $('#original-date').val()) {
              dbFormatDate = $('#original-date').val();
              console.log("Orijinal tarih değeri kullanılıyor:", dbFormatDate);
            }

            // Form verisinden mevcut değeri değiştir
            data.delete('start-date');
            data.append('start-date', dbFormatDate);
          }
        } catch (e) {
          console.error("Tarih formatı dönüştürme hatası:", e);
        }
      }

      // Seçilen saati kontrol et ve form verisine ekle
      var selectedTime = $(".custom-option-item-check:checked").val();
      console.log("Seçilen saat: " + selectedTime);

      // Debug için form verilerini göster
      console.log("Form verileri (randevu düzenleme):");
      for (var pair of data.entries()) {
        console.log(pair[0] + ': ' + pair[1]);
      }

      // Saat değerinin doğru şekilde gönderilmesini sağlayalım (ÖNEMLİ FİX)
      if (selectedTime) {
        try {
          // Form verisinden mevcut değeri sil
          data.delete('customOptionsCheckableRadiosWithIcon');

          // Saniye ile tam saat formatını oluştur
          var fullTimeValue = selectedTime;
          if (selectedTime.split(':').length < 3) {
            fullTimeValue = selectedTime + ':00';
          }

          // Formata göre ekle
          data.append('customOptionsCheckableRadiosWithIcon', fullTimeValue);
          console.log("Saat form verisine eklendi: " + fullTimeValue);

          // Doğrudan input değerini de güncelle
          var hiddenInput = document.createElement('input');
          hiddenInput.type = 'hidden';
          hiddenInput.name = 'manualTimeValue';
          hiddenInput.value = fullTimeValue;
          $('#randevuOlustur').append(hiddenInput);

          console.log("Manuel saat değeri eklendi: " + fullTimeValue);
        } catch (e) {
          console.error("Saat değeri ekleme hatası:", e);
        }
      } else {
        console.error("HATA: Randevu saati seçilmemiş!");

        // Yine de form gönderimi için zorunlu alan ekleme
        var manualTime = "00:00:00";
        data.append('manualTimeValue', manualTime);
        console.log("Varsayılan saat eklendi, lütfen kontrol ediniz: " + manualTime);
      }

      $.ajax({
        type: 'post',
        url: '../eral',
        data: data,
        enctype: 'multipart/form-data',
        processData: false,
        contentType: false,
        cache: false,
        success: function(response) {
          // Yanıtı kontrol et ve logla
          console.log("Sunucu yanıtı:", response);

          Swal.fire({
            title: title,
            text: text,
            icon: 'success',
            confirmButtonColor: '#7367f0',
            confirmButtonText: "Tamam"
          }).then((result) => {
            if (result.isConfirmed) {
              //document.getElementById("randevuOlustur").reset();
              location.reload();
            }
            if (result.isDismissed) {
              //document.getElementById("randevuOlustur").reset();
              location.reload();
            }
          });
        }
      });
    }
  }
});
</script>
<script>
$("#randevuSil").click(function() {
  Swal.fire({
    title: 'Randevuyu silmek istediğinize emin misiniz?',
    showDenyButton: true,
    confirmButtonText: 'Evet',
    denyButtonText: 'Vazgeç',
    confirmButtonColor: '#7367f0'
  }).then((result) => {
    /* Read more about isConfirmed, isDenied below */
    if (result.isConfirmed) {
      var randevuID = $('#edit').val();
      var title = "Tebrikler!";
      var text = "Randevu başarıyla silindi!";
      $.ajax({
        type: 'post',
        url: '../eral',
        data: {
          randevuSil: '1',
          randevuID: randevuID
        },
        success: function() {
          Swal.fire({
            title: title,
            text: text,
            icon: 'success',
            confirmButtonColor: '#7367f0',
            confirmButtonText: "Tamam"
          }).then((result) => {
            if (result.isConfirmed) {
              //document.getElementById("randevuOlustur").reset();
              location.reload();
            }
            if (result.isDismissed) {
              //document.getElementById("randevuOlustur").reset();
              location.reload();
            }
          });
        }
      });
    } else if (result.isDenied) {
      Swal.fire('Randevu silinmedi.', '', 'info');
    }
  });
});
</script>
<script>
$("#randevuEkle").click(function() {
  if ($('#service').val() == undefined) {
    Swal.fire({
      title: "Hata",
      text: "Lütfen hizmet seçiniz.",
      icon: 'error',
      confirmButtonColor: '#7367f0',
      confirmButtonText: "Tamam"
    });
  } else if ($('#providerList').val() == undefined) {
    Swal.fire({
      title: "Hata",
      text: "Lütfen çalışan seçiniz.",
      icon: 'error',
      confirmButtonColor: '#7367f0',
      confirmButtonText: "Tamam"
    });
  } else if ($('#start-date').val() == '') {
    Swal.fire({
      title: "Hata",
      text: "Lütfen randevu tarihi seçiniz.",
      icon: 'error',
      confirmButtonColor: '#7367f0',
      confirmButtonText: "Tamam"
    });
  } else if ($(".custom-option-item-check:checked").val() == undefined) {
    Swal.fire({
      title: "Hata",
      text: "Lütfen randevu saati seçiniz.",
      icon: 'error',
      confirmButtonColor: '#7367f0',
      confirmButtonText: "Tamam"
    });
  } else if ($(".musteriTipi:checked").val() == undefined) {
    Swal.fire({
      title: "Hata",
      text: "Lütfen müşteri tipini seçiniz.",
      icon: 'error',
      confirmButtonColor: '#7367f0',
      confirmButtonText: "Tamam"
    });
  } else if ($("#event-guests").val() == undefined && $(".musteriTipi:checked").val() == 'mevcut') {
    Swal.fire({
      title: "Hata",
      text: "Lütfen müşteri seçiniz.",
      icon: 'error',
      confirmButtonColor: '#7367f0',
      confirmButtonText: "Tamam"
    });
  } else {
    if ($(".musteriTipi:checked").val() == 'yeni') {
      if ($("#musteriAd").val() == '') {
        Swal.fire({
          title: "Hata",
          text: "Lütfen müşteri adı yazınız.",
          icon: 'error',
          confirmButtonColor: '#7367f0',
          confirmButtonText: "Tamam"
        });
      } else if ($("#musteriTelefon").val() == '') {
        Swal.fire({
          title: "Hata",
          text: "Lütfen müşteri telefonu yazınız.",
          icon: 'error',
          confirmButtonColor: '#7367f0',
          confirmButtonText: "Tamam"
        });
      } else {
        var title = "Tebrikler!";
        var text = "Randevu oluşturuldu!";
        var form = $('#randevuOlustur')[0];
        var data = new FormData(form);
        $.ajax({
          type: 'post',
          url: '../eral',
          data: data,
          enctype: 'multipart/form-data',
          processData: false,
          contentType: false,
          cache: false,
          success: function(data) {
            if (data == 'varvar') {
              Swal.fire({
                title: "Üzgünüz :(",
                text: "Seçtiğiniz randevu başkası tarafından alındı. Lütfen tekrar tarih ve saat seçiniz.",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "Tamam"
              }).then((result) => {
                if (result.isConfirmed) {
                  //document.getElementById("randevuOlustur").reset();
                  showTab(2);
                  var x = document.getElementsByClassName(
                    "multisteps_form_panel");
                  x[3].style.display = "none";
                }
                if (result.isDismissed) {
                  //document.getElementById("randevuOlustur").reset();
                  showTab(2);
                  var x = document.getElementsByClassName(
                    "multisteps_form_panel");
                  x[3].style.display = "none";
                }
              });
            } else {
              Swal.fire({
                title: title,
                text: text,
                icon: 'success',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "Tamam"
              }).then((result) => {
                if (result.isConfirmed) {
                  //document.getElementById("randevuOlustur").reset();
                  location.reload();
                }
                if (result.isDismissed) {
                  //document.getElementById("randevuOlustur").reset();
                  location.reload();
                }
              });
            }
          }
        });
      }
    } else {
      var title = "Tebrikler!";
      var text = "Randevu oluşturuldu!";
      var form = $('#randevuOlustur')[0];
      var data = new FormData(form);
      $.ajax({
        type: 'post',
        url: '../eral',
        data: data,
        enctype: 'multipart/form-data',
        processData: false,
        contentType: false,
        cache: false,
        success: function(data) {
          if (data == 'varvar') {
            Swal.fire({
              title: "Üzgünüz :(",
              text: "Seçtiğiniz randevu başkası tarafından alındı. Lütfen tekrar tarih ve saat seçiniz.",
              icon: 'error',
              confirmButtonColor: '#7367f0',
              confirmButtonText: "Tamam"
            }).then((result) => {
              if (result.isConfirmed) {
                //document.getElementById("randevuOlustur").reset();
                showTab(2);
                var x = document.getElementsByClassName(
                  "multisteps_form_panel");
                x[3].style.display = "none";
              }
              if (result.isDismissed) {
                //document.getElementById("randevuOlustur").reset();
                showTab(2);
                var x = document.getElementsByClassName(
                  "multisteps_form_panel");
                x[3].style.display = "none";
              }
            });
          } else {
            Swal.fire({
              title: title,
              text: text,
              icon: 'success',
              confirmButtonColor: '#7367f0',
              confirmButtonText: "Tamam"
            }).then((result) => {
              if (result.isConfirmed) {
                //document.getElementById("randevuOlustur").reset();
                location.reload();
              }
              if (result.isDismissed) {
                //document.getElementById("randevuOlustur").reset();
                location.reload();
              }
            });
          }
        }
      });
    }
  }
});
</script>

<script>
// Randevu verilerini işleme fonksiyonu
function processAppointments(jsonData) {
  try {
    console.log("Tüm randevular alındı");

    // Veri içeriğini incele
    if (jsonData) {
      console.log("Alınan veri türü:", typeof jsonData);
      console.log("İlk öğe örneği:", jsonData.length > 0 ? JSON.stringify(jsonData[0]).substring(0, 100) + '...' :
        'Veri yok');
    }

    // JSON dizisi mi kontrol et
    var events = jsonData || [];

    // Veri tipine göre işleme
    console.log("İşlenecek event sayısı:", Array.isArray(events) ? events.length : "Veri array değil");

    // Takvim DOM manipülasyonu
    try {
      console.log("Takvim DOM manipülasyonu başlıyor...");

      // Görünümü değiştir
      var calendarEl = document.getElementById('calendar');
      if (calendarEl) {
        // Element içeriğini temizle
        calendarEl.innerHTML = '';

        // Yeni yapı oluştur
        var cardDiv = document.createElement('div');
        cardDiv.className = 'card';

        var cardHeader = document.createElement('div');
        cardHeader.className = 'card-header';
        cardHeader.innerHTML = '<h4 class="card-title">TÜM RANDEVULAR</h4>';

        var cardBody = document.createElement('div');
        cardBody.className = 'card-body';

        var listContainer = document.createElement('div');
        listContainer.className = 'randevu-list-container table-responsive';

        // Element yapısını oluştur
        cardBody.appendChild(listContainer);
        cardDiv.appendChild(cardHeader);
        cardDiv.appendChild(cardBody);
        calendarEl.appendChild(cardDiv);

        console.log("DOM yapısı tamamen yeniden oluşturuldu");
      } else {
        console.error("calendar elementi bulunamadı!");
        throw new Error("calendar elementi bulunamadı");
      }

      var randevuHTML = '';
      var count = 0;
      var validEvents = [];

      // Array olarak doğru şekilde işle
      if (Array.isArray(events)) {
        // Debug - kaç olay var?
        console.log("Toplam olay sayısı: " + events.length);

        // Sadece randevu içeren olayları filtrele
        events.forEach(function(event) {
          if (event && event.start && !event.isUnavailable) {
            validEvents.push(event);
          }
        });

        // Randevuları tarihe göre sırala (en yeniden eskiye)
        validEvents.sort(function(a, b) {
          return new Date(b.start) - new Date(a.start);
        });

        console.log("Geçerli randevu sayısı:", validEvents.length);

        // Randevu gösterimi başlıyor...
        console.log("Randevu gösterimi başlıyor... Toplam geçerli randevu:", validEvents.length);
        if (validEvents.length > 0) {
          // Tarih gruplarını oluştur
          var groupedByDate = {};

          // Randevuları tarihlerine göre grupla
          validEvents.forEach(function(event) {
            try {
              var startDate = new Date(event.start);
              var dateKey = startDate.getFullYear() + '-' +
                (startDate.getMonth() + 1).toString().padStart(2, '0') + '-' +
                startDate.getDate().toString().padStart(2, '0');

              // Tarih grubu yoksa oluştur
              if (!groupedByDate[dateKey]) {
                // Gün/Ay/Yıl formatında tarih oluştur
                var formattedDate = startDate.getDate().toString().padStart(2, '0') + '/' +
                  (startDate.getMonth() + 1).toString().padStart(2, '0') + '/' +
                  startDate.getFullYear();

                // Türkçe ay adı
                var aylar = ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran",
                  "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"
                ];
                var ayAdi = aylar[startDate.getMonth()];

                // Daha okunabilir tarih formatı: "19 Nisan 2025"
                var guzelTarih = startDate.getDate() + " " + ayAdi + " " + startDate.getFullYear();

                groupedByDate[dateKey] = {
                  formattedDate: formattedDate, // Backend için DD/MM/YYYY formatı
                  beautifulDate: guzelTarih, // Görüntüleme için gün ay_adı yıl formatı
                  dayName: new Intl.DateTimeFormat('tr-TR', {
                    weekday: 'long'
                  }).format(startDate),
                  events: []
                };
              }

              // Randevuyu gruba ekle
              groupedByDate[dateKey].events.push(event);
            } catch (e) {
              console.log("Randevu gruplama hatası:", e.message);
            }
          });

          // Tarih grubunu diziyi çevir ve sırala (en yeni tarih en üstte)
          var sortedDates = Object.keys(groupedByDate).sort(function(a, b) {
            return b.localeCompare(a); // En yeni tarih en üstte
          });

          // Accordion yapısı oluştur
          randevuHTML = '<div class="accordion" id="dateAccordion">';

          // Her tarih grubu için bir bölüm oluştur
          sortedDates.forEach(function(dateKey, index) {
            var dateGroup = groupedByDate[dateKey];
            var accordionId = 'date_' + dateKey.replace(/-/g, '_');
            var isFirst = index === 0;

            // Grup başlığı
            randevuHTML +=
              '<div class="accordion-item">' +
              '<h2 class="accordion-header d-flex" id="heading_' + accordionId + '">' +
              '<button class="accordion-button ' + (!isFirst ? 'collapsed' : '') +
              '" type="button" data-bs-toggle="collapse" ' +
              'data-bs-target="#collapse_' + accordionId + '" aria-expanded="' + (isFirst ? 'true' : 'false') +
              '" ' +
              'aria-controls="collapse_' + accordionId + '" style="position: relative;">' +
              '<div class="me-auto"><strong>' + dateGroup.beautifulDate + '</strong> &nbsp;-&nbsp; ' + dateGroup
              .dayName + '</div>' +
              '<div class="position-absolute" style="right: 50px;">' +
              '<span class="badge rounded-pill bg-primary" style="font-size: 0.8rem;">' + dateGroup.events.length +
              ' randevu</span>' +
              '</div>' +
              '</button>' +
              '</h2>' +
              '<div id="collapse_' + accordionId + '" class="accordion-collapse collapse ' + (isFirst ? 'show' :
              '') + '" ' +
              'aria-labelledby="heading_' + accordionId + '" data-bs-parent="#dateAccordion">' +
              '<div class="accordion-body pb-0 px-1 pt-1">' +
              '<div class="table-responsive mb-0" style="box-shadow: 0 4px 24px 0 rgba(34, 41, 47, 0.1); border-radius: 0.428rem; overflow: hidden;">' +
              '<style>' +
              // Tablo ve hücre stilleri
              '.randevu-table { width: 100%; margin-bottom: 0; border-collapse: separate; border-spacing: 0; }' +
              '.randevu-table th, .randevu-table td { vertical-align: middle; text-align: center; padding: 15px 8px; }' +
              '.randevu-table th { background-color: #f8f9fa; font-weight: 600; border-top: 0; }' +
              '.randevu-table tr:hover { background-color: rgba(115, 103, 240, 0.08); }' +
              '.randevu-table td:first-child, .randevu-table th:first-child { text-align: center; }' +
              '.randevu-table td:last-child, .randevu-table th:last-child { text-align: center; }' +
              '.accordion-button:not(.collapsed) { background-color: rgba(115, 103, 240, 0.12); color: #7367f0; }' +
              '.accordion-button:focus { box-shadow: none; }' +
              '.bg-light-primary { background-color: rgba(115, 103, 240, 0.12); }' +
              '.accordion .card-header { padding: 1rem 1.5rem; border-radius: 0.42rem; }' +
              '.accordion .accordion-item { border-radius: 0.42rem; border: 1px solid #ebe9f1; margin-bottom: 0.5rem; overflow: hidden; }' +
              '.accordion .accordion-button { font-weight: 500; }' +
              '</style>' +
              '<table class="table table-hover randevu-table mb-0">' +
              '<thead>' +
              '<tr>' +
              '<th style="width: 5%;" class="text-center">ID</th>' +
              '<th style="width: 8%;" class="text-center">Saat</th>' +
              '<th style="width: 25%;" class="text-center">Hizmet</th>' +
              '<th style="width: 15%;" class="text-center">Çalışan</th>' +
              '<th style="width: 20%;" class="text-center">Müşteri</th>' +
              '<th style="width: 12%;" class="text-center">Durum</th>' +
              '<th style="width: 15%;" class="text-center">İşlemler</th>' +
              '</tr>' +
              '</thead>' +
              '<tbody>';

            // Tarih grubundaki randevuları saate göre sırala (en erken saat en üstte)
            dateGroup.events.sort(function(a, b) {
              return new Date(a.start).getTime() - new Date(b.start).getTime();
            });

            // Gruptaki randevuları işle
            dateGroup.events.forEach(function(event) {
              try {
                count++;
                var startDate = new Date(event.start);

                // Saat formatla
                var hours = startDate.getHours().toString().padStart(2, '0');
                var minutes = startDate.getMinutes().toString().padStart(2, '0');
                var formattedTime = hours + ':' + minutes;

                // End time extraction and formatting
                var endDate = new Date(event.end || event.start);
                var endHours = endDate.getHours().toString().padStart(2, '0');
                var endMinutes = endDate.getMinutes().toString().padStart(2, '0');
                var formattedEndTime = endHours + ':' + endMinutes;

                // Durum belirle
                var statusClass = 'secondary';
                var statusText = 'Belirsiz';

                if (event.extendedProps && event.extendedProps.coming !== undefined) {
                  if (event.extendedProps.coming == 1) {
                    statusClass = 'success';
                    statusText = 'Geldi';
                  } else if (event.extendedProps.coming == 2) {
                    statusClass = 'warning';
                    statusText = 'Beklemede';
                  } else if (event.extendedProps.coming == 3) {
                    statusClass = 'danger';
                    statusText = 'Gelmedi';
                  } else if (event.extendedProps.coming == 4) {
                    statusClass = 'secondary';
                    statusText = 'İptal Edildi';
                  }
                }

                // Randevu ID'sini al
                var randevuId = event.extendedProps && event.extendedProps.location ? event.extendedProps
                  .location : 'N/A';

                // Müşteri adını al
                var musteriAd = event.extendedProps && event.extendedProps.musteriAd ? event.extendedProps
                  .musteriAd : 'İsimsiz';

                // Çalışan adını al
                var calisanAd = event.extendedProps && event.extendedProps.calisanAd ? event.extendedProps
                  .calisanAd : '';

                // Satır HTML'i - daha iyi hizalama ve stil ile
                randevuHTML += '<tr class="randevu-item" data-id="' + randevuId + '">' +
                  '<td class="text-center font-weight-bold">' + randevuId + '</td>' +
                  '<td class="text-center">' +
                  '<div class="badge bg-light-primary text-primary" style="font-size: 1rem; padding: 10px; min-width: 120px;">' +
                  formattedTime + ' - ' + formattedEndTime +
                  '</div>' +
                  '</td>' +
                  '<td class="text-center">' +
                  '<span class="text-primary fw-bold">' + event.title + '</span>' +
                  '</td>' +
                  '<td class="text-center">' + calisanAd + '</td>' +
                  '<td class="text-center">' + musteriAd + '</td>' +
                  '<td class="text-center">' +
                  '<span class="badge bg-' + statusClass + '" style="padding: 8px 12px; font-size: 0.85rem;">' +
                  statusText +
                  '</span>' +
                  '</td>' +
                  '<td class="text-center">' +
                  '<button class="btn btn-primary edit-randevu" data-id="' + randevuId + '" ' +
                  'data-service="' + (event.id || '') + '" ' +
                  'data-provider="' + (event.extendedProps ? event.extendedProps.description : '') + '" ' +
                  'data-coming="' + (event.extendedProps ? event.extendedProps.coming : '') + '" ' +
                  'data-member="' + (event.extendedProps ? event.extendedProps.guests : '') + '" ' +
                  'data-date="' + dateKey + '" ' +
                  'data-time="' + event.start.split('T')[1] + '" ' +
                  'style="padding: 6px 15px;">' +
                  '<i class="fas fa-edit me-1"></i>Düzenle' +
                  '</button>' +
                  '</td>' +
                  '</tr>';
              } catch (e) {
                console.log("Randevu satırı oluşturma hatası:", e.message);
              }
            });

            randevuHTML += '</tbody></table></div></div></div></div>';
          });

          randevuHTML += '</div>'; // Accordion sonu

          // Düzenleme butonu için olay işleyicisi - sonradan ekle
          setTimeout(function() {
            $('.edit-randevu').on('click', function(e) {
              e.preventDefault();
              e.stopPropagation();

              console.log("Tüm Randevular - düzenleme butonu tıklandı");

              // Randevu verilerini al
              var randevuId = $(this).data('id');
              var serviceId = $(this).data('service');
              var providerId = $(this).data('provider');
              var memberId = $(this).data('member');
              var coming = $(this).data('coming');
              var date = $(this).data('date');
              var time = $(this).data('time');

              // Simüle edilmiş event objesi oluştur (takvim formatında)
              var fakeEvent = {
                id: serviceId,
                extendedProps: {
                  location: randevuId,
                  description: providerId,
                  calendar: providerId,
                  guests: memberId,
                  coming: coming,
                  note: ""
                },
                start: date + 'T' + time
              };

              // Randevu düzenleme modal'ını hazırla
              $('#edit').val(randevuId);
              $('#randevuDuzenle').val('1');
              $('#randevuEkleDurum').val('0');

              // Hizmet seç
              $("#service option").prop("selected", false);
              $('#service' + serviceId).prop('selected', true);

              // Tarihi gün/ay/yıl formatına dönüştür
              var dateParts = date.split('-');
              if (dateParts.length === 3) {
                var formattedDate = dateParts[2] + '/' + dateParts[1] + '/' + dateParts[0];
                // Tarihi ayarla (formatlanmış şekilde göster)
                $('#start-date').val(formattedDate);

                // Orijinal tarihi hidden input olarak sakla
                if ($('#original-date').length === 0) {
                  $('<input>').attr({
                    type: 'hidden',
                    id: 'original-date',
                    name: 'original-date',
                    value: date
                  }).appendTo('#randevuOlustur');
                } else {
                  $('#original-date').val(date);
                }
              } else {
                // Format dönüşümü yapılamazsa orijinal tarihi kullan
                $('#start-date').val(date);
              }
              $('#providerID').val(providerId);

              // Müşteri alanlarını gizle
              $('#inlineRadio1').attr('checked', true);
              $('#secimEkran').hide();
              $('#mevcutMusteri').hide();
              $('#adSoyad').hide();
              $('#telefon').hide();
              $('#email').hide();
              $('#note').remove();
              $('#musteriDuzenle').show();
              $('#sendSmsDiv').show();

              // Ajaxla çalışan bilgilerini al
              $.ajax({
                type: "POST",
                url: "../admin/system/ajax/ProviderAjax.php",
                data: {
                  "serviceID": serviceId
                },
                success: function(response) {
                  $("#providerList").html(response);
                  $("#timeSelect").html("");

                  // Çalışanı seç
                  setTimeout(function() {
                    // Birkaç farklı yöntemle seçmeyi dene
                    $('#provider' + providerId).prop('selected', true);
                    $("#providerList option[value='" + providerId + "']").prop("selected", true);

                    console.log("Çalışan seçildi: " + providerId);
                  }, 100);

                  // Müşteri bilgilerini göster
                  $.ajax({
                    type: "POST",
                    url: "../admin/system/ajax/ProviderAjax.php",
                    data: {
                      "getMemberInfo": "1",
                      "memberID": memberId
                    },
                    success: function(memberInfo) {
                      try {
                        $("#musteriDuzenle").html(memberInfo);

                        // Ödeme durumu seç
                        setTimeout(function() {
                          if (coming == 1) {
                            $('#geldi').prop('selected', true);
                          } else {
                            $('#gelmedi').prop('selected', true);
                          }
                        }, 100);
                      } catch (e) {
                        console.error("Müşteri bilgisi hatası:", e);
                      }
                    }
                  });

                  // Saatleri yükle
                  setTimeout(function() {
                    // Saniyesiz saat formatı
                    var selectedTime = time.substring(0, 5);
                    console.log("Saat yükleniyor, seçilecek saat: " + selectedTime);

                    // Tarihi değiştirmeyi tetikle (saatlerin yüklenmesi için)
                    $('#start-date').trigger('change');

                    // Manuel saat seçimi için bekle
                    setTimeout(function() {
                      console.log("Saat seçme girişimi");

                      // Saat radio butonlarını kontrol et
                      $('input[name="customOptionsCheckableRadiosWithIcon"]').each(function() {
                        var radioValue = $(this).val().substring(0, 5);
                        if (radioValue === selectedTime) {
                          $(this).prop('checked', true);
                          $(this).next('label').addClass('active');
                          console.log("Saat seçildi: " + selectedTime);
                        }
                      });
                    }, 1000);
                  }, 200);

                  // Modalı göster
                  $('#add-new-sidebar').modal('show');
                  $('.add-event-btn').addClass('d-none');
                  $('.btn-cancel').addClass('d-none');
                  $('.update-event-btn').removeClass('d-none');
                  $('.btn-delete-event').removeClass('d-none');
                }
              });
            });
          }, 200);

        } else {
          // Randevu yoksa bilgi mesajı
          randevuHTML = '<div class="alert alert-info">Görüntülenecek randevu bulunamadı.</div>';
        }
      } else {
        // Veri tipi hatalı veya boş
        randevuHTML =
          '<div class="alert alert-warning">Veri işlenirken bir sorun oluştu. Lütfen sayfayı yenileyin.</div>';
        console.error("Randevu verisi diziye dönüştürülemedi:", events);
      }

      // HTML'i ekle
      console.log("HTML içeriği ekleniyor, içerik uzunluğu:", randevuHTML.length);

      try {
        // Doğrudan calendar elementini güncelle
        var calendarEl = document.getElementById('calendar');

        // Her zaman calendar elementini kullan - daha güvenilir
        if (calendarEl) {
          console.log("Calendar elementi bulundu, içeriği güncellenecek");

          // İçeriği daha basit bir şekilde güncelle
          calendarEl.innerHTML = '';

          // Yeni card elementi oluştur
          var cardDiv = document.createElement('div');
          cardDiv.className = 'card border-primary';

          // Kart başlığı
          var cardHeader = document.createElement('div');
          cardHeader.className = 'card-header bg-primary';
          cardHeader.innerHTML = '<h4 class="card-title mb-0" style="color: #ffffff !important;">TÜM RANDEVULAR (' +
            count + ' adet)</h4>';
          cardDiv.appendChild(cardHeader);

          // Kart gövdesi
          var cardBody = document.createElement('div');
          cardBody.className = 'card-body p-0';

          // Randevu listesi container
          var listContainer = document.createElement('div');
          listContainer.className = 'randevu-list-container table-responsive p-1';
          listContainer.innerHTML = randevuHTML;

          // Elementleri birleştir
          cardBody.appendChild(listContainer);
          cardDiv.appendChild(cardBody);
          calendarEl.appendChild(cardDiv);

          console.log("Calendar içeriği tamamen güncellendi");
        } else {
          console.error("HATA: calendar elementi bulunamadı!");
          alert("Takvim elementi bulunamadı, sayfayı yenileyin");
        }

        // Ekleme başarılı mı kontrol et (jQuery ile)
        console.log("HTML ekleme tamamlandı, content uzunluğu:", $('.randevu-list-container').length > 0 ? $(
          '.randevu-list-container').html().length : "Container bulunamadı");
      } catch (err) {
        console.error("HTML ekleme hatası:", err.message);
      }

      // Bilgi başlığı
      $('#calendar .card-title').text('TÜM RANDEVULAR (' + count + ' randevu)');

      // Takvim araç çubuğunu gizle
      $('.fc-header-toolbar').hide();

      // Başarı mesajı
      setTimeout(function() {
        Swal.fire({
          title: 'Başarılı!',
          text: 'Tüm randevular yüklendi',
          icon: 'success',
          timer: 1500,
          showConfirmButton: false
        });
      }, 500);
    } catch (e) {
      console.log("Takvim işlemleri hatası:", e.message);
      Swal.fire({
        title: 'Hata',
        text: 'Takvim görünümü değiştirilirken hata oluştu',
        icon: 'error',
        timer: 2000,
        showConfirmButton: false
      });
    }
  } catch (e) {
    console.log("JSON işleme hatası:", e.message);
    Swal.fire({
      title: 'Hata',
      text: 'Randevu verisi işlenirken bir hata oluştu',
      icon: 'error',
      timer: 2000,
      showConfirmButton: false
    });
  }
}

$(document).ready(function() {
  // Türkçe tarih ayarları
  var aylar = [
    "Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran",
    "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"
  ];
  var gunler = [
    "Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"
  ];

  var bugun = new Date();
  updateDateTitle(bugun);

  // Datepicker'ı Türkçe ve gün/ay/yıl formatında yapılandır
  flatpickr('#start-date', {
    dateFormat: 'Y-m-d',
    locale: 'tr',
    allowInput: true,
    altInput: true,
    altFormat: 'd F Y',
    onReady: function(selectedDates, dateStr, instance) {
      // Tarih seçici hazır olduğunda style ekleyelim
      instance.calendarContainer.classList.add('custom-flatpickr');
    },
    onChange: function(selectedDates, dateStr, instance) {
      // Seçilen tarihi veritabanı formatına çevir ve sakla
      var date = selectedDates[0];
      if (date) {
        var dbFormatDate = date.getFullYear() + '-' +
          (date.getMonth() + 1).toString().padStart(2, '0') + '-' +
          date.getDate().toString().padStart(2, '0');

        // Orijinal tarihi hidden input'ta sakla
        if ($('#original-date').length === 0) {
          $('<input>').attr({
            type: 'hidden',
            id: 'original-date',
            name: 'original-date',
            value: dbFormatDate
          }).appendTo('#randevuOlustur');
        } else {
          $('#original-date').val(dbFormatDate);
        }

        // Tarihin değiştiğini bildiren olayı tetikle
        $('#start-date').trigger('change');
      }
    }
  });

  // Sayfa yüklendikten 1 saniye sonra kaydedilen görünümü uygula
  setTimeout(function() {
    // LocalStorage'dan görünüm bilgisini al
    var savedView = localStorage.getItem('calendarView');
    if (savedView) {
      console.log("Kaydedilen görünüm uygulanıyor:", savedView);

      // Görünümü uygula
      try {
        if (typeof window.calendar !== 'undefined' && window.calendar) {
          // FullCalendar API'yi kullan
          switch (savedView) {
            case 'month':
              window.calendar.changeView('dayGridMonth');
              break;
            case 'week':
              window.calendar.changeView('timeGridWeek');
              break;
            case 'day':
              window.calendar.changeView('timeGridDay');
              break;
            case 'today':
              window.calendar.today();
              window.calendar.changeView('timeGridDay');
              break;
          }

          // Uygulama sonrası LocalStorage'ı temizle
          localStorage.removeItem('calendarView');
        } else {
          // FullCalendar API yoksa alternatif yöntem (butonları tıkla)
          switch (savedView) {
            case 'month':
              $('.fc-dayGridMonth-button').trigger('click');
              break;
            case 'week':
              $('.fc-timeGridWeek-button').trigger('click');
              break;
            case 'day':
              $('.fc-timeGridDay-button').trigger('click');
              break;
            case 'today':
              $('.fc-today-button').trigger('click');
              break;
          }

          // Uygulama sonrası LocalStorage'ı temizle
          localStorage.removeItem('calendarView');
        }
      } catch (e) {
        console.log("Görünüm değiştirme hatası:", e.message);
      }
    }
  }, 1000);

  function updateDateTitle(date) {
    var gun = date.getDate();
    var ay = aylar[date.getMonth()];
    var yil = date.getFullYear();
    var haftaGunu = gunler[date.getDay()];

    var tarihString = gun + " " + ay + " " + yil + " " + haftaGunu;
    $('.fc-toolbar-title').text(tarihString);
  }

  $('.fc-next-button').click(function() {
    bugun.setDate(bugun.getDate() + 1);
    updateDateTitle(bugun);
  });

  $('.fc-prev-button').click(function() {
    bugun.setDate(bugun.getDate() - 1);
    updateDateTitle(bugun);
  });

  // Tüm randevuları göster butonu
  $('#tumRandevularButton').click(function() {
    try {
      console.log("Tüm randevuları göster butonuna tıklandı");

      // Direkt içeriği HTML ile göster
      var calendarEl = document.getElementById('calendar');
      if (calendarEl) {
        calendarEl.innerHTML =
          '<div class="text-center p-3"><h4>Randevular Yükleniyor...</h4><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Yükleniyor...</span></div></div>';

        // SetTimeout ile işlemi geciktir
        setTimeout(function() {
          // Sabit URL
          var url = window.location.origin + '/admin/pages/AppJson.php';

          // AJAX isteği
          $.ajax({
            url: url,
            type: 'GET',
            dataType: 'json',
            data: {
              view: 'allAppointmentsList',
              manual_request: 'true',
              nocache: new Date().getTime()
            },
            success: function(jsonData) {
              if (jsonData && (Array.isArray(jsonData) || typeof jsonData === 'object')) {
                console.log("Veri başarıyla alındı, işleniyor...", jsonData.length || 0, "randevu");
                processAppointments(jsonData);
              } else {
                console.error("Veri alındı fakat uygun formatta değil:", jsonData);
                showError(
                  "Randevu verileri uygun formatta değil. Lütfen sayfayı yenileyin veya yöneticinize başvurun."
                  );
              }
            },
            error: function(xhr, status, error) {
              console.log("AJAX istek hatası:", error);
              console.log("Status:", status);
              console.log("XHR Yanıtı:", xhr.responseText);
              console.log("URL:", url);

              // Hatayı uygun şekilde ele al
              var errorMessage = "Randevu bilgileri getirilirken bir hata oluştu";

              if (xhr.status === 404) {
                errorMessage =
                  "Randevu verileri için gerekli dosya bulunamadı (404). Lütfen sistem yöneticinize başvurun.";

                // Hata durumunda alternatif URL dene
                var altUrl = window.location.origin + '/admin/pages/AppProviderJson.php';
                console.log("Alternatif URL deneniyor:", altUrl);

                // Alternatif yöntem: Diğer dosyayı dene
                $.ajax({
                  url: altUrl,
                  type: 'GET',
                  dataType: 'json',
                  data: {
                    view: 'allAppointmentsList',
                    manual_request: 'true',
                    nocache: new Date().getTime()
                  },
                  success: function(data) {
                    if (data && data.length > 0) {
                      console.log("Alternatif kaynak başarılı. Veri alındı.");
                      // Ana işleme fonksiyonunu çağır
                      processAppointments(data);
                    } else {
                      showError("Alternatif kaynaktan da veri alınamadı.");

                      // Son çare: Tüm randevuları doğrudan çekmeyi dene
                      tryDirectQuery();
                    }
                  },
                  error: function() {
                    showError("Alternatif kaynak da başarısız oldu.");

                    // Son çare: Tüm randevuları doğrudan çekmeyi dene
                    tryDirectQuery();
                  }
                });
              } else {
                showError(errorMessage + ": " + error);

                // Yanıt varsa ve JSON parse edilebilirse kullan
                if (xhr.responseText) {
                  try {
                    var data = JSON.parse(xhr.responseText);
                    if (data && Array.isArray(data)) {
                      console.log("Yanıt JSON olarak işlenebiliyor, kullanılıyor...");
                      processAppointments(data);
                      return;
                    }
                  } catch (e) {
                    console.log("Yanıt JSON olarak işlenemiyor:", e);
                  }
                }
              }

              // Son çare: Doğrudan veritabanından sorgu yapan bir fonksiyon
              function tryDirectQuery() {
                console.log("Doğrudan sorgu deneniyor...");
                // Özel dosyayı çağır
                $.ajax({
                  url: window.location.origin + '/admin/system/ajax/GetUnavailableHours.php',
                  type: 'POST',
                  data: {
                    action: 'get_all_appointments',
                    emergency: true
                  },
                  success: function(data) {
                    try {
                      var jsonData = JSON.parse(data);
                      if (jsonData && jsonData.length > 0) {
                        console.log("Acil durum sorgusu başarılı. Veri alındı:", jsonData
                          .length, "randevu");
                        processAppointments(jsonData);
                      } else {
                        showError("Tüm alternatif yöntemler başarısız oldu. Veri alınamıyor.");
                      }
                    } catch (e) {
                      showError("Veri format hatası: " + e.message);
                    }
                  },
                  error: function() {
                    showError("Tüm alternatif yöntemler başarısız oldu. Veri alınamıyor.");
                  }
                });
              }

              function showError(message) {
                // Hatayı kullanıcıya göster
                Swal.fire({
                  title: 'Hata',
                  text: message,
                  icon: 'error',
                  timer: 5000,
                  showConfirmButton: true
                });

                // DOM'a hata göster
                document.getElementById('calendar').innerHTML =
                  '<div class="alert alert-danger m-3"><h4 class="alert-heading">AJAX Hatası</h4><p>' +
                  message + '</p><p><strong>Status:</strong> ' + status +
                  '</p><p><strong>Error:</strong> ' + error + '</p>' +
                  '<p><strong>URL:</strong> ' + url + '</p>' +
                  '<div class="mt-3"><button class="btn btn-primary" onclick="window.location.reload()">Sayfayı Yenile</button>' +
                  '<button class="btn btn-secondary ms-2" onclick="$(\'#tumRandevularButton\').click()">Tekrar Dene</button></div></div>';
              }
            }
          });
        }, 500);
      }
    } catch (e) {
      console.log("Genel hata:", e.message);
      Swal.fire({
        title: 'Hata',
        text: 'Bir hata oluştu: ' + e.message,
        icon: 'error',
        timer: 2000,
        showConfirmButton: false
      });
    }
  });

  // Takvim görünümü yükleme fonksiyonu
  function loadCalendarView() {
    // Tüm randevular görünümünden çık, normal takvim görünümüne dön
    var calendarEl = document.getElementById('calendar');
    if (calendarEl) {
      // Yükleniyor mesajı göster
      calendarEl.innerHTML =
        '<div class="text-center p-3"><h4>Takvim Yükleniyor...</h4><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Yükleniyor...</span></div></div>';

      // Sayfayı yeniden yükle - en güvenilir yöntem
      setTimeout(function() {
        window.location.reload();
      }, 300);
    }
  }

  // Görünüm butonları için event listener'lar
  $('#viewMonthBtn').click(function() {
    // Önce normal takvim görünümüne dön
    loadCalendarView();

    // Yeni sayfa yüklendikten sonra çalışacak fonksiyon için local storage kullan
    localStorage.setItem('calendarView', 'month');
  });

  $('#viewWeekBtn').click(function() {
    // Önce normal takvim görünümüne dön
    loadCalendarView();

    // Yeni sayfa yüklendikten sonra çalışacak fonksiyon için local storage kullan
    localStorage.setItem('calendarView', 'week');
  });

  $('#viewDayBtn').click(function() {
    // Önce normal takvim görünümüne dön
    loadCalendarView();

    // Yeni sayfa yüklendikten sonra çalışacak fonksiyon için local storage kullan
    localStorage.setItem('calendarView', 'day');
  });

  $('#viewTodayBtn').click(function() {
    // Önce normal takvim görünümüne dön
    loadCalendarView();

    // Yeni sayfa yüklendikten sonra çalışacak fonksiyon için local storage kullan
    localStorage.setItem('calendarView', 'today');
  });

  // Tüm Randevular için özel işlem
  $(document).on('click', '.fc-allAppointmentsButton-button', function() {
    try {
      // Özel olarak oluşturduğumuz allAppointmentsButton butonuna tıklandığında
      // tumRandevularButton'ın click event'ini tetikliyoruz
      $('#tumRandevularButton').click();
    } catch (e) {
      console.log("allAppointmentsButton hatası: " + e.message);
      // Takvimi listWeek moduna getir
      if (typeof window.calendar !== 'undefined' && window.calendar) {
        try {
          window.calendar.changeView('listWeek');
        } catch (err) {
          console.log("View değiştirme hatası: " + err.message);
        }
      }
    }
  });
});
</script>
<?php
require $_SERVER['DOCUMENT_ROOT'].'/admin/system/includes/Footer.php';
?>
