<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';
?>
<?php
require $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Header.php';
?>

<!-- JavaScript hata yakalama devre dışı -->
<script>
window.onerror = null;
</script>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">Özel Gün Ekle</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="/admin/home">Anasayfa</a>
                                </li>
                                <li class="breadcrumb-item"><a href="/admin/special-days">Özel Günler</a>
                                </li>
                                <li class="breadcrumb-item active">Özel Gün Ekle
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="basic-horizontal-layouts">
                <div class="row">
                    <div class="col-md-12 col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Özel Gün Bilgileri</h4>
                            </div>
                            <div class="card-body">
                                <form id="specialDayForm" class="form form-horizontal" method="post" action="/admin/eral">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="title">Başlık</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" id="title" class="form-control" name="title" placeholder="Özel gün başlığı" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="description">Açıklama</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <textarea id="description" class="form-control" name="description" placeholder="Açıklama" rows="3"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="date-range">Tarih Aralığı</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" id="date-range" class="form-control flatpickr-range" name="date-range" placeholder="YYYY-MM-DD - YYYY-MM-DD" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="start_time">Mesai Başlangıç Saati</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" id="start_time" class="form-control flatpickr-time" name="start_time" placeholder="HH:MM" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="end_time">Mesai Bitiş Saati</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" id="end_time" class="form-control flatpickr-time" name="end_time" placeholder="HH:MM" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="category">Kategori</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <select id="category" class="form-select" name="category">
                                                        <?php
                                                        try {
                                                            // Önce tablonun varlığını kontrol et
                                                            $tableCheck = $DB->query("SHOW TABLES LIKE 'special_day_categories'");
                                                            if ($tableCheck->rowCount() == 0) {
                                                                // Tablo yoksa oluştur
                                                                $createTableSQL = "CREATE TABLE IF NOT EXISTS `special_day_categories` (
                                                                    `id` int(11) NOT NULL AUTO_INCREMENT,
                                                                    `name` varchar(255) NOT NULL,
                                                                    `code` varchar(50) NOT NULL,
                                                                    `color` varchar(20) DEFAULT '#7367f0',
                                                                    `description` text DEFAULT NULL,
                                                                    `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
                                                                    PRIMARY KEY (`id`),
                                                                    UNIQUE KEY `code` (`code`)
                                                                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
                                                                $DB->exec($createTableSQL);
                                                                
                                                                // Varsayılan kategori oluştur
                                                                $insertDefault = $DB->prepare("INSERT INTO special_day_categories (name, code, color, description) VALUES (?, ?, ?, ?)");
                                                                $insertDefault->execute(['Varsayılan', 'default', '#7367f0', 'Sistem tarafından oluşturulan varsayılan kategori']);
                                                            }
                                                            
                                                            // Kategorileri getir
                                                            $categoriesQuery = $DB->query("SELECT * FROM special_day_categories ORDER BY name ASC");
                                                            
                                                            // Kategori sayısını kontrol et, hiç yoksa varsayılan kategoriyi oluştur
                                                            if ($categoriesQuery->rowCount() == 0) {
                                                                $insertDefault = $DB->prepare("INSERT INTO special_day_categories (name, code, color, description) VALUES (?, ?, ?, ?)");
                                                                $insertDefault->execute(['Varsayılan', 'default', '#7367f0', 'Sistem tarafından oluşturulan varsayılan kategori']);
                                                                $categoriesQuery = $DB->query("SELECT * FROM special_day_categories ORDER BY name ASC");
                                                            }
                                                            
                                                            while ($category = $categoriesQuery->fetch(PDO::FETCH_ASSOC)) {
                                                                echo '<option value="' . $category['code'] . '" ' . ($category['code'] == 'default' ? 'selected' : '') . ' data-color="' . $category['color'] . '">' . htmlspecialchars($category['name']) . '</option>';
                                                            }
                                                        } catch (Exception $e) {
                                                            // Hata durumunda varsayılan seçenek göster
                                                            echo '<option value="default" data-color="#7367f0">Varsayılan</option>';
                                                            error_log("Kategori listesi hata: " . $e->getMessage());
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label">Tekrarlama</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <div class="mb-1">
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" type="radio" name="repeat_type" id="repeat_none" value="none" checked>
                                                            <label class="form-check-label" for="repeat_none">Tekrarlama</label>
                                                        </div>
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" type="radio" name="repeat_type" id="repeat_daily" value="daily">
                                                            <label class="form-check-label" for="repeat_daily">Günlük</label>
                                                        </div>
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" type="radio" name="repeat_type" id="repeat_weekly" value="weekly">
                                                            <label class="form-check-label" for="repeat_weekly">Haftalık</label>
                                                        </div>
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" type="radio" name="repeat_type" id="repeat_monthly" value="monthly">
                                                            <label class="form-check-label" for="repeat_monthly">Aylık</label>
                                                        </div>
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" type="radio" name="repeat_type" id="repeat_yearly" value="yearly">
                                                            <label class="form-check-label" for="repeat_yearly">Yıllık</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="repeat_options" style="display: none;">
                                            <div class="col-12">
                                                <div class="mb-1 row">
                                                    <div class="col-sm-3">
                                                        <label class="col-form-label" for="repeat_interval">Tekrarlama Aralığı</label>
                                                    </div>
                                                    <div class="col-sm-9">
                                                        <div class="input-group mb-2">
                                                            <input type="number" id="repeat_interval" name="repeat_interval" class="form-control" min="1" value="1">
                                                            <span class="input-group-text" id="repeat_interval_text">gün</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="mb-1 row">
                                                    <div class="col-sm-3">
                                                        <label class="col-form-label" for="repeat_until">Tekrarlama Sonu</label>
                                                    </div>
                                                    <div class="col-sm-9">
                                                        <input type="text" id="repeat_until" class="form-control flatpickr-basic" name="repeat_until" placeholder="YYYY-MM-DD">
                                                        <small class="text-muted">Boş bırakılırsa süresiz tekrar eder</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="status">Durum</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <div class="form-check form-check-primary form-switch">
                                                        <input type="checkbox" class="form-check-input" id="status" name="status" checked />
                                                        <label class="form-check-label" for="status">
                                                            <span class="switch-icon-left"><i data-feather="check"></i></span>
                                                            <span class="switch-icon-right"><i data-feather="x"></i></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-9 offset-sm-3">
                                            <input type="hidden" name="specialDayAdd" value="1">
                                            <!-- Tarih ve saat alanları için gizli inputlar -->
                                            <input type="hidden" id="start_date_hidden" name="start_date">
                                            <input type="hidden" id="end_date_hidden" name="end_date">
                                            <button type="button" id="saveBtn" class="btn btn-primary me-1" onclick="console.log('Butona tıklandı'); saveSpecialDay();">Kaydet</button>
                                            <a href="/admin/special-days" class="btn btn-outline-secondary">Vazgeç</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        // Date Range Picker
        if ($('#date-range').length) {
            $('#date-range').flatpickr({
                mode: 'range',
                minDate: "today",
                locale: {
                    "firstDayOfWeek": 1,
                    "weekdays": {
                        "shorthand": ["Paz", "Pzt", "Sal", "Çar", "Per", "Cum", "Cmt"],
                        "longhand": ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"]
                    },
                    "months": {
                        "shorthand": ["Oca", "Şub", "Mar", "Nis", "May", "Haz", "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"],
                        "longhand": ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"]
                    }
                }
            });
        }

        // Time Picker
        if ($('.flatpickr-time').length) {
            $('.flatpickr-time').flatpickr({
                enableTime: true,
                noCalendar: true,
                dateFormat: "H:i",
                time_24hr: true
            });
        }
        
        // Basic date picker for repeat until
        if ($('.flatpickr-basic').length) {
            $('.flatpickr-basic').flatpickr({
                minDate: "today",
                locale: {
                    "firstDayOfWeek": 1,
                    "weekdays": {
                        "shorthand": ["Paz", "Pzt", "Sal", "Çar", "Per", "Cum", "Cmt"],
                        "longhand": ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"]
                    },
                    "months": {
                        "shorthand": ["Oca", "Şub", "Mar", "Nis", "May", "Haz", "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"],
                        "longhand": ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"]
                    }
                }
            });
        }
        
        // Tekrarlama seçenekleri
        $('input[name="repeat_type"]').change(function() {
            var repeatType = $('input[name="repeat_type"]:checked').val();
            
            if (repeatType === 'none') {
                $('#repeat_options').slideUp();
            } else {
                $('#repeat_options').slideDown();
                
                // Repeat interval text güncelleme
                var intervalText = 'gün';
                switch(repeatType) {
                    case 'daily':
                        intervalText = 'gün';
                        break;
                    case 'weekly':
                        intervalText = 'hafta';
                        break;
                    case 'monthly':
                        intervalText = 'ay';
                        break;
                    case 'yearly':
                        intervalText = 'yıl';
                        break;
                }
                $('#repeat_interval_text').text(intervalText);
            }
        });
        
        // Kategori rengi değiştiğinde stil güncelleme
        $('#category').change(function() {
            var color = $(this).find('option:selected').data('color');
            $(this).css('border-left', '4px solid ' + color);
        }).change(); // Sayfa yüklendiğinde çalıştır

        // Global ölçekte özel gün kaydetme fonksiyonu tanımla
        window.saveSpecialDay = function() {
            console.log("saveSpecialDay fonksiyonu çağrıldı");
            
            // Doğrudan POST isteği gönder
            saveSpecialDayData();
        };
        
        // Kaydet butonuna tıklandığında AJAX ile gönder (Yedek)
        function saveSpecialDayData() {
            console.log("-------------- YENİ İSTEK BAŞLANGIÇ --------------");
            console.log("Özel gün kaydet butonuna tıklandı - " + new Date().toLocaleString());
            
            // Tüm form alanlarının içeriğini konsola logla
            console.log("Form Alanları:");
            console.log("Başlık:", $('#title').val());
            console.log("Açıklama:", $('#description').val());
            console.log("Tarih Aralığı:", $('#date-range').val());
            console.log("Başlangıç Saati:", $('#start_time').val());
            console.log("Bitiş Saati:", $('#end_time').val());
            console.log("Durum:", $('#status').is(':checked'));
            console.log("Tekrarlama:", $('input[name="repeat_type"]:checked').val());
            console.log("Kategori:", $('#category').val());
            
            // Gelişmiş validasyon
            var validasyonHatalari = [];
            
            if (!$('#title').val() || $('#title').val().trim() === '') {
                validasyonHatalari.push("Başlık alanı boş bırakılamaz");
            }

            if (!$('#date-range').val() || $('#date-range').val().trim() === '') {
                validasyonHatalari.push("Tarih aralığı seçilmelidir");
            }
            
            if (!$('#start_time').val() || $('#start_time').val().trim() === '') {
                validasyonHatalari.push("Mesai başlangıç saati girilmelidir");
            }

            if (!$('#end_time').val() || $('#end_time').val().trim() === '') {
                validasyonHatalari.push("Mesai bitiş saati girilmelidir");
            }
            
            // Validasyon hatalarını kontrol et
            if (validasyonHatalari.length > 0) {
                console.log("Validasyon Hataları:", validasyonHatalari);
                
                Swal.fire({
                    title: "Form Eksik",
                    html: "<strong>Lütfen aşağıdaki alanları doldurun:</strong><br><br>" + 
                          validasyonHatalari.map(hata => "• " + hata).join("<br>"),
                    icon: 'warning',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }
            
            // Form data - Tarih aralığını işle
            var dateRangeVal = $('#date-range').val();
            console.log("Tarih aralığı orijinal değer:", dateRangeVal);
            
            var startDate, endDate;
            
            // Tüm olası tarih formatlarını kontrol et
            if (dateRangeVal.indexOf(" to ") !== -1) {
                // İngilizce format: "2025-03-15 to 2025-03-16"
                var dateRange = dateRangeVal.split(" to ");
                startDate = dateRange[0];
                endDate = dateRange[1] || startDate;
                console.log("İngilizce format algılandı");
            } else if (dateRangeVal.indexOf(" - ") !== -1) {
                // Türkçe format: "2025-03-15 - 2025-03-16"
                var dateRange = dateRangeVal.split(" - ");
                startDate = dateRange[0];
                endDate = dateRange[1] || startDate;
                console.log("Türkçe format algılandı");
            } else if (dateRangeVal.indexOf(",") !== -1) {
                // Virgülle ayrılmış: "2025-03-15,2025-03-16"
                var dateRange = dateRangeVal.split(",");
                startDate = dateRange[0];
                endDate = dateRange[1] || startDate;
                console.log("Virgülle ayrılmış format algılandı");
            } else {
                // Tek tarih seçilmiş
                startDate = dateRangeVal;
                endDate = dateRangeVal;
                console.log("Tek tarih formatı algılandı");
            }
            
            console.log("Ayrıştırılan tarihler - Başlangıç:", startDate, "Bitiş:", endDate);
            
            // Durum ve özellikler
            var status = $('#status').is(':checked') ? 1 : 0;
            var repeatType = $('input[name="repeat_type"]:checked').val();
            var repeatInterval = repeatType !== 'none' ? $('#repeat_interval').val() : "1";
            var repeatUntil = repeatType !== 'none' ? $('#repeat_until').val() : "";
            var category = $('#category').val();
            var color = $('#category option:selected').data('color') || "#7367f0";

            // Tüm verileri içeren obje oluştur
            var formData = {
                specialDayAdd: 1,
                title: $('#title').val(),
                description: $('#description').val(),
                start_date: startDate,
                end_date: endDate,
                start_time: $('#start_time').val(),
                end_time: $('#end_time').val(),
                status: status,
                repeat_type: repeatType,
                repeat_interval: repeatInterval,
                repeat_until: repeatUntil,
                category: category,
                color: color
            };
            
            // Tüm verileri detaylı bir şekilde logla
            console.log("Hazırlanan Veriler:", JSON.stringify(formData, null, 2));
            
            // Kullanıcıya işlem bilgisi göster
            Swal.fire({
                title: 'İşleniyor...',
                text: 'Özel gün kaydediliyor, lütfen bekleyin',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // AJAX request
            console.log("AJAX isteği başlatılıyor: /admin/eral");
            $.ajax({
                type: 'post',
                url: '/admin/eral',
                cache: false,
                data: formData,
                dataType: 'text',
                beforeSend: function(xhr) {
                    console.log("Ajax isteği gönderiliyor...");
                    console.log("İstek başlıkları:", xhr);
                },
                success: function(response) {
                    console.log("Sunucu yanıtı (ham):", response);
                    console.log("Yanıt tipi:", typeof response);
                    console.log("Yanıt uzunluğu:", response ? response.length : 0);
                    
                    // Detaylı hata incelemesi için ekstra loglama
                    if (response) {
                        console.log("Yanıt ilk 10 karakter:", response.substring(0, 10));
                        console.log("Yanıt son 10 karakter:", response.substring(response.length - 10));
                        console.log("Yanıt Unicode kodları:", Array.from(response).map(c => c.charCodeAt(0)));
                    }
                    
                    // Yanıt başarılı mı kontrol et
                    if (response === 'OK') {
                        console.log("Başarılı yanıt algılandı: OK");
                        Swal.fire({
                            title: "Başarılı!",
                            text: "Özel gün başarıyla eklendi.",
                            icon: 'success',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        }).then((result) => {
                            window.location.href = '/admin/special-days';
                        });
                    } else {
                        console.log("Farklı yanıt formatı algılandı. Yanıt prefix kontrolü yapılıyor...");
                        
                        // Prefix'li yanıtları destekle
                        if (response && response.startsWith('BAŞARILI:')) {
                            console.log("Başarılı prefix'i algılandı");
                            Swal.fire({
                                title: "Başarılı!",
                                text: "Özel gün başarıyla eklendi.",
                                icon: 'success',
                                confirmButtonColor: '#7367f0',
                                confirmButtonText: "Tamam"
                            }).then((result) => {
                                window.location.href = '/admin/special-days';
                            });
                        } else if (response && response.startsWith('BAŞLADI:')) {
                            // BAŞLADI: prefix'li yanıtlar - gerçek mesajı al
                            console.log("BAŞLADI: prefix'i algılandı");
                            var realMessage = response.substring(8);
                            console.log("Prefix sonrası mesaj:", realMessage);
                            
                            if (realMessage.startsWith('OK') || realMessage.startsWith('BAŞARILI:')) {
                                Swal.fire({
                                    title: "Başarılı!",
                                    text: "Özel gün başarıyla eklendi.",
                                    icon: 'success',
                                    confirmButtonColor: '#7367f0',
                                    confirmButtonText: "Tamam"
                                }).then((result) => {
                                    window.location.href = '/admin/special-days';
                                });
                            } else {
                                Swal.fire({
                                    title: "İşlem Durum",
                                    html: "<strong>Sunucu yanıtı:</strong><br>" + realMessage,
                                    icon: 'info',
                                    confirmButtonColor: '#7367f0',
                                    confirmButtonText: "Tamam"
                                });
                            }
                        } else if (response && response.startsWith('HATA:')) {
                            // Hata prefix'i ile gelen mesajları göster
                            console.log("HATA: prefix'i algılandı");
                            var errorMessage = response.substring(5);
                            console.log("Hata mesajı:", errorMessage);
                            
                            Swal.fire({
                                title: "Hata!",
                                html: "<strong>İşlem başarısız:</strong><br>" + errorMessage,
                                icon: 'error',
                                confirmButtonColor: '#7367f0',
                                confirmButtonText: "Tamam"
                            });
                        } else if (response && response.startsWith('ERROR:')) {
                            // ERROR prefix'i ile gelen mesajları göster
                            console.log("ERROR: prefix'i algılandı");
                            var errorMessage = response.substring(6);
                            console.log("Hata mesajı:", errorMessage);
                            
                            Swal.fire({
                                title: "Hata!",
                                html: "<strong>İşlem başarısız:</strong><br>" + errorMessage,
                                icon: 'error',
                                confirmButtonColor: '#7367f0',
                                confirmButtonText: "Tamam"
                            });
                        } else {
                            // Diğer hata mesajları veya bilinmeyen yanıtlar
                            console.log("Bilinmeyen yanıt formatı");
                            Swal.fire({
                                title: "Hata!",
                                html: "<strong>İşlem sırasında bir hata oluştu.</strong><br><br>Sunucu yanıtı:<br><pre style='text-align:left;background:#f8f8f8;padding:10px;max-height:200px;overflow:auto;'>" + 
                                      (response || "Yanıt alınamadı") + "</pre>",
                                icon: 'error',
                                confirmButtonColor: '#7367f0',
                                confirmButtonText: "Tamam"
                            });
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX hatası:", error);
                    console.error("Status:", status);
                    console.error("Durum kodu:", xhr.status);
                    console.error("Durum metni:", xhr.statusText);
                    console.error("Yanıt metni:", xhr.responseText);
                    console.error("Tüm XHR objesi:", xhr);
                    
                    var errorDetails = "Hata: " + error + "<br>" +
                                      "Durum: " + status + "<br>" +
                                      "Durum Kodu: " + xhr.status + "<br>" +
                                      "Yanıt: " + (xhr.responseText || "Boş yanıt");
                    
                    Swal.fire({
                        title: "Bağlantı Hatası!",
                        html: "<strong>Sunucu ile iletişim sırasında bir hata oluştu:</strong><br><br>" + errorDetails,
                        icon: 'error',
                        confirmButtonColor: '#7367f0',
                        confirmButtonText: "Tamam"
                    });
                },
                complete: function(xhr, status) {
                    console.log("AJAX isteği tamamlandı. Durum:", status);
                    console.log("-------------- İSTEK SONU --------------");
                }
            });
        }
        
        // Bu kod bloğu artık kullanılmıyor, yukarıda butona direkt işlev atandı
    });
</script>

<?php
require $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Footer.php';
?>

<!-- Özel gün kaydetme fonksiyonu -->
<script>
    // Global saveSpecialDay fonksiyonu
    function saveSpecialDay() {
        // Form değerlerini al ve kontrol et
        var title = document.getElementById('title').value;
        if (!title) {
            alert("Lütfen başlık giriniz");
            return false;
        }
        
        var dateRange = document.getElementById('date-range').value;
        if (!dateRange) {
            alert("Lütfen tarih aralığı seçiniz");
            return false;
        }
        
        var startTime = document.getElementById('start_time').value;
        if (!startTime) {
            alert("Lütfen başlangıç saati giriniz");
            return false;
        }
        
        var endTime = document.getElementById('end_time').value;
        if (!endTime) {
            alert("Lütfen bitiş saati giriniz");
            return false;
        }
        
        // Tarih aralığını ayrıştır
        var startDate, endDate;
        
        if (dateRange.indexOf(" to ") !== -1) {
            var dates = dateRange.split(" to ");
            startDate = dates[0];
            endDate = dates[1] || dates[0];
        } else if (dateRange.indexOf(" - ") !== -1) {
            var dates = dateRange.split(" - ");
            startDate = dates[0];
            endDate = dates[1] || dates[0]; 
        } else {
            startDate = dateRange;
            endDate = dateRange;
        }
        
        var status = document.getElementById('status').checked ? 1 : 0;
        var repeatType = document.querySelector('input[name="repeat_type"]:checked').value;
        var repeatInterval = repeatType !== 'none' ? document.getElementById('repeat_interval').value : "1";
        var repeatUntil = repeatType !== 'none' ? document.getElementById('repeat_until').value : "";
        var category = document.getElementById('category').value;
        
        // Form verilerini string olarak hazırla
        var data = 'specialDayAdd=1' + 
                   '&title=' + encodeURIComponent(title) + 
                   '&description=' + encodeURIComponent(document.getElementById('description').value) + 
                   '&start_date=' + encodeURIComponent(startDate) + 
                   '&end_date=' + encodeURIComponent(endDate) + 
                   '&start_time=' + encodeURIComponent(startTime) + 
                   '&end_time=' + encodeURIComponent(endTime) + 
                   '&status=' + status +
                   '&repeat_type=' + encodeURIComponent(repeatType) +
                   '&repeat_interval=' + encodeURIComponent(repeatInterval) +
                   '&repeat_until=' + encodeURIComponent(repeatUntil) +
                   '&category=' + encodeURIComponent(category);
        
        // AJAX isteği gönder
        var xhr = new XMLHttpRequest();
        xhr.open('POST', '/admin/eral', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    if (xhr.responseText === "OK" || 
                        xhr.responseText.indexOf("BAŞARILI") !== -1 || 
                        xhr.responseText.indexOf("OK") !== -1) {
                        window.location.href = '/admin/special-days';
                    } else if (xhr.responseText.indexOf("HATA") !== -1 || xhr.responseText.indexOf("ERROR") !== -1) {
                        // Hata mesajını göster
                        var errorMsg = xhr.responseText;
                        if (errorMsg.indexOf("HATA:") !== -1) {
                            errorMsg = errorMsg.split("HATA:")[1];
                        } else if (errorMsg.indexOf("ERROR:") !== -1) {
                            errorMsg = errorMsg.split("ERROR:")[1];
                        }
                        alert("Hata: " + errorMsg);
                    } else {
                        // Diğer yanıtlar
                        alert("İşlem tamamlandı.");
                        window.location.href = '/admin/special-days';
                    }
                } else {
                    alert("Sunucu hatası: " + xhr.status);
                }
            }
        };
        xhr.send(data);
        
        return false; // Formun normal gönderimini engelle
    }
</script>