<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';
?>
<?php
require $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Header.php';
?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">Özel Gün Kategorileri</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="/admin/home">Anasayfa</a>
                                </li>
                                <li class="breadcrumb-item"><a href="/admin/special-days">Özel Günler</a>
                                </li>
                                <li class="breadcrumb-item active">Özel Gün Kategorileri
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="basic-datatable">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title">Kategori Listesi</h4>
                                <button class="btn btn-primary waves-effect waves-float waves-light" 
                                    data-bs-toggle="modal" data-bs-target="#addCategoryModal">Yeni Kategori Ekle</button>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Kategori Adı</th>
                                            <th>Kod</th>
                                            <th>Renk</th>
                                            <th>Açıklama</th>
                                            <th>İşlemler</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $categoriesQuery = $DB->query("SELECT * FROM special_day_categories ORDER BY id ASC");
                                        while ($category = $categoriesQuery->fetch(PDO::FETCH_ASSOC)) {
                                        ?>
                                            <tr>
                                                <td><?= $category['id'] ?></td>
                                                <td><?= htmlspecialchars($category['name']) ?></td>
                                                <td><code><?= htmlspecialchars($category['code']) ?></code></td>
                                                <td>
                                                    <span class="badge rounded-pill" style="background-color: <?= $category['color'] ?>">
                                                        <?= $category['color'] ?>
                                                    </span>
                                                </td>
                                                <td><?= htmlspecialchars($category['description']) ?></td>
                                                <td>
                                                    <div class="btn-group" role="group" aria-label="İşlemler">
                                                        <button type="button" class="btn btn-outline-primary waves-effect" 
                                                            onclick="editCategory(<?= $category['id'] ?>)">Düzenle</button>
                                                        <?php if ($category['code'] != 'default') { ?>
                                                            <button type="button" class="btn btn-outline-danger waves-effect" 
                                                                onclick="deleteCategory(<?= $category['id'] ?>)">Sil</button>
                                                        <?php } ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- Kategori Ekleme Modal -->
<div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addCategoryModalLabel">Yeni Kategori Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
            </div>
            <div class="modal-body">
                <form id="addCategoryForm">
                    <div class="mb-3">
                        <label for="categoryName" class="form-label">Kategori Adı</label>
                        <input type="text" class="form-control" id="categoryName" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="categoryCode" class="form-label">Kategori Kodu</label>
                        <input type="text" class="form-control" id="categoryCode" name="code" required>
                        <small class="text-muted">Sadece küçük harfler, rakamlar ve alt çizgi kullanın</small>
                    </div>
                    <div class="mb-3">
                        <label for="categoryColor" class="form-label">Renk</label>
                        <input type="color" class="form-control form-control-color" id="categoryColor" name="color" value="#7367f0" required>
                    </div>
                    <div class="mb-3">
                        <label for="categoryDescription" class="form-label">Açıklama</label>
                        <textarea class="form-control" id="categoryDescription" name="description" rows="3"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-primary" id="saveCategoryBtn">Kaydet</button>
            </div>
        </div>
    </div>
</div>

<!-- Kategori Düzenleme Modal -->
<div class="modal fade" id="editCategoryModal" tabindex="-1" aria-labelledby="editCategoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editCategoryModalLabel">Kategori Düzenle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
            </div>
            <div class="modal-body">
                <form id="editCategoryForm">
                    <input type="hidden" id="editCategoryId" name="id">
                    <div class="mb-3">
                        <label for="editCategoryName" class="form-label">Kategori Adı</label>
                        <input type="text" class="form-control" id="editCategoryName" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="editCategoryCode" class="form-label">Kategori Kodu</label>
                        <input type="text" class="form-control" id="editCategoryCode" name="code" required>
                        <small class="text-muted">Sadece küçük harfler, rakamlar ve alt çizgi kullanın</small>
                    </div>
                    <div class="mb-3">
                        <label for="editCategoryColor" class="form-label">Renk</label>
                        <input type="color" class="form-control form-control-color" id="editCategoryColor" name="color" value="#7367f0" required>
                    </div>
                    <div class="mb-3">
                        <label for="editCategoryDescription" class="form-label">Açıklama</label>
                        <textarea class="form-control" id="editCategoryDescription" name="description" rows="3"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-primary" id="updateCategoryBtn">Güncelle</button>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // jQuery kontrolü
        if (typeof $ === 'undefined') {
            console.error('jQuery yüklenemedi! jQuery manuel olarak yükleniyor...');
            // jQuery'yi yükle
            var script = document.createElement('script');
            script.src = 'https://code.jquery.com/jquery-3.6.0.min.js';
            script.onload = initFunctions;
            document.head.appendChild(script);
        } else {
            console.log('jQuery zaten yüklenmiş, sürüm:', $.fn.jquery);
            initFunctions();
        }
    });
    
    // Tüm jQuery bağımlı fonksiyonları buraya taşı
    function initFunctions() {
        // Kategori Ekleme
        console.log("Save butonu eventleri tanımlanıyor...");
        var saveBtn = document.getElementById('saveCategoryBtn');
        if (!saveBtn) {
            console.error("Kaydet butonu bulunamadı!");
        } else {
            console.log("Kaydet butonu bulundu, event tanımlanıyor");
        }
        
        $(document).on('click', '#saveCategoryBtn', function(e) {
            e.preventDefault();
            console.log("Kaydet butonuna tıklandı!");
            // Form doğrulama
            if (!$('#categoryName').val()) {
                Swal.fire({
                    title: "Hata",
                    text: "Lütfen kategori adı giriniz.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }
            
            if (!$('#categoryCode').val()) {
                Swal.fire({
                    title: "Hata",
                    text: "Lütfen kategori kodu giriniz.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }
            
            // Kod formatı kontrolü
            var codePattern = /^[a-z0-9_]+$/;
            if (!codePattern.test($('#categoryCode').val())) {
                Swal.fire({
                    title: "Hata",
                    text: "Kategori kodu sadece küçük harfler, rakamlar ve alt çizgi içerebilir.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }
            
            // Form verisini göster
            console.log("Gönderilecek veriler:", {
                addSpecialDayCategory: 1,
                name: $('#categoryName').val(),
                code: $('#categoryCode').val(),
                color: $('#categoryColor').val(),
                description: $('#categoryDescription').val()
            });
            
            // AJAX isteği
            $.ajax({
                type: 'post',
                url: '/admin/eral',
                data: "addSpecialDayCategory=1&name=" + encodeURIComponent($('#categoryName').val()) + 
                      "&code=" + encodeURIComponent($('#categoryCode').val()) + 
                      "&color=" + encodeURIComponent($('#categoryColor').val()) + 
                      "&description=" + encodeURIComponent($('#categoryDescription').val()),
                contentType: 'application/x-www-form-urlencoded',
                dataType: 'text',
                success: function(response) {
                    console.log("Yeni kategori ekleme yanıtı:", response);
                    
                    if (response.includes('OK')) {
                        Swal.fire({
                            title: "Başarılı!",
                            text: "Kategori başarıyla eklendi.",
                            icon: 'success',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        }).then((result) => {
                            location.reload();
                        });
                    } else if (response === 'DUPLICATE') {
                        Swal.fire({
                            title: "Hata!",
                            text: "Bu kategori kodu zaten kullanılıyor.",
                            icon: 'error',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        });
                    } else {
                        // ERROR: ile başlayan hata mesajlarını kontrol et
                        let errorMsg = "İşlem sırasında bir hata oluştu.";
                        if (typeof response === 'string' && response.includes('ERROR:')) {
                            // ERROR: sonrasını çıkar (satır sonu olabilir)
                            const errorParts = response.split('ERROR:');
                            if (errorParts.length > 1) {
                                errorMsg = errorParts[1].trim();
                            }
                        }
                        
                        Swal.fire({
                            title: "Hata!",
                            text: errorMsg,
                            icon: 'error',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX hatası:", error);
                    Swal.fire({
                        title: "Bağlantı Hatası!",
                        text: "Sunucu ile iletişim sırasında bir hata oluştu.",
                        icon: 'error',
                        confirmButtonColor: '#7367f0',
                        confirmButtonText: "Tamam"
                    });
                }
            });
        });
        
        // Kategori Güncelleme
        console.log("Update butonu eventleri tanımlanıyor...");
        $(document).on('click', '#updateCategoryBtn', function(e) {
            e.preventDefault();
            console.log("Güncelle butonuna tıklandı!");
            // Form doğrulama
            if (!$('#editCategoryName').val()) {
                Swal.fire({
                    title: "Hata",
                    text: "Lütfen kategori adı giriniz.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }
            
            if (!$('#editCategoryCode').val()) {
                Swal.fire({
                    title: "Hata",
                    text: "Lütfen kategori kodu giriniz.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }
            
            // Kod formatı kontrolü
            var codePattern = /^[a-z0-9_]+$/;
            if (!codePattern.test($('#editCategoryCode').val())) {
                Swal.fire({
                    title: "Hata",
                    text: "Kategori kodu sadece küçük harfler, rakamlar ve alt çizgi içerebilir.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }
            
            // Form verisini göster
            console.log("Güncellenecek veriler:", {
                updateSpecialDayCategory: 1,
                id: $('#editCategoryId').val(),
                name: $('#editCategoryName').val(),
                code: $('#editCategoryCode').val(),
                color: $('#editCategoryColor').val(),
                description: $('#editCategoryDescription').val()
            });
            
            // AJAX isteği
            $.ajax({
                type: 'post',
                url: '/admin/eral',
                data: "updateSpecialDayCategory=1&id=" + encodeURIComponent($('#editCategoryId').val()) +
                      "&name=" + encodeURIComponent($('#editCategoryName').val()) + 
                      "&code=" + encodeURIComponent($('#editCategoryCode').val()) + 
                      "&color=" + encodeURIComponent($('#editCategoryColor').val()) + 
                      "&description=" + encodeURIComponent($('#editCategoryDescription').val()),
                contentType: 'application/x-www-form-urlencoded',
                dataType: 'text',
                success: function(response) {
                    console.log("Kategori güncelleme yanıtı:", response);
                    
                    if (response.includes('OK')) {
                        Swal.fire({
                            title: "Başarılı!",
                            text: "Kategori başarıyla güncellendi.",
                            icon: 'success',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        }).then((result) => {
                            location.reload();
                        });
                    } else if (response === 'DUPLICATE') {
                        Swal.fire({
                            title: "Hata!",
                            text: "Bu kategori kodu zaten kullanılıyor.",
                            icon: 'error',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        });
                    } else {
                        // ERROR: ile başlayan hata mesajlarını kontrol et
                        let errorMsg = "İşlem sırasında bir hata oluştu.";
                        if (typeof response === 'string' && response.includes('ERROR:')) {
                            // ERROR: sonrasını çıkar (satır sonu olabilir)
                            const errorParts = response.split('ERROR:');
                            if (errorParts.length > 1) {
                                errorMsg = errorParts[1].trim();
                            }
                        }
                        
                        Swal.fire({
                            title: "Hata!",
                            text: errorMsg,
                            icon: 'error',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX hatası:", error);
                    Swal.fire({
                        title: "Bağlantı Hatası!",
                        text: "Sunucu ile iletişim sırasında bir hata oluştu.",
                        icon: 'error',
                        confirmButtonColor: '#7367f0',
                        confirmButtonText: "Tamam"
                    });
                }
            });
        });
    }

    // Kategori Düzenleme Fonksiyonu tanımını burada tut - global scope'ta olsun
    function editCategory(id) {
        $.ajax({
            type: 'post',
            url: '/admin/eral',
            data: {
                getSpecialDayCategory: 1,
                id: id
            },
            success: function(response) {
                console.log("API yanıtı:", response);
                try {
                    // Yanıt halihazırda JSON objesi olabilir
                    let category;
                    
                    if (typeof response === 'object') {
                        category = response;
                    } else {
                        category = JSON.parse(response);
                    }
                    
                    if (category.error) {
                        throw new Error(category.error);
                    }
                    
                    $('#editCategoryId').val(category.id);
                    $('#editCategoryName').val(category.name);
                    $('#editCategoryCode').val(category.code);
                    $('#editCategoryColor').val(category.color);
                    $('#editCategoryDescription').val(category.description);
                    
                    // Default kategori kodunu düzenlemeyi engelle
                    if (category.code === 'default') {
                        $('#editCategoryCode').prop('readonly', true);
                    } else {
                        $('#editCategoryCode').prop('readonly', false);
                    }
                    
                    // Modalı aç
                    $('#editCategoryModal').modal('show');
                } catch (e) {
                    console.error("Kategori bilgisi ayrıştırma hatası:", e, "Yanıt:", response);
                    Swal.fire({
                        title: "Hata!",
                        text: "Kategori bilgileri alınamadı: " + e.message,
                        icon: 'error',
                        confirmButtonColor: '#7367f0',
                        confirmButtonText: "Tamam"
                    });
                }
            }
        });
    }

    // Kategori Silme Fonksiyonu - global scope'ta
    function deleteCategory(id) {
        Swal.fire({
            title: 'Emin misiniz?',
            text: "Bu kategoriyi silmek istediğinize emin misiniz? Bu kategoriyi kullanan özel günler, varsayılan kategoriye taşınacaktır.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Evet, sil!',
            cancelButtonText: 'İptal'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'post',
                    url: '/admin/eral',
                    data: {
                        deleteSpecialDayCategory: 1,
                        id: id
                    },
                    success: function(response) {
                        if (response === 'OK') {
                            Swal.fire(
                                'Silindi!',
                                'Kategori başarıyla silindi.',
                                'success'
                            ).then((result) => {
                                location.reload();
                            });
                        } else if (response === 'DEFAULT') {
                            Swal.fire(
                                'Hata!',
                                'Varsayılan kategori silinemez.',
                                'error'
                            );
                        } else {
                            Swal.fire(
                                'Hata!',
                                'Silme işlemi sırasında bir hata oluştu.',
                                'error'
                            );
                        }
                    }
                });
            }
        });
    }
</script>

<?php
require $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Footer.php';
?>