<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';
?>
<?php
require $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Header.php';

// ID'yi URL'den al
$url = $_SERVER["REQUEST_URI"];
$url_components = parse_url($url);
$url_components = explode('/', $url_components['path']);
$id = end($url_components);

// Loglama
error_log("SpecialDayEdit.php - ID: $id, URL: $url");

// Özel gün bilgilerini çek
try {
    $specialDayQuery = $DB->prepare("SELECT * FROM special_days WHERE id = ?");
    $specialDayQuery->execute([$id]);
    $specialDay = $specialDayQuery->fetch(PDO::FETCH_ASSOC);
    
    // Bulundu mu kontrol et
    if ($specialDay) {
        error_log("SpecialDayEdit.php - Özel gün bulundu: " . json_encode($specialDay));
    } else {
        error_log("SpecialDayEdit.php - Özel gün bulunamadı (ID: $id)");
    }
} catch (Exception $e) {
    error_log("SpecialDayEdit.php - Veritabanı hatası: " . $e->getMessage());
    $specialDay = null;
}

// Eğer kayıt bulunamazsa SpecialDays sayfasına yönlendir
if (!$specialDay) {
    echo "<script>window.location.href = 'SpecialDays';</script>";
    exit;
}
?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">Özel Gün Düzenle</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="/admin/home">Anasayfa</a>
                                </li>
                                <li class="breadcrumb-item"><a href="/admin/special-days">Özel Günler</a>
                                </li>
                                <li class="breadcrumb-item active">Özel Gün Düzenle
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="basic-horizontal-layouts">
                <div class="row">
                    <div class="col-md-12 col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Özel Gün Bilgileri</h4>
                            </div>
                            <div class="card-body">
                                <form id="specialDayForm" class="form form-horizontal">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="title">Başlık</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" id="title" class="form-control" name="title" placeholder="Özel gün başlığı" value="<?= htmlspecialchars($specialDay['title']) ?>" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="description">Açıklama</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <textarea id="description" class="form-control" name="description" placeholder="Açıklama" rows="3"><?= htmlspecialchars($specialDay['description']) ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="date-range">Tarih Aralığı</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" id="date-range" class="form-control flatpickr-range" name="date-range" placeholder="YYYY-MM-DD - YYYY-MM-DD" value="<?= $specialDay['start_date'] . ($specialDay['start_date'] != $specialDay['end_date'] ? ' to ' . $specialDay['end_date'] : '') ?>" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="start_time">Mesai Başlangıç Saati</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" id="start_time" class="form-control flatpickr-time" name="start_time" placeholder="HH:MM" value="<?= $specialDay['start_time'] ?>" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="end_time">Mesai Bitiş Saati</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" id="end_time" class="form-control flatpickr-time" name="end_time" placeholder="HH:MM" value="<?= $specialDay['end_time'] ?>" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-1 row">
                                                <div class="col-sm-3">
                                                    <label class="col-form-label" for="status">Durum</label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <div class="form-check form-check-primary form-switch">
                                                        <input type="checkbox" class="form-check-input" id="status" name="status" <?= $specialDay['status'] ? 'checked' : '' ?> />
                                                        <label class="form-check-label" for="status">
                                                            <span class="switch-icon-left"><i data-feather="check"></i></span>
                                                            <span class="switch-icon-right"><i data-feather="x"></i></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-9 offset-sm-3">
                                            <input type="hidden" name="specialDayEdit" value="1">
                                            <input type="hidden" name="id" value="<?= $id ?>">
                                            <button id="saveBtn" type="button" class="btn btn-primary me-1" onclick="updateSpecialDay()">Güncelle</button>
                                            <a href="/admin/special-days" class="btn btn-outline-secondary">Vazgeç</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/jquery/jquery.min.js"></script>
<script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // jQuery'nin yüklü olup olmadığını kontrol et, yüklü değilse ekle
    if (typeof jQuery === 'undefined') {
        console.log('jQuery yüklü değil, yükleniyor...');
        document.write('<script src="https://code.jquery.com/jquery-3.6.0.min.js"><\/script>');
    }

    jQuery(document).ready(function($) {
        console.log('Document ready, jQuery sürümü:', $.fn.jquery);
        
        // Date Range Picker
        if ($('#date-range').length) {
            $('#date-range').flatpickr({
                mode: 'range',
                minDate: "today",
                locale: {
                    "firstDayOfWeek": 1,
                    "weekdays": {
                        "shorthand": ["Paz", "Pzt", "Sal", "Çar", "Per", "Cum", "Cmt"],
                        "longhand": ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"]
                    },
                    "months": {
                        "shorthand": ["Oca", "Şub", "Mar", "Nis", "May", "Haz", "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"],
                        "longhand": ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"]
                    }
                }
            });
        }

        // Time Picker
        if ($('.flatpickr-time').length) {
            $('.flatpickr-time').flatpickr({
                enableTime: true,
                noCalendar: true,
                dateFormat: "H:i",
                time_24hr: true
            });
        }
    });
    
    // Güncelleme Fonksiyonu - Global scope
    function updateSpecialDay() {
        // jQuery'in yüklü olduğundan emin ol
        if (typeof jQuery !== 'undefined') {
            var $ = jQuery;
            
            // Simple validation
            if ($('#title').val() == '') {
                Swal.fire({
                    title: "Hata",
                    text: "Lütfen başlık giriniz.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }

            if ($('#date-range').val() == '') {
                Swal.fire({
                    title: "Hata",
                    text: "Lütfen tarih aralığı seçiniz.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }

            if ($('#start_time').val() == '') {
                Swal.fire({
                    title: "Hata",
                    text: "Lütfen mesai başlangıç saati giriniz.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }

            if ($('#end_time').val() == '') {
                Swal.fire({
                    title: "Hata",
                    text: "Lütfen mesai bitiş saati giriniz.",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "Tamam"
                });
                return false;
            }

            // Form data
            var dateRange = $('#date-range').val().split(" to ");
            var startDate = dateRange[0];
            var endDate = dateRange[1] || dateRange[0];
            var status = $('#status').is(':checked') ? 1 : 0;

            // AJAX request
            console.log("Güncelleme başlatılıyor...");
            // Kullanıcıya bildirim göster
            Swal.fire({
                title: 'İşleniyor...',
                text: 'Güncelleme yapılıyor, lütfen bekleyin',
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // Form verileri için FormData kullan
            var formData = new FormData();
            formData.append('specialDayEdit', '1');
            formData.append('id', '<?= $id ?>');
            formData.append('title', $('#title').val());
            formData.append('description', $('#description').val());
            formData.append('start_date', startDate);
            formData.append('end_date', endDate);
            formData.append('start_time', $('#start_time').val());
            formData.append('end_time', $('#end_time').val());
            formData.append('status', status);
            formData.append('repeat_type', 'none');
            formData.append('repeat_interval', '1');
            formData.append('category', 'default');
            formData.append('color', '#7367f0');
            
            console.log("FormData içeriği:", {
                specialDayEdit: 1,
                id: <?= $id ?>,
                title: $('#title').val(),
                description: $('#description').val(),
                start_date: startDate,
                end_date: endDate,
                start_time: $('#start_time').val(),
                end_time: $('#end_time').val(),
                status: status,
                repeat_type: 'none',
                repeat_interval: 1,
                category: 'default',
                color: '#7367f0'
            });
            
            $.ajax({
                type: 'post',
                url: '/admin/eral', // Tekrar eral endpoint'ini kullan
                data: {
                    specialDayEdit: 1,
                    id: <?= $id ?>,
                    title: $('#title').val(),
                    description: $('#description').val(),
                    start_date: startDate,
                    end_date: endDate,
                    start_time: $('#start_time').val(),
                    end_time: $('#end_time').val(),
                    status: status,
                    repeat_type: 'none',
                    repeat_interval: 1,
                    category: 'default',
                    color: '#7367f0'
                },
                success: function(response) {
                    console.log("Yanıt:", response);
                    
                    // Konsola detaylı log yaz
                    console.log("Güncelleme: ID=" + <?= $id ?> + ", URL=/admin/eral");
                    console.log("Tam yanıt:", response);
                    console.log("Yanıt tipi:", typeof response);
                    
                    // Boş yanıtı kontrol et
                    if (response === "" || response === null || response === undefined) {
                        console.error("Sunucu boş yanıt döndürdü!");
                        Swal.fire({
                            title: "Hata!",
                            text: "Sunucu boş yanıt döndürdü. Lütfen sistem loglarını kontrol edin.",
                            icon: 'error',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        });
                        return;
                    }
                    
                    // Basit string yanıt kontrolü - yeni format (BAŞLADI:, BAŞARILI:, HATA:)
                    if (response.indexOf('BAŞARILI:') === 0 || response.indexOf('BAŞLADI:BAŞARILI:') === 0) {
                        Swal.fire({
                            title: "Başarılı!",
                            text: "Özel gün başarıyla güncellendi.",
                            icon: 'success',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        }).then((result) => {
                            window.location.href = '/admin/special-days';
                        });
                    } else if (response === 'OK') { // Eski format
                        Swal.fire({
                            title: "Başarılı!",
                            text: "Özel gün başarıyla güncellendi.",
                            icon: 'success',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        }).then((result) => {
                            window.location.href = '/admin/special-days';
                        });
                    } else if (response.indexOf('HATA:') === 0 || response.indexOf('BAŞLADI:HATA:') === 0) {
                        // Hata mesajı varsa göster
                        var errorMessage = response.replace('HATA:', '').replace('BAŞLADI:', '').trim();
                        if (!errorMessage) errorMessage = "İşlem sırasında bir hata oluştu.";
                        
                        Swal.fire({
                            title: "Hata!",
                            text: errorMessage,
                            icon: 'error',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        });
                    } else if (typeof response === 'string' && response.indexOf('ERROR') === 0) {
                        // Eski format hata
                        var errorMessage = response.replace('ERROR:', '').trim();
                        if (!errorMessage) errorMessage = "İşlem sırasında bir hata oluştu.";
                        
                        Swal.fire({
                            title: "Hata!",
                            text: errorMessage,
                            icon: 'error',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        });
                    } else {
                        // Bilinmeyen yanıt formatı
                        console.log("Bilinmeyen yanıt formatı:", response);
                        Swal.fire({
                            title: "Uyarı!",
                            text: "Sunucu yanıtı: " + String(response).substring(0, 100),
                            icon: 'warning',
                            confirmButtonColor: '#7367f0',
                            confirmButtonText: "Tamam"
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX hatası:", error);
                    Swal.fire({
                        title: "Hata!",
                        text: "Sunucu ile iletişim sırasında bir hata oluştu: " + error,
                        icon: 'error',
                        confirmButtonColor: '#7367f0',
                        confirmButtonText: "Tamam"
                    });
                }
            });
        } else {
            console.error("jQuery yüklü değil!");
            alert("Sistem hatası: jQuery yüklü değil. Lütfen sayfayı yenileyip tekrar deneyin.");
        }
    }
</script>

<?php
require $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Footer.php';
?>