<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';
?>
<?php
require $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Header.php';
?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">Özel Günler</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="/admin/home">Anasayfa</a>
                                </li>
                                <li class="breadcrumb-item active">Özel Günler
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="basic-datatable">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title">Özel Günler Listesi</h4>
                                <a href="/admin/special-day-add" class="btn btn-primary waves-effect waves-float waves-light">Yeni Ekle</a>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Başlık</th>
                                            <th>Tarih Aralığı</th>
                                            <th>Mesai Saatleri</th>
                                            <th>Durum</th>
                                            <th>İşlemler</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $specialDaysQuery = $DB->query("SELECT * FROM special_days ORDER BY id DESC");
                                        while ($specialDay = $specialDaysQuery->fetch(PDO::FETCH_ASSOC)) {
                                        ?>
                                            <tr>
                                                <td><?= $specialDay['id'] ?></td>
                                                <td><?= $specialDay['title'] ?></td>
                                                <td><?= date('d.m.Y', strtotime($specialDay['start_date'])) ?> - <?= date('d.m.Y', strtotime($specialDay['end_date'])) ?></td>
                                                <td><?= $specialDay['start_time'] ?> - <?= $specialDay['end_time'] ?></td>
                                                <td>
                                                    <?php if ($specialDay['status'] == 1) { ?>
                                                        <span class="badge rounded-pill badge-light-success">Aktif</span>
                                                    <?php } else { ?>
                                                        <span class="badge rounded-pill badge-light-danger">Pasif</span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <div class="btn-group" role="group" aria-label="Basic example">
                                                        <a href="/admin/special-day/<?= $specialDay['id'] ?>" class="btn btn-outline-primary waves-effect">Düzenle</a>
                                                        <button type="button" class="btn btn-outline-danger waves-effect" onclick="specialDayDelete(<?= $specialDay['id'] ?>)">Sil</button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function specialDayDelete(id) {
        // jQuery kontrolü
        if (typeof $ === 'undefined') {
            console.error('jQuery yüklenemedi!');
            alert('jQuery yüklenemedi! Vanilla JavaScript kullanılacak');
            deleteWithVanillaJS(id);
            return;
        }
        
        Swal.fire({
            title: 'Emin misiniz?',
            text: "Bu kaydı silmek istediğinize emin misiniz?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Evet, sil!',
            cancelButtonText: 'İptal'
        }).then((result) => {
            if (result.isConfirmed) {
                // AJAX işlemi
                console.log("Silme işlemi başlatılıyor, ID:", id);
                
                $.ajax({
                    type: 'post',
                    url: '/admin/eral',
                    data: {
                        specialDayDelete: 1,
                        id: id
                    },
                    dataType: 'text',
                    success: function(response) {
                        console.log("Sunucu yanıtı (ham):", response);
                        console.log("Yanıt tipi:", typeof response);
                        console.log("Yanıt uzunluğu:", response ? response.length : 0);
                        
                        // Yanıt boş olabilir, kontrol et
                        if (!response || response.trim() === '') {
                            console.error("Boş yanıt alındı!");
                            Swal.fire(
                                'Hata!',
                                'Sunucudan boş yanıt alındı. Lütfen sayfayı yenileyip tekrar deneyin.',
                                'error'
                            );
                            return;
                        }
                        
                        // OK yanıtı veya içinde OK barındıran string
                        if (response === 'OK' || 
                            response.indexOf('OK') !== -1 || 
                            response.indexOf('ok') !== -1) {
                            
                            console.log("Başarılı yanıt algılandı, kayıt silindi");
                            Swal.fire(
                                'Silindi!',
                                'Kayıt başarıyla silindi.',
                                'success'
                            ).then((result) => {
                                location.reload();
                            });
                        } else {
                            // Yanıtın içeriğini kontrol et
                            var errorMsg = 'Bilinmeyen hata.';
                            
                            if (response.startsWith('ERROR:')) {
                                errorMsg = response.substring(6);
                            } else if (response.startsWith('HATA:')) {
                                errorMsg = response.substring(5);
                            } else {
                                errorMsg = 'Silme işlemi sırasında bir hata oluştu. Detay: ' + response;
                            }
                            
                            console.error("Hata yanıtı:", errorMsg);
                            
                            Swal.fire({
                                title: 'Hata!',
                                text: errorMsg,
                                icon: 'error',
                                confirmButtonColor: '#d33',
                                confirmButtonText: 'Tamam'
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX hatası:", error);
                        console.error("Durum:", status);
                        console.error("XHR:", xhr);
                        
                        Swal.fire(
                            'Bağlantı Hatası!',
                            'Sunucu ile iletişim sırasında bir hata oluştu.',
                            'error'
                        );
                    }
                });
            }
        });
    }
    
    // jQuery yoksa bu fonksiyon çalışacak
    function deleteWithVanillaJS(id) {
        if (confirm("Bu kaydı silmek istediğinize emin misiniz?")) {
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '/admin/eral', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    console.log("Vanilla JS - Sunucu yanıtı:", xhr.responseText);
                    console.log("Vanilla JS - Yanıt uzunluğu:", xhr.responseText ? xhr.responseText.length : 0);
                    
                    if (xhr.status === 200) {
                        // Boş yanıt kontrolü
                        if (!xhr.responseText || xhr.responseText.trim() === '') {
                            console.error("Boş yanıt alındı!");
                            alert('Sunucudan boş yanıt alındı. Lütfen sayfayı yenileyip tekrar deneyin.');
                            return;
                        }
                        
                        // Başarı kontrolü
                        if (xhr.responseText === "OK" || 
                            xhr.responseText.indexOf('OK') !== -1 || 
                            xhr.responseText.indexOf('ok') !== -1) {
                            
                            alert('Kayıt başarıyla silindi.');
                            location.reload();
                        } else {
                            // Hata mesajı ayrıştırma
                            var errorMsg = 'Bilinmeyen hata.';
                            
                            if (xhr.responseText.startsWith('ERROR:')) {
                                errorMsg = xhr.responseText.substring(6);
                            } else if (xhr.responseText.startsWith('HATA:')) {
                                errorMsg = xhr.responseText.substring(5);
                            } else {
                                errorMsg = 'Silme işlemi sırasında bir hata oluştu. Detay: ' + xhr.responseText;
                            }
                            
                            console.error("Vanilla JS - Hata yanıtı:", errorMsg);
                            alert(errorMsg);
                        }
                    } else {
                        console.error("Vanilla JS - HTTP hata kodu:", xhr.status);
                        alert('Sunucu bağlantı hatası: ' + xhr.status + '\nLütfen daha sonra tekrar deneyin.');
                    }
                }
            };
            // ID'nin sayısal bir değer olduğundan emin ol
            var safeId = parseInt(id, 10);
            if (isNaN(safeId)) {
                console.error("Geçersiz ID değeri:", id);
                alert("Geçersiz ID değeri.");
                return;
            }
            
            xhr.send('specialDayDelete=1&id=' + safeId);
        }
    }
</script>

<?php
require $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Footer.php';
?>