const CACHE_NAME = 'pwa-cache-v1'; 
const cacheUrls = [
    '/admin/',
    '/admin/index.php',
    '/admin/pages/Login.php',
    '/admin/styles.css',
    '/admin/app.js',
    '/admin/pwaa.png',
    '/admin/iconn.png',
  
];

self.addEventListener('install', (event) => {
    event.waitUntil(
        caches.open(CACHE_NAME).then((cache) => {
            return cache.addAll(cacheUrls);
        })
    );
});

self.addEventListener('fetch', (event) => {
    // POST isteklerini ele alma - sadece GET isteklerini önbelleğe al
    if (event.request.method !== 'GET') {
        return;
    }
    
    event.respondWith(
        caches.match(event.request).then((response) => {
            return response || fetch(event.request).then(networkResponse => {
                // Yanıtı önbelleğe ekle ama sadece GET istekleri için
                if (networkResponse.status === 200) {
                    const responseToCache = networkResponse.clone();
                    caches.open(CACHE_NAME).then(cache => {
                        cache.put(event.request, responseToCache);
                    });
                }
                return networkResponse;
            });
        })
    );
});

self.addEventListener('activate', (event) => {
    event.waitUntil(
        caches.keys().then((cacheNames) => {
            return Promise.all(
                cacheNames
                    .filter((name) => name !== CACHE_NAME)
                    .map((name) => caches.delete(name))
            );
        })
    );
});
