<?php
// ACİL DÜZELTME - 27.03.2025
date_default_timezone_set('Europe/Istanbul');
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/eral.php';

// Loglama fonksiyonu
function logDebug($message) {
    $logFile = $_SERVER['DOCUMENT_ROOT'] . '/admin/system/logs/ajax_debug_' . date('Y-m-d') . '.log';
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
    error_log($message);
}

// Ayarları yükle
$setting = $DB->prepare("SELECT * from settings where id=?");
$setting->execute(array(1));
$settings = $setting->fetch(PDO::FETCH_ASSOC);

// Yardımcı fonksiyonlar
function id($text) {
    $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
    $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
    $text = strtolower(str_replace($find, $replace, $text));
    $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
    $text = trim(preg_replace('/\s+/', ' ', $text));
    $text = str_replace(' ', '', $text);
    return $text;
}

// POST verilerini logla
logDebug("POST verileri: " . print_r($_POST, true));

// Ana işlem başlangıcı
if (!empty($_POST['providerID']) and !empty($_POST['date'])) {
    // Değişkenleri al
    $suankiSaat = date("H:i");
    $bugunTarih = date('Y-m-d');
    $providerID = $_POST['providerID'];
    $dateString = $_POST['date'];
    $date = date("Y-m-d", strtotime($dateString));

    logDebug("====== AvailableTimeAjax.php başlatıldı ======");
    logDebug("Tarih: $date, ProviderID: $providerID");

    // Çalışılmayacak saatler (tarih ve saat birleşik format)
    $unavailableHours = [];
    if (!empty($_POST['unavailableHours'])) {
        $unavailableHours = json_decode($_POST['unavailableHours'], true);
        logDebug("Frontend'den gelen çalışılmayacak saatler: " . count($unavailableHours) . " adet");
        logDebug("Çalışılmayacak saatler: " . print_r($unavailableHours, true));
    } else {
        logDebug("UYARI: Frontend'den gelen çalışılmayacak saatler parametresi boş, doğrudan veritabanından alınacak");
    }

    // Her durumda veritabanından taze veri çekelim - bu kritik güvenlik için daha güvenli
    $unavailableHoursQuery = $DB->prepare("
        SELECT
            tarih,
            saat
        FROM saatler
        WHERE provid = ?
        AND tarih = ?
        ORDER BY tarih, saat
    ");
    $unavailableHoursQuery->execute([$providerID, $date]);

    while ($hour = $unavailableHoursQuery->fetch(PDO::FETCH_ASSOC)) {
        // Veritabanındaki saat formatı (HH:MM:SS veya HH:MM)
        $dbTime = $hour['saat'];

        // Eğer saat formatı HH:MM:SS ise, ayrıca HH:MM formatına dönüştür
        $shortTime = (strlen($dbTime) > 5) ? substr($dbTime, 0, 5) : $dbTime;

        // Her iki format için ekle
        $dateTime = $hour['tarih'] . ' ' . $shortTime;
        $unavailableHours[] = $dateTime;

        // HH:MM:SS formatı için
        $dateTimeWithSeconds = $hour['tarih'] . ' ' . $shortTime . ':00';
        if ($dateTimeWithSeconds != $dateTime) {
            $unavailableHours[] = $dateTimeWithSeconds;
        }

        // Eğer orijinal veritabanındaki formatta daha farklı bir format varsa onu da ekle
        if ($shortTime != $dbTime) {
            $unavailableHours[] = $hour['tarih'] . ' ' . $dbTime;
        }
    }

    logDebug("Veritabanından alınan çalışılmayacak saatler: " . count($unavailableHours) . " adet");
    logDebug("Çalışılmayacak saatler: " . print_r($unavailableHours, true));

    // Ayrıca hızlı bir erişim için çalışılmayacak saatleri bir dizi içinde index olarak tutalım
    $unavailableHoursIndex = [];
    foreach ($unavailableHours as $hour) {
        $unavailableHoursIndex[$hour] = true;
    }

    // Personel bilgilerini al
    $providerCheck = $DB->prepare("select * from provider where id=?");
    $providerCheck->execute(array($providerID));
    $provider = $providerCheck->fetch(PDO::FETCH_ASSOC);

    // Haftanın günü
    $breakDate = new DateTime($date);
    $breakDate = $breakDate->format('N');

    // ÖZEL GÜN KONTROLÜ
    $specialDay = null;
    $isSpecialDay = false;

    try {
        logDebug("Özel gün kontrolü yapılıyor. Tarih: " . $date);

        // Tablo var mı?
        $checkTable = $DB->query("SHOW TABLES LIKE 'special_days'");
        if ($checkTable->rowCount() == 0) {
            logDebug("Özel günler tablosu bulunamadı!");
            throw new Exception("special_days tablosu mevcut değil");
        }

        // Ayar aktif mi?
        $settingsCheck = $DB->prepare("SELECT specialDaysSystem FROM settings WHERE id = 1");
        $settingsCheck->execute();
        $settingsRow = $settingsCheck->fetch(PDO::FETCH_ASSOC);
        $specialDaysSystemSetting = isset($settingsRow['specialDaysSystem']) ? $settingsRow['specialDaysSystem'] : '0';

        logDebug("specialDaysSystem ayarı: " . $specialDaysSystemSetting);

        if ($specialDaysSystemSetting == '1') {
            logDebug("ÖZEL GÜN KONTROLÜ BELİRTİSİ");

            // Özel gün kontrolü
            $specialDayCheck = $DB->prepare("SELECT * FROM special_days WHERE ? BETWEEN start_date AND end_date AND status = 1");
            $specialDayCheck->execute(array($date));

            logDebug("Özel gün sorgusu yapıldı - Bulunan kayıt sayısı: " . $specialDayCheck->rowCount());

            // Bir sonraki gün kontrolü
            $nextDay = date('Y-m-d', strtotime($date . ' +1 day'));
            $nextDayCheck = $DB->prepare("SELECT * FROM special_days WHERE ? BETWEEN start_date AND end_date AND status = 1");
            $nextDayCheck->execute(array($nextDay));

            // Önceki gün kontrolü
            $previousDay = date('Y-m-d', strtotime($date . ' -1 day'));
            $prevDayCheck = $DB->prepare("SELECT * FROM special_days WHERE ? BETWEEN start_date AND end_date AND status = 1");
            $prevDayCheck->execute(array($previousDay));

            logDebug("ÖZEL GÜN KONTROL - Tarih: $date, Bulunan: " . $specialDayCheck->rowCount() . " kayıt");
            logDebug("ÖZEL GÜN KONTROL - Sonraki gün: $nextDay, Bulunan: " . $nextDayCheck->rowCount() . " kayıt");
            logDebug("ÖZEL GÜN KONTROL - Önceki gün: $previousDay, Bulunan: " . $prevDayCheck->rowCount() . " kayıt");

            // DEBUG: Seçili tarihi ve özel günlerin başlangıç-bitiş tarihlerini kontrol et
            if ($specialDayCheck->rowCount() > 0) {
                $debugSpecialDay = $specialDayCheck->fetch(PDO::FETCH_ASSOC);
                $specialDayCheck->execute(array($date)); // Yeniden sorgu için
                logDebug("DEBUG - Seçili tarih: $date, Özel gün başlangıç: " . $debugSpecialDay['start_date'] . ", Özel gün bitiş: " . $debugSpecialDay['end_date']);
            }

            if ($specialDayCheck->rowCount() > 0) {
                // Bugünkü özel günü kullan
                $specialDay = $specialDayCheck->fetch(PDO::FETCH_ASSOC);
                $isSpecialDay = true;
                logDebug("ÖZEL GÜN - Bugünkü özel gün: " . $specialDay['title']);

                // Mesai saatlerini özel günden al
                $startTime = $specialDay['start_time'];
                $endTime = $specialDay['end_time'];
                $endTimeCheck = $endTime;

                // Bilgilendirme mesajı
                echo '<div class="alert alert-info mb-2" style="font-size: 14px;">';
                echo '<strong>' . $specialDay['title'] . '</strong> nedeniyle bugün çalışma saatleri: <strong>' . $startTime . ' - ' . $endTime . '</strong> olarak uygulanmaktadır. <small>(Özel gün saatleri <i class="fas fa-star-of-life" style="font-size: 7px; color: #0077be;"></i> işareti ile belirtilmiştir)</small>';

                // Gece çalışması kontrolü
                $specialStartTime = $specialDay['start_time'];
                $specialEndTime = $specialDay['end_time'];
                $specialStartHour = intval(substr($specialStartTime, 0, 2));
                $specialEndHour = intval(substr($specialEndTime, 0, 2));
                $isOvernight = $specialEndHour < $specialStartHour;

                if ($isOvernight) {
                    echo '<div class="mt-1"><small class="text-muted">Not: Gece yarısından sonraki saatler (00:00 sonrası) ertesi gün takviminde görüntülenecektir.</small></div>';

                    // Ertesi gün tarihini göster
                    $nextDayFormatted = date('d.m.Y', strtotime($date . ' +1 day'));
                    echo '<div class="mt-1"><small class="text-info"><strong>Önemli:</strong> ' . $nextDayFormatted . ' tarihini seçerek saat 01:00-' . $endTime . ' arası özel gün saatlerini görebilirsiniz.</small></div>';
                }

                echo '</div>';
            } else if ($nextDayCheck->rowCount() > 0) {
                // Sonraki günün özel gününü kullan
                $specialDay = $nextDayCheck->fetch(PDO::FETCH_ASSOC);
                // Özel gün DEĞİL - sadece bilgilendirme göster
                $isSpecialDay = false;
                logDebug("BİLGİ - Sonraki günün özel günü: " . $specialDay['title'] . " - Bugünü özel gün olarak işaretlemiyoruz");

                // Özel gün bilgilendirme mesajı ekle
                echo '<div class="alert alert-info mb-2" style="font-size: 14px;">';
                echo '<strong>' . $specialDay['title'] . '</strong> nedeniyle yarın çalışma saatleri: <strong>' . $specialDay['start_time'] . ' - ' . $specialDay['end_time'] . '</strong> olacaktır. <small>(Bugün için normal çalışma saatleri geçerlidir)</small>';

                // Gece çalışması kontrolü
                $specialStartTime = $specialDay['start_time'];
                $specialEndTime = $specialDay['end_time'];
                $specialStartHour = intval(substr($specialStartTime, 0, 2));
                $specialEndHour = intval(substr($specialEndTime, 0, 2));
                $isOvernight = $specialEndHour < $specialStartHour;

                if ($isOvernight) {
                    // Ertesi gün tarihini göster
                    $nextDayFormatted = date('d.m.Y', strtotime($date . ' +1 day'));
                    echo '<div class="mt-1"><small class="text-info"><strong>Bilgi:</strong> ' . $nextDayFormatted . ' tarihini seçtiğinizde, gece çalışması saatleri 00:00-' . $specialEndTime . ' arası özel gün olarak işaretlenecektir.</small></div>';
                }

                echo '</div>';

                // Normal mesai saatlerini kullan
                $workingTime = $provider['workingTime'];
                $workingTime = explode("-", $workingTime);
                $startTime = $workingTime[0];
                $endTime = $workingTime[1];
                $endTimeCheck = $endTime;
            } else {
                // Özel gün yok, normal mesai saatlerini kullan
                $workingTime = $provider['workingTime'];
                $workingTime = explode("-", $workingTime);
                $startTime = $workingTime[0];
                $endTime = $workingTime[1];
                $endTimeCheck = $endTime;
            }
        } else {
            // Özel günler kapalı
            $workingTime = $provider['workingTime'];
            $workingTime = explode("-", $workingTime);
            $startTime = $workingTime[0];
            $endTime = $workingTime[1];
            $endTimeCheck = $endTime;
        }
    } catch (Exception $e) {
        logDebug("Özel gün kontrolünde hata: " . $e->getMessage());

        // Hata durumunda normal mesai saatleri
        $workingTime = $provider['workingTime'];
        $workingTime = explode("-", $workingTime);
        $startTime = $workingTime[0];
        $endTime = $workingTime[1];
        $endTimeCheck = $endTime;
    }

    // İzin günü kontrolü
    $breakTime = $provider['breakTime'];
    
    // breakTime null veya boş olabilir, kontrol et
    if (!empty($breakTime)) {
        $breakTime = explode(",", $breakTime);
    } else {
        // Boş veya null ise boş dizi oluştur
        $breakTime = [];
    }
    if (in_array($breakDate, $breakTime)) {
        // Personel izin günü - saatleri gösterme ve uyarı ver
        echo '<script>
            $(document).ready(function() {
                Swal.fire({
                    title: "' . $translations['error'] . '",
                    text: "' . $translations['dayoff'] . '",
                    icon: "warning",
                    confirmButtonColor: "#7367f0",
                    confirmButtonText: "' . $translations['okey'] . '"
                });
            });
        </script>';
        exit; // Saatleri göstermeyi tamamen durdur
    }

    // Kapsamlı debug bilgisi ekle - en kritik bilgiler
    $debugText = "AJAX:DEBUG - Şu anki işlemin kritik değişkenleri:
        - Tarih: $date
        - Personel ID: $providerID
        - Hizmet ID: " . (isset($_POST['hizmet']) ? $_POST['hizmet'] : 'BELİRTİLMEMİŞ') . "
        - Mesai Saatleri: $startTime - $endTime";
    logDebug($debugText);

    // Mevcut düzenleme işlemi varsa
    $mevcutStart = '';
    $mevcutStartReadable = '';
    $mevcutEnd = '';
    $selectedTime = isset($_POST['selectedTime']) ? $_POST['selectedTime'] : ''; // Doğrudan seçilecek saat parametresi
    
    if (!empty($_POST['edit'])) {
        $editID = $_POST['edit'];
        $editCheck = $DB->prepare("SELECT * from appointments where id=?");
        $editCheck->execute(array($editID));
        $editDeger = $editCheck->fetch(PDO::FETCH_ASSOC);
        $mevcutStart = $editDeger['startTime'];
        $mevcutEnd = $editDeger['endTime'];
        
        // Eğer dışarıdan seçilecek saat gönderilmemişse, veritabanındaki saati kullan
        if (empty($selectedTime) && !empty($mevcutStart)) {
            $mevcutStartObj = new DateTime($mevcutStart);
            $mevcutStartReadable = $mevcutStartObj->format('H:i');
            $selectedTime = $mevcutStartReadable;
        } else if (!empty($selectedTime)) {
            $mevcutStartReadable = $selectedTime;
        }
        
        // Debug için bilgi
        logDebug("Mevcut randevu bilgileri: ID=$editID, Başlangıç=$mevcutStart, Seçilecek saat=$selectedTime");
        echo '<script>console.log("Düzenlenecek randevu saati: ' . $mevcutStartReadable . '");</script>';
        
        // Görünür bilgi
        echo '<div class="alert alert-info mb-2">
            <strong>Mevcut Randevu Saati:</strong> ' . $mevcutStartReadable . 
            (isset($mevcutEnd) && !empty($mevcutEnd) ? ' - ' . substr($mevcutEnd, 0, 5) : '') . 
            '<br><small>Aşağıdan farklı bir saat seçebilirsiniz.</small>
        </div>';
    }

    // Hizmet bilgilerini al
    $hizmet = isset($_POST['hizmet']) ? $_POST['hizmet'] : null;
    if (!$hizmet) {
        logDebug("UYARI: 'hizmet' parametresi alınamadı. POST verileri: " . print_r($_POST, true));
        echo '<div class="alert alert-danger">Hizmet bilgisi bulunamadı. Lütfen sayfayı yenileyip tekrar deneyin.</div>';
        exit;
    }

    logDebug("Hizmet ID: $hizmet - sorgulama başlıyor");

    $serviceCheck = $DB->prepare("select * from services where id=?");
    $serviceCheck->execute(array($hizmet));
    $service = $serviceCheck->fetch(PDO::FETCH_ASSOC);
    $serviceDakika = $service['hour'];

    // Özel gün bilgilerini hazırla
    if ($isSpecialDay) {
        $selectedDate = new DateTime($date);
        $specialStartDate = new DateTime($specialDay['start_date']);
        $specialEndDate = new DateTime($specialDay['end_date']);

        // İlk gün mü, sonraki gün mü?
        $isFirstDay = ($selectedDate->format('Y-m-d') === $specialStartDate->format('Y-m-d'));
        $isNextDay = ($selectedDate->format('Y-m-d') > $specialStartDate->format('Y-m-d'));

        // Gece çalışması kontrolü
        $specialStartTime = $specialDay['start_time'];
        $specialEndTime = $specialDay['end_time'];
        $specialStartHour = intval(substr($specialStartTime, 0, 2));
        $specialEndHour = intval(substr($specialEndTime, 0, 2));
        $isOvernight = $specialEndHour < $specialStartHour;

        logDebug("ÖZEL GÜN BİLGİLERİ - ID: " . $specialDay['id'] .
                 ", Başlık: " . $specialDay['title'] .
                 ", Tarih Aralığı: " . $specialDay['start_date'] . " - " . $specialDay['end_date'] .
                 ", Saatler: " . $specialStartTime . " - " . $specialEndTime .
                 ", İlk gün: " . ($isFirstDay ? "EVET" : "HAYIR") .
                 ", Sonraki gün: " . ($isNextDay ? "EVET" : "HAYIR") .
                 ", Gece çalışması: " . ($isOvernight ? "EVET" : "HAYIR"));
    }

    // ===== ACİL DÜZELTME =====
    // SAATLER OLUŞTURMA BÖLÜMÜ
    $i = 0;

    // SAATLER ARASINDA 15 DAKİKALIK ADIMLAR KULLANIYORUZ
    $stepSize = 15; // Sabit 15 dakikalık adımlar

    // Hizmet süresini doğru şekilde al
    $serviceDuration = intval($serviceDakika);
    if ($serviceDuration <= 0) {
        // Eğer bir şekilde hizmet süresi yoksa 30dk varsayılanı kullan
        $serviceDuration = 30;
    }

    logDebug("ADIM BOYUTU: $stepSize dakika, HİZMET SÜRESİ: $serviceDuration dakika");

    // Özel günler için saatleri oluştur
    $hours = [];

    // Mesai başlangıç saatinden başlayarak dakika cinsinden hesaplama
    // Önce mesai başlangıç saatini dakika cinsine dönüştürelim
    $startHour = intval(substr($startTime, 0, 2));
    $startMinute = intval(substr($startTime, 3, 2));
    $startTimeInMinutes = $startHour * 60 + $startMinute;

    // Mesai bitiş saati
    $endHour = intval(substr($endTime, 0, 2));
    $endMinute = intval(substr($endTime, 3, 2));
    $endTimeInMinutes = $endHour * 60 + $endMinute;

    // Gece vardiyası kontrolü (örneğin 22:00-06:00)
    $isOvernight = $endTimeInMinutes <= $startTimeInMinutes;
    if ($isOvernight) {
        $endTimeInMinutes += 24 * 60; // 24 saat ekliyoruz
    }

    logDebug("SAAT HESAPLAMA - Mesai başlangıç dakika: $startTimeInMinutes, Mesai bitiş dakika: $endTimeInMinutes, Gece vardiyası: " . ($isOvernight ? "EVET" : "HAYIR"));

    // Saatleri oluşturmak için döngü - tam olarak mesai saatinden başlayacak
    $totalMinutes = $startTimeInMinutes;

    // Konsola debug bilgisi
    echo "<script>console.log('Saatler yükleniyor - AvailableTimeAjax.php - Adım: $stepSize, Hizmet: $hizmet, Süresi: $serviceDuration dakika, Özel Gün: " . ($isSpecialDay ? "Evet" : "Hayır") . "');</script>";

    // HİZMET SÜRESİNE GÖRE HESAPLAMA
    // Hizmet süresine göre sıralı randevu saatleri oluşturuyoruz
    // Mesai bitiş saatine kadar (son saat hariç) hizmet süresi kadar adımlarla ilerle

    // İlk saat için mesai başlangıcını kullan
    $totalMinutes = $startTimeInMinutes;
    $lastEndTime = null;
    $skipUntilMinutes = null; // Çalışılmayacak saatlerden sonra atlanacak dakika değeri

    // Konsola debug bilgisi
    echo "<script>console.log('Saatler yükleniyor - AvailableTimeAjax.php - Hizmet süresi: $serviceDuration dakika, Özel Gün: " . ($isSpecialDay ? "Evet" : "Hayır") . "');</script>";

    while ($totalMinutes <= $endTimeInMinutes - $serviceDuration) {
        // Eğer atlanacak bir dakika değeri varsa ve mevcut dakika bu değerden küçükse, bu saati atla
        if ($skipUntilMinutes !== null && $totalMinutes < $skipUntilMinutes) {
            // Bir sonraki 15 dakikalık dilime atla
            $totalMinutes += $stepSize;
            continue;
        }

        // Saat ve dakika hesaplamaları (24 saat formatına göre modülo alınıyor)
        $realMinutes = $totalMinutes;
        if ($realMinutes >= 24 * 60) {
            $realMinutes = $realMinutes % (24 * 60);
        }

        $hour = floor($realMinutes / 60);
        $minute = $realMinutes % 60;

        // Formatlı saat:dakika oluştur
        $formattedHour = str_pad($hour, 2, "0", STR_PAD_LEFT) . ":" . str_pad($minute, 2, "0", STR_PAD_LEFT);

        // Gece saati mi (00:00-05:00 arası)?
        $isLateHour = ($hour >= 0 && $hour <= 5);

        // Varsayılan değerler
        $isSpecialHour = false;
        $showHour = true;

        // Bugün için geçmiş saatleri kontrol et
        if ($date == $bugunTarih) {
            $currentHour = intval(date("H"));
            $currentMinute = intval(date("i"));
            $currentTimeInMinutes = $currentHour * 60 + $currentMinute;

            // Saat değişkenlerini dakika cinsine çevir
            $hourInMinutes = $hour * 60 + $minute;

            if ($hourInMinutes <= $currentTimeInMinutes) {
                $showHour = false; // Geçmiş saatleri gösterme
                logDebug("Saat $formattedHour geçmiş saat olduğu için gösterilmiyor. Şu anki saat: " . date("H:i"));
            }
        }

        // Randevu kontrolü - Bu saatte ve sonraki hizmet süresi içindeki tüm zaman dilimlerinde çakışma olup olmadığını kontrol et
        if ($showHour) {
            // Randevunun başlangıç dakikasını hesapla
            $currentTimeInMinutes = $hour * 60 + $minute;

            // Bu randevunun bitiş dakikası
            $endAppointmentMinutes = $currentTimeInMinutes + $serviceDuration;
            
            // KAPSAMLI RANDEVU ÇAKIŞMA KONTROLÜ
            // Bu kontrol, mevcut randevular ile çakışma olup olmadığını tam olarak kontrol eder
            
            // 1. Tüm randevuları başlangıç saatine göre sıralı olarak al
            $randevularSorgu = $DB->prepare("
                SELECT 
                    id,
                    TIME_TO_SEC(TIME(startTime))/60 as start_minutes,
                    CASE 
                        WHEN endTime IS NOT NULL AND endTime != '' THEN TIME_TO_SEC(TIME(endTime))/60 
                        ELSE TIME_TO_SEC(TIME(startTime))/60 + 
                             COALESCE((SELECT hour FROM services WHERE id = appointments.service), 30)
                    END as end_minutes,
                    TIME(startTime) as start_time,
                    service
                FROM appointments
                WHERE providerID = ?
                AND appDate = ?
                AND coming != 4
                ORDER BY startTime
            ");
            
            $randevularSorgu->execute([$providerID, $date]);
            $randevular = $randevularSorgu->fetchAll(PDO::FETCH_ASSOC);
            
            logDebug("Randevu sayısı: " . count($randevular) . " - Seçilen saat: $formattedHour - Hizmet süresi: $serviceDuration dk");
            
            // 2. Çakışma kontrolü
            $cakismaVar = false;
            
            // Hizmetin zaman aralığı
            $hizmetBaslangic = $currentTimeInMinutes;
            $hizmetBitis = $hizmetBaslangic + $serviceDuration;
            
            // Her randevu için çakışma kontrolü
            foreach ($randevular as $randevu) {
                $randevuBaslangic = $randevu['start_minutes'];
                $randevuBitis = $randevu['end_minutes'];
                
                // Hizmet ve randevu aralıklarının çakışma durumu:
                // 1. Hizmet başlangıcı randevu aralığında mı?
                // 2. Hizmet bitişi randevu aralığında mı?
                // 3. Randevu, hizmet aralığı içinde mi başlıyor?
                // 4. Randevu, hizmet aralığı içinde mi bitiyor?
                
                if (
                    // Hizmet başlangıcı randevu aralığı içinde
                    ($hizmetBaslangic >= $randevuBaslangic && $hizmetBaslangic < $randevuBitis) || 
                    // Hizmet bitişi randevu aralığı içinde
                    ($hizmetBitis > $randevuBaslangic && $hizmetBitis <= $randevuBitis) || 
                    // Randevu, hizmet aralığı içinde
                    ($randevuBaslangic >= $hizmetBaslangic && $randevuBaslangic < $hizmetBitis) ||
                    // Randevu, hizmet aralığını tamamen kapsıyor
                    ($randevuBaslangic <= $hizmetBaslangic && $randevuBitis >= $hizmetBitis)
                ) {
                    $cakismaVar = true;
                    $randevuBaslangicSaat = floor($randevuBaslangic / 60);
                    $randevuBaslangicDakika = $randevuBaslangic % 60;
                    $randevuBaslangicStr = sprintf("%02d:%02d", $randevuBaslangicSaat, $randevuBaslangicDakika);
                    
                    logDebug("ÇAKIŞMA: $formattedHour - $hizmetBitis dk hizmet süresi, $randevuBaslangicStr başlangıçlı randevu ile çakışıyor");
                    break;
                }
            }
            
            // Çakışma durumunu ara boşluk uygunluğuna aktar
            $araBoslukUygun = !$cakismaVar;
            
            if (!$araBoslukUygun) {
                logDebug("Saat $formattedHour için hizmet süresi ($serviceDuration dk) çakışma nedeniyle uygun değil");
            } else {
                logDebug("Saat $formattedHour için hizmet süresi ($serviceDuration dk) uygundur - çakışma yok");
            }
            
            // Yeni kapsamlı çakışma kontrolü var, eski sorguyu çalıştırmaya gerek yok
            if (!$araBoslukUygun) {
                $showHour = false; // Dolu randevuları gösterme
                logDebug("Saat $formattedHour randevu çakışması nedeniyle gösterilmiyor");
            }

            // Çalışılmayacak saatleri kontrol et
            $dateTimeCheck = $date . ' ' . $formattedHour;
            $dateTimeCheckWithSeconds = $date . ' ' . $formattedHour . ':00';

            // Önce randevunun bitiş saatini kontrol et - ÖNEMLİ EKLEME
            $serviceEndMinutes = $totalMinutes + $serviceDuration;
            $serviceEndRealMinutes = $serviceEndMinutes;
            if ($serviceEndRealMinutes >= 24 * 60) {
                $serviceEndRealMinutes = $serviceEndRealMinutes % (24 * 60);
            }
            $serviceEndHour = floor($serviceEndRealMinutes / 60);
            $serviceEndMinute = $serviceEndRealMinutes % 60;
            $serviceEndFormatted = str_pad($serviceEndHour, 2, "0", STR_PAD_LEFT) . ":" . str_pad($serviceEndMinute, 2, "0", STR_PAD_LEFT);
            $dateTimeEndCheck = $date . ' ' . $serviceEndFormatted;
            $dateTimeEndCheckWithSeconds = $date . ' ' . $serviceEndFormatted . ':00';

            // Hem başlangıç hem de bitiş saati için çalışılmayacak saatleri kontrol et
            if (isset($unavailableHoursIndex[$dateTimeCheck]) ||
                isset($unavailableHoursIndex[$dateTimeCheckWithSeconds]) ||
                isset($unavailableHoursIndex[$dateTimeEndCheck]) ||
                isset($unavailableHoursIndex[$dateTimeEndCheckWithSeconds])) {

                $showHour = false; // Çalışılmayacak saatleri gösterme
                logDebug("Saat $formattedHour çalışılmayacak saat olduğu için gösterilmiyor (hızlı kontrolden)");

                // Çalışılmayacak saati bulduk, bir sonraki 30 dakikalık dilime atla (hizmet süresi kadar)
                $skipUntilMinutes = $totalMinutes + $serviceDuration;
                logDebug("Çalışılmayacak saat bulundu, $skipUntilMinutes dakikasına kadar atlanacak");
            } else {
                // Başlangıç ve bitiş arasındaki saatleri kontrol et
                $isBetweenUnavailable = false;

                // Randevu süresince her 15 dakikada bir kontrol et
                for ($checkMin = $totalMinutes; $checkMin <= $totalMinutes + $serviceDuration; $checkMin += 15) {
                    $checkRealMin = $checkMin;
                    if ($checkRealMin >= 24 * 60) {
                        $checkRealMin = $checkRealMin % (24 * 60);
                    }

                    $checkHour = floor($checkRealMin / 60);
                    $checkMinute = $checkRealMin % 60;
                    $checkFormatted = str_pad($checkHour, 2, "0", STR_PAD_LEFT) . ":" . str_pad($checkMinute, 2, "0", STR_PAD_LEFT);
                    $checkDateTime = $date . ' ' . $checkFormatted;
                    $checkDateTimeWithSeconds = $date . ' ' . $checkFormatted . ':00';

                    if (isset($unavailableHoursIndex[$checkDateTime]) || isset($unavailableHoursIndex[$checkDateTimeWithSeconds])) {
                        $isBetweenUnavailable = true;
                        logDebug("Saat $formattedHour ile $serviceEndFormatted arasında çalışılmayacak saat var: $checkFormatted");

                        // Çalışılmayacak saati bulduk, bir sonraki 30 dakikalık dilime atla
                        $skipUntilMinutes = $checkMin + $serviceDuration;
                        break;
                    }
                }

                if ($isBetweenUnavailable) {
                    $showHour = false;
                    logDebug("Saat $formattedHour, çalışılmayacak saatler arasında kaldığı için gösterilmiyor");
                } else {
                    // Cache'de yoksa veritabanında kontrol et - GELİŞMİŞ SORGU
                    $unavailableCheck = $DB->prepare("
                        SELECT * FROM saatler
                        WHERE provid = ?
                        AND tarih = ?
                        AND (
                            saat = ? OR
                            saat = ? OR
                            saat LIKE ? OR
                            SUBSTRING(saat, 1, 5) = ?
                        )
                    ");

                    // Sorguyu çalıştır
                    $unavailableCheck->execute([
                        $providerID,
                        $date,
                        $formattedHour,
                        $formattedHour . ":00",
                        $formattedHour . "%",
                        $formattedHour
                    ]);

                    if ($unavailableCheck->rowCount() > 0) {
                        $showHour = false; // Çalışılmayacak saatleri gösterme
                        logDebug("Saat $formattedHour çalışılmayacak saat olduğu için gösterilmiyor (veritabanı kontrolünden)");

                        // Çalışılmayacak saati bulduk, bir sonraki 30 dakikalık dilime atla
                        $skipUntilMinutes = $totalMinutes + $serviceDuration;
                    }
                }
            }
        }

        // Gösterilecek saatleri ekle
        if ($showHour) {
            // Hizmet bitiş zamanını hesapla
            $serviceEndMinutes = $totalMinutes + $serviceDuration;
            $serviceEndRealMinutes = $serviceEndMinutes;
            if ($serviceEndRealMinutes >= 24 * 60) {
                $serviceEndRealMinutes = $serviceEndRealMinutes % (24 * 60);
            }
            $serviceEndHour = floor($serviceEndRealMinutes / 60);
            $serviceEndMinute = $serviceEndRealMinutes % 60;
            $serviceEndFormatted = str_pad($serviceEndHour, 2, "0", STR_PAD_LEFT) . ":" . str_pad($serviceEndMinute, 2, "0", STR_PAD_LEFT);

            // Özel gün saati kontrolü
            if ($isSpecialDay) {
                $isSpecialHour = true;
            }

            $hours[] = [
                "hour" => $formattedHour,
                "is_special" => $isSpecialHour,
                "is_late_hour" => $isLateHour,
                "end_time" => $serviceEndFormatted,
                "duration" => $serviceDuration,
                "start_minutes" => $totalMinutes
            ];

            // Bir sonraki randevu için bitiş saatini kaydet
            $lastEndTime = $serviceEndFormatted;
            logDebug("Gösterilen saat: " . $formattedHour . " - " . $serviceEndFormatted . " - Özel saat mi: " . ($isSpecialHour ? "EVET" : "HAYIR"));

            // Bir sonraki uygun saat önceki randevunun bitişinden başlamalı
            $totalMinutes += $serviceDuration;
        } else {
            // Eğer bu saat uygun değilse, sadece 15 dakika ilerlet ve tekrar kontrol et
            $totalMinutes += $stepSize;
        }
    }

    // Saat sıralama özel durumu
    if ($isSpecialDay && $isNextDay) {
        usort($hours, function($a, $b) {
            // Saat değerlerini al
            $hourA = $a["hour"];
            $hourB = $b["hour"];

            // Dakika değerlerini hesapla
            $hoursA = intval(substr($hourA, 0, 2));
            $minutesA = intval(substr($hourA, 3, 2));
            $totalMinutesA = $hoursA * 60 + $minutesA;

            $hoursB = intval(substr($hourB, 0, 2));
            $minutesB = intval(substr($hourB, 3, 2));
            $totalMinutesB = $hoursB * 60 + $minutesB;

            // Gece yarısından sonraki saatler (00:00-05:59) önce gelsin
            $isEarlyHourA = ($hoursA >= 0 && $hoursA < 6);
            $isEarlyHourB = ($hoursB >= 0 && $hoursB < 6);

            // Sıralama mantığı: Gece yarısından sonraki saatler önce, sonra diğerleri
            if ($isEarlyHourA && !$isEarlyHourB) {
                return -1; // A önce gelsin
            } else if (!$isEarlyHourA && $isEarlyHourB) {
                return 1; // B önce gelsin
            } else {
                // İkisi de gece yarısından sonra ya da ikisi de gece yarısından önce ise normal sıralama
                return $totalMinutesA <=> $totalMinutesB;
            }
        });
    }

    // Ekranda gösterilecek HTML oluştur
    echo '<div class="row" style="display: flex; flex-wrap: wrap;">';

    // Debug amaçlı çıktı ekle
    echo '<script>
    console.log("Randevu saatleri hesaplandı:", ' . json_encode(count($hours)) . ');
    console.log("Çalışma saatleri:", "' . $startTime . ' - ' . $endTime . '");
    console.log("Mesai dakika değerleri:", "Başlangıç: ' . $startTimeInMinutes . ', Bitiş: ' . $endTimeInMinutes . '");
    console.log("Gösterilecek saatler:", ' . json_encode(array_column($hours, 'hour')) . ');
    </script>';

    // Saatleri göster
    if (count($hours) == 0) {
        echo '<div class="col-12 alert alert-warning">Bu tarihte uygun randevu saati bulunmamaktadır.</div>';
        logDebug("Uyarı: Tarih " . $date . " için hiç uygun saat bulunamadı!");
    } else {
        // Özel gün marker'ı ekleyelim
        if ($isSpecialDay) {
            echo '<div class="col-12 alert alert-info mb-2" style="font-size: 12px;">
                <i class="fas fa-star-of-life" style="font-size: 7px; color: #0077be;"></i>
                Özel gün saatleri işaretlidir
            </div>';
        }

        foreach ($hours as $hourData) {
            $hour = $hourData["hour"];
            $isSpecial = $hourData["is_special"];
            $isLateHour = $hourData["is_late_hour"];
            $endTime = $hourData["end_time"];
            $duration = $hourData["duration"]; // Eklendi

            // Saat görüntüsü için temiz formatlar
            $hourDisplay = substr($hour, 0, 5);
            $endTimeDisplay = substr($endTime, 0, 5);

            // Özel gün/gece saati için stiller
            $specialClass = $isSpecial ? ' special-time' : '';
            $lateHourClass = $isLateHour ? ' late-hour' : '';
            $specialStyle = $isSpecial ? ' style="color:#0077be; font-weight:bold;"' : '';

            // Bu saat seçili mi?
            $isSelected = !empty($selectedTime) && $hourDisplay === $selectedTime;
            
            // Saat seçimi için debug bilgisi (konsola)
            if ($isSelected) {
                echo '<script>console.log("Otomatik seçilecek saat bulundu: '.$hour.':00");</script>';
            } else {
                echo '<script>console.log("Oluşturulan saat: '.$hour.':00 (seçili değil)");</script>';
            }
            
            // Basit HTML çıktısı
            echo '<div class="col-md-3 mb-2 p-1">
                <input type="radio" class="custom-option-item-check' . $specialClass . $lateHourClass . '"
                       id="timeOption'.$i.'"
                       name="customOptionsCheckableRadiosWithIcon"
                       value="'.$hour.':00"
                       data-hour-value="'.$hour.'"
                       '.($isSelected ? ' checked' : '').'>
                <label class="custom-option-item text-center p-2'.($isSelected ? ' active' : '').'" for="timeOption'.$i.'">
                    <strong'.$specialStyle.'>'.$hourDisplay.' - '.$endTimeDisplay.'</strong>
                    <small class="d-block">'.$duration.' dk</small>
                    '.($isSpecial ? '<small class="d-block text-info"><i class="fas fa-star-of-life" style="font-size: 7px;"></i> Özel gün saati</small>' : '').'
                    '.($isSelected ? '<small class="d-block text-success"><i class="fas fa-check-circle"></i> Mevcut randevu</small>' : '').'
                </label>
            </div>';

            $i++;
        }
    }
    echo '</div>';

    // JavaScript eklentisi
    echo '<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Radio buttonları seç
        var radios = document.querySelectorAll(".custom-option-item-check");
        
        // Düzenleme modu için mevcut saati seç
        var mevcutStartTime = "' . $mevcutStartReadable . '";
        var isEdit = ' . (!empty($_POST['edit']) ? 'true' : 'false') . ';
        
        if (isEdit && mevcutStartTime) {
            console.log("Mevcut randevu saati seçilmeye çalışılıyor: " + mevcutStartTime);
            setTimeout(function() {
                var autoSelected = false;
                
                // Tüm saatleri döngüye al ve uygun olanı bul
                radios.forEach(function(radio) {
                    var hourValue = radio.value.substring(0, 5);
                    console.log("Kontrol edilen saat: " + hourValue + " vs " + mevcutStartTime);
                    
                    if (hourValue === mevcutStartTime) {
                        // Saati otomatik seç
                        radio.checked = true;
                        radio.nextElementSibling.classList.add("active");
                        console.log("Randevu saati otomatik seçildi: " + hourValue);
                        autoSelected = true;
                    }
                });
                
                if (!autoSelected) {
                    console.log("Mevcut saat (" + mevcutStartTime + ") mevcut seçenekler arasında bulunamadı");
                }
            }, 100);
        }

        // Her birine click event listener ekle
        radios.forEach(function(radio) {
            radio.addEventListener("change", function() {
                // Önce tüm etiketleri pasif yap
                document.querySelectorAll(".custom-option-item").forEach(function(label) {
                    label.classList.remove("active");
                });

                // Seçilen etiketi aktif yap
                this.nextElementSibling.classList.add("active");

                // Gizli input alanına değeri yaz
                var selectedTimeInput = document.getElementById("selectedTimeInput");
                if (selectedTimeInput) {
                    selectedTimeInput.value = this.value;
                    console.log("Saat seçildi: " + this.value);
                }
            });
        });
    });
    </script>';

    // Mesai bitimi kontrolü (gece çalışması durumunu da ele alarak)
    $suankiSaatTimestamp = strtotime(date('Y-m-d ') . $suankiSaat);
    $endTimeTimestamp = strtotime(date('Y-m-d ') . $endTimeCheck);

    // Gece mesaisi kontrolü
    $isEndTimeAfterMidnight = $endTimeCheck < $startTime;
    if($isEndTimeAfterMidnight) {
        // Gece yarısından sonra biten mesailerde, bitiş saati timestamp'ini 1 gün sonrası olarak ayarla
        $endTimeTimestamp = strtotime(date('Y-m-d ', strtotime('+1 day')) . $endTimeCheck);
    }

    // SweetAlert için JavaScript kodunu hazırla - Uyarılar için
    $sweetAlertJs = '';

    // Şu anki saat, mesai bitiş saatinden sonra ve bugünkü tarih seçiliyse
    if($suankiSaatTimestamp > $endTimeTimestamp && $date == $bugunTarih) {
        logDebug("MESAI SAATI UYARISI: Şu anki saat ($suankiSaat) mesai bitiş saatinden ($endTimeCheck) sonra");
        $sweetAlertJs .= "
            Swal.fire({
                title: \"{$translations['error']}\",
                text: \"{$translations['timepass']}\",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: \"{$translations['okey']}\"
            });
        ";
    } else {
        $sweetAlertJs .= "
            if ($(\"#timeSelect .col-md-3\").length) {
                // Saatler zaten gösteriliyor, bir şey yapma
            } else {
        ";

        if (in_array($breakDate, $breakTime)) {
            $sweetAlertJs .= "
                Swal.fire({
                    title: \"{$translations['error']}\",
                    text: \"{$translations['staffpass']}\",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: \"{$translations['okey']}\"
                });
            ";
        } else {
            // Backup sistem ayarları
            $backupSystem = isset($settings['backupSystem']) && $settings['backupSystem'] == '1';

            // Ajax URL
            $protocol21 = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
            $host41 = $_SERVER['HTTP_HOST'];
            $current_site_url = $protocol21 . $host41;
            $ajaxurl = $current_site_url."/admin/system/ajax/backup_appointment.php";

            // SweetAlert konfigürasyonu
            $sweetAlertConfig = [
                'title' => "'{$translations['error']}'",
                'text' => "'{$translations['apppass']}'",
                'icon' => "'error'",
                'showCancelButton' => 'true',
                'cancelButtonText' => "'{$translations['okey']}'",
                'showDenyButton' => $backupSystem ? 'true' : 'false',
                'cancelButtonColor' => "'#7367f0'",
                'showConfirmButton' => 'false',
                'reverseButtons' => 'false'
            ];

            // Eğer backup sistem etkinse
            if ($backupSystem) {
                $sweetAlertConfig['denyButtonText'] = "'Yedek Randevu'";
                $sweetAlertConfig['denyButtonColor'] = "'#0fbf0f'";
            }

            // Config objesi olarak oluştur
            $configString = '{';
            foreach ($sweetAlertConfig as $key => $value) {
                $configString .= "\n    $key: $value,";
            }
            $configString = rtrim($configString, ',');
            $configString .= "\n}";

            // SweetAlert ve Ajax kodlarını ekle
            $sweetAlertJs .= "
                Swal.fire($configString).then(function(result) {
                    if (result.isDenied) {
                        // Yedek randevu işlemi
                        $.ajax({
                            url: '$ajaxurl',
                            type: 'POST',
                            data: {
                                providerID: $('#providerID').val(),
                                date: $('#start-date').val(),
                                service: $('#service').val(),
                                tel: $('#musteriTelefon').val(),
                                ad: $('#musteriAd').val(),
                                backup: 1
                            },
                            success: function(response) {
                                let res = JSON.parse(response);
                                if (res.status === \"success\") {
                                    Swal.fire('Başarılı', res.message, 'success');
                                } else {
                                    Swal.fire('Hata', res.message, 'error');
                                }
                            },
                            error: function() {
                                Swal.fire('Hata', 'Randevu kaydedilemedi. Lütfen tekrar deneyin.', 'error');
                            }
                        });
                    }
                });
            ";
        }

        $sweetAlertJs .= "}"; // if ($("#timeSelect .col-md-3").length) { ... } else { ... } sonu
    }
    ?>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">
$(document).ready(function() {
  <?php echo $sweetAlertJs; ?>
});
</script>
<?php } ?>

<!-- Takvim Break Sorgulama -->
<?php if (!empty($_POST['providerID'])) { ?>
<?php
    $breakCheck = $DB->prepare("SELECT * from provider where id=? and breakstatus=?");
    $breakCheck->execute(array($_POST['providerID'], '1'));
    $break = $breakCheck->fetch(PDO::FETCH_ASSOC);
    if ($breakCheck->rowCount()) {
        ?>
<script type="text/javascript">
$(document).ready(function() {
  var start_time = "<?=$break['break_start_time']?>";
  var end_time = "<?=$break['break_end_time']?>";
  startDate = $('#start-date');
  if (startDate.length) {
    var start = startDate.flatpickr({
      disable: [{
        from: start_time,
        to: end_time
      }],
      minDate: "today",
      maxDate: new Date().fp_incr(
        <?=isset($settings['max_day_for_service']) ? $settings['max_day_for_service'] : 30?>),
      locale: {
        firstDayOfWeek: 1,
        weekdays: {
          longhand: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma',
            'Cumartesi'
          ],
          shorthand: ['Paz', 'Pzt', 'Sal', 'Çar', 'Per', 'Cum', 'Cmt']
        },
        months: {
          longhand: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz',
            'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'
          ],
          shorthand: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki',
            'Kas', 'Ara'
          ]
        },
        today: 'Bugün',
        clear: 'Temizle'
      },
      altFormat: 'd-m-YTH:i',
      onReady: function(selectedDates, dateStr, instance) {
        if (instance.isMobile) {
          $(instance.mobileInput).attr('step', null);
        }
      }
    });
  }
});
</script>
<?php } else { ?>
<script type="text/javascript">
$(document).ready(function() {
  var startDate = $('#start-date');
  if (startDate.length) {
    var start = startDate.flatpickr({
      minDate: "today",
      maxDate: new Date().fp_incr(
        <?=isset($settings['max_day_for_service']) ? $settings['max_day_for_service'] : 30?>),
      locale: {
        firstDayOfWeek: 1,
        weekdays: {
          longhand: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi'],
          shorthand: ['Paz', 'Pzt', 'Sal', 'Çar', 'Per', 'Cum', 'Cmt']
        },
        months: {
          longhand: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim',
            'Kasım', 'Aralık'
          ],
          shorthand: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara']
        },
        today: 'Bugün',
        clear: 'Temizle'
      },
      altFormat: 'd-m-YTH:i',
      onReady: function(selectedDates, dateStr, instance) {
        if (instance.isMobile) {
          $(instance.mobileInput).attr('step', null);
        }
      }
    });
  }
});
</script>
<?php } ?>
<?php } ?>
<!-- Takvim Break Sorgulama -->
