<?php
/**
 * Çalışılmayacak Saatler Sorgulama Scripti
 * Son güncelleme: 27.03.2025
 */

// Gerekli dosyaları dahil et
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/eral.php';

// Zaman dilimi ayarı
date_default_timezone_set('Europe/Istanbul');

// Hata ayıklama için log yazma
function logUnavailableHours($message) {
    $logFile = $_SERVER['DOCUMENT_ROOT'] . '/admin/system/logs/unavailable_hours_' . date('Y-m-d') . '.log';
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

// Başlangıç log kaydı
logUnavailableHours("GetUnavailableHours.php başlatıldı");

// Acil durum - Tüm randevuları getirme fonksiyonu
if (isset($_POST['action']) && $_POST['action'] === 'get_all_appointments') {
    try {
        logUnavailableHours("Acil durum: get_all_appointments fonksiyonu çağrıldı");
        
        // Oturum kontrolü
        session_start();
        $user_id = isset($_SESSION['memberId']) ? $_SESSION['memberId'] : 0;
        
        // Admin kontrolü
        $isAdmin = 0;
        if ($user_id > 0) {
            $providerCheck = $DB->prepare("SELECT isAdmin FROM provider WHERE id = ?");
            $providerCheck->execute([$user_id]);
            $provider = $providerCheck->fetch(PDO::FETCH_ASSOC);
            $isAdmin = ($provider && isset($provider['isAdmin'])) ? $provider['isAdmin'] : 0;
        }
        
        logUnavailableHours("Kullanıcı ID: $user_id, Admin: $isAdmin");
        
        // Sorgu hazırlığı
        $sql = "";
        $params = [];
        
        if ($isAdmin == 1) {
            // Admin tüm randevuları görebilir
            $sql = "SELECT a.*, s.serviceName, p.name as providerName, p.renk, p.yazirenk, 
                   m.name as memberName, m.phone, m.email 
                   FROM appointments a 
                   LEFT JOIN services s ON a.service = s.id 
                   LEFT JOIN provider p ON a.providerID = p.id 
                   LEFT JOIN members m ON a.member = m.id 
                   ORDER BY a.appDate DESC, a.startTime ASC";
        } else {
            // Normal kullanıcı sadece kendi randevularını görebilir
            $sql = "SELECT a.*, s.serviceName, p.name as providerName, p.renk, p.yazirenk, 
                   m.name as memberName, m.phone, m.email 
                   FROM appointments a 
                   LEFT JOIN services s ON a.service = s.id 
                   LEFT JOIN provider p ON a.providerID = p.id 
                   LEFT JOIN members m ON a.member = m.id 
                   WHERE a.providerID = ? 
                   ORDER BY a.appDate DESC, a.startTime ASC";
            $params = [$user_id];
        }
        
        // Sorguyu çalıştır
        if (count($params) > 0) {
            $stmt = $DB->prepare($sql);
            $stmt->execute($params);
        } else {
            $stmt = $DB->query($sql);
        }
        
        // Sonuçları hazırla
        $appointments = [];
        $settings = $DB->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
        $today = date('Y-m-d');
        
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            // Başlangıç ve bitiş zamanları
            $start = $row['appDate'].'T'.$row['startTime'];
            $end = $row['appDate'].'T'.$row['endTime'];
            
            // Durum sınıfı
            $statusClass = 'secondary';
            if ($row['coming'] == 1) $statusClass = 'success';
            else if ($row['coming'] == 2) $statusClass = 'warning';
            else if ($row['coming'] == 3) $statusClass = 'danger';
            
            // Randevu dizisi
            $appointments[] = array(
                "id" => $row['service'],
                "resourceId" => $row['providerID'],
                "url" => '',
                "color" => $row['renk'] ?? '#7367f0',
                "textColor" => $row['yazirenk'] ?? '#FFFFFF',
                "title" => $row['serviceName'],
                "start" => $start,
                "end" => $end,
                "allDay" => false,
                "isUnavailable" => false,
                "classNames" => ["appointment-status-" . $statusClass],
                "extendedProps" => array(
                    "calendar" => strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $row['providerName'] ?? '')),
                    "guests" => $row['member'],
                    "location" => $row['id'],
                    "description" => $row['providerID'],
                    "musteriAd" => $row['memberName'],
                    "musteriTel" => $row['phone'],
                    "musteriMail" => $row['email'],
                    "calisanAd" => $row['providerName'],
                    "payment" => $row['payment'],
                    "paymentStatus" => $row['paymentStatus'],
                    "coming" => $row['coming'],
                    "paytrSystem" => $settings['paytrSystem'] ?? 0,
                    "note" => $row['note'],
                    "isToday" => ($row['appDate'] === $today),
                    "statusText" => $row['coming'] == 1 ? 'Geldi' : 
                                  ($row['coming'] == 2 ? 'Beklemede' : 
                                  ($row['coming'] == 3 ? 'Gelmedi' : 'İptal Edildi'))
                )
            );
        }
        
        logUnavailableHours("Acil sorgu başarılı: " . count($appointments) . " randevu bulundu");
        echo json_encode($appointments);
        exit;
        
    } catch (Exception $e) {
        logUnavailableHours("Acil sorguda hata: " . $e->getMessage());
        echo json_encode(['error' => 'Veritabanı hatası: ' . $e->getMessage()]);
        exit;
    }
}

// Normal işlev - POST parametrelerini kontrol et
if (empty($_POST['providerID']) || empty($_POST['date'])) {
    echo json_encode(['error' => 'Parametre eksik: providerID ve date gerekli']);
    logUnavailableHours("Hata: Eksik parametreler. providerID: " . (isset($_POST['providerID']) ? $_POST['providerID'] : 'yok') . " date: " . (isset($_POST['date']) ? $_POST['date'] : 'yok'));
    exit;
}

try {
    // Parametreleri al
    $providerID = $_POST['providerID'];
    $dateString = $_POST['date'];
    $date = date("Y-m-d", strtotime($dateString));
    
    logUnavailableHours("Sorgu başlatılıyor - Tarih: $date, ProviderID: $providerID");
    
    // Çalışılmayacak saatleri sorgula
    $query = $DB->prepare("
        SELECT 
            tarih, 
            saat 
        FROM saatler 
        WHERE provid = ? 
        AND tarih = ? 
        ORDER BY tarih, saat
    ");
    $query->execute([$providerID, $date]);
    
    // Sonuçları hazırla
    $unavailableHours = [];
    while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
        // Tarih ve saat formatını birleştir
        // Her zaman HH:MM formatına standardize et
        $saat = strlen($row['saat']) > 5 ? substr($row['saat'], 0, 5) : $row['saat'];
        $dateTime = $row['tarih'] . ' ' . $saat;
        
        // Ana formatta ekle
        $unavailableHours[] = $dateTime;
        
        // Alternatif format (HH:MM:SS) - bazı sistemler bunu kullanıyor olabilir
        if (strlen($row['saat']) <= 5) {
            $unavailableHours[] = $row['tarih'] . ' ' . $saat . ':00';
        }
    }
    
    logUnavailableHours("Toplam " . count($unavailableHours) . " çalışılmayacak saat bulundu");
    
    // JSON olarak yanıt ver
    echo json_encode($unavailableHours);
    
} catch (Exception $e) {
    // Hata durumunda log yaz ve boş array döndür
    logUnavailableHours("Hata oluştu: " . $e->getMessage());
    echo json_encode([]);
}