<?php 
// Provider AJAX endpointi - çalışanları getirir
header('Content-Type: text/html; charset=utf-8');

// Debugger için
ini_set('display_errors', 1);
error_reporting(E_ALL);

// CORS kontrolü
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Log dizinini kontrol et veya oluştur
$logDir = $_SERVER['DOCUMENT_ROOT'].'/admin/system/logs';
if (!file_exists($logDir)) {
    mkdir($logDir, 0755, true);
}

// Loglama fonksiyonu
function logMessage($message) {
    global $logDir;
    $date = date('Y-m-d H:i:s');
    $logFile = $logDir . '/provider_ajax_' . date('Y-m-d') . '.log';
    file_put_contents($logFile, "[$date] $message" . PHP_EOL, FILE_APPEND);
}

// Detaylı hata gösterme - geliştirme ortamında aktif
error_reporting(E_ALL);
ini_set('display_errors', 1);

logMessage("ProviderAjaxMusteri.php çağrıldı - başlangıç");

// Gerekli dosyaları dahil et
try {
    require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/db.php';
    require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/eral.php';
    logMessage("Gerekli dosyalar başarıyla dahil edildi");
} catch (Exception $e) {
    logMessage("HATA: Gerekli dosyalar yüklenemedi: " . $e->getMessage());
    echo '<div class="col-12 text-center py-3 text-danger">Sistem dosyaları yüklenemedi. Lütfen daha sonra tekrar deneyin.</div>';
    exit;
}

// ID temizleme fonksiyonu
function id($text) {
    $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
    $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
    $text = strtolower(str_replace($find, $replace, $text));
    $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
    $text = trim(preg_replace('/\s+/', ' ', $text));
    $text = str_replace(' ', '', $text);
    return $text;
}

// CSS düzenlemeleri - radyo düğmelerinin görünümünü iyileştir
echo '<style>
    label:after {
        content: "";
        width: 0rem;
        height: 0rem;
        top: 0%;
    }
    .custom-option-item {
        transition: all 0.3s ease;
        cursor: pointer;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        margin-bottom: 12px;
    }
    .custom-option-item:hover {
        border-color: #ff950e;
        transform: translateY(-3px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .custom-option-item-check-provider:checked + .custom-option-item {
        border-color: #ff950e;
        background-color: rgba(255, 149, 14, 0.05);
        transform: translateY(-3px);
        box-shadow: 0 6px 12px rgba(255, 149, 14, 0.2);
    }
</style>';

// Çıktı tamponlamasını başlat
ob_start();

// Service ID'yi al ve doğrula
if (!isset($_POST['serviceID']) || empty($_POST['serviceID'])) {
    logMessage("HATA: Hizmet ID'si alınamadı. POST verileri: " . print_r($_POST, true));
    echo '<div class="col-12 text-center py-3 alert alert-warning">
        <i class="fas fa-exclamation-triangle me-2"></i> Hizmet ID\'si alınamadı. Lütfen bir hizmet seçin.
    </div>';
    ob_end_flush();
    exit;
}

$serviceID = intval($_POST['serviceID']);
logMessage("İşleniyor: Service ID: $serviceID");

// Tamponu temizle ama başka bir ara içerik gösterme
ob_end_clean();
// Debug ve geliştirme için isteği logla
logMessage("REQUEST: " . print_r($_POST, true));

// Yeni tamponlama başlat
ob_start();

// Servisi veritabanından doğrula
try {
    $serviceCheck = $DB->prepare("SELECT id, serviceName FROM services WHERE id = ?");
    $serviceCheck->execute([$serviceID]);
    $serviceData = $serviceCheck->fetch(PDO::FETCH_ASSOC);
    
    if (!$serviceData) {
        logMessage("HATA: Geçersiz hizmet ID: $serviceID - Veritabanında bulunamadı");
        echo '<div class="col-12 text-center py-3 alert alert-danger">
            <i class="fas fa-times-circle me-2"></i> Geçersiz hizmet seçimi. Lütfen tekrar deneyin.
        </div>';
        ob_end_flush();
        exit;
    }
    
    logMessage("Hizmet doğrulandı: " . $serviceData['serviceName']);
} catch (Exception $e) {
    logMessage("HATA: Servis sorgulanırken hata oluştu: " . $e->getMessage());
    echo '<div class="col-12 text-center py-3 alert alert-danger">
        <i class="fas fa-database me-2"></i> Veritabanı hatası oluştu. Lütfen daha sonra tekrar deneyin.
    </div>';
    ob_end_flush();
    exit;
}

// Yükleniyor mesajını temizle
echo '<div class="row">'; // Container başlangıcı

// Çalışan/personel sayacı
$foundProviders = 0;

try {
    // Veritabanından personelleri çek
    $providersQuery = $DB->prepare("SELECT * FROM provider WHERE working = '1' ORDER BY sira ASC");
    $providersQuery->execute();
    $providers = $providersQuery->fetchAll(PDO::FETCH_ASSOC);
    
    logMessage("Toplam " . count($providers) . " aktif personel bulundu, filtreleniyor...");
    
    // Her bir personel için kontrol et
    foreach ($providers as $provider) {
        // Personelin verdiği hizmetleri al ve kontrol et
        if (empty($provider['services'])) {
            logMessage("UYARI: Personel ID=" . $provider['id'] . " için hizmet listesi boş");
            continue; // Bu personeli atla
        }
        
        $providerServices = explode(",", $provider['services']);
        logMessage("Personel ID=" . $provider['id'] . " için hizmetler: " . $provider['services'] . ", Aranan hizmet ID: " . $serviceID);
        
        // Bu personel, seçilen hizmeti veriyor mu?
        // Hem string hem integer kontrolü yapalım
        if (in_array((string)$serviceID, $providerServices) || in_array((int)$serviceID, $providerServices)) {
            $foundProviders++;
            
            // Personel kartını oluştur - daha modern stil ile
            echo '<div class="col-lg-3 col-md-4 col-sm-6 mb-3">
                <input class="custom-option-item-check-provider" type="radio" name="provider"
                    id="provider' . id($provider['name']) . '" value="' . $provider['id'] . '" 
                    data-name="' . htmlspecialchars($provider['name']) . '" />
                <label class="custom-option-item text-center p-3" for="provider' . id($provider['name']) . '">
                    <div class="mb-2">
                        <img style="border-radius: 50%; height: 100px; width: 100px; object-fit: cover; box-shadow: 0 4px 8px rgba(0,0,0,0.1);"
                            src="https://' . $_SERVER['SERVER_NAME'] . '/admin/app-assets/images/profile/' . 
                            (empty($provider['photo']) ? 'no-photo.png' : $provider['photo']) . '"
                            alt="' . htmlspecialchars($provider['name']) . '">
                    </div>
                    <span class="custom-option-item-title h5 d-block fw-bold">
                        ' . htmlspecialchars($provider['name']) . '
                    </span>
                </label>
            </div>';
            
            logMessage("Personel eklendi: ID=" . $provider['id'] . ", Ad=" . $provider['name']);
        }
    }
    
    // Sonuç istatistiği
    logMessage("Hizmet ID=$serviceID için $foundProviders personel bulundu");
    
    // Hiç personel bulunamadıysa kullanıcı dostu bir mesaj göster
    if ($foundProviders === 0) {
        echo '<div class="col-12 text-center py-4">
            <div class="alert alert-info mb-0">
                <i class="fas fa-info-circle me-2"></i>
                Bu hizmet için uygun çalışan bulunamadı. Lütfen başka bir hizmet seçin veya daha sonra tekrar deneyin.
            </div>
        </div>';
        logMessage("UYARI: Bu hizmet için personel bulunamadı");
    }
    
} catch (Exception $e) {
    // Hata durumunda detaylı log ve kullanıcıya geri bildirim
    logMessage("KRİTİK HATA: Provider sorgulama hatası: " . $e->getMessage());
    echo '<div class="col-12 text-center py-3">
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle me-2"></i>
            Personel listesi yüklenirken bir sorun oluştu. Lütfen sayfayı yenileyip tekrar deneyin.
            <small class="d-block mt-2">Teknik detay: ' . htmlspecialchars($e->getMessage()) . '</small>
        </div>
    </div>';
}

echo '</div>'; // Container sonu

// Tamponlanmış çıktıyı temizle, tüm sonuçları döndür ve sonlandır
$finalOutput = ob_get_clean();
echo $finalOutput;

logMessage("ProviderAjaxMusteri.php işlemi tamamlandı - " . $foundProviders . " personel listelendi");
?>