<?php
// Debug ve log amaçlı AJAX yardımcı dosyası
header('Content-Type: application/json');

// Hata gösterme aktif
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Log dizinini kontrol et veya oluştur
$logDir = $_SERVER['DOCUMENT_ROOT'].'/admin/system/logs';
if (!file_exists($logDir)) {
    mkdir($logDir, 0755, true);
}

// Gelen verileri kaydet
$data = $_POST;
$timestamp = date('Y-m-d H:i:s');
$clientIP = $_SERVER['REMOTE_ADDR'];
$userAgent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'Unknown';
$referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'Direct access';

// Log dosyasına yaz
$logFile = $logDir . '/ajax_debug_' . date('Y-m-d') . '.log';
$logEntry = "[$timestamp] - IP: $clientIP\n";
$logEntry .= "User-Agent: $userAgent\n";
$logEntry .= "Referer: $referer\n";
$logEntry .= "POST data: " . print_r($data, true) . "\n";
$logEntry .= "----------------------------------------\n";

file_put_contents($logFile, $logEntry, FILE_APPEND);

// İsteğe yanıt döndür
$response = [
    'status' => 'success',
    'message' => 'Debug bilgileri kaydedildi',
    'timestamp' => $timestamp,
    'received_data' => $data
];

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>