<?php
// Saatleri oluşturan basit bir çözüm - acil durum için
date_default_timezone_set('Europe/Istanbul');
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';

// Özel günleri yükle
$specialDays = $DB->query("SELECT * FROM special_days WHERE status = 1")->fetchAll(PDO::FETCH_ASSOC);

echo "<h1>Saatler Yardımcısı</h1>";

// Tarih ve personel seçimi
echo "<form method='post'>";
echo "<div style='margin-bottom: 15px;'>";
echo "<label>Tarih: </label>";
echo "<input type='date' name='date' value='" . (isset($_POST['date']) ? $_POST['date'] : date('Y-m-d')) . "'>";
echo "</div>";

echo "<div style='margin-bottom: 15px;'>";
echo "<label>Personel: </label>";
echo "<select name='provider'>";

$providers = $DB->query("SELECT * FROM provider WHERE status = 1")->fetchAll(PDO::FETCH_ASSOC);
foreach ($providers as $provider) {
    $selected = (isset($_POST['provider']) && $_POST['provider'] == $provider['id']) ? 'selected' : '';
    echo "<option value='" . $provider['id'] . "' $selected>" . $provider['adsoyad'] . "</option>";
}

echo "</select>";
echo "</div>";

echo "<div>";
echo "<button type='submit'>Saatleri Göster</button>";
echo "</div>";
echo "</form>";

// Form gönderildiğinde saatleri oluştur
if (isset($_POST['date']) && isset($_POST['provider'])) {
    $date = $_POST['date'];
    $providerId = $_POST['provider'];
    
    echo "<h2>Tarih: $date, Personel ID: $providerId</h2>";
    
    // Personel bilgilerini al
    $provider = $DB->prepare("SELECT * FROM provider WHERE id = ?");
    $provider->execute(array($providerId));
    $providerData = $provider->fetch(PDO::FETCH_ASSOC);
    
    // Normal çalışma saatleri
    $workingTime = $providerData['workingTime'];
    $workingHours = explode("-", $workingTime);
    $startTime = $workingHours[0];
    $endTime = $workingHours[1];
    
    echo "<p>Normal çalışma saatleri: $startTime - $endTime</p>";
    
    // Özel gün kontrolü
    $selectedDate = new DateTime($date);
    $specialDay = null;
    
    foreach ($specialDays as $day) {
        $specialStartDate = new DateTime($day['start_date']);
        $specialEndDate = new DateTime($day['end_date']);
        
        if ($selectedDate >= $specialStartDate && $selectedDate <= $specialEndDate) {
            $specialDay = $day;
            break;
        }
    }
    
    if ($specialDay) {
        echo "<div style='background-color: #d9edf7; padding: 10px; margin: 10px 0;'>";
        echo "<strong>Özel Gün:</strong> " . $specialDay['title'] . "<br>";
        echo "<strong>Tarih Aralığı:</strong> " . $specialDay['start_date'] . " - " . $specialDay['end_date'] . "<br>";
        echo "<strong>Saat Aralığı:</strong> " . $specialDay['start_time'] . " - " . $specialDay['end_time'];
        echo "</div>";
        
        // Özel gün saatleri
        $startTime = $specialDay['start_time'];
        $endTime = $specialDay['end_time'];
        
        // Gece çalışması kontrolü
        $isOvernight = intval(substr($endTime, 0, 2)) < intval(substr($startTime, 0, 2));
        
        // İlk gün veya sonraki gün kontrolü
        $isFirstDay = ($selectedDate->format('Y-m-d') === $specialDay['start_date']);
        $isNextDay = ($selectedDate->format('Y-m-d') > $specialDay['start_date']);
        
        echo "<p>";
        echo "Gece çalışması: " . ($isOvernight ? "<span style='color:red'>EVET</span>" : "Hayır") . "<br>";
        echo "İlk gün: " . ($isFirstDay ? "EVET" : "Hayır") . "<br>";
        echo "Sonraki gün: " . ($isNextDay ? "EVET" : "Hayır");
        echo "</p>";
    }
    
    // Saatleri oluştur
    echo "<h3>Oluşturulan Saatler</h3>";
    
    echo "<div style='display: flex; flex-wrap: wrap; gap: 10px;'>";
    
    // Özel günler için saatleri oluştur
    $hours = [];
    for ($h = 0; $h < 24; $h++) {
        $formattedHour = str_pad($h, 2, "0", STR_PAD_LEFT) . ":00";
        
        // Saat değeri (0-23)
        $hourValue = $h;
        
        // Gece saati mi (00:00-05:00 arası)?
        $isLateHour = ($hourValue >= 0 && $hourValue <= 5);
        
        // Varsayılan olarak normal saat
        $isSpecialHour = false;
        $showHour = true;
        
        // Eğer özel gün varsa
        if ($specialDay) {
            // Başlangıç ve bitiş saatleri
            $specialStartHour = intval(substr($specialDay["start_time"], 0, 2));
            $specialEndHour = intval(substr($specialDay["end_time"], 0, 2));
            
            // Gece çalışması mı?
            $isOvernight = $specialEndHour < $specialStartHour;
            
            if ($isFirstDay) {
                // İlk günde gece saatleri gösterme
                if ($isLateHour) {
                    $showHour = false;
                }
                // İlk günde sadece özel gün başlangıcından sonraki saatler özel
                else if ($hourValue >= $specialStartHour && $hourValue <= 23) {
                    $isSpecialHour = true;
                }
            } 
            else if ($isNextDay) {
                if ($isOvernight) {
                    // Ertesi günde 01:00-bitiş saati arası göster ve özel saat olarak işaretle
                    if ($isLateHour && $hourValue >= 1 && $hourValue <= $specialEndHour) {
                        $isSpecialHour = true;
                    }
                    // 00:00-01:00 arası gösterme
                    else if ($isLateHour && $hourValue == 0) {
                        $showHour = false;
                    }
                }
                // Normal çalışma saatlerini özel saat olarak göster
                else if ($hourValue >= $specialStartHour && $hourValue <= $specialEndHour) {
                    $isSpecialHour = true;
                }
            }
        }
        
        if ($showHour) {
            $hours[] = [
                "hour" => $formattedHour,
                "is_special" => $isSpecialHour,
                "is_late_hour" => $isLateHour
            ];
        }
    }
    
    // Saatleri göster
    $i = 0;
    foreach ($hours as $hourData) {
        $hour = $hourData["hour"];
        $isSpecial = $hourData["is_special"];
        $isLate = $hourData["is_late_hour"];
        
        $style = $isSpecial ? 'background-color: #d9edf7; border: 1px solid #0077be;' : 'background-color: #f9f9f9; border: 1px solid #ddd;';
        $style .= $isLate ? ' color: #c00;' : '';
        
        echo '<div style="width: 70px; height: 40px; display: flex; align-items: center; justify-content: center; ' . $style . '">
            <span style="' . ($isSpecial ? 'color: #0077be; font-weight: bold;' : '') . '">' . $hour . '</span>
            ' . ($isSpecial ? '<i style="font-size: 8px; color: #0077be; margin-left: 2px;">*</i>' : '') . '
        </div>';
        
        $i++;
    }
    
    echo "</div>";
    
    echo "<div style='margin-top: 20px;'>";
    echo "<p><strong>Önerilen Kod:</strong></p>";
    echo "<pre style='background-color: #f5f5f5; padding: 10px; border: 1px solid #ddd; overflow: auto;'>";
    echo htmlspecialchars('
// AvailableTimeAjax.php dosyasında saat oluşturma bölümüne eklenmeli:

// Özel günler için saatleri oluştur
$hours = [];
for ($h = 0; $h < 24; $h++) {
    $formattedHour = str_pad($h, 2, "0", STR_PAD_LEFT) . ":00";
    
    // Saat değeri (0-23)
    $hourValue = $h;
    
    // Gece saati mi (00:00-05:00 arası)?
    $isLateHour = ($hourValue >= 0 && $hourValue <= 5);
    
    // Özel gün mu?
    $isSpecialHour = false;
    $showHour = true;
    
    // Eğer özel gün varsa
    if (isset($specialDay)) {
        // Başlangıç ve bitiş saatleri
        $specialStartHour = intval(substr($specialDay["start_time"], 0, 2));
        $specialEndHour = intval(substr($specialDay["end_time"], 0, 2));
        
        // Gece çalışması mı?
        $isOvernight = $specialEndHour < $specialStartHour;
        
        // Seçilen tarih ilk gün mü?
        $isFirstDay = ($selectedDate->format("Y-m-d") === $specialStartDate->format("Y-m-d"));
        $isNextDay = ($selectedDate->format("Y-m-d") > $specialStartDate->format("Y-m-d"));
        
        if ($isFirstDay) {
            // İlk günde gece saatleri gösterme
            if ($isLateHour) {
                $showHour = false;
            }
            // İlk günde sadece özel gün başlangıcından sonraki saatler özel
            else if ($hourValue >= $specialStartHour && $hourValue <= 23) {
                $isSpecialHour = true;
            }
        } 
        else if ($isNextDay) {
            if ($isOvernight) {
                // Ertesi günde 01:00-bitiş saati arası göster
                if ($isLateHour && $hourValue >= 1 && $hourValue <= $specialEndHour) {
                    $isSpecialHour = true;
                }
                // 00:00-01:00 arası gösterme
                else if ($isLateHour && $hourValue == 0) {
                    $showHour = false;
                }
            }
            // Normal çalışma saatlerini özel saat olarak göster
            else if ($hourValue >= $specialStartHour && $hourValue <= $specialEndHour) {
                $isSpecialHour = true;
            }
        }
    }
    
    if ($showHour) {
        $hours[] = [
            "hour" => $formattedHour,
            "is_special" => $isSpecialHour,
            "is_late_hour" => $isLateHour
        ];
    }
}

// Saatleri göster
foreach ($hours as $hourData) {
    $hour = $hourData["hour"];
    $isSpecial = $hourData["is_special"];
    
    echo \'<div class="col-md-2">
        <input class="custom-option-item-check\' . ($isSpecial ? \' special-day-time\' : \'\') . \'" 
               type="radio" value="\' . $hour . \':00" 
               name="customOptionsCheckableRadiosWithIcon" 
               id="customOptionsCheckableRadiosWithIcon\' . $i . \'">
        <label class="custom-option-item text-center p-1\' . ($isSpecial ? \' special-day-time\' : \'\') . \'"
               for="customOptionsCheckableRadiosWithIcon\' . $i . \'"
               onclick="setTimeout(function() { 
                  document.getElementById(\\\'customOptionsCheckableRadiosWithIcon\' . $i . \'\\\').checked = true; 
                  document.getElementById(\\\'customOptionsCheckableRadiosWithIcon\' . $i . \'\\\').dispatchEvent(new Event(\\\'change\\\')); 
               }, 10);">
            <small\' . ($isSpecial ? \' style="color: #0077be; font-weight: bold;"\' : \'\') . \'>\' . substr($hour, 0, 5) . \'</small>
            \' . ($isSpecial ? \'<i class="fas fa-star-of-life" style="font-size: 8px; color: #0077be; margin-left: 2px;"></i>\' : \'\') . \'
        </label>
    </div>\';
    
    $i++;
}');
    echo "</pre>";
    echo "</div>";
}
?>