<?php
// Özel günler - acil düzeltme dosyası
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';

// Test tarihleri
$test_dates = ['2025-03-27', '2025-03-28', '2025-03-29', '2025-03-30', '2025-03-31'];
$results = [];

// Özel günleri getir
$specialDays = $DB->query("SELECT * FROM special_days WHERE status = 1")->fetchAll(PDO::FETCH_ASSOC);

// Saatleri oluştur
$hours = [];
for ($h = 0; $h < 24; $h++) {
    $hour = str_pad($h, 2, '0', STR_PAD_LEFT);
    $hours[] = "$hour:00";
}

foreach ($test_dates as $date) {
    // Seçilen tarihe denk gelen özel gün var mı?
    $specialDayCheck = $DB->prepare("SELECT * FROM special_days WHERE ? BETWEEN start_date AND end_date AND status = 1");
    $specialDayCheck->execute(array($date));
    
    $results[$date] = [
        'has_special_day' => $specialDayCheck->rowCount() > 0,
        'hours' => []
    ];
    
    if ($specialDayCheck->rowCount() > 0) {
        $specialDay = $specialDayCheck->fetch(PDO::FETCH_ASSOC);
        $results[$date]['special_day'] = $specialDay;
        
        // Özel gün saatleri
        $specialStartTime = $specialDay['start_time'];
        $specialEndTime = $specialDay['end_time'];
        
        // Gece çalışması kontrolü
        $isOvernight = intval(substr($specialEndTime, 0, 2)) < intval(substr($specialStartTime, 0, 2));
        $results[$date]['is_overnight'] = $isOvernight;
        
        // Seçilen tarih, özel günün başlangıç tarihi mi?
        $selectedDate = new DateTime($date);
        $specialStartDate = new DateTime($specialDay['start_date']);
        $isFirstDay = ($selectedDate->format('Y-m-d') === $specialStartDate->format('Y-m-d'));
        $isNextDay = ($selectedDate->format('Y-m-d') > $specialStartDate->format('Y-m-d'));
        
        $results[$date]['is_first_day'] = $isFirstDay;
        $results[$date]['is_next_day'] = $isNextDay;
        
        // Saatleri kontrol et
        foreach ($hours as $hour) {
            $hourValue = intval(substr($hour, 0, 2));
            $isLateHour = ($hourValue >= 0 && $hourValue <= 5);
            
            $isSpecialHour = false;
            $showHour = false;
            
            if ($isFirstDay) {
                // İlk günde sadece mesai başlangıcından gece yarısına kadar göster
                if (!$isLateHour && $hourValue >= intval(substr($specialStartTime, 0, 2)) && $hourValue <= 23) {
                    $isSpecialHour = true;
                    $showHour = true;
                }
            } else if ($isNextDay) {
                if ($isOvernight) {
                    // Ertesi günde 01:00-bitiş saati arası göster
                    if ($isLateHour && $hourValue >= 1 && $hourValue <= intval(substr($specialEndTime, 0, 2))) {
                        $isSpecialHour = true;
                        $showHour = true;
                    }
                    // Normal saatleri de göster
                    else if (!$isLateHour) {
                        $showHour = true;
                    }
                } else {
                    // Özel gün saatlerinde göster
                    if ($hourValue >= intval(substr($specialStartTime, 0, 2)) && 
                        $hourValue <= intval(substr($specialEndTime, 0, 2))) {
                        $isSpecialHour = true;
                        $showHour = true;
                    } else {
                        $showHour = true;
                    }
                }
            }
            
            // Sonuçları ekle
            $results[$date]['hours'][$hour] = [
                'is_late_hour' => $isLateHour,
                'is_special_hour' => $isSpecialHour,
                'show_hour' => $showHour
            ];
        }
    } else {
        // Normal günler için saatleri ekle
        foreach ($hours as $hour) {
            $results[$date]['hours'][$hour] = [
                'is_late_hour' => (intval(substr($hour, 0, 2)) >= 0 && intval(substr($hour, 0, 2)) <= 5),
                'is_special_hour' => false,
                'show_hour' => true
            ];
        }
    }
}

// Sonuçları göster
echo "<h1>Özel Günler Testi</h1>";

foreach ($results as $date => $data) {
    echo "<h2>Tarih: $date</h2>";
    
    if ($data['has_special_day']) {
        $specialDay = $data['special_day'];
        echo "<div style='background-color: #d9edf7; padding: 10px; margin-bottom: 10px;'>";
        echo "<strong>" . $specialDay['title'] . "</strong> özel günü: " . 
             $specialDay['start_time'] . " - " . $specialDay['end_time'] . 
             ", İlk gün: " . ($data['is_first_day'] ? 'Evet' : 'Hayır') . 
             ", Sonraki gün: " . ($data['is_next_day'] ? 'Evet' : 'Hayır') . 
             ", Gece çalışması: " . ($data['is_overnight'] ? 'Evet' : 'Hayır');
        echo "</div>";
    } else {
        echo "<p>Normal gün (özel gün değil)</p>";
    }
    
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr>
            <th>Saat</th>
            <th>Göster</th>
            <th>Özel Gün Saati</th>
            <th>Gece Saati</th>
          </tr>";
    
    foreach ($data['hours'] as $hour => $info) {
        echo "<tr>";
        echo "<td>" . $hour . "</td>";
        echo "<td style='background-color: " . ($info['show_hour'] ? '#dff0d8' : '#f2dede') . "'>" . 
             ($info['show_hour'] ? 'EVET' : 'HAYIR') . "</td>";
        echo "<td style='background-color: " . ($info['is_special_hour'] ? '#d9edf7' : '#f9f9f9') . "'>" . 
             ($info['is_special_hour'] ? 'ÖZEL' : '-') . "</td>";
        echo "<td>" . ($info['is_late_hour'] ? 'EVET' : '-') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
}

// ACİL DÜZELTME İÇİN KODLAR
echo "<h2>DÜZELTME KODLARI</h2>";
echo '<pre>
// Düzeltilmiş saat görüntüleme kodu - BAŞLANGIÇ
// Bu kodu AvailableTimeAjax.php dosyasında saatlerin oluşturulduğu kısma ekleyin (yaklaşık 240-255 satırlar arası)

// Özel günler için saatleri oluştur
$hours = [];
for ($h = 0; $h < 24; $h++) {
    $formattedHour = str_pad($h, 2, "0", STR_PAD_LEFT) . ":00";
    $hourObj = DateTime::createFromFormat("H:i", $formattedHour);
    
    // Saat değeri (0-23)
    $hourValue = $h;
    
    // Gece saati mi (00:00-05:00 arası)?
    $isLateHour = ($hourValue >= 0 && $hourValue <= 5);
    
    // Özel gün mu?
    $isSpecialHour = false;
    $showHour = true;
    
    // Eğer özel gün varsa
    if (isset($specialDay)) {
        // Başlangıç ve bitiş saatleri
        $specialStartHour = intval(substr($specialDay["start_time"], 0, 2));
        $specialEndHour = intval(substr($specialDay["end_time"], 0, 2));
        
        // Gece çalışması mı?
        $isOvernight = $specialEndHour < $specialStartHour;
        
        // Seçilen tarih ilk gün mü?
        $isFirstDay = ($selectedDate->format("Y-m-d") === $specialStartDate->format("Y-m-d"));
        $isNextDay = ($selectedDate->format("Y-m-d") > $specialStartDate->format("Y-m-d"));
        
        if ($isFirstDay) {
            // İlk günde gece saatleri gösterme
            if ($isLateHour) {
                $showHour = false;
            }
            // İlk günde sadece özel gün başlangıcından sonraki saatler özel
            else if ($hourValue >= $specialStartHour && $hourValue <= 23) {
                $isSpecialHour = true;
            }
        } 
        else if ($isNextDay) {
            if ($isOvernight) {
                // Ertesi günde 01:00-bitiş saati arası göster
                if ($isLateHour && $hourValue >= 1 && $hourValue <= $specialEndHour) {
                    $isSpecialHour = true;
                }
                // 00:00-01:00 arası gösterme
                else if ($isLateHour && $hourValue == 0) {
                    $showHour = false;
                }
            }
            // Normal çalışma saatlerini özel saat olarak göster
            else if ($hourValue >= $specialStartHour && $hourValue <= $specialEndHour) {
                $isSpecialHour = true;
            }
        }
    }
    
    if ($showHour) {
        $hours[] = [
            "hour" => $formattedHour,
            "is_special" => $isSpecialHour,
            "is_late_hour" => $isLateHour
        ];
    }
}

// Saatleri göster
foreach ($hours as $hourData) {
    $hour = $hourData["hour"];
    $isSpecial = $hourData["is_special"];
    
    echo \'<div class="col-md-2">
        <input class="custom-option-item-check\' . ($isSpecial ? \' special-day-time\' : \'\') . \'" 
               type="radio" value="\' . $hour . \':00" 
               name="customOptionsCheckableRadiosWithIcon" 
               id="customOptionsCheckableRadiosWithIcon\' . $i . \'">
        <label class="custom-option-item text-center p-1\' . ($isSpecial ? \' special-day-time\' : \'\') . \'"
               for="customOptionsCheckableRadiosWithIcon\' . $i . \'"
               onclick="setTimeout(function() { 
                  document.getElementById(\\\'customOptionsCheckableRadiosWithIcon\' . $i . \'\\\').checked = true; 
                  document.getElementById(\\\'customOptionsCheckableRadiosWithIcon\' . $i . \'\\\').dispatchEvent(new Event(\\\'change\\\')); 
               }, 10);">
            <small\' . ($isSpecial ? \' style="color: #0077be; font-weight: bold;"\' : \'\') . \'>\' . substr($hour, 0, 5) . \'</small>
            \' . ($isSpecial ? \'<i class="fas fa-star-of-life" style="font-size: 8px; color: #0077be; margin-left: 2px;"></i>\' : \'\') . \'
        </label>
    </div>\';
    
    $i++;
}
// Düzeltilmiş saat görüntüleme kodu - SON
</pre>';