<?php
date_default_timezone_set("Europe/Istanbul");
echo "<h1>Saat Testi</h1>";
$startTime = "09:00";
$endTime = "18:00";
$periyot = 30;
$serviceDakika = 60;

// Saatleri oluştur ve göster
echo "<h2>Normal Mesai: $startTime - $endTime</h2>";
echo "<h3>Periyot: $periyot dk, Hizmet Süresi: $serviceDakika dk</h3>";

// Mesai saatlerini dakika cinsinden hesapla
$startHour = intval(substr($startTime, 0, 2));
$startMinute = intval(substr($startTime, 3, 2));
$endHour = intval(substr($endTime, 0, 2));
$endMinute = intval(substr($endTime, 3, 2));

// Başlangıç ve bitiş dakikaları
$startTimeInMinutes = $startHour * 60 + $startMinute;
$endTimeInMinutes = $endHour * 60 + $endMinute;

// Saatleri oluştur
$hours = [];
for ($totalMinutes = $startTimeInMinutes; $totalMinutes <= $endTimeInMinutes - $serviceDakika; $totalMinutes += $periyot) {
    $hour = floor($totalMinutes / 60);
    $minute = $totalMinutes % 60;
    
    // Formatlı saat:dakika oluştur
    $formattedHour = str_pad($hour, 2, "0", STR_PAD_LEFT) . ":" . str_pad($minute, 2, "0", STR_PAD_LEFT);
    
    // Hizmet bitiş zamanını hesapla
    $serviceEndMinutes = $totalMinutes + $serviceDakika;
    $serviceEndHour = floor($serviceEndMinutes / 60);
    $serviceEndMinute = $serviceEndMinutes % 60;
    $serviceEndFormatted = str_pad($serviceEndHour, 2, "0", STR_PAD_LEFT) . ":" . str_pad($serviceEndMinute, 2, "0", STR_PAD_LEFT);
    
    $hours[] = [
        "hour" => $formattedHour,
        "end_time" => $serviceEndFormatted
    ];
}

// Saatleri göster
echo "<div style=\"display: flex; flex-wrap: wrap; gap: 10px;\">";
foreach ($hours as $hour) {
    echo "<div style=\"border: 1px solid #ddd; padding: 10px; border-radius: 4px;\">";
    echo $hour["hour"] . " - " . $hour["end_time"];
    echo "</div>";
}
echo "</div>";

// Gece mesaisi testi
echo "<h2>Gece Mesaisi: 21:00 - 05:00</h2>";
$startTime = "21:00";
$endTime = "05:00";

// Mesai saatlerini dakika cinsinden hesapla
$startHour = intval(substr($startTime, 0, 2));
$startMinute = intval(substr($startTime, 3, 2));
$endHour = intval(substr($endTime, 0, 2));
$endMinute = intval(substr($endTime, 3, 2));

// Başlangıç ve bitiş dakikaları
$startTimeInMinutes = $startHour * 60 + $startMinute;
$endTimeInMinutes = $endHour * 60 + $endMinute;

// Gece çalışması kontrolü
$isWorkingOvernight = $endTimeInMinutes <= $startTimeInMinutes;
if ($isWorkingOvernight) {
    $endTimeInMinutes += 24 * 60; // 24 saat ekliyoruz
    echo "<p>Gece çalışması tespit edildi. Bitiş dakikası: $endTimeInMinutes</p>";
}

// Saatleri oluştur
$hours = [];
for ($totalMinutes = $startTimeInMinutes; $totalMinutes <= $endTimeInMinutes - $serviceDakika; $totalMinutes += $periyot) {
    // Gerçek saat ve dakika (24 saat formatına modülo alınarak)
    $realMinutes = $totalMinutes;
    if ($realMinutes >= 24 * 60) {
        $realMinutes = $realMinutes % (24 * 60);
    }
    
    $hour = floor($realMinutes / 60);
    $minute = $realMinutes % 60;
    
    // Formatlı saat:dakika oluştur
    $formattedHour = str_pad($hour, 2, "0", STR_PAD_LEFT) . ":" . str_pad($minute, 2, "0", STR_PAD_LEFT);
    
    // Hizmet bitiş zamanını hesapla
    $serviceEndMinutes = $totalMinutes + $serviceDakika;
    $serviceEndRealMinutes = $serviceEndMinutes;
    if ($serviceEndRealMinutes >= 24 * 60) {
        $serviceEndRealMinutes = $serviceEndRealMinutes % (24 * 60);
    }
    
    $serviceEndHour = floor($serviceEndRealMinutes / 60);
    $serviceEndMinute = $serviceEndRealMinutes % 60;
    $serviceEndFormatted = str_pad($serviceEndHour, 2, "0", STR_PAD_LEFT) . ":" . str_pad($serviceEndMinute, 2, "0", STR_PAD_LEFT);
    
    $hours[] = [
        "hour" => $formattedHour,
        "end_time" => $serviceEndFormatted,
        "is_late_hour" => ($hour >= 0 && $hour < 6)
    ];
}

// Saatleri göster
echo "<div style=\"display: flex; flex-wrap: wrap; gap: 10px;\">";
foreach ($hours as $hour) {
    $style = $hour["is_late_hour"] ? "background-color: #ffe0e0;" : "";
    
    echo "<div style=\"border: 1px solid #ddd; padding: 10px; border-radius: 4px; $style\">";
    echo $hour["hour"] . " - " . $hour["end_time"];
    echo $hour["is_late_hour"] ? " (Gece saati)" : "";
    echo "</div>";
}
echo "</div>";
?>
