<?php
// Test dosyası - özel gün saatleri kontrolü
require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';

// Özel günler tablosunu kontrol et
$hasSpecialDaysTable = $DB->query("SHOW TABLES LIKE 'special_days'")->rowCount() > 0;

if (!$hasSpecialDaysTable) {
    die("Özel günler tablosu mevcut değil");
}

// Aktif özel günleri getir
$specialDays = $DB->query("SELECT * FROM special_days WHERE status = 1")->fetchAll(PDO::FETCH_ASSOC);

echo "<h1>Aktif Özel Günler</h1>";
echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
echo "<tr>
        <th>ID</th>
        <th>Başlık</th>
        <th>Tarih Aralığı</th>
        <th>Saat Aralığı</th>
        <th>Durum</th>
        <th>Gece Çalışması</th>
    </tr>";

foreach ($specialDays as $day) {
    $id = $day['id'];
    $title = $day['title'];
    $startDate = $day['start_date'];
    $endDate = $day['end_date'];
    $startTime = $day['start_time'];
    $endTime = $day['end_time'];
    $status = $day['status'] == 1 ? 'Aktif' : 'Pasif';
    
    // Gece çalışması kontrolü (bitiş < başlangıç)
    $isOvernight = substr($endTime, 0, 2) < substr($startTime, 0, 2);
    $overnightText = $isOvernight ? 'EVET' : 'Hayır';

    echo "<tr>
            <td>$id</td>
            <td>$title</td>
            <td>$startDate - $endDate</td>
            <td>$startTime - $endTime</td>
            <td>$status</td>
            <td style='color:" . ($isOvernight ? 'red' : 'black') . "'>$overnightText</td>
        </tr>";
}
echo "</table>";

// Test saatleri oluştur
echo "<h2>Test Saatleri</h2>";
echo "<p>Sonraki gün saatleri için 01:00-05:00 arası kontrolü</p>";

// Fonksiyon
function timeInRange($time, $start, $end) {
    $timeObj = DateTime::createFromFormat('H:i', $time);
    $startObj = DateTime::createFromFormat('H:i', $start);
    $endObj = DateTime::createFromFormat('H:i', $end);
    
    // Gece çalışması mı?
    $isOvernight = $endObj < $startObj;
    
    if ($isOvernight) {
        // Gece yarısı öncesi kontrolü
        if ($timeObj >= $startObj && $timeObj <= DateTime::createFromFormat('H:i', '23:59')) {
            return true;
        }
        // Gece yarısı sonrası kontrolü
        else if ($timeObj >= DateTime::createFromFormat('H:i', '00:00') && $timeObj <= $endObj) {
            return true;
        }
    } else {
        // Normal gün içi çalışma kontrolü
        if ($timeObj >= $startObj && $timeObj <= $endObj) {
            return true;
        }
    }
    
    return false;
}

// Testler
$testTimes = [];

// Sabahtan akşama
for ($h = 1; $h <= 23; $h++) {
    $hour = str_pad($h, 2, '0', STR_PAD_LEFT);
    $testTimes[] = $hour . ':00';
    if ($h % 3 == 0) {
        $testTimes[] = $hour . ':30';
    }
}

// Özel gün saati kontrolü
$specialDay = $specialDays[0]; // İlk aktif özel gün
$startTime = $specialDay['start_time'];
$endTime = $specialDay['end_time'];

echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
echo "<tr>
        <th>Saat</th>
        <th>İlk Gün (". $specialDay['start_date'] .")</th>
        <th>Sonraki Gün</th>
        <th>Detay</th>
    </tr>";

foreach ($testTimes as $time) {
    $hour = intval(substr($time, 0, 2));
    
    // İlk gün kontrolü
    $isSpecialForFirstDay = timeInRange($time, $startTime, $endTime) && ($hour <= 23 && $hour >= intval(substr($startTime, 0, 2)));
    
    // Sonraki gün kontrolü
    $isSpecialForNextDay = false;
    $isLateHour = ($hour >= 0 && $hour <= 5);
    $hasNextDayHours = substr($endTime, 0, 2) < substr($startTime, 0, 2);
    
    // Özel gün gece saati kontrolü (1-5 arası)
    if ($hasNextDayHours && $isLateHour && $hour >= 1 && $hour <= intval(substr($endTime, 0, 2))) {
        $isSpecialForNextDay = true;
        $detail = "Ertesi gün özel saat (gece)";
    } else if (!$isLateHour && timeInRange($time, $startTime, $endTime)) {
        $isSpecialForNextDay = true;
        $detail = "Ertesi gün normal özel saat";
    } else {
        $detail = "-";
    }
    
    echo "<tr>
            <td>$time</td>
            <td style='background-color:" . ($isSpecialForFirstDay ? '#d9edf7' : '#f9f9f9') . "'>
                " . ($isSpecialForFirstDay ? 'ÖZEL' : 'Normal') . "
            </td>
            <td style='background-color:" . ($isSpecialForNextDay ? '#d9edf7' : '#f9f9f9') . "'>
                " . ($isSpecialForNextDay ? 'ÖZEL' : 'Normal') . "
            </td>
            <td>$detail</td>
        </tr>";
}
echo "</table>";

// AvailableTimeAjax için öneriler
echo "<h2>AvailableTimeAjax.php için Kritik Değişiklikler</h2>";
echo "<p>Aşağıdaki düzeltmeler yapılmalıdır:</p>";
echo "<pre>
// 1. Gece saati kontrolü için basit integer karşılaştırması yapın:
if (\$isLateHour && intval(\$timeObj->format('H')) >= 1 && intval(\$timeObj->format('H')) <= intval(substr(\$specialEndTime, 0, 2))) {
    \$specialDaySaat = true;
    error_log('Ertesi gün özel saat: ' . \$time);
}

// 2. sonraki gün kontrolünü düzeltmek için:
\$isFirstDay = (\$selectedDate->format('Y-m-d') === \$specialStartDate->format('Y-m-d'));
\$isNextDay = (\$selectedDate->format('Y-m-d') > \$specialStartDate->format('Y-m-d'));

// 3. Özel gün için açık renk ile görüntülenen işaretlemeyi eklemeyi unutmayın:
echo '&lt;div class=\"special-day-time\"&gt;' . \$time . '&lt;/div&gt;';
</pre>";