<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/db.php'; 
require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/googletakvim/vendor/autoload.php'; 
$settings = $DB->prepare("SELECT * FROM settings WHERE id = ?");
$settings->execute(array('1'));
$settings = $settings ->fetch(PDO::FETCH_ASSOC);

$providers = $DB->query("SELECT * from provider order by id ASC")->fetchAll(PDO::FETCH_ASSOC); 
foreach ($providers as $provider) {
$calisanID = $provider['id'];
$kontrol = $DB->prepare("SELECT * FROM provider WHERE id = ?");
$kontrol->execute(array($calisanID));
$kontrol = $kontrol ->fetch(PDO::FETCH_ASSOC);

$client = new Google_Client();
$client->setClientId($settings['GoogleCalendarClientId']);
$client->setClientSecret($settings['GoogleCalendarClientSecret']);
$client->setRedirectUri('https://'.$_SERVER['SERVER_NAME'].'/admin/GoogleConnect');
$client->setAccessType('offline');
$client->setApprovalPrompt('force');
$client->addScope(Google_Service_Calendar::CALENDAR);

$token = $kontrol['GoogleCalendarToken'];
$getRefreshToken = $kontrol['GoogleCalendarRefresh'];
$client->setAccessToken($token);

if ($client->isAccessTokenExpired() && $getRefreshToken) {
    $client->fetchAccessTokenWithRefreshToken($getRefreshToken);
    $newToken = $client->getAccessToken();
    $guncelle = $DB->prepare("UPDATE provider set GoogleCalendarToken=? WHERE id=?");
    $guncelle -> execute(array(json_encode($newToken),$calisanID));
}

$service = new Google_Service_Calendar($client);

$calendarId = 'primary';
$events = $service->events->listEvents($calendarId);

$appCheck = $DB->query("SELECT * FROM appointments");
$systemEvents = $appCheck->fetchAll(PDO::FETCH_ASSOC);

function findSystemEventById($systemEvents, $eventId)
{
    foreach ($systemEvents as $systemEvent) {
        if ($systemEvent['calendarID'] == $eventId) {
            return $systemEvent;
        }
    }
    return null;
}


foreach ($events->getItems() as $event) {
    $eventIdFromCalendar = $event->getId();

    $systemEvent = findSystemEventById($systemEvents, $eventIdFromCalendar);

    if (!$systemEvent) {
        try {
            $service->events->delete($calendarId, $eventIdFromCalendar);
            echo 'Etkinlik (ID: ' . $eventIdFromCalendar . ') takvimden ve sistemden başarıyla silindi.';
        } catch (Google\Service\Exception $e) {
            echo 'Takvimden etkinlik silme hatası: ' . $e->getMessage();
        }
    }
}

function findCalendarEventById($calendarEvents, $eventId)
{
    foreach ($calendarEvents as $event) {
        if ($event->getId() == $eventId) {
            return $event;
        }
    }
    return null;
}

foreach ($systemEvents as $systemEvent) {
    $eventIdFromSystem = $systemEvent['calendarID'];

   
     $calendarEvent = findCalendarEventById($events->getItems(), $eventIdFromSystem);

    if (!$calendarEvent) {
        $sil = $DB->prepare("DELETE from appointments where calendarID=?");
        $sil -> execute(array($eventIdFromSystem));
        echo 'Etkinlik (ID: ' . $eventIdFromSystem . ') sistemden ve takvimden başarıyla silindi.';
    }
}

}


