<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class AppsPeopleOzExternalMergedpeopleapiAbout extends \Google\Model
{
  /**
   * @var string
   */
  public $contentType;
  /**
   * @var AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
   */
  public $metadata;
  protected $metadataType = AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata::class;
  protected $metadataDataType = '';
  /**
   * @var WebutilHtmlTypesSafeHtmlProto
   */
  public $safeHtmlValue;
  protected $safeHtmlValueType = WebutilHtmlTypesSafeHtmlProto::class;
  protected $safeHtmlValueDataType = '';
  /**
   * @var string
   */
  public $value;

  /**
   * @param string
   */
  public function setContentType($contentType)
  {
    $this->contentType = $contentType;
  }
  /**
   * @return string
   */
  public function getContentType()
  {
    return $this->contentType;
  }
  /**
   * @param AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
   */
  public function setMetadata(AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata $metadata)
  {
    $this->metadata = $metadata;
  }
  /**
   * @return AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
   */
  public function getMetadata()
  {
    return $this->metadata;
  }
  /**
   * @param WebutilHtmlTypesSafeHtmlProto
   */
  public function setSafeHtmlValue(WebutilHtmlTypesSafeHtmlProto $safeHtmlValue)
  {
    $this->safeHtmlValue = $safeHtmlValue;
  }
  /**
   * @return WebutilHtmlTypesSafeHtmlProto
   */
  public function getSafeHtmlValue()
  {
    return $this->safeHtmlValue;
  }
  /**
   * @param string
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return string
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppsPeopleOzExternalMergedpeopleapiAbout::class, 'Google_Service_Contentwarehouse_AppsPeopleOzExternalMergedpeopleapiAbout');
