<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceUsage;

class GoogleApiServiceusageV1ServiceConfig extends \Google\Collection
{
  protected $collection_key = 'monitoredResources';
  /**
   * @var Api[]
   */
  public $apis;
  protected $apisType = Api::class;
  protected $apisDataType = 'array';
  /**
   * @var Authentication
   */
  public $authentication;
  protected $authenticationType = Authentication::class;
  protected $authenticationDataType = '';
  /**
   * @var Documentation
   */
  public $documentation;
  protected $documentationType = Documentation::class;
  protected $documentationDataType = '';
  /**
   * @var Endpoint[]
   */
  public $endpoints;
  protected $endpointsType = Endpoint::class;
  protected $endpointsDataType = 'array';
  /**
   * @var MonitoredResourceDescriptor[]
   */
  public $monitoredResources;
  protected $monitoredResourcesType = MonitoredResourceDescriptor::class;
  protected $monitoredResourcesDataType = 'array';
  /**
   * @var Monitoring
   */
  public $monitoring;
  protected $monitoringType = Monitoring::class;
  protected $monitoringDataType = '';
  /**
   * @var string
   */
  public $name;
  /**
   * @var Quota
   */
  public $quota;
  protected $quotaType = Quota::class;
  protected $quotaDataType = '';
  /**
   * @var string
   */
  public $title;
  /**
   * @var Usage
   */
  public $usage;
  protected $usageType = Usage::class;
  protected $usageDataType = '';

  /**
   * @param Api[]
   */
  public function setApis($apis)
  {
    $this->apis = $apis;
  }
  /**
   * @return Api[]
   */
  public function getApis()
  {
    return $this->apis;
  }
  /**
   * @param Authentication
   */
  public function setAuthentication(Authentication $authentication)
  {
    $this->authentication = $authentication;
  }
  /**
   * @return Authentication
   */
  public function getAuthentication()
  {
    return $this->authentication;
  }
  /**
   * @param Documentation
   */
  public function setDocumentation(Documentation $documentation)
  {
    $this->documentation = $documentation;
  }
  /**
   * @return Documentation
   */
  public function getDocumentation()
  {
    return $this->documentation;
  }
  /**
   * @param Endpoint[]
   */
  public function setEndpoints($endpoints)
  {
    $this->endpoints = $endpoints;
  }
  /**
   * @return Endpoint[]
   */
  public function getEndpoints()
  {
    return $this->endpoints;
  }
  /**
   * @param MonitoredResourceDescriptor[]
   */
  public function setMonitoredResources($monitoredResources)
  {
    $this->monitoredResources = $monitoredResources;
  }
  /**
   * @return MonitoredResourceDescriptor[]
   */
  public function getMonitoredResources()
  {
    return $this->monitoredResources;
  }
  /**
   * @param Monitoring
   */
  public function setMonitoring(Monitoring $monitoring)
  {
    $this->monitoring = $monitoring;
  }
  /**
   * @return Monitoring
   */
  public function getMonitoring()
  {
    return $this->monitoring;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param Quota
   */
  public function setQuota(Quota $quota)
  {
    $this->quota = $quota;
  }
  /**
   * @return Quota
   */
  public function getQuota()
  {
    return $this->quota;
  }
  /**
   * @param string
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
  /**
   * @param Usage
   */
  public function setUsage(Usage $usage)
  {
    $this->usage = $usage;
  }
  /**
   * @return Usage
   */
  public function getUsage()
  {
    return $this->usage;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleApiServiceusageV1ServiceConfig::class, 'Google_Service_ServiceUsage_GoogleApiServiceusageV1ServiceConfig');
