<?php
// Tarih düzeltme dosyası
require_once __DIR__ . '/eral_date_fix.php';

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);

$_SERVER['SERVER_NAME'] .= ($_SERVER['SERVER_PORT'] != '443' && $_SERVER['SERVER_PORT'] != '80' ? ':' . $_SERVER['SERVER_PORT'] : '');

$installFile = $_SERVER['DOCUMENT_ROOT'] . "/system/settings/install/install.eralbilisim";

@chmod($installFile, 0777);

if (is_file($installFile)) {

    echo '<meta http-equiv="refresh" content="0; url=../install">';

    exit();

}

date_default_timezone_set('Europe/Istanbul');

require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
// WhatsApp fonksiyonlarını dahil et
if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/whatsapp_functions.php')) {
    require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/whatsapp_functions.php';
} else {
    // Log dosyası oluştur
    $missing_file_log = $_SERVER['DOCUMENT_ROOT'] . '/whatsapp_missing_file.log';
    file_put_contents($missing_file_log, date('Y-m-d H:i:s') . " - whatsapp_functions.php dosyası bulunamadı!\n", FILE_APPEND);
}
// Debug bilgisi
$debug_log_file = $_SERVER['DOCUMENT_ROOT'] . '/admin/specialDays_log/debug.txt';
file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - eral.php başlangıç - specialDayAdd kontrol ediliyor\n", FILE_APPEND);

// specialDayAdd parametresi geldi mi kontrol et
if (isset($_POST['specialDayAdd'])) {
    file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - specialDayAdd POST parametresi bulundu\n", FILE_APPEND);

    // specialDays.php dosyasını dahil et
    if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/specialDays.php')) {
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - specialDays.php dahil ediliyor\n", FILE_APPEND);
        require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/specialDays.php';
        // specialDayAdd işlemi specialDays.php içinde yapıldı, ana kodu devam ettirme
        exit;
    } else {
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - HATA: specialDays.php dosyası bulunamadı!\n", FILE_APPEND);
        echo "ERROR: Özel günler modülü bulunamadı";
        exit;
    }
} else if (isset($_POST['specialDayEdit']) ||
             isset($_GET['getSpecialDaysForCalendar']) ||
             isset($_POST['specialDayDelete']) ||
             isset($_POST['getSpecialDayCategory']) ||
             isset($_POST['addSpecialDayCategory']) ||
             isset($_POST['updateSpecialDayCategory']) ||
             isset($_POST['deleteSpecialDayCategory'])) {
    // Diğer özel gün işlemleri için specialDays.php dosyasını dahil et
    if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/specialDays.php')) {
        require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/specialDays.php';
    }
}

$settings = $DB->query("select * from settings where id=1")->fetch(PDO::FETCH_ASSOC);



if ($settings['langSystem'] == '1') {

    if (empty($_COOKIE['lang'])) {

        $language = $settings['defaultLang'];

        setcookie("lang", $language, time() + 31556926, '/');

    } else {

        $language = $_COOKIE['lang'];

    }

} else {

    $language = $settings['defaultLang'];

}



$lang = $DB->prepare("SELECT key_name, value FROM translations WHERE language = :language");

$lang->bindParam(':language', $language);

$lang->execute();

$translations = [];

while ($row = $lang->fetch(PDO::FETCH_ASSOC)) {

    $translations[$row['key_name']] = $row['value'];

}



function randomCreate($length)

{

    $char = "1234567890abcdefghKLMNOPRSTuvyzABCDEFGHklmnoprstUVYZ0987654321";

    $text = '';

    for ($i = 0; $i < $length; $i++) {

        $text .= $char[rand() % 72];

    }

    return $text;

}



function generateUrl($length = 5)

{

    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';

    $charactersLength = strlen($characters);

    $randomString = '';

    for ($i = 0; $i < $length; $i++) {

        $randomString .= $characters[rand(0, $charactersLength - 1)];

    }

    $time = substr(time(), -3);

    return $randomString . $time;

}



if (isset($_POST['login'])) {

    session_start();

    $email = htmlspecialchars(trim($_POST['email']));

    $password = htmlspecialchars(trim($_POST['password']));

    $login = $DB->prepare("select * from provider where email=?");

    $login->execute(array($email));

    $exp = $login->fetch(PDO::FETCH_ASSOC);

    $check = $login->rowCount();

    $checkdate = date("d-m-Y H:i:s");

    if ($login->rowCount() == '0') {

        echo '<meta http-equiv="refresh" content="0; url=login?err=5&mail=' . $email . '">'; //Mail sistemde yoksa

    } else {



        $dbPassword = $exp['password'];

        if (password_verify($password, $dbPassword)) {

            session_start();

            $_SESSION["memberLogin"] = "true";

            $_SESSION['memberId'] = $exp['id'];

            setcookie("memberLogin", "true");

//beni hatırla bas

            if (isset($_POST['remember-me'])) {

                $UserID = $exp['id'];

                $delete = $DB->exec("DELETE FROM remember_me WHERE user_id = '$UserID' ");

                $NewToken = bin2hex(openssl_random_pseudo_bytes(32));



                $Insert2 = $DB->prepare("INSERT INTO remember_me SET

    user_id = :bir,

    remember_token = :iki,

    expired_time = :uc,

    user_browser = :dort");

                $insert = $Insert2->execute(array(

                    "bir" => $UserID,

                    "iki" => $NewToken,

                    "uc" => time() + 31556926,

                    'dort' => md5($_SERVER['HTTP_USER_AGENT'])

                ));



                setcookie("ERAL", $NewToken, time() + 31556926, '/');

            }

//beni hatırla bitis

            echo '<meta http-equiv="refresh" content="0; url=home">';

        } else {

            echo '<meta http-equiv="refresh" content="0; url=login?err=5&mail=' . $email . '">'; //Şifre doğru değil ise

        }

    }

}





if (isset($_POST['randevuEkle'])) {

//KONTROL

    $provider = htmlspecialchars(trim($_POST['provider']));

    $randevuTarih = htmlspecialchars(trim($_POST['start-date']));

    $saat = htmlspecialchars(trim($_POST['customOptionsCheckableRadiosWithIcon']));
    // Eğer bitiş saati POST'ta varsa al, yoksa NULL olarak bırak
    $bitisSaat = isset($_POST['selectedEndTime']) ? htmlspecialchars(trim($_POST['selectedEndTime'])) : null;

    $randevuKontrol = $DB->prepare("SELECT * FROM appointments WHERE providerID=? AND appDate=? AND startTime=?");

    $randevuKontrol->execute(array($provider, $randevuTarih, $saat));

//KONTROL

    if ($randevuKontrol->rowCount()) {

        echo "varvar";

    } else {

        if ($_POST['randevuDuzenle'] == '0') {

            $service = htmlspecialchars(trim($_POST['service']));

            $provider = htmlspecialchars(trim($_POST['provider']));

            $randevuTarih = htmlspecialchars(trim($_POST['start-date']));

            $saat = htmlspecialchars(trim($_POST['customOptionsCheckableRadiosWithIcon']));

            $musteri = isset($_POST['musteri']) ? htmlspecialchars(trim($_POST['musteri'])) : "";

            $musteriAd = htmlspecialchars(trim($_POST['musteriAd']));

            $musteriTelefon = htmlspecialchars(trim($_POST['musteriTelefon']));

            $musteriMail = isset($_POST['musteriMail']) ? htmlspecialchars(trim($_POST['musteriMail'])) : "";



            if (!empty($musteri)) {

                $musteriID = $musteri;

            } else {



                $kontrol = $DB->prepare("SELECT * FROM members WHERE phone = ?");

                $kontrol->execute(array($musteriTelefon));

                if ($kontrol->rowCount()) {

                    $row = $kontrol->fetch(PDO::FETCH_ASSOC);

                    $musteriID = $row['id'];

                } else {

                    $musteriEkle = $DB->prepare("INSERT into members set name=?, phone=?, email=?");

                    $musteriEkle->execute(array($musteriAd, $musteriTelefon, $musteriMail));

                    $musteriID = $DB->lastInsertId();

                }

            }



            $musteriKontrol = $DB->prepare("SELECT * FROM members WHERE id=?");

            $musteriKontrol->execute(array($musteriID));

            $musteriKontrolDeger = $musteriKontrol->fetch(PDO::FETCH_ASSOC);



            $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

            $providerKontrol->execute(array($provider));

            $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);



            $serviceKontrol = $DB->prepare("SELECT * FROM services WHERE id=?");

            $serviceKontrol->execute(array($service));

            $serviceKontrolDeger = $serviceKontrol->fetch(PDO::FETCH_ASSOC);

            $serviceSaat = $serviceKontrolDeger['hour'];



            // Eğer bir bitiş saati geldi ise onu kullan, yoksa hesapla
            if ($bitisSaat) {
                $endTimeDeger = $bitisSaat;
            } else {
                $endTime = new DateTime($saat);
                $endTime->modify('+' . $serviceSaat . ' minute');
                $endTimeDeger = $endTime->format('H:i:s');
            }



            $payment = htmlspecialchars(trim($_POST['odemeYontemi']));

            $note = isset($_POST['note']) ? htmlspecialchars(trim($_POST['note'])) : "";





$stmt = $DB->prepare("SELECT COUNT(*) FROM appointments WHERE providerID = :providerID AND appDate = :appDate AND startTime = :startTime AND endTime = :endTime");

$stmt->bindParam(':providerID', $provider);

$stmt->bindParam(':appDate', $randevuTarih);

$stmt->bindParam(':startTime', $saat);

$stmt->bindParam(':endTime', $endTimeDeger);

$stmt->execute();



$rowCount = $stmt->fetchColumn();

  if ($rowCount > 0) {

      ?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



<?php
// Tarih düzeltme dosyası
require_once __DIR__ . '/eral_date_fix.php';

    echo "<script>

            Swal.fire({

                title: 'Randevu Çakışması!',

                text: 'Bu zaman diliminde zaten bir randevu var.',

                icon: 'warning',

                confirmButtonText: 'Tamam'

            }).then((result) => {

                if (result.isConfirmed) {

                    window.location.href = '/'; // Ana URL'ye yönlendirme

                }

            });

          </script>";

          die();

}



            $ekle = $DB->prepare("INSERT into appointments set service=?, providerID=?, appDate=?, startTime=?, endTime=?, member=?, payment=?, note=?");

            $ekle->execute(array($service, $provider, $randevuTarih, $saat, $endTimeDeger, $musteriID, $payment, $note));

            $url = generateUrl();

            $eklenenRandevu = $DB->lastInsertId();
            $whatsappBildirimGonderildi = false; // Bildirim durumu için bayrak

            // Notification_log tablosuna randevu oluşturulduğu kaydını ekle
            try {
                // İlk kaydı oluştur
                $DB->prepare("INSERT INTO notification_log (appointment_id, phone, notification_type, sent_at, success)
                              VALUES (?, ?, ?, NOW(), ?)")
                   ->execute(array($eklenenRandevu, $musteriTelefon, 'randevu_olusturma', 1));
                file_put_contents($debug_log_file, "Yeni randevu bildirim logu oluşturuldu\n", FILE_APPEND);
            } catch (Exception $e) {
                file_put_contents($debug_log_file, "Randevu bildirim logu oluşturulamadı: " . $e->getMessage() . "\n", FILE_APPEND);
            }


            $ekle = $DB->prepare("INSERT into redirect set url=?, appointment=?");

            $ekle->execute(array($url, $eklenenRandevu));

            // WhatsApp bildirimi için kod - Ayarlardan bağımsız olarak her zaman çalışır
            file_put_contents($debug_log_file, "WhatsApp bildirimi için randevu eklendi, ID: " . $eklenenRandevu . "\n", FILE_APPEND);
            if ($settings['whatsappSystem'] == '1') {
            try {
                // Müşteri ve randevu bilgilerini al
                $randevuBilgi = $DB->prepare("SELECT a.*, m.name as member_name, m.phone, s.serviceName, p.name as provider_name
                    FROM appointments a
                    LEFT JOIN members m ON a.member = m.id
                    LEFT JOIN services s ON a.service = s.id
                    LEFT JOIN provider p ON a.providerID = p.id
                    WHERE a.id = ?");
                $randevuBilgi->execute(array($eklenenRandevu));

                if ($randevuBilgi->rowCount() > 0) {
                    $randevu = $randevuBilgi->fetch(PDO::FETCH_ASSOC);

                    // Settings tablosundan WhatsApp API anahtarını al
                    $settingsQuery = $DB->query("SELECT whatsappApiKey FROM settings WHERE id = 1");
                    $apiKey = $settingsQuery ? $settingsQuery->fetchColumn() : '';

                    if (!empty($apiKey) && !empty($randevu['phone'])) {
                        // Bildirimi doğrudan gönder
                        file_put_contents($debug_log_file, "Müşteriye doğrudan WhatsApp gönderimi deneniyor...\n", FILE_APPEND);

                        // Telefon numarasını formatla
                        $phone = preg_replace('/[^0-9]/', '', $randevu['phone']);

                        // Numaranın ilk karakteri 0 ise kaldır
                        if (strlen($phone) > 0 && substr($phone, 0, 1) == '0') {
                            $phone = substr($phone, 1);
                        }

                        // Farklı numara formatlarını ele al
                        if (strlen($phone) == 10) {
                            $phone = '90' . $phone;
                        }
                        else if (strlen($phone) == 11 && substr($phone, 0, 1) == '5') {
                            $phone = '90' . $phone;
                        }

                        // Veritabanından mesaj şablonunu al
                        $notification_query = $DB->query("SELECT * FROM notification_settings WHERE id = 1"); // Randevu alındı bildirimi

                        if ($notification_query && $notification_query->rowCount() > 0) {
                            $notification = $notification_query->fetch(PDO::FETCH_ASSOC);
                            $template = $notification['template'];

                            // Değişkenleri değiştir
                            $template = str_replace('{siteAdi}', $settings['siteName'], $template);
                            $template = str_replace('{uyeAdi}', $randevu['member_name'], $template);
                            $template = str_replace('{tarih}', $randevu['appDate'], $template);
                            $template = str_replace('{saat}', $randevu['startTime'], $template);
                            $template = str_replace('{hizmet}', $randevu['serviceName'], $template);
                            $template = str_replace('{calisan}', $randevu['provider_name'], $template);
                            $template = str_replace('{siteadres}', $_SERVER['SERVER_NAME'], $template);

                            // İptal/değişiklik linkini ekle
                            if ($settings['cancelSystem'] == '1') {
                                $redirect = "https://" . $_SERVER['SERVER_NAME'] . "/r/" . $url;
                                $cancelMessageText = " " . $settings['cancelMessage'] . $redirect;
                                $template .= $cancelMessageText;

                                file_put_contents($debug_log_file, "İptal/değişiklik linki eklendi: " . $redirect . "\n", FILE_APPEND);
                            }

                            $message = $template;
                        } else {
                            // Şablon bulunamadıysa varsayılan mesajı kullan
                            $message = "Sayın " . $randevu['member_name'] . ", " . $randevu['appDate'] . " tarihinde saat " . $randevu['startTime'] . " için " . $randevu['serviceName'] . " randevunuz oluşturulmuştur. Teşekkür ederiz.";
                        }

                        // API isteği
                        $body = array(
                            "api_key" => $apiKey,
                            "receiver" => $phone,
                            "data" => array("message" => $message)
                        );

                        file_put_contents($debug_log_file, "WhatsApp API isteği: " . json_encode($body) . "\n", FILE_APPEND);

                        $curl = curl_init();
                        curl_setopt_array($curl, [
                            CURLOPT_URL => "https://api.wpapi.com.tr/api/send-message",
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => "POST",
                            CURLOPT_POSTFIELDS => json_encode($body),
                            CURLOPT_HTTPHEADER => [
                                "Accept: */*",
                                "Content-Type: application/json",
                            ],
                        ]);

                        $response = curl_exec($curl);
                        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                        $err = curl_error($curl);

                        curl_close($curl);

                        file_put_contents($debug_log_file, "WhatsApp API yanıtı (HTTP: $httpCode): " . $response . "\n", FILE_APPEND);

                        if ($err) {
                            file_put_contents($debug_log_file, "WhatsApp API hatası: " . $err . "\n", FILE_APPEND);
                        }
                    } else {
                        file_put_contents($debug_log_file, "WhatsApp API anahtarı bulunamadı veya telefon numarası boş\n", FILE_APPEND);
                    }
                }
            } catch (Exception $e) {
                file_put_contents($debug_log_file, "WhatsApp gönderiminde hata: " . $e->getMessage() . "\n", FILE_APPEND);
            }
        }

            }



//Google Takvim Entegrasyonu Randevu Ekleme

            if ($settings['GoogleCalendarStatus'] == '1') {

                $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

                $providerKontrol->execute(array($provider));

                $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

                if ($providerKontrolDeger['GoogleCalendarStatus'] == '1') {

                    require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/googletakvim/vendor/autoload.php';

                    $title = $serviceKontrolDeger['serviceName'] . " Randevusu";

                    if (!empty($note)) {

                        $noteG = "<br>Müşteri Notu: " . $note;

                    } else {

                        $noteG = "";

                    }

                    $desc = "Müşteri Ad Soyad: " . $musteriKontrolDeger['name'] . "<br>Telefon: " . $musteriKontrolDeger['phone'] . $noteG;

                    $start = $randevuTarih . 'T' . $saat;

                    $end = $randevuTarih . 'T' . $endTimeDeger;



                    $client = new Google_Client();

                    $client->setClientId($settings['GoogleCalendarClientId']);

                    $client->setClientSecret($settings['GoogleCalendarClientSecret']);

                    $client->setRedirectUri('https://' . $_SERVER['SERVER_NAME'] . '/admin/GoogleConnect');

                    $client->setAccessType('offline');

                    $client->setApprovalPrompt('force');

                    $client->addScope(Google_Service_Calendar::CALENDAR);

                    $token = $providerKontrolDeger['GoogleCalendarToken'];

                    $getRefreshToken = $providerKontrolDeger['GoogleCalendarRefresh'];

                    $client->setAccessToken($token);



                    if ($client->isAccessTokenExpired() && $getRefreshToken) {

                        $client->fetchAccessTokenWithRefreshToken($getRefreshToken);

                        $newToken = $client->getAccessToken();

                        $guncelle = $DB->prepare("UPDATE provider set GoogleCalendarToken=? WHERE id=?");

                        $guncelle->execute(array(json_encode($newToken), $provider));

                    }



                    $service = new Google_Service_Calendar($client);



                    $event = new Google_Service_Calendar_Event(array(

                        'summary' => $title,

                        'description' => $desc,

                        'start' => array(

                            'dateTime' => $start,

                            'timeZone' => 'Europe/Istanbul',

                        ),

                        'end' => array(

                            'dateTime' => $end,

                            'timeZone' => 'Europe/Istanbul',

                        ),

                    ));





                    $calendarId = 'primary';

                    $event = $service->events->insert($calendarId, $event);

                    $createdEventId = $event->id;



                    $guncelleAppointments = $DB->prepare("UPDATE appointments set calendarID=? WHERE id=?");

                    $guncelleAppointments->execute(array($createdEventId, $eklenenRandevu));



                }

            }



//Email Sistemi

            $musteriMail = $musteriKontrolDeger['email'];

            if ($settings['emailSystem'] == '1') {

                $mail_settings = $DB->query("SELECT * from mail_settings where id=1")->fetch(PDO::FETCH_ASSOC);

                $sunucu = htmlspecialchars(trim($mail_settings['siteSmtphost']));

                $posta = htmlspecialchars(trim($mail_settings['siteSmtpmail']));

                $esifre = htmlspecialchars(trim($mail_settings['siteSmtppass']));

                $port = htmlspecialchars(trim($mail_settings['siteSmtpport']));

                $type = htmlspecialchars(trim($mail_settings['siteSmtptype']));

                $email = $musteriMail;

                $siteadi = htmlspecialchars(trim($settings['siteName']));

                $randevuhizmet = $serviceKontrolDeger['serviceName'];

                $subeAd = $providerKontrolDeger['name'];

                $musteriAd = $musteriKontrolDeger['name'];

                $musteriTelefon = $musteriKontrolDeger['phone'];

                $logoadres = "https://" . $_SERVER['SERVER_NAME'] . "/admin/app-assets/images/logo/" . $settings['siteLogo'];

                include($_SERVER['DOCUMENT_ROOT'] . '/admin/system/mail/PHPMailerAutoload.php');

                $siteadresi = "https://" . $_SERVER['SERVER_NAME'];

                $mail = new PHPMailer;

                $body = file_get_contents($_SERVER['DOCUMENT_ROOT'] . "/admin/system/mail/template/randevu.html");

                $body = str_replace('%logoadres%', $logoadres, $body);

                $body = str_replace('%siteisim%', $siteadi, $body);

                $body = str_replace('%siteadresi%', $siteadresi, $body);

                $body = str_replace('%isim%', $musteriAd, $body);

                $body = str_replace('%randevuhizmet%', $randevuhizmet, $body);

                $body = str_replace('%subeisim%', $subeAd, $body);

                $body = str_replace('%randevutarih%', $randevuTarih, $body);

                $body = str_replace('%randevusaat%', $saat, $body);

                $mail->IsSMTP();

                //$mail->SMTPDebug = 1; // hata ayiklama: 1 = hata ve mesaj, 2 = sadece mesaj

                $mail->SMTPAuth = true;

                $mail->SMTPSecure = "$type"; // Güvenli baglanti icin ssl normal baglanti icin tls

                $mail->Host = "$sunucu"; // Mail sunucusuna ismi

                $mail->Port = "$port"; // Gucenli baglanti icin 465 Normal baglanti icin 587

                $mail->IsHTML(true);

                $mail->SetLanguage("tr", "phpmailer/language");

                $mail->CharSet = "utf-8";

                $mail->Username = "$posta"; // Mail adresimizin kullanicı adi

                $mail->Password = "$esifre"; // Mail adresimizin sifresi

                $mail->SetFrom($mail->Username, '' . $siteadi . '');

                $mail->AddAddress($email); // Maili gonderecegimiz kisi yani alici

                $mail->addReplyTo($email, $siteadi);

                $mail->Subject = "Randevunuz Oluşturuldu"; // Konu basligi

                $mail->MsgHTML($body);

                $mail->IsHTML(true);

                $mail->CharSet = "utf-8";

                $mail->Send();



//yönetici mail

                $email = $providerKontrolDeger['email'];

                $subeAd = $providerKontrolDeger['name'];



                $mail = new PHPMailer;

                $body = file_get_contents($_SERVER['DOCUMENT_ROOT'] . "/admin/system/mail/template/sube.html");

                $body = str_replace('%logoadres%', $logoadres, $body);

                $body = str_replace('%siteisim%', $siteadi, $body);

                $body = str_replace('%siteadresi%', $siteadresi, $body);

                $body = str_replace('%subeisim%', $subeAd, $body);

                $body = str_replace('%musteriAd%', $musteriAd, $body);

                $body = str_replace('%musteriTelefon%', $musteriTelefon, $body);

                $body = str_replace('%musteriEmail%', $musteriMail, $body);

                $body = str_replace('%randevuhizmet%', $randevuhizmet, $body);

                $body = str_replace('%randevutarih%', $randevuTarih, $body);

                $body = str_replace('%randevusaat%', $saat, $body);

                $mail->IsSMTP();

                //$mail->SMTPDebug = 1; // hata ayiklama: 1 = hata ve mesaj, 2 = sadece mesaj

                $mail->SMTPAuth = true;

                $mail->SMTPSecure = "$type"; // Güvenli baglanti icin ssl normal baglanti icin tls

                $mail->Host = "$sunucu"; // Mail sunucusuna ismi

                $mail->Port = "$port"; // Gucenli baglanti icin 465 Normal baglanti icin 587

                $mail->IsHTML(true);

                $mail->SetLanguage("tr", "phpmailer/language");

                $mail->CharSet = "utf-8";

                $mail->Username = "$posta"; // Mail adresimizin kullanicı adi

                $mail->Password = "$esifre"; // Mail adresimizin sifresi

                $mail->SetFrom($mail->Username, '' . $siteadi . '');

                $mail->AddAddress($email); // Maili gonderecegimiz kisi yani alici

                $mail->addReplyTo($email, $siteadi);

                $mail->Subject = "Yeni Randevu"; // Konu basligi

                $mail->MsgHTML($body);

                $mail->IsHTML(true);

                $mail->CharSet = "utf-8";

                $mail->Send();

            }



//netgsm Sms Entegrasyonu
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - SMS entegrasyonu kontrol ediliyor\n", FILE_APPEND);

            if ($settings['smsSystem'] == '1') { //sms bildirim
                file_put_contents($debug_log_file, "SMS sistemi aktif\n", FILE_APPEND);

                $notification_settings = $DB->query("select * from notification_settings where id=1")->fetch(PDO::FETCH_ASSOC);

                if ($notification_settings['status'] == '1') {
                    // Buraya bir debug mesajı ekliyoruz
                    file_put_contents($debug_log_file, "Bildirim ayarları aktif, SMS ve WhatsApp hazırlanıyor\n", FILE_APPEND);

                    $smsSettings = $DB->prepare("select * from sms_settings where id=?");

                    $smsSettings->execute(array('1'));

                    $sms = $smsSettings->fetch(PDO::FETCH_ASSOC);

                    $username = $sms['username'];

                    $password = $sms['password'];

                    $title = $sms['title'];

                    $number = $musteriKontrolDeger['phone'];

                    $siteadresi = "https://" . $_SERVER['SERVER_NAME'];

                    $siteAdi = $settings['siteName'];

                    $musteriAdiNe = $musteriKontrolDeger['name'];

                    $calisanAdiNe = $providerKontrolDeger['name'];

                    // Burada WhatsApp fonksiyonunun varlığını kontrol edelim
                    file_put_contents($debug_log_file, "WhatsApp fonksiyonu kontrol ediliyor\n", FILE_APPEND);
                    if (function_exists('sendWhatsAppMessage')) {
                        file_put_contents($debug_log_file, "sendWhatsAppMessage fonksiyonu bulundu\n", FILE_APPEND);
                    } else {
                        file_put_contents($debug_log_file, "sendWhatsAppMessage fonksiyonu bulunamadı, yükleniyor\n", FILE_APPEND);

                        if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/whatsapp_functions.php')) {
                            require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/whatsapp_functions.php';
                            file_put_contents($debug_log_file, "whatsapp_functions.php dosyası yüklendi\n", FILE_APPEND);
                        } else {
                            file_put_contents($debug_log_file, "HATA: whatsapp_functions.php dosyası bulunamadı\n", FILE_APPEND);
                        }
                    }



                    $sablon = $DB->prepare("select * from notification_settings where id=?");

                    $sablon->execute(array('1'));

                    $sablonCek = $sablon->fetch(PDO::FETCH_ASSOC);

                    $messageSablon = $sablonCek['template'];

                    $tarihNe = $randevuTarih;

                    $saatNe = $saat;

                    $hizmetNe = $serviceKontrolDeger['serviceName'];

                    setlocale(LC_TIME, 'turkish');

                    // strftime kaldırıldı, date() kullanılıyor
                    setlocale(LC_TIME, 'tr_TR.UTF-8', 'tr_TR', 'tr', 'turkish');
                    $fmt = new IntlDateFormatter(
                        'tr_TR',
                        IntlDateFormatter::LONG,
                        IntlDateFormatter::NONE,
                        null,
                        null,
                        ' d MMMM Y EEEE '
                    );
                    $tarihNe = $fmt->format(new DateTime($tarihNe));



                    $aylar = array(

                        'January' => 'Ocak',

                        'February' => 'Şubat',

                        'March' => 'Mart',

                        'April' => 'Nisan',

                        'May' => 'Mayıs',

                        'June' => 'Haziran',

                        'July' => 'Temmuz',

                        'August' => 'Ağustos',

                        'September' => 'Eylül',

                        'October' => 'Ekim',

                        'November' => 'Kasım',

                        'December' => 'Aralık'

                    );



                    $gunler = array(

                        'Monday' => 'Pazartesi',

                        'Tuesday' => 'Salı',

                        'Wednesday' => 'Çarşamba',

                        'Thursday' => 'Perşembe',

                        'Friday' => 'Cuma',

                        'Saturday' => 'Cumartesi',

                        'Sunday' => 'Pazar'

                    );

                    $tarihNe = str_replace(array_keys($aylar), array_values($aylar), $tarihNe);

                    $tarihNe = str_replace(array_keys($gunler), array_values($gunler), $tarihNe);





                    $saatNe = new DateTime($saatNe);

                    $saatNe = $saatNe->format("H:i");





                    $messageSablon = str_replace('{siteAdi}', $siteAdi, $messageSablon);

                    $messageSablon = str_replace('{uyeAdi}', $musteriAdiNe, $messageSablon);

                    $messageSablon = str_replace('{tarih}', $tarihNe, $messageSablon);

                    $messageSablon = str_replace('{saat}', $saatNe, $messageSablon);

                    $messageSablon = str_replace('{hizmet}', $hizmetNe, $messageSablon);

                    $messageSablon = str_replace('{calisan}', $calisanAdiNe, $messageSablon);

                    // Şablon değişkenleri topla (WhatsApp için)
                    $messageVars = array(
                        'siteAdi' => $siteAdi,
                        'uyeAdi' => $musteriAdiNe,
                        'tarih' => $tarihNe,
                        'saat' => $saatNe,
                        'hizmet' => $hizmetNe,
                        'calisan' => $calisanAdiNe,
                        'siteadres' => $siteadresi,
                        'randevuID' => $eklenenRandevu // Randevu ID'sini ekleyelim (iptal/değişiklik linki için)
                    );



                    $cancelSystem = $settings['cancelSystem'];

                    $cancelMessage = $settings['cancelMessage'];

                    if ($cancelSystem == '1') {

                        $redirect = "https://" . $_SERVER['SERVER_NAME'] . "/r/" . $url;

                        $cancelMessageText = " " . $cancelMessage . $redirect;

                        $message = $messageSablon . $cancelMessageText;

                    } else {

                        $message = $messageSablon;

                    }

                    // Değişken tanımlı değilse oluştur
                    if (!isset($source)) {
                        $source = '';
                    }
                    if (!isset($source)) $source = ''; $source .= '<mesaj><metin>' . $message . '</metin><nums>' . $number . '</nums></mesaj>';

                    $xml_data = '<?xml version="1.0"?>

<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
  xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

  <SOAP-ENV:Body>

    <ns3:smsGonderNNV2 xmlns:ns3="http://sms/">

      <username>' . $username . '</username>

      <password>' . $password . '</password>

      <header>' . $title . '</header>

      <msg>' . $message . '</msg>

      <gsm>' . $number . '</gsm>

      <filter>0</filter>

      <encoding>TR</encoding>

    </ns3:smsGonderNNV2>

  </SOAP-ENV:Body>

</SOAP-ENV:Envelope>';



$curl = curl_init();

curl_setopt_array($curl, array(

CURLOPT_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl/',

CURLOPT_RETURNTRANSFER => true,

CURLOPT_ENCODING => '',

CURLOPT_MAXREDIRS => 10,

CURLOPT_TIMEOUT => 0,

CURLOPT_FOLLOWLOCATION => true,

CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,

CURLOPT_CUSTOMREQUEST => 'POST',

CURLOPT_POSTFIELDS => "$xml_data",

CURLOPT_HTTPHEADER => array(

'Content-Type: text/xml'

),

));

$response = curl_exec($curl);

curl_close($curl);

$time = date('Y-m-d H:i:s');

$ekle = $DB->prepare("INSERT into sms_history set member=?, number=?, message=?, time=?, appointment_id=?,
remember_time=?");

$ekle->execute(array($musteriID, $number, $message, $time, $eklenenRandevu, '0'));

// WhatsApp bildirimi artık burada gönderilmiyor
// Bildirimler tek bir yerden, sonraki kod bloğunda gönderiliyor
if ($settings['whatsappSystem'] == '1') {
file_put_contents($debug_log_file, "WhatsApp bildirimi sonraki blokta gönderilecek\n", FILE_APPEND);
} else {
file_put_contents($debug_log_file, "WhatsApp sistemi kapalı\n", FILE_APPEND);
}
} else {
file_put_contents($debug_log_file, "HATA: sendWhatsAppMessage fonksiyonu bulunamadı\n", FILE_APPEND);
}
} else {
file_put_contents($debug_log_file, "WhatsApp bildirimi atlanıyor (daha önce gönderilmiş veya sistem kapalı)\n",
FILE_APPEND);
}

$providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");
$providerKontrol->execute(array($provider));
$providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

$calisanNumber = $providerKontrolDeger['smsNumber'];
$calisanMessage = "Sayın " . $calisanAdiNe . ", " . $musteriAdiNe . " adlı müşteri tarafından" . $tarihNe . "saat " .
$saatNe . " için " . $hizmetNe . " randevusu alınmıştır. İyi çalışmalar dileriz.";

// Çalışana özel XML verisi
$calisanXmlData = '
<?xml version="1.0"?>
<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
  xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
  <SOAP-ENV:Body>
    <ns3:smsGonderNNV2 xmlns:ns3="http://sms/">
      <username>' . $username . '</username>
      <password>' . $password . '</password>
      <header>' . $title . '</header>
      <msg>' . $calisanMessage . '</msg>
      <gsm>' . $calisanNumber . '</gsm>
      <filter>0</filter>
      <encoding>TR</encoding>
    </ns3:smsGonderNNV2>
  </SOAP-ENV:Body>
</SOAP-ENV:Envelope>';

// Çalışana SMS gönderimi
file_put_contents($debug_log_file, "Çalışana SMS gönderimi hazırlanıyor\n", FILE_APPEND);
$calisanCurl = curl_init();
curl_setopt_array($calisanCurl, array(
CURLOPT_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl/',
CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => '',
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 0,
CURLOPT_FOLLOWLOCATION => true,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => 'POST',
CURLOPT_POSTFIELDS => "$calisanXmlData",
CURLOPT_HTTPHEADER => array(
'Content-Type: text/xml'
),
));
$calisanResponse = curl_exec($calisanCurl);
curl_close($calisanCurl);

// Çalışana WhatsApp bildirimi
if ($settings['whatsappSystem'] == '1' && $settings['providerSmsSystem'] == '1') {
file_put_contents($debug_log_file, "Çalışana WhatsApp bildirimi gönderiliyor...\n", FILE_APPEND);

// BU BLOK DEVRE DIŞI BIRAKILDI - çift bildirim sorunu yaratıyor
if (false && function_exists('sendWhatsAppMessage')) {
file_put_contents($debug_log_file, "Çalışan için sendWhatsAppMessage fonksiyonu devre dışı bırakıldı\n", FILE_APPEND);
// $whatsapp_result = sendWhatsAppMessage($calisanNumber, $calisanMessage);
$whatsapp_result = false;
file_put_contents($debug_log_file, "Çalışana WhatsApp bildirimi atlandı - çift gönderim engellemesi\n", FILE_APPEND);
} else {
file_put_contents($debug_log_file, "HATA: Çalışan için sendWhatsAppMessage fonksiyonu bulunamadı\n", FILE_APPEND);
}
}

// WhatsApp Bildirimi Gönderimi - Log Dosyası başlatma
file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - WhatsApp bildirimi hazırlanıyor\n", FILE_APPEND);

// notification_log tablosunda bu randevu için bildirim gönderilip gönderilmediğini kontrol et
if (function_exists('sendWhatsAppMessage') && $settings['whatsappSystem'] == '1') {
// Randevu ID'ye göre bildirim kontrolü
try {
// notification_log tablosu var mı kontrol edelim (tablonun olmaması beyaz ekrana neden olabilir)
$table_check = $DB->query("SHOW TABLES LIKE 'notification_log'");
if ($table_check->rowCount() == 0) {
// Tablo yoksa oluşturalım
$DB->exec("CREATE TABLE IF NOT EXISTS notification_log (
id INT AUTO_INCREMENT PRIMARY KEY,
appointment_id INT NOT NULL,
phone VARCHAR(20) NOT NULL,
notification_type VARCHAR(20) NOT NULL,
sent_at DATETIME NOT NULL,
success TINYINT(1) DEFAULT 1
)");
file_put_contents($debug_log_file, "notification_log tablosu oluşturuldu\n", FILE_APPEND);
// Tablo yeni oluşturuldu, kayıt yok
$notification_count = 0;
} else {
// Tablo var, son 30 saniyedeki bildirimleri kontrol et
$check_query = $DB->prepare("SELECT COUNT(*) FROM notification_log WHERE
appointment_id = ? AND notification_type = ? AND
sent_at > DATE_SUB(NOW(), INTERVAL 30 SECOND)");
$check_query->execute(array($eklenenRandevu, 'alindi'));
$notification_count = $check_query->fetchColumn();
}

if ($notification_count > 0) {
file_put_contents($debug_log_file, "Son 30 saniyede zaten bildirim gönderilmiş, tekrar gönderilmeyecek\n", FILE_APPEND);
$whatsappBildirimGonderildi = true;
} else {
file_put_contents($debug_log_file, "Bildirim kontrol edildi, gönderim yapılabilir\n", FILE_APPEND);

// WhatsApp Log Dosyası
$whatsapp_log_file = $_SERVER['DOCUMENT_ROOT'] . '/whatsapp_debug.txt';
file_put_contents($whatsapp_log_file, "\n--- YENİ RANDEVU: " . date('Y-m-d H:i:s') . " ---\n", FILE_APPEND);
file_put_contents($whatsapp_log_file, "Randevu bilgileri: " . $musteriAdiNe . ", " . $hizmetNe . ", " . $tarihNe . ", "
. $saatNe . "\n", FILE_APPEND);

// Değişkenleri kontrol et - özellikle uyeAdi'nin doğru olduğundan emin ol
if (empty($messageVars['uyeAdi']) || $messageVars['uyeAdi'] == '{uyeAdi}') {
$messageVars['uyeAdi'] = $musteriAd;
file_put_contents($debug_log_file, "uyeAdi değişkeni düzeltildi: " . $musteriAd . "\n", FILE_APPEND);
}

// SADECE BU BLOKTA MÜŞTERİYE BİLDİRİM GÖNDER
file_put_contents($debug_log_file, "Müşteriye WhatsApp gönderiliyor: " . $number . "\n", FILE_APPEND);
$wa_result = sendWhatsAppMessage($number, "", "alindi", $messageVars);

if ($wa_result) {
$whatsappBildirimGonderildi = true;
file_put_contents($debug_log_file, "WhatsApp bildirimi gönderildi ve başarı bayrağı set edildi\n", FILE_APPEND);
}
file_put_contents($debug_log_file, "Müşteriye WhatsApp sonucu: " . ($wa_result ? "Başarılı" : "Başarısız") . "\n",
FILE_APPEND);
}
} catch (Exception $e) {
file_put_contents($debug_log_file, "Bildirim kontrolünde hata: " . $e->getMessage() . "\n", FILE_APPEND);
}
} else {
file_put_contents($debug_log_file, "WhatsApp bildirimi gönderilemiyor - fonksiyon mevcut değil veya sistem kapalı\n",
FILE_APPEND);
}

// Çalışana WhatsApp mesajı (eğer provider sms aktifse)
if ($settings['providerSmsSystem'] == '1' && $settings['whatsappSystem'] == '1' &&
function_exists('sendWhatsAppMessage')) {
// Çalışana da bildirim gönderilip gönderilmediğini kontrol et
try {
// Önce tablonun var olduğundan emin olalım
$table_check = $DB->query("SHOW TABLES LIKE 'notification_log'");
if ($table_check->rowCount() == 0) {
// Tablo yoksa bildirim gönderilmemiş kabul edelim
$calisan_notification_count = 0;
file_put_contents($debug_log_file, "notification_log tablosu yok, çalışana bildirim gönderilecek\n", FILE_APPEND);
} else {
// Tablo var, son 30 saniyede gönderilen bildirimleri kontrol et
$check_query = $DB->prepare("SELECT COUNT(*) FROM notification_log WHERE
appointment_id = ? AND notification_type = ? AND phone LIKE ?");
$check_query->execute(array($eklenenRandevu, 'calisan_bildirim', '%' . $calisanNumber . '%'));
$calisan_notification_count = $check_query->fetchColumn();
}

if ($calisan_notification_count > 0) {
file_put_contents($debug_log_file, "Çalışana son 30 saniyede zaten bildirim gönderilmiş, tekrar gönderilmeyecek\n",
FILE_APPEND);
} else {
// Çalışan için değişkenleri hazırla (gerekliyse)
file_put_contents($debug_log_file, "Çalışana WhatsApp gönderiliyor: " . $calisanNumber . "\n", FILE_APPEND);
// Çalışan için değişkenler oluştur
$calisanVars = array(
'siteAdi' => $siteAdi,
'uyeAdi' => $musteriAdiNe,
'tarih' => $tarihNe,
'saat' => $saatNe,
'hizmet' => $hizmetNe,
'calisan' => $calisanAdiNe,
'siteadres' => $siteadresi,
'randevuID' => $eklenenRandevu
);
// Çalışan için farklı bildirim tipi kullan ki karışmasın
$wa_result = sendWhatsAppMessage($calisanNumber, "", "calisan_bildirim", $calisanVars);
file_put_contents($debug_log_file, "Çalışana WhatsApp sonucu: " . ($wa_result ? "Başarılı" : "Başarısız") . "\n",
FILE_APPEND);
}
} catch (Exception $e) {
file_put_contents($debug_log_file, "Çalışan bildirimi kontrolünde hata: " . $e->getMessage() . "\n", FILE_APPEND);
}
}
}
} else {
if ($settings['whatsappSystem'] != '1') {
file_put_contents($debug_log_file, "WhatsApp sistemi aktif değil\n", FILE_APPEND);
}
if (!function_exists('sendWhatsAppMessage')) {
file_put_contents($debug_log_file, "sendWhatsAppMessage fonksiyonu tanımlı değil\n", FILE_APPEND);
}
}



// Fonksiyon kontrol - WhatsApp sistem ayarına bağlı olmadan çalışsın

// WhatsApp log dosyasının tanımlı olduğundan emin olalım
if (!isset($whatsapp_log_file)) {
$whatsapp_log_file = $_SERVER['DOCUMENT_ROOT'] . '/whatsapp_debug.txt';
}

// Telefon numarası tanımlı mı kontrolü
if (isset($phone) && !empty($phone)) {
file_put_contents($whatsapp_log_file, "Temizlenmiş telefon: " . $phone . " (Uzunluk: " . strlen($phone) . ")\n",
FILE_APPEND);
} else {
// Log dosyasına bilgi yaz ama hatayı engelle
file_put_contents($whatsapp_log_file, "UYARI: Telefon değişkeni tanımlı değil veya boş\n", FILE_APPEND);
// Kodu kırmayı önlemek için phone değişkenini boş string olarak tanımla
$phone = "";
}

// Numaranın ilk karakteri 0 ise kaldır
if (strlen($phone) > 0 && substr($phone, 0, 1) == '0') {
$phone = substr($phone, 1);
if (isset($whatsapp_log_file)) {
file_put_contents($whatsapp_log_file, "0 kaldırıldı: " . $phone . "\n", FILE_APPEND);
}
}

// Farklı numara formatlarını ele al - güvenli şekilde
if (!empty($phone) && strlen($phone) == 10) {
// 10 haneli Türkiye numarası (5xx xxx xxxx)
$phone = '90' . $phone;
if (isset($whatsapp_log_file)) {
file_put_contents($whatsapp_log_file, "10 haneli numara: 90 eklendi -> " . $phone . "\n", FILE_APPEND);
}
}
else if (!empty($phone) && strlen($phone) == 11 && substr($phone, 0, 1) == '5') {
// 11 haneli ve 5 ile başlayan numara (5xx xxx xxxx)
$phone = '90' . $phone;
if (isset($whatsapp_log_file)) {
file_put_contents($whatsapp_log_file, "11 haneli 5 ile başlayan numara: 90 eklendi -> " . $phone . "\n", FILE_APPEND);
}
}
else if (!empty($phone) && strlen($phone) == 12 && substr($phone, 0, 2) == '90') {
// Zaten tam formatta, dokunma (90xxx)
if (isset($whatsapp_log_file)) {
file_put_contents($whatsapp_log_file, "12 haneli 90 ile başlayan numara: format korundu -> " . $phone . "\n",
FILE_APPEND);
}
}
else if (!empty($phone)) {
// Diğer durumlar için bir kontrol daha ekle
if (strlen($phone) <= 15 && strlen($phone)>= 10) {
  // Numara zaten uluslararası formatta olabilir, sadece logla
  if (isset($whatsapp_log_file)) {
  file_put_contents($whatsapp_log_file, "Özel format: mevcut numara korundu -> " . $phone . "\n", FILE_APPEND);
  }
  } else {
  // Numara beklenmeyen uzunlukta, hata logla
  if (isset($whatsapp_log_file)) {
  file_put_contents($whatsapp_log_file, "UYARI: Beklenmeyen numara uzunluğu (" . strlen($phone) . "): " . $phone . "\n",
  FILE_APPEND);
  }
  }
  } else {
  // Telefon değişkeni boş
  if (isset($whatsapp_log_file)) {
  file_put_contents($whatsapp_log_file, "UYARI: Telefon değişkeni boş, işlem atlanıyor\n", FILE_APPEND);
  }
  }


  // Debug log için telefon formatını kaydet
  if (isset($whatsapp_log_file) && isset($phone)) {
  $_phone = isset($_phone) ? $_phone : "tanımsız";
  file_put_contents($whatsapp_log_file, "TELEFON FORMATLAMA: Orijinal " . $_phone . " -> Formatlanmış " . $phone . "\n",
  FILE_APPEND);
  }

  // $message değişkeni tanımlı değilse boş string ataması yap
  if (!isset($message)) {
  $message = "";
  }

  $body = array(
  "api_key" => $settings['whatsappApiKey'],
  "receiver" => $phone,
  "data" => array("message" => $message)
  );

  if (isset($whatsapp_log_file)) {
  file_put_contents($whatsapp_log_file, "API isteği gönderiliyor - API Key: " . $settings['whatsappApiKey'] . "\n",
  FILE_APPEND);
  file_put_contents($whatsapp_log_file, "Alıcı: " . $phone . "\n", FILE_APPEND);

  // $message değişkeni tanımlı değilse boş string olarak göster
  $messageContent = isset($message) ? $message : "(boş mesaj)";
  file_put_contents($whatsapp_log_file, "Mesaj: " . $messageContent . "\n", FILE_APPEND);
  }

  try {
  $curl = curl_init();
  curl_setopt_array($curl, [
  CURLOPT_URL => "https://api.wpapi.com.tr/api/send-message",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => json_encode($body),
  CURLOPT_HTTPHEADER => [
  "Accept: */*",
  "Content-Type: application/json",
  ],
  ]);

  file_put_contents($whatsapp_log_file, "CURL isteği hazırlandı\n", FILE_APPEND);
  file_put_contents($whatsapp_log_file, "POST verisi: " . json_encode($body) . "\n", FILE_APPEND);

  $response = curl_exec($curl);
  $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
  $err = curl_error($curl);

  file_put_contents($whatsapp_log_file, "HTTP kodu: " . $httpCode . "\n", FILE_APPEND);
  file_put_contents($whatsapp_log_file, "API Yanıtı: " . $response . "\n", FILE_APPEND);

  if ($err) {
  file_put_contents($whatsapp_log_file, "Curl Hatası: " . $err . "\n", FILE_APPEND);
  }

  curl_close($curl);

  if ($err) {
  file_put_contents($whatsapp_log_file, "Hata nedeniyle işlem başarısız\n", FILE_APPEND);
  error_log("WhatsApp API Error: " . $err);
  return false;
  }

  // API yanıtını JSON olarak çözümle
  $responseData = json_decode($response, true);
  if (isset($responseData['status']) && $responseData['status'] === true) {
  $whatsappBildirimGonderildi = true;
  file_put_contents($whatsapp_log_file, "WhatsApp mesajı başarıyla gönderildi!\n", FILE_APPEND);
  return true;
  } else {
  $errorMessage = isset($responseData['message']) ? $responseData['message'] : 'Bilinmeyen hata';
  file_put_contents($whatsapp_log_file, "WhatsApp API hatası: " . $errorMessage . "\n", FILE_APPEND);
  return false;
  }
  } catch (Exception $e) {
  file_put_contents($whatsapp_log_file, "İstisna hatası: " . $e->getMessage() . "\n", FILE_APPEND);
  return false;
  }


  // Randevu ekleme kısmında WhatsApp bildirimi gönderme
  if (isset($_POST['randevuEkle'])) {
  try {
  file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Randevu ekleme başladı\n", FILE_APPEND);

  // ... mevcut randevu ekleme kodu ...


  } catch (Exception $e) {
  file_put_contents($debug_log_file, "Hata: " . $e->getMessage() . "\n", FILE_APPEND);
  echo "Hata oluştu: " . $e->getMessage();
  }
  } // randevuEkle if bloğunun sonu









  if (isset($_POST['randevuSil'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $randevuID = htmlspecialchars(trim($_POST['randevuID']));



  //Google Takvim Entegrasyonu Randevu Silme

  if ($settings['GoogleCalendarStatus'] == '1') {

  $appointmentCheck = $DB->prepare("SELECT * from appointments where id=?");

  $appointmentCheck->execute(array($randevuID));

  $appointment = $appointmentCheck->fetch(PDO::FETCH_ASSOC);

  $provider = $appointment['providerID'];

  $eventId = $appointment['calendarID'];

  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerKontrol->execute(array($provider));

  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  if ($providerKontrolDeger['GoogleCalendarStatus'] == '1') {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/googletakvim/vendor/autoload.php';





  $client = new Google_Client();

  $client->setClientId($settings['GoogleCalendarClientId']);

  $client->setClientSecret($settings['GoogleCalendarClientSecret']);

  $client->setRedirectUri('https://' . $_SERVER['SERVER_NAME'] . '/admin/GoogleConnect');

  $client->setAccessType('offline');

  $client->setApprovalPrompt('force');

  $client->addScope(Google_Service_Calendar::CALENDAR);

  $token = $providerKontrolDeger['GoogleCalendarToken'];

  $getRefreshToken = $providerKontrolDeger['GoogleCalendarRefresh'];

  $client->setAccessToken($token);



  if ($client->isAccessTokenExpired() && $getRefreshToken) {

  $client->fetchAccessTokenWithRefreshToken($getRefreshToken);

  $newToken = $client->getAccessToken();

  $guncelle = $DB->prepare("UPDATE provider set GoogleCalendarToken=? WHERE id=?");

  $guncelle->execute(array(json_encode($newToken), $provider));

  }



  $service = new Google_Service_Calendar($client);

  $service->events->delete('primary', $eventId);



  }

  }



  $sil = $DB->prepare("delete from appointments where id=?");

  $sil->execute(array($randevuID));

  $silredirect = $DB->prepare("DELETE from redirect where appointment=?");

  $silredirect->execute(array($randevuID));



  }

  if (isset($_POST['rDuzenle'])) {
  // Randevu URL parametresi
  $rid = htmlspecialchars(trim($_POST['randevuR']));

  if (empty($rid)) {
  echo "Geçersiz randevu kodu!";
  exit;
  }

  $redirectCheck = $DB->prepare("SELECT * from redirect where url=? ORDER BY id DESC");
  $redirectCheck->execute(array($rid));

  if ($redirectCheck->rowCount() === 0) {
  echo "Randevu bulunamadı!";
  exit;
  }

  $redirect = $redirectCheck->fetch(PDO::FETCH_ASSOC);

  if (!isset($redirect['appointment']) || empty($redirect['appointment'])) {
  echo "Randevu bilgisi bulunamadı!";
  exit;
  }

  $appointmentID = $redirect['appointment'];

  $appointmentCheck = $DB->prepare("SELECT * from appointments where id=?");
  $appointmentCheck->execute(array($appointmentID));

  if ($appointmentCheck->rowCount() === 0) {
  echo "Randevu kaydı bulunamadı!";
  exit;
  }

  $appointment = $appointmentCheck->fetch(PDO::FETCH_ASSOC);

  $service = $appointment['service'];

  $providerID = $appointment['providerID'];

  $member = $appointment['member'];

  $note = $appointment['note'];



  $randevuTarih = htmlspecialchars(trim($_POST['start-date']));

  // Öncelikle özel gün saati için hidden input'u kontrol et (yeni eklenen alan)
  if (isset($_POST['selectedTime']) && !empty($_POST['selectedTime'])) {
  $saat = htmlspecialchars(trim($_POST['selectedTime']));
  } else {
  $saat = htmlspecialchars(trim($_POST['customOptionsCheckableRadiosWithIcon']));
  }



  $randevuKontrol = $DB->prepare("SELECT * FROM appointments WHERE providerID=? AND appDate=? AND startTime=? AND
  note=?");

  $randevuKontrol->execute(array($providerID, $randevuTarih, $saat, $note));

  //KONTROL

  if ($randevuKontrol->rowCount()) {

  echo "varvar";

  } else {

  $serviceKontrol = $DB->prepare("SELECT * FROM services WHERE id=?");

  $serviceKontrol->execute(array($service));

  $serviceKontrolDeger = $serviceKontrol->fetch(PDO::FETCH_ASSOC);

  $serviceSaat = $serviceKontrolDeger['hour'];

  // Saat formatını kontrol et ve düzgün bir DateTime nesnesi oluştur
  if (preg_match('/^\d{1,2}:\d{2}(:\d{2})?$/', $saat)) {
  // Saat formatı doğru, şimdi saniye olup olmadığını kontrol et
  if (substr_count($saat, ':') === 1) {
  // Sadece saat:dakika formatı, saniye ekle
  $saat = $saat . ':00';
  }
  } else {
  // Geçersiz saat formatı, günlük kaydet ve varsayılan değeri kullan
  error_log("Geçersiz saat formatı alındı: " . $saat);
  // Varsayılan olarak HH:MM:SS formatına çevir
  $saat = date("H:i:s");
  }

  // Güncellenmiş saat formatıyla DateTime nesnesi oluştur
  $endTime = new DateTime($saat);
  $endTime->modify('+' . $serviceSaat . ' minute');
  $endTimeDeger = $endTime->format('H:i:s');



  $guncelle = $DB->prepare("UPDATE appointments SET appDate=?, startTime=?, endTime=? where id=?");

  $guncelle->execute(array($randevuTarih, $saat, $endTimeDeger, $appointmentID));

  // SMS gönderme
  if ($settings['smsSystem'] == '1') { // SMS bildirim aktifse
  $notification_settings = $DB->query("select * from notification_settings where id=4")->fetch(PDO::FETCH_ASSOC);

  if ($notification_settings['status'] == '1') { // Bildirim şablonu aktifse
  $smsSettings = $DB->prepare("select * from sms_settings where id=?");
  $smsSettings->execute(array('1'));
  $sms = $smsSettings->fetch(PDO::FETCH_ASSOC);

  $username = $sms['username'];
  $password = $sms['password'];
  $title = $sms['title'];

  // Müşteri bilgilerini al
  $uyeKontrol = $DB->prepare("SELECT * FROM members WHERE id=?");
  $uyeKontrol->execute(array($member));
  $uyeKontrolDeger = $uyeKontrol->fetch(PDO::FETCH_ASSOC);
  $number = $uyeKontrolDeger['phone'];

  $siteadresi = "https://" . $_SERVER['SERVER_NAME'];
  $siteAdi = $settings['siteName'];
  $musteriAdiNe = $uyeKontrolDeger['name'];

  // Şablonu al
  $sablon = $DB->prepare("select * from notification_settings where id=?");
  $sablon->execute(array('4')); // Güncelleme şablonu (id=4)
  $sablonCek = $sablon->fetch(PDO::FETCH_ASSOC);
  $messageSablon = $sablonCek['template'];

  // Formatları ayarla
  setlocale(LC_TIME, 'turkish');
  $tarihFormat = iconv('latin5', 'utf-8', strftime(' %d %B %Y %A ', strtotime($randevuTarih)));
  $aylar = array(
  'January' => 'Ocak', 'February' => 'Şubat', 'March' => 'Mart', 'April' => 'Nisan',
  'May' => 'Mayıs', 'June' => 'Haziran', 'July' => 'Temmuz', 'August' => 'Ağustos',
  'September' => 'Eylül', 'October' => 'Ekim', 'November' => 'Kasım', 'December' => 'Aralık'
  );
  $gunler = array(
  'Monday' => 'Pazartesi', 'Tuesday' => 'Salı', 'Wednesday' => 'Çarşamba', 'Thursday' => 'Perşembe',
  'Friday' => 'Cuma', 'Saturday' => 'Cumartesi', 'Sunday' => 'Pazar'
  );
  $tarihFormat = str_replace(array_keys($aylar), array_values($aylar), $tarihFormat);
  $tarihFormat = str_replace(array_keys($gunler), array_values($gunler), $tarihFormat);

  // Saat formatını düzenle
  $saatObj = new DateTime($saat);
  $saatFormat = $saatObj->format("H:i");

  // Servis bilgilerini al
  $serviceKontrol = $DB->prepare("SELECT * FROM services WHERE id=?");
  $serviceKontrol->execute(array($service));
  $serviceKontrolDeger = $serviceKontrol->fetch(PDO::FETCH_ASSOC);
  $hizmetAdi = $serviceKontrolDeger['serviceName'];

  // Personel bilgilerini al
  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");
  $providerKontrol->execute(array($providerID));
  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);
  $calisanAdi = $providerKontrolDeger['name'];

  // Değişkenleri şablonda değiştir
  $messageSablon = str_replace('{siteAdi}', $siteAdi, $messageSablon);
  $messageSablon = str_replace('{uyeAdi}', $musteriAdiNe, $messageSablon);
  $messageSablon = str_replace('{tarih}', $tarihFormat, $messageSablon);
  $messageSablon = str_replace('{saat}', $saatFormat, $messageSablon);
  $messageSablon = str_replace('{hizmet}', $hizmetAdi, $messageSablon);
  $messageSablon = str_replace('{calisan}', $calisanAdi, $messageSablon);
  $messageSablon = str_replace('{siteadres}', $siteadresi, $messageSablon);

  // Güncelleme şablonu için özel değişkenler
  $messageSablon = str_replace('{yenitarih}', $tarihFormat, $messageSablon);
  $messageSablon = str_replace('{yenisaat}', $saatFormat, $messageSablon);

  // İptal/düzenleme linkleri ekle
  $redirect_query = $DB->prepare("SELECT url FROM redirect WHERE appointment = ?");
  $redirect_query->execute(array($appointmentID));
  if ($redirect_query->rowCount() > 0) {
  $url = $redirect_query->fetchColumn();
  if ($settings['cancelSystem'] == '1') {
  $redirect = "https://" . $_SERVER['SERVER_NAME'] . "/r/" . $url;
  $cancelMessageText = " " . $settings['cancelMessage'] . $redirect;
  $messageSablon .= $cancelMessageText;
  }
  }

  $message = $messageSablon;

  // XML formatında mesaj hazırla
  $source = '<mesaj>
    <metin>' . $message . '</metin>
    <nums>' . $number . '</nums>
  </mesaj>';

  $xml_data = '
  <?xml version="1.0"?>
  <SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <SOAP-ENV:Body>
      <ns3:smsGonderNNV2 xmlns:ns3="http://sms/">
        <username>' . $username . '</username>
        <password>' . $password . '</password>
        <header>' . $title . '</header>
        <msg>' . $message . '</msg>
        <gsm>' . $number . '</gsm>
        <filter>0</filter>
        <encoding>TR</encoding>
      </ns3:smsGonderNNV2>
    </SOAP-ENV:Body>
  </SOAP-ENV:Envelope>';

  // SMS'i gönder
  $curl = curl_init();
  curl_setopt_array($curl, array(
  CURLOPT_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl/',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => "$xml_data",
  CURLOPT_HTTPHEADER => array(
  'Content-Type: text/xml'
  ),
  ));
  $response = curl_exec($curl);
  curl_close($curl);

  // SMS kaydını tut
  $time = date('Y-m-d H:i:s');
  $ekle = $DB->prepare("INSERT into sms_history set member=?, number=?, message=?, time=?, appointment_id=?,
  remember_time=?");
  $ekle->execute(array($member, $number, $message, $time, $appointmentID, '0'));

  // Log ekleme
  error_log(date('Y-m-d H:i:s') . " - Randevu güncellemesi SMS bildirimi gönderildi. Telefon: " . $number);
  }
  }

  // WhatsApp mesajı gönderme

  // WhatsApp bildirimi

  // WhatsApp mesajını gönder
  if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/whatsapp_functions.php')) {
  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/whatsapp_functions.php';

  if (function_exists('sendWhatsAppMessage')) {
  // Müşteri bilgilerini al
  $uyeKontrol = $DB->prepare("SELECT * FROM members WHERE id=?");
  $uyeKontrol->execute(array($member));
  $uyeKontrolDeger = $uyeKontrol->fetch(PDO::FETCH_ASSOC);

  // Servis bilgilerini al
  $serviceKontrol = $DB->prepare("SELECT * FROM services WHERE id=?");
  $serviceKontrol->execute(array($service));
  $serviceKontrolDeger = $serviceKontrol->fetch(PDO::FETCH_ASSOC);

  // Personel bilgilerini al
  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");
  $providerKontrol->execute(array($providerID));
  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  // Tarih formatını düzenle
  setlocale(LC_TIME, 'turkish');
  $tarihFormat = iconv('latin5', 'utf-8', strftime(' %d %B %Y %A ', strtotime($randevuTarih)));
  $aylar = array(
  'January' => 'Ocak', 'February' => 'Şubat', 'March' => 'Mart', 'April' => 'Nisan',
  'May' => 'Mayıs', 'June' => 'Haziran', 'July' => 'Temmuz', 'August' => 'Ağustos',
  'September' => 'Eylül', 'October' => 'Ekim', 'November' => 'Kasım', 'December' => 'Aralık'
  );
  $gunler = array(
  'Monday' => 'Pazartesi', 'Tuesday' => 'Salı', 'Wednesday' => 'Çarşamba', 'Thursday' => 'Perşembe',
  'Friday' => 'Cuma', 'Saturday' => 'Cumartesi', 'Sunday' => 'Pazar'
  );
  $tarihFormat = str_replace(array_keys($aylar), array_values($aylar), $tarihFormat);
  $tarihFormat = str_replace(array_keys($gunler), array_values($gunler), $tarihFormat);

  // Saat formatını düzenle
  $saatObj = new DateTime($saat);
  $saatFormat = $saatObj->format("H:i");

  // WhatsApp için değişkenleri hazırla
  $messageVars = array(
  'siteAdi' => $settings['siteName'],
  'uyeAdi' => $uyeKontrolDeger['name'],
  'tarih' => $tarihFormat,
  'saat' => $saatFormat,
  'yenitarih' => $tarihFormat,
  'yenisaat' => $saatFormat,
  'hizmet' => $serviceKontrolDeger['serviceName'],
  'calisan' => $providerKontrolDeger['name'],
  'siteadres' => "https://" . $_SERVER['SERVER_NAME']
  );

  // WhatsApp mesajını gönder
  $number = $uyeKontrolDeger['phone'];
  // randevuID ekle
  if (!isset($messageVars['randevuID']) && isset($id)) {
  $messageVars['randevuID'] = $id;
  }
  sendWhatsAppMessage($number, "", "guncelleme", $messageVars);
  }
  }





  $uyeKontrol = $DB->prepare("SELECT * FROM members WHERE id=?");

  $uyeKontrol->execute(array($member));

  $uyeKontrolDeger = $uyeKontrol->fetch(PDO::FETCH_ASSOC);





  //Google Takvim Entegrasyonu Randevu Güncelleme

  if ($settings['GoogleCalendarStatus'] == '1') {

  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerKontrol->execute(array($providerID));

  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  if ($providerKontrolDeger['GoogleCalendarStatus'] == '1') {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/googletakvim/vendor/autoload.php';

  $title = $serviceKontrolDeger['serviceName'] . " Randevusu";

  if (!empty($note)) {

  $noteG = "<br>Müşteri Notu: " . $note;

  } else {

  $noteG = "";

  }

  $desc = "Müşteri Ad Soyad: " . $uyeKontrolDeger['name'] . "<br>Telefon: " . $uyeKontrolDeger['phone'] . $noteG;

  $start = $randevuTarih . 'T' . $saat;

  $end = $randevuTarih . 'T' . $endTimeDeger;

  $eventId = $appointment['calendarID'];



  $client = new Google_Client();

  $client->setClientId($settings['GoogleCalendarClientId']);

  $client->setClientSecret($settings['GoogleCalendarClientSecret']);

  $client->setRedirectUri('https://' . $_SERVER['SERVER_NAME'] . '/admin/GoogleConnect');

  $client->setAccessType('offline');

  $client->setApprovalPrompt('force');

  $client->addScope(Google_Service_Calendar::CALENDAR);

  $token = $providerKontrolDeger['GoogleCalendarToken'];

  $getRefreshToken = $providerKontrolDeger['GoogleCalendarRefresh'];

  $client->setAccessToken($token);



  if ($client->isAccessTokenExpired() && $getRefreshToken) {

  $client->fetchAccessTokenWithRefreshToken($getRefreshToken);

  $newToken = $client->getAccessToken();

  $guncelle = $DB->prepare("UPDATE provider set GoogleCalendarToken=? WHERE id=?");

  $guncelle->execute(array(json_encode($newToken), $providerID));

  }



  $service = new Google_Service_Calendar($client);

  $event = $service->events->get('primary', $eventId);





  $event->setSummary($title);

  $event->setDescription($desc);



  $newStartDateTime = new Google\Service\Calendar\EventDateTime();

  $newStartDateTime->setDateTime($start);

  $newStartDateTime->setTimeZone('Europe/Istanbul');



  $newEndDateTime = new Google\Service\Calendar\EventDateTime();

  $newEndDateTime->setDateTime($end);

  $newEndDateTime->setTimeZone('Europe/Istanbul');



  $event->setStart($newStartDateTime);

  $event->setEnd($newEndDateTime);



  $updatedEvent = $service->events->update('primary', $eventId, $event);

  }

  }





  //netgsm Sms Entegrasyonu

  if ($settings['smsSystem'] == '1') { //sms bildirim

  $notification_settings = $DB->query("select * from notification_settings where id=4")->fetch(PDO::FETCH_ASSOC);

  if ($notification_settings['status'] == '1') {

  $smsSettings = $DB->prepare("select * from sms_settings where id=?");

  $smsSettings->execute(array('1'));

  $sms = $smsSettings->fetch(PDO::FETCH_ASSOC);

  $username = $sms['username'];

  $password = $sms['password'];

  $title = $sms['title'];

  $number = $uyeKontrolDeger['phone'];

  $siteadresi = "https://" . $_SERVER['SERVER_NAME'];

  $siteAdi = $settings['siteName'];

  $musteriAdiNe = $uyeKontrolDeger['name'];



  $sablon = $DB->prepare("select * from notification_settings where id=?");

  $sablon->execute(array('4'));

  $sablonCek = $sablon->fetch(PDO::FETCH_ASSOC);

  $messageSablon = $sablonCek['template'];

  $tarihNe = $randevuTarih;

  $saatNe = $saat;

  $hizmetNe = $serviceKontrolDeger['serviceName'];

  setlocale(LC_TIME, 'turkish');

  $tarihNe = iconv('latin5', 'utf-8', strftime(' %d %B %Y %A ', strtotime($tarihNe)));

  $aylar = array(

  'January' => 'Ocak',

  'February' => 'Şubat',

  'March' => 'Mart',

  'April' => 'Nisan',

  'May' => 'Mayıs',

  'June' => 'Haziran',

  'July' => 'Temmuz',

  'August' => 'Ağustos',

  'September' => 'Eylül',

  'October' => 'Ekim',

  'November' => 'Kasım',

  'December' => 'Aralık'

  );



  $gunler = array(

  'Monday' => 'Pazartesi',

  'Tuesday' => 'Salı',

  'Wednesday' => 'Çarşamba',

  'Thursday' => 'Perşembe',

  'Friday' => 'Cuma',

  'Saturday' => 'Cumartesi',

  'Sunday' => 'Pazar'

  );

  $tarihNe = str_replace(array_keys($aylar), array_values($aylar), $tarihNe);

  $tarihNe = str_replace(array_keys($gunler), array_values($gunler), $tarihNe);

  $saatNe = new DateTime($saatNe);

  $saatNe = $saatNe->format("H:i");



  $yenitarih = $tarihNe;

  $yenisaat = $saatNe;



  $messageSablon = str_replace('{siteAdi}', $siteAdi, $messageSablon);

  $messageSablon = str_replace('{uyeAdi}', $musteriAdiNe, $messageSablon);

  $messageSablon = str_replace('{hizmet}', $hizmetNe, $messageSablon);

  $messageSablon = str_replace('{yenitarih}', $yenitarih, $messageSablon);

  $messageSablon = str_replace('{yenisaat}', $yenisaat, $messageSablon);



  $cancelSystem = $settings['cancelSystem'];

  $cancelMessage = $settings['cancelMessage'];

  if ($cancelSystem == '1') {

  $redirect = "https://" . $_SERVER['SERVER_NAME'] . "/r/" . $rid;

  $cancelMessageText = " " . $cancelMessage . $redirect;

  $message = $messageSablon . $cancelMessageText;

  } else {

  $message = $messageSablon;

  }



  if (!isset($source)) $source = ''; $source .= '<mesaj>

    <metin>' . $message . '</metin>

    <nums>' . $number . '</nums>

  </mesaj>';

  $xml_data = '
  <?xml version="1.0"?>

  <SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <SOAP-ENV:Body>

      <ns3:smsGonderNNV2 xmlns:ns3="http://sms/">

        <username>' . $username . '</username>

        <password>' . $password . '</password>

        <header>' . $title . '</header>

        <msg>' . $message . '</msg>

        <gsm>' . $number . '</gsm>

        <filter>0</filter>

        <encoding>TR</encoding>

      </ns3:smsGonderNNV2>

    </SOAP-ENV:Body>

  </SOAP-ENV:Envelope>';



  $curl = curl_init();

  curl_setopt_array($curl, array(

  CURLOPT_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl/',

  CURLOPT_RETURNTRANSFER => true,

  CURLOPT_ENCODING => '',

  CURLOPT_MAXREDIRS => 10,

  CURLOPT_TIMEOUT => 0,

  CURLOPT_FOLLOWLOCATION => true,

  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,

  CURLOPT_CUSTOMREQUEST => 'POST',

  CURLOPT_POSTFIELDS => "$xml_data",

  CURLOPT_HTTPHEADER => array(

  'Content-Type: text/xml'

  ),

  ));

  $response = curl_exec($curl);

  curl_close($curl);

  $time = date('Y-m-d H:i:s');

  $ekle = $DB->prepare("INSERT into sms_history set member=?, number=?, message=?, time=?, appointment_id=?,
  remember_time=?");

  $ekle->execute(array($member, $number, $message, $time, $appointmentID, '0'));



  }

  }



  }

  }

  if (isset($_POST['rIptal'])) {
  $rid = htmlspecialchars(trim($_POST['randevuR']));

  if (empty($rid)) {
  echo "Geçersiz randevu kodu!";
  exit;
  }

  $redirectCheck = $DB->prepare("SELECT * from redirect where url=? ORDER BY id DESC");
  $redirectCheck->execute(array($rid));

  if ($redirectCheck->rowCount() === 0) {
  echo "Randevu bulunamadı!";
  exit;
  }

  $redirect = $redirectCheck->fetch(PDO::FETCH_ASSOC);

  if (!isset($redirect['appointment']) || empty($redirect['appointment'])) {
  echo "Randevu bilgisi bulunamadı!";
  exit;
  }

  $appointmentID = $redirect['appointment'];

  $appointmentCheck = $DB->prepare("SELECT * from appointments where id=?");
  $appointmentCheck->execute(array($appointmentID));

  if ($appointmentCheck->rowCount() === 0) {
  echo "Randevu kaydı bulunamadı!";
  exit;
  }

  $appointment = $appointmentCheck->fetch(PDO::FETCH_ASSOC);

  $service = $appointment['service'];

  $providerID = $appointment['providerID'];

  $appDate = $appointment['appDate'];

  $startTime = $appointment['startTime'];

  $endTime = $appointment['endTime'];

  $member = $appointment['member'];



  $ekle = $DB->prepare("INSERT into canceled set service=?, providerID=?, appDate=?, startTime=?, endTime=?,
  member=?");

  $ekle->execute(array($service, $providerID, $appDate, $startTime, $endTime, $member));



  $randevuKontrol = $DB->prepare("SELECT * FROM appointments WHERE id=?");

  $randevuKontrol->execute(array($appointmentID));

  $randevuKontrolDeger = $randevuKontrol->fetch(PDO::FETCH_ASSOC);

  $hangiuye = $randevuKontrolDeger['member'];



  $uyeKontrol = $DB->prepare("SELECT * FROM members WHERE id=?");

  $uyeKontrol->execute(array($hangiuye));

  $uyeKontrolDeger = $uyeKontrol->fetch(PDO::FETCH_ASSOC);

  // WhatsApp bildirim gönderimi eklendi
  if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/whatsapp_functions.php')) {
  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/whatsapp_functions.php';

  if (function_exists('sendWhatsAppMessage')) {
  // Servis bilgilerini al
  $serviceKontrol = $DB->prepare("SELECT * FROM services WHERE id=?");
  $serviceKontrol->execute(array($service));
  $serviceKontrolDeger = $serviceKontrol->fetch(PDO::FETCH_ASSOC);

  // Personel bilgilerini al
  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");
  $providerKontrol->execute(array($providerID));
  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  // Tarih formatını düzenle
  setlocale(LC_TIME, 'turkish');
  $tarihFormat = iconv('latin5', 'utf-8', strftime(' %d %B %Y %A ', strtotime($appDate)));
  $aylar = array(
  'January' => 'Ocak', 'February' => 'Şubat', 'March' => 'Mart', 'April' => 'Nisan',
  'May' => 'Mayıs', 'June' => 'Haziran', 'July' => 'Temmuz', 'August' => 'Ağustos',
  'September' => 'Eylül', 'October' => 'Ekim', 'November' => 'Kasım', 'December' => 'Aralık'
  );
  $gunler = array(
  'Monday' => 'Pazartesi', 'Tuesday' => 'Salı', 'Wednesday' => 'Çarşamba', 'Thursday' => 'Perşembe',
  'Friday' => 'Cuma', 'Saturday' => 'Cumartesi', 'Sunday' => 'Pazar'
  );
  $tarihFormat = str_replace(array_keys($aylar), array_values($aylar), $tarihFormat);
  $tarihFormat = str_replace(array_keys($gunler), array_values($gunler), $tarihFormat);

  // Saat formatını düzenle
  $saatObj = new DateTime($startTime);
  $saatFormat = $saatObj->format("H:i");

  // WhatsApp için değişkenleri hazırla
  $messageVars = array(
  'siteAdi' => $settings['siteName'],
  'uyeAdi' => $uyeKontrolDeger['name'],
  'tarih' => $tarihFormat,
  'saat' => $saatFormat,
  'hizmet' => $serviceKontrolDeger['serviceName'],
  'calisan' => $providerKontrolDeger['name'],
  'siteadres' => "https://" . $_SERVER['SERVER_NAME']
  );

  // WhatsApp mesajı gönder - iptal şablonu (id=7)
  $number = $uyeKontrolDeger['phone'];
  // randevuID ekle
  if (!isset($messageVars['randevuID']) && isset($id)) {
  $messageVars['randevuID'] = $id;
  }
  sendWhatsAppMessage($number, "", "iptal", $messageVars);

  // Log dosyasına kaydet
  $log_file = $_SERVER['DOCUMENT_ROOT'] . '/whatsapp_debug.txt';
  file_put_contents($log_file, date('Y-m-d H:i:s') . " - Randevu iptali WhatsApp bildirimi gönderildi. Telefon: " .
  $number . "\n", FILE_APPEND);
  }
  }

  if ($settings['smsSystem'] == '1') { //sms bildirim

  $notification_settings = $DB->query("select * from notification_settings where id=7")->fetch(PDO::FETCH_ASSOC);

  if ($notification_settings['status'] == '1') {

  $smsSettings = $DB->prepare("select * from sms_settings where id=?");

  $smsSettings->execute(array('1'));

  $sms = $smsSettings->fetch(PDO::FETCH_ASSOC);

  $username = $sms['username'];

  $password = $sms['password'];

  $title = $sms['title'];

  $number = $uyeKontrolDeger['phone'];

  $siteadresi = "https://" . $_SERVER['SERVER_NAME'];

  $siteAdi = $settings['siteName'];

  $musteriAdiNe = $uyeKontrolDeger['name'];



  $sablon = $DB->prepare("select * from notification_settings where id=?");

  $sablon->execute(array('7'));

  $sablonCek = $sablon->fetch(PDO::FETCH_ASSOC);

  $messageSablon = $sablonCek['template'];

  $tarihNe = $appDate;

  $saatNe = $startTime;

  $serviceKontrol = $DB->prepare("SELECT * FROM services WHERE id=?");

  $serviceKontrol->execute(array($service));

  $serviceKontrolDeger = $serviceKontrol->fetch(PDO::FETCH_ASSOC);

  $hizmetNe = $serviceKontrolDeger['serviceName'];

  setlocale(LC_TIME, 'turkish');

  $tarihNe = iconv('latin5', 'utf-8', strftime(' %d %B %Y %A ', strtotime($tarihNe)));



  $aylar = array(

  'January' => 'Ocak',

  'February' => 'Şubat',

  'March' => 'Mart',

  'April' => 'Nisan',

  'May' => 'Mayıs',

  'June' => 'Haziran',

  'July' => 'Temmuz',

  'August' => 'Ağustos',

  'September' => 'Eylül',

  'October' => 'Ekim',

  'November' => 'Kasım',

  'December' => 'Aralık'

  );



  $gunler = array(

  'Monday' => 'Pazartesi',

  'Tuesday' => 'Salı',

  'Wednesday' => 'Çarşamba',

  'Thursday' => 'Perşembe',

  'Friday' => 'Cuma',

  'Saturday' => 'Cumartesi',

  'Sunday' => 'Pazar'

  );

  $tarihNe = str_replace(array_keys($aylar), array_values($aylar), $tarihNe);

  $tarihNe = str_replace(array_keys($gunler), array_values($gunler), $tarihNe);





  $saatNe = new DateTime($saatNe);

  $saatNe = $saatNe->format("H:i");





  $messageSablon = str_replace('{siteAdi}', $siteAdi, $messageSablon);

  $messageSablon = str_replace('{uyeAdi}', $musteriAdiNe, $messageSablon);

  $messageSablon = str_replace('{saat}', $saatNe, $messageSablon);

  $messageSablon = str_replace('{siteadres}', $siteadresi, $messageSablon);



  $message = $messageSablon;

  if (!isset($source)) $source = ''; $source .= '<mesaj>
    <metin>' . $message . '</metin>
    <nums>' . $number . '</nums>
  </mesaj>';

  $xml_data = '
  <?xml version="1.0"?>

  <SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <SOAP-ENV:Body>

      <ns3:smsGonderNNV2 xmlns:ns3="http://sms/">

        <username>' . $username . '</username>

        <password>' . $password . '</password>

        <header>' . $title . '</header>

        <msg>' . $message . '</msg>

        <gsm>' . $number . '</gsm>

        <filter>0</filter>

        <encoding>TR</encoding>

      </ns3:smsGonderNNV2>

    </SOAP-ENV:Body>

  </SOAP-ENV:Envelope>';



  $curl = curl_init();

  curl_setopt_array($curl, array(

  CURLOPT_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl/',

  CURLOPT_RETURNTRANSFER => true,

  CURLOPT_ENCODING => '',

  CURLOPT_MAXREDIRS => 10,

  CURLOPT_TIMEOUT => 0,

  CURLOPT_FOLLOWLOCATION => true,

  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,

  CURLOPT_CUSTOMREQUEST => 'POST',

  CURLOPT_POSTFIELDS => "$xml_data",

  CURLOPT_HTTPHEADER => array(

  'Content-Type: text/xml'

  ),

  ));

  $response = curl_exec($curl);

  curl_close($curl);

  $time = date('Y-m-d H:i:s');

  $ekle = $DB->prepare("INSERT into sms_history set member=?, number=?, message=?, time=?, appointment_id=?,
  remember_time=?");

  $ekle->execute(array($hangiuye, $number, $message, $time, $appointmentID, '0'));

  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");
  $providerKontrol->execute(array($providerID));
  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  $calisanNumber = $providerKontrolDeger['smsNumber'];
  $calisanAdiNe = $providerKontrolDeger['name'];
  $calisanMessage = "Sayın " . $calisanAdiNe . ", " . $musteriAdiNe . " adlı müşteri tarafından" . $tarihNe . "saat "
  .
  $saatNe . " için alınan " . $hizmetNe . " randevusu iptal edilmiştir. İyi çalışmalar dileriz.";

  // Çalışana özel XML verisi
  $calisanXmlData = '
  <?xml version="1.0"?>
  <SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <SOAP-ENV:Body>
      <ns3:smsGonderNNV2 xmlns:ns3="http://sms/">
        <username>' . $username . '</username>
        <password>' . $password . '</password>
        <header>' . $title . '</header>
        <msg>' . $calisanMessage . '</msg>
        <gsm>' . $calisanNumber . '</gsm>
        <filter>0</filter>
        <encoding>TR</encoding>
      </ns3:smsGonderNNV2>
    </SOAP-ENV:Body>
  </SOAP-ENV:Envelope>';

  // Çalışana SMS gönderimi
  $calisanCurl = curl_init();
  curl_setopt_array($calisanCurl, array(
  CURLOPT_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl/',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => "$calisanXmlData",
  CURLOPT_HTTPHEADER => array(
  'Content-Type: text/xml'
  ),
  ));
  $calisanResponse = curl_exec($calisanCurl);
  curl_close($calisanCurl);

  }

  }





  // Eklemeden bağımsız olarak silme işlemini gerçekleştir
  // canceled tablosuna ekleme başarılı olmasa bile randevuyu iptal etmeliyiz
  $sil = $DB->prepare("DELETE from appointments where id=?");
  $silSonuc = $sil->execute(array($appointmentID));

  if ($silSonuc) {
  // Randevu silindi, şimdi redirect tablosundan URL'yi sil
  $silredirect = $DB->prepare("DELETE from redirect where url=?");
  $silredirect->execute(array($rid));

  // Redirect ID ile alternatif silme (garanti olması için)
  $silredirectByAppt = $DB->prepare("DELETE from redirect where appointment=?");
  $silredirectByAppt->execute(array($appointmentID));

  // İşlemi logla
  error_log(date('Y-m-d H:i:s') . " - Randevu başarıyla iptal edildi. ID: " . $appointmentID . ", URL: " . $rid);
  } else {
  // Silme başarısız oldu, logla
  error_log(date('Y-m-d H:i:s') . " - Randevu iptal hatası. ID: " . $appointmentID . ", URL: " . $rid);
  }

  }



  if (isset($_POST['randevuDuzenle'])) {

  // Verileri logla - analiz için
  error_log("RANDEVU DÜZENLEME - TÜM POST VERİLERİ: " . print_r($_POST, true));

  if ($_POST['randevuDuzenle'] == '1') {

  // Backend'de doğrudan saati doğrula
  if (isset($_POST['customOptionsCheckableRadiosWithIcon']) && !empty($_POST['customOptionsCheckableRadiosWithIcon']))
  {
  error_log("Saat verisi bulundu: " . $_POST['customOptionsCheckableRadiosWithIcon']);
  } else {
  error_log("KRITIK: customOptionsCheckableRadiosWithIcon verisi eksik! POST değerleri: " . print_r($_POST, true));
  }

  // Manuel eklenen saat değerini kontrol et (YENİ)
  if (isset($_POST['manualTimeValue']) && !empty($_POST['manualTimeValue'])) {
  error_log("Manuel saat verisi bulundu: " . $_POST['manualTimeValue']);
  }

  $service = isset($_POST['service']) ? htmlspecialchars(trim($_POST['service'])) : '';
  $provider = isset($_POST['provider']) ? htmlspecialchars(trim($_POST['provider'])) : '';
  $randevuTarih = isset($_POST['start-date']) ? htmlspecialchars(trim($_POST['start-date'])) : '';

  // Saat için birkaç alternatif kaynak kontrol et - en güvenilir kaynağı seç
  if (isset($_POST['manualTimeValue']) && !empty($_POST['manualTimeValue'])) {
  // Manuel eklenen değeri öncelikle kullan
  $saat = htmlspecialchars(trim($_POST['manualTimeValue']));
  error_log("manualTimeValue kullanılıyor: $saat");
  } else if (isset($_POST['customOptionsCheckableRadiosWithIcon']) &&
  !empty($_POST['customOptionsCheckableRadiosWithIcon'])) {
  // Form seçimini kullan
  $saat = htmlspecialchars(trim($_POST['customOptionsCheckableRadiosWithIcon']));
  error_log("customOptionsCheckableRadiosWithIcon kullanılıyor: $saat");
  } else {
  // Varsayılan değer
  $saat = "00:00:00";
  error_log("Hiç saat değeri bulunamadı, varsayılan değer atandı: $saat");
  }

  $serviceKontrol = $DB->prepare("SELECT * FROM services WHERE id=?");

  $serviceKontrol->execute(array($service));

  $serviceKontrolDeger = $serviceKontrol->fetch(PDO::FETCH_ASSOC);

  $serviceSaat = $serviceKontrolDeger['hour'];

  // Saat formatını kontrol et ve düzgün bir DateTime nesnesi oluştur
  if (preg_match('/^\d{1,2}:\d{2}(:\d{2})?$/', $saat)) {
  // Saat formatı doğru, şimdi saniye olup olmadığını kontrol et
  if (substr_count($saat, ':') === 1) {
  // Sadece saat:dakika formatı, saniye ekle
  $saat = $saat . ':00';
  }
  } else {
  // Geçersiz saat formatı, günlük kaydet ve varsayılan değeri kullan
  error_log("Geçersiz saat formatı alındı: " . $saat);
  // Varsayılan olarak HH:MM:SS formatına çevir
  $saat = date("H:i:s");
  }

  // Güncellenmiş saat formatıyla DateTime nesnesi oluştur
  $endTime = new DateTime($saat);
  $endTime->modify('+' . $serviceSaat . ' minute');
  $endTimeDeger = $endTime->format('H:i:s');



  $randevuID = htmlspecialchars(trim($_POST['edit']));



  $appPayment = $_POST['appPayment'];

  if ($appPayment == '0') {

  $paymentStatus = '0';

  $appPayment = "Nakit";

  } else {

  $paymentStatus = '1';



  if ($settings['caseSystem'] == '1') {

  $randevuKontrol = $DB->prepare("SELECT * FROM appointments WHERE id=?");

  $randevuKontrol->execute(array($randevuID));

  $randevuKontrolDeger = $randevuKontrol->fetch(PDO::FETCH_ASSOC);

  $hangiuye = $randevuKontrolDeger['member'];

  $uyeKontrol = $DB->prepare("SELECT * FROM members WHERE id=?");

  $uyeKontrol->execute(array($hangiuye));

  $uyeKontrolDeger = $uyeKontrol->fetch(PDO::FETCH_ASSOC);

  $serviceKontrol = $DB->prepare("SELECT * FROM services WHERE id=?");

  $serviceKontrol->execute(array($service));

  $serviceKontrolDeger = $serviceKontrol->fetch(PDO::FETCH_ASSOC);

  if ($randevuKontrolDeger['paymentStatus'] == '0') {

  $caseDate = $randevuTarih;

  $casePaymentMethod = $appPayment;

  $caseAmount = $serviceKontrolDeger['price'];

  $caseNote = $serviceKontrolDeger['serviceName'];

  $caseNote = $caseNote . " - Hizmet Ödemesi |";

  $caseNote = $caseNote . " " . $uyeKontrolDeger['name'];

  $caseType = '1';

  $ekle = $DB->prepare("INSERT into business_case set caseDate=?, casePaymentMethod=?, caseAmount=?, caseNote=?,
  member=?,
  caseType=?");

  $ekle->execute(array($caseDate, $casePaymentMethod, $caseAmount, $caseNote, $hangiuye, $caseType));

  }

  }



  }

  $coming = $_POST['appComing'];

  $note = isset($_POST['note']) ? htmlspecialchars(trim($_POST['note'])) : "";



  // Saat değerinin varlığını doğrula ve işle
  $debug_message = "RANDEVU DÜZENLEME DEBUG - ID: $randevuID\n";
  $debug_message .= "POST Verileri: " . print_r($_POST, true) . "\n";
  error_log($debug_message);

  // Saat alanını koruma ve düzgün formatlama
  if (empty($saat) || !isset($_POST['customOptionsCheckableRadiosWithIcon'])) {
  error_log("UYARI: Saat değeri problemi - POST value: " . (isset($_POST['customOptionsCheckableRadiosWithIcon']) ?
  $_POST['customOptionsCheckableRadiosWithIcon'] : 'YOK') . " - Parsed: $saat");

  // Formdan doğrudan saati alma girişimi
  if (isset($_POST['customOptionsCheckableRadiosWithIcon']) && $_POST['customOptionsCheckableRadiosWithIcon'] != '') {
  $saat = trim($_POST['customOptionsCheckableRadiosWithIcon']);
  error_log("Formdan saat değeri doğrudan alındı: $saat");
  } else {
  // Mevcut randevudan saati al
  $mevcutRandevu = $DB->prepare("SELECT startTime FROM appointments WHERE id=?");
  $mevcutRandevu->execute(array($randevuID));
  $mevcutVeri = $mevcutRandevu->fetch(PDO::FETCH_ASSOC);
  if ($mevcutVeri) {
  $saat = $mevcutVeri['startTime'];
  error_log("Mevcut randevudan saat alındı: $saat");
  } else {
  $saat = date("H:i:s");
  error_log("Varsayılan saat kullanılıyor: $saat");
  }
  }
  }

  // Saat formatını kontrol et ve düzelt
  error_log("Saat değeri format kontrolü öncesi: $saat");
  if (preg_match('/^\d{1,2}:\d{2}(:\d{2})?$/', $saat)) {
  // Doğru format, saniye kontrolü
  if (substr_count($saat, ':') === 1) {
  $saat = $saat . ':00';
  error_log("Saniye eklendi - Yeni değer: $saat");
  }
  } else {
  error_log("UYARI: Geçersiz saat formatı: $saat");
  // Acil düzeltme girişimi
  if (preg_match('/^(\d{1,2}):(\d{2})/', $saat, $matches)) {
  $saat = $matches[1] . ':' . $matches[2] . ':00';
  error_log("Saat düzeltildi: $saat");
  } else {
  // Son çare olarak varsayılan saat
  $saat = date("H:i:s");
  error_log("Saat varsayılana sıfırlandı: $saat");
  }
  }

  // Debug log ekle
  error_log("Randevu güncelleniyor - ID: $randevuID, Tarih: $randevuTarih, Saat: $saat, Bitiş: $endTimeDeger");

  // Veritabanında güncelleme öncesi onay mesajı
  echo '<script>
  console.log(
    "Randevu güncellenecek - Saat: ' . htmlspecialchars($saat) . ', Bitiş: ' . htmlspecialchars($endTimeDeger) . '")
  </script>';

  // EKLENEN BÖLÜM: Randevu kaydedilmeden önce bilgileri konsola yazdır
  error_log("SAVE DEBUG - Randevu ID: $randevuID, Service: $service, Provider: $provider, Date: $randevuTarih, Time:
  $saat");

  // Önce randevunun mevcut durumunu kontrol et
  $randevuKontrol = $DB->prepare("SELECT * FROM appointments WHERE id = ?");
  $randevuKontrol->execute(array($randevuID));
  $mevcutRandevu = $randevuKontrol->fetch(PDO::FETCH_ASSOC);

  if (!$mevcutRandevu) {
  error_log("HATA: Güncellenecek randevu bulunamadı! ID: $randevuID");
  echo "<script>
  alert('Güncellenecek randevu bulunamadı!');
  </script>";
  } else {
  // Mevcut değerleri logla
  error_log("Mevcut randevu bilgileri: " . print_r($mevcutRandevu, true));

  // Değişen alanları raporla
  $changes = array();
  if ($mevcutRandevu['service'] != $service) $changes[] = "service: " . $mevcutRandevu['service'] . " -> $service";
  if ($mevcutRandevu['providerID'] != $provider) $changes[] = "providerID: " . $mevcutRandevu['providerID'] . " ->
  $provider";
  if ($mevcutRandevu['appDate'] != $randevuTarih) $changes[] = "appDate: " . $mevcutRandevu['appDate'] . " ->
  $randevuTarih";
  if ($mevcutRandevu['startTime'] != $saat) $changes[] = "startTime: " . $mevcutRandevu['startTime'] . " -> $saat";
  if ($mevcutRandevu['endTime'] != $endTimeDeger) $changes[] = "endTime: " . $mevcutRandevu['endTime'] . " ->
  $endTimeDeger";

  if (!empty($changes)) {
  error_log("Değişiklikler tespit edildi: " . implode(", ", $changes));
  } else {
  error_log("Hiçbir değişiklik tespit edilmedi, mevcut değerler korunacak");
  }

  // ACİL DOĞRUDAN SORGU GÜNCELLEME - KRİTİK SORUN GİDERME
  try {
  error_log("RANDEVU GÜNCELLENİYOR - ID: $randevuID, Service: $service, Provider: $provider, Tarih: $randevuTarih,
  Saat: $saat, Bitiş: $endTimeDeger");

  // İLK YAKLAŞIM: PDO ile parametreli güncelleme
  $DB->beginTransaction(); // İşlem başlat

  // Saat ve bitiş saati alanlarını özellikle güncelleyelim
  $saatSQL = "UPDATE appointments SET startTime = :saat, endTime = :bitis WHERE id = :id";
  $saatStmt = $DB->prepare($saatSQL);
  $saatStmt->bindParam(':saat', $saat);
  $saatStmt->bindParam(':bitis', $endTimeDeger);
  $saatStmt->bindParam(':id', $randevuID);
  $saatSonuc = $saatStmt->execute();

  // Saat güncelleme başarı durum raporlama
  error_log("SAAT VE BİTİŞ GÜNCELLEMESİ: " . ($saatSonuc ? "BAŞARILI" : "BAŞARISIZ"));
  error_log("Etkilenen satır (saat güncellemesi): " . $saatStmt->rowCount());

  // Tüm randevu bilgileriyle tam güncelleme
  $guncelle = $DB->prepare("UPDATE appointments SET
  service = :service,
  providerID = :provider,
  appDate = :tarih,
  startTime = :saat,
  endTime = :bitis,
  payment = :payment,
  paymentStatus = :status,
  coming = :coming,
  note = :note
  WHERE id = :id");

  $guncelle->bindParam(':service', $service);
  $guncelle->bindParam(':provider', $provider);
  $guncelle->bindParam(':tarih', $randevuTarih);
  $guncelle->bindParam(':saat', $saat);
  $guncelle->bindParam(':bitis', $endTimeDeger);
  $guncelle->bindParam(':payment', $appPayment);
  $guncelle->bindParam(':status', $paymentStatus);
  $guncelle->bindParam(':coming', $coming);
  $guncelle->bindParam(':note', $note);
  $guncelle->bindParam(':id', $randevuID);

  $sonuc = $guncelle->execute();

  // İKİNCİ YAKLAŞIM: Doğrudan string değerlerle sorgu
  if (!$sonuc || $guncelle->rowCount() == 0) {
  error_log("İlk güncelleme yöntemi başarısız, ikinci yöntem deneniyor...");

  // Alternatif doğrudan sorgu yöntemi
  $alternatifSQL = "UPDATE appointments SET
  startTime = '$saat',
  endTime = '$endTimeDeger',
  service = '$service',
  providerID = '$provider',
  appDate = '$randevuTarih'
  WHERE id = '$randevuID'";

  $alternatifSonuc = $DB->exec($alternatifSQL);
  error_log("Alternatif güncelleme sonucu: " . ($alternatifSonuc !== false ? "BAŞARILI ($alternatifSonuc satır)" :
  "BAŞARISIZ"));
  }

  // VERİFİKASYON: Güncelleme sonrası veriyi kontrol et
  $dogrula = $DB->prepare("SELECT * FROM appointments WHERE id = ?");
  $dogrula->execute(array($randevuID));
  $randevuBilgi = $dogrula->fetch(PDO::FETCH_ASSOC);

  if ($randevuBilgi) {
  error_log("Güncelleme sonrası randevu bilgileri: " . print_r($randevuBilgi, true));

  // Başarı durum bildirimi
  if ($randevuBilgi['startTime'] == $saat) {
  error_log("BAŞARILI: Saat güncellendi - " . $randevuBilgi['startTime']);
  } else {
  error_log("BAŞARISIZ: Saat güncellenemedi - Beklenen: $saat, Mevcut: " . $randevuBilgi['startTime']);

  // SON ÇARE: Farklı bir sorgu yaklaşımı
  $sonCareSorgu = "UPDATE appointments SET startTime = ?, endTime = ? WHERE id = ?";
  $sonCareStmt = $DB->prepare($sonCareSorgu);
  $sonCareSonuc = $sonCareStmt->execute(array($saat, $endTimeDeger, $randevuID));
  error_log("Son çare güncelleme sonucu: " . ($sonCareSonuc ? "BAŞARILI" : "BAŞARISIZ"));
  }
  } else {
  error_log("HATA: Güncelleme sonrası randevu bilgisi bulunamadı!");
  }

  $DB->commit(); // İşlemi tamamla

  } catch (PDOException $e) {
  if ($DB->inTransaction()) {
  $DB->rollBack(); // Hata durumunda geri al
  }
  error_log("KRİTİK: Randevu güncelleme hatası - " . $e->getMessage());

  // Hata detaylarını yazdır
  error_log("SQL Hatası: " . print_r($e, true));
  }
  }



  $randevuKontrol = $DB->prepare("SELECT * FROM appointments WHERE id=?");

  $randevuKontrol->execute(array($randevuID));

  $randevuKontrolDeger = $randevuKontrol->fetch(PDO::FETCH_ASSOC);

  $hangiuye = $randevuKontrolDeger['member'];



  $uyeKontrol = $DB->prepare("SELECT * FROM members WHERE id=?");

  $uyeKontrol->execute(array($hangiuye));

  $uyeKontrolDeger = $uyeKontrol->fetch(PDO::FETCH_ASSOC);



  //Google Takvim Entegrasyonu Randevu Güncelleme

  if ($settings['GoogleCalendarStatus'] == '1') {

  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerKontrol->execute(array($provider));

  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  if ($providerKontrolDeger['GoogleCalendarStatus'] == '1') {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/googletakvim/vendor/autoload.php';

  $title = $serviceKontrolDeger['serviceName'] . " Randevusu";

  if (!empty($note)) {

  $noteG = "<br>Müşteri Notu: " . $note;

  } else {

  $noteG = "";

  }

  $desc = "Müşteri Ad Soyad: " . $uyeKontrolDeger['name'] . "<br>Telefon: " . $uyeKontrolDeger['phone'] . $noteG;

  $start = $randevuTarih . 'T' . $saat;

  $end = $randevuTarih . 'T' . $endTimeDeger;

  $eventId = $randevuKontrolDeger['calendarID'];



  $client = new Google_Client();

  $client->setClientId($settings['GoogleCalendarClientId']);

  $client->setClientSecret($settings['GoogleCalendarClientSecret']);

  $client->setRedirectUri('https://' . $_SERVER['SERVER_NAME'] . '/admin/GoogleConnect');

  $client->setAccessType('offline');

  $client->setApprovalPrompt('force');

  $client->addScope(Google_Service_Calendar::CALENDAR);

  $token = $providerKontrolDeger['GoogleCalendarToken'];

  $getRefreshToken = $providerKontrolDeger['GoogleCalendarRefresh'];

  $client->setAccessToken($token);



  if ($client->isAccessTokenExpired() && $getRefreshToken) {

  $client->fetchAccessTokenWithRefreshToken($getRefreshToken);

  $newToken = $client->getAccessToken();

  $guncelle = $DB->prepare("UPDATE provider set GoogleCalendarToken=? WHERE id=?");

  $guncelle->execute(array(json_encode($newToken), $provider));

  }



  $service = new Google_Service_Calendar($client);

  $event = $service->events->get('primary', $eventId);





  $event->setSummary($title);

  $event->setDescription($desc);



  $newStartDateTime = new Google\Service\Calendar\EventDateTime();

  $newStartDateTime->setDateTime($start);

  $newStartDateTime->setTimeZone('Europe/Istanbul');



  $newEndDateTime = new Google\Service\Calendar\EventDateTime();

  $newEndDateTime->setDateTime($end);

  $newEndDateTime->setTimeZone('Europe/Istanbul');



  $event->setStart($newStartDateTime);

  $event->setEnd($newEndDateTime);



  $updatedEvent = $service->events->update('primary', $eventId, $event);

  }

  }



  //netgsm Sms Entegrasyonu

  if (isset($_POST['smsSendSystem']) && $_POST['smsSendSystem'] == 'on') {

  if ($settings['smsSystem'] == '1') { //sms bildirim

  $notification_settings = $DB->query("select * from notification_settings where id=4")->fetch(PDO::FETCH_ASSOC);

  if ($notification_settings['status'] == '1') {

  $smsSettings = $DB->prepare("select * from sms_settings where id=?");

  $smsSettings->execute(array('1'));

  $sms = $smsSettings->fetch(PDO::FETCH_ASSOC);

  $username = $sms['username'];

  $password = $sms['password'];

  $title = $sms['title'];

  $number = $uyeKontrolDeger['phone'];

  $siteadresi = "https://" . $_SERVER['SERVER_NAME'];

  $siteAdi = $settings['siteName'];

  $musteriAdiNe = $uyeKontrolDeger['name'];



  $sablon = $DB->prepare("select * from notification_settings where id=?");

  $sablon->execute(array('4'));

  $sablonCek = $sablon->fetch(PDO::FETCH_ASSOC);

  $messageSablon = $sablonCek['template'];

  $tarihNe = $randevuTarih;

  $saatNe = $saat;

  $hizmetNe = $serviceKontrolDeger['serviceName'];

  setlocale(LC_TIME, 'turkish');

  $tarihNe = iconv('latin5', 'utf-8', strftime(' %d %B %Y %A ', strtotime($tarihNe)));

  $aylar = array(

  'January' => 'Ocak',

  'February' => 'Şubat',

  'March' => 'Mart',

  'April' => 'Nisan',

  'May' => 'Mayıs',

  'June' => 'Haziran',

  'July' => 'Temmuz',

  'August' => 'Ağustos',

  'September' => 'Eylül',

  'October' => 'Ekim',

  'November' => 'Kasım',

  'December' => 'Aralık'

  );



  $gunler = array(

  'Monday' => 'Pazartesi',

  'Tuesday' => 'Salı',

  'Wednesday' => 'Çarşamba',

  'Thursday' => 'Perşembe',

  'Friday' => 'Cuma',

  'Saturday' => 'Cumartesi',

  'Sunday' => 'Pazar'

  );

  $tarihNe = str_replace(array_keys($aylar), array_values($aylar), $tarihNe);

  $tarihNe = str_replace(array_keys($gunler), array_values($gunler), $tarihNe);

  $saatNe = new DateTime($saatNe);

  $saatNe = $saatNe->format("H:i");



  $yenitarih = $tarihNe;

  $yenisaat = $saatNe;



  $messageSablon = str_replace('{siteAdi}', $siteAdi, $messageSablon);

  $messageSablon = str_replace('{uyeAdi}', $musteriAdiNe, $messageSablon);

  $messageSablon = str_replace('{hizmet}', $hizmetNe, $messageSablon);

  $messageSablon = str_replace('{yenitarih}', $yenitarih, $messageSablon);

  $messageSablon = str_replace('{yenisaat}', $yenisaat, $messageSablon);





  $message = $messageSablon;





  if (!isset($source)) $source = ''; $source .= '<mesaj>

    <metin>' . $message . '</metin>

    <nums>' . $number . '</nums>

  </mesaj>';

  $xml_data = '
  <?xml version="1.0"?>

  <SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <SOAP-ENV:Body>

      <ns3:smsGonderNNV2 xmlns:ns3="http://sms/">

        <username>' . $username . '</username>

        <password>' . $password . '</password>

        <header>' . $title . '</header>

        <msg>' . $message . '</msg>

        <gsm>' . $number . '</gsm>

        <filter>0</filter>

        <encoding>TR</encoding>

      </ns3:smsGonderNNV2>

    </SOAP-ENV:Body>

  </SOAP-ENV:Envelope>';



  $curl = curl_init();

  curl_setopt_array($curl, array(

  CURLOPT_URL => 'http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl/',

  CURLOPT_RETURNTRANSFER => true,

  CURLOPT_ENCODING => '',

  CURLOPT_MAXREDIRS => 10,

  CURLOPT_TIMEOUT => 0,

  CURLOPT_FOLLOWLOCATION => true,

  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,

  CURLOPT_CUSTOMREQUEST => 'POST',

  CURLOPT_POSTFIELDS => "$xml_data",

  CURLOPT_HTTPHEADER => array(

  'Content-Type: text/xml'

  ),

  ));

  $response = curl_exec($curl);

  curl_close($curl);

  $time = date('Y-m-d H:i:s');

  $ekle = $DB->prepare("INSERT into sms_history set member=?, number=?, message=?, time=?, appointment_id=?,
  remember_time=?");

  $ekle->execute(array(isset($uyeKontrolDeger["id"]) ? $uyeKontrolDeger["id"] : 0, $number, $message, $time,
  $appointmentID, '0'));



  }

  }



  }

  }


  }


  if (isset($_POST['hizmetEkle'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $serviceName = htmlspecialchars(trim($_POST['serviceName']));

  $serviceDesc = htmlspecialchars(trim($_POST['serviceDesc']));

  $hour = htmlspecialchars(trim($_POST['hour']));

  $againDay = htmlspecialchars(trim($_POST['againDay']));

  if (isset($_POST['status'])) {

  $status = '1';

  } else {

  $status = '0';

  }

  $price = htmlspecialchars(trim($_POST['price']));

  $ekle = $DB->prepare("INSERT into services set serviceName=?, serviceDesc=?, price=?, hour=?, againDay=?,
  status=?");

  $ekle->execute(array($serviceName, $serviceDesc, $price, $hour, $againDay, $status));

  }





  if (isset($_POST['hizmetDuzenle'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $serviceName = htmlspecialchars(trim($_POST['serviceName']));

  $serviceDesc = htmlspecialchars(trim($_POST['serviceDesc']));

  $hour = htmlspecialchars(trim($_POST['hour']));

  $againDay = htmlspecialchars(trim($_POST['againDay']));

  if (isset($_POST['status'])) {

  $status = '1';

  } else {

  $status = '0';

  }

  $price = htmlspecialchars(trim($_POST['price']));

  $serviceID = htmlspecialchars(trim($_POST['serviceID']));



  $ekle = $DB->prepare("UPDATE services set serviceName=?, serviceDesc=?, price=?, hour=?, againDay=?, status=? where

  id=?");

  $ekle->execute(array($serviceName, $serviceDesc, $price, $hour, $againDay, $status, $serviceID));

  }



  if (isset($_POST['hizmetSil'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $hizmetID = htmlspecialchars(trim($_POST['hizmetID']));

  $sil = $DB->prepare("delete from services where id=?");

  $sil->execute(array($hizmetID));



  }





  if (isset($_POST['calisanEkle'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $name = htmlspecialchars(trim($_POST['name']));

  $email = htmlspecialchars(trim($_POST['email']));

  $password = htmlspecialchars(trim($_POST['password']));

  $hashed_password = password_hash($password, PASSWORD_DEFAULT);

  $services = $_POST['services'];

  $w1 = htmlspecialchars(trim($_POST['w1']));

  $w2 = htmlspecialchars(trim($_POST['w2']));

  $workingTime = $w1 . '-' . $w2;

  $breakTime = $_POST['breakTime'];

  $renk = htmlspecialchars(trim($_POST['renk']));

  if (empty($renk)) {

  $renk = "#000";

  }

  $services = implode(",", $services);



  if (!empty($breakTime)) {

  $breakTime = implode(",", $breakTime);

  }



  if (isset($_POST['working'])) {

  $working = '1';

  } else {

  $working = '0';

  }

  if (isset($_POST['isAdmin'])) {

  $isAdmin = '1';

  } else {

  $isAdmin = '0';

  }



  $ekle = $DB->prepare("INSERT into provider set name=?, email=?, password=?, services=?, workingTime=?, breakTime=?,

  renk=?, working=?, isAdmin=?");

  $ekle->execute(array($name, $email, $hashed_password, $services, $workingTime, $breakTime, $renk, $working,
  $isAdmin));

  }



  if (isset($_POST['calisanDuzenle'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $name = htmlspecialchars(trim($_POST['name']));

  $email = htmlspecialchars(trim($_POST['email']));

  $password = htmlspecialchars(trim($_POST['password']));

  $hashed_password = password_hash($password, PASSWORD_DEFAULT);

  $services = $_POST['services'];

  $w1 = htmlspecialchars(trim($_POST['w1']));

  $w2 = htmlspecialchars(trim($_POST['w2']));

  $workingTime = $w1 . '-' . $w2;

  $breakTime = $_POST['breakTime'];

  $renk = htmlspecialchars(trim($_POST['renk']));

  $calisanID = htmlspecialchars(trim($_POST['calisanID']));







  $sil_sorgu = "DELETE FROM saatler WHERE provid = ?";

  $stmt_sil = $DB->prepare($sil_sorgu);

  $stmt_sil->execute([$calisanID]);



  // hours dizisi var mı kontrol et

  if (isset($_POST["hours"])) {

  // hours dizisinden saatleri al

  $saatler = $_POST["hours"];

  // Diğer verileri de al

  $hizmet = "1";

  $tarih = date("Y-m-d");





  // Şimdi yeni verileri ekleyebiliriz

  foreach ($saatler as $saat) {

  $bold = explode(" ",$saat);

  $tarih1 = $bold[0];

  $tarih2 = $bold[1];



  // Veriyi eklemek için sorgu hazırlama

  $ekle_sorgu = "INSERT INTO saatler (provid, hizmet, tarih, saat) VALUES (?, ?, ?, ?)";

  $stmt = $DB->prepare($ekle_sorgu);

  $stmt->execute([ $calisanID, $hizmet, $tarih1, $tarih2]);

  }



  echo "Veriler başarıyla güncellendi.";

  }









  $services = implode(",", $services);



  if (!empty($breakTime)) {

  $breakTime = implode(",", $breakTime);

  }





  if (isset($_POST['smsNoti'])) {

  $smsNoti = '1';

  } else {

  $smsNoti = '0';

  }

  $smsNumber = htmlspecialchars(trim($_POST['smsNumber']));



  if (isset($_POST['breakstatus'])) {

  $breakstatus = '1';

  } else {

  $breakstatus = '0';

  }

  $break_start_time = htmlspecialchars(trim($_POST['break_start_time']));

  $break_end_time = htmlspecialchars(trim($_POST['break_end_time']));





  if (empty($renk)) {

  $renk = "#000";

  }

  $kontrol = $DB->prepare("SELECT * FROM provider WHERE id = ?");

  $kontrol->execute(array($calisanID));

  $kontrol = $kontrol->fetch(PDO::FETCH_ASSOC);



  if (empty($w1)) {

  $workingTime = $kontrol['workingTime'];

  }

  if (empty($w2)) {

  $workingTime = $kontrol['workingTime'];

  }



  if (isset($_POST['working'])) {

  $working = '1';

  } else {

  $working = '0';

  }

  if (isset($_POST['isAdmin'])) {

  $isAdmin = '1';

  } else {

  $isAdmin = '0';

  }



  if ($_FILES['files']['type']) {

  $path = $_SERVER['DOCUMENT_ROOT'] . "/admin/app-assets/images/profile";

  $imageType = $_FILES['files']['type'];

  $imageName = $_FILES['files']['name'];

  $extension = ".webp";

  $newName = randomCreate(34);

  $newNameDB = $newName . $extension;



  if (empty($password)) {

  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, services=?, workingTime=?, breakTime=?, renk=?,

  working=?, photo=?, isAdmin=?, breakstatus=?, break_start_time=?, break_end_time=?, smsNoti=?, smsNumber=? WHERE
  id=?");

  $guncelle->execute(array($name, $email, $services, $workingTime, $breakTime, $renk, $working, $newNameDB, $isAdmin,
  $breakstatus, $break_start_time, $break_end_time, $smsNoti, $smsNumber, $calisanID));

  } else {

  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, password=?, services=?, workingTime=?, breakTime=?,

  renk=?, working=?, photo=?, isAdmin=?, breakstatus=?, break_start_time=?, break_end_time=?, smsNoti=?, smsNumber=?
  WHERE
  id=?");

  $guncelle->

  execute(array($name, $email, $hashed_password, $services, $workingTime, $breakTime, $renk, $working, $newNameDB,
  $isAdmin, $breakstatus, $break_start_time, $break_end_time, $smsNoti, $smsNumber, $calisanID));

  }



  if ($imageType == 'image/jpeg' || $imageType == 'image/jpg' || $imageType == 'image/png') {

  require 'class.upload.php';

  $image = new \Verot\Upload\Upload($_FILES["files"]["tmp_name"]);

  if ($image->uploaded) {

  $image->allowed = array('image/*');

  $image->image_convert = 'webp';

  $image->webp_quality = 70;

  $image->file_new_name_body = $newName;

  $image->Process($path . '/');

  if ($image->processed) {

  print 'Success';



  } else {

  print 'Error: ' . $image->error;

  }



  }



  }



  } else {



  if (empty($password)) {

  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, services=?, workingTime=?, breakTime=?, renk=?,

  working=?, isAdmin=?, breakstatus=?, break_start_time=?, break_end_time=?, smsNoti=?, smsNumber=? WHERE id=?");

  $guncelle->execute(array($name, $email, $services, $workingTime, $breakTime, $renk, $working, $isAdmin,
  $breakstatus,
  $break_start_time, $break_end_time, $smsNoti, $smsNumber, $calisanID));

  } else {

  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, password=?, services=?, workingTime=?, breakTime=?,

  renk=?, working=?, isAdmin=?, breakstatus=?, break_start_time=?, break_end_time=?, smsNoti=?, smsNumber=? WHERE
  id=?");

  $guncelle->

  execute(array($name, $email, $hashed_password, $services, $workingTime, $breakTime, $renk, $working, $isAdmin,
  $breakstatus, $break_start_time, $break_end_time, $smsNoti, $smsNumber, $calisanID));

  }



  }





  }





  if (isset($_POST['providerSil'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $providerID = htmlspecialchars(trim($_POST['providerID']));

  $sil = $DB->prepare("delete from provider where id=?");

  $sil->execute(array($providerID));



  }





  if (isset($_POST['uyeEkle'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $name = htmlspecialchars(trim($_POST['name']));

  $email = htmlspecialchars(trim($_POST['email']));

  $phone = htmlspecialchars(trim($_POST['phone']));

  $birthday = htmlspecialchars(trim($_POST['birthday']));

  $ekle = $DB->prepare("INSERT into members set name=?, email=?, phone=?, birthday=?");

  $ekle->execute(array($name, $email, $phone, $birthday));

  }



  if (isset($_POST['uyeDuzenle'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $name = htmlspecialchars(trim($_POST['name']));

  $email = htmlspecialchars(trim($_POST['email']));

  $phone = htmlspecialchars(trim($_POST['phone']));

  $birthday = htmlspecialchars(trim($_POST['birthday']));



  $uyeid = htmlspecialchars(trim($_POST['uyeid']));

  $ekle = $DB->prepare("UPDATE members set name=?, email=?, phone=?, birthday=? WHERE id=?");

  $ekle->execute(array($name, $email, $phone, $birthday, $uyeid));

  }



  if (isset($_POST['uyeSil'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $membersID = htmlspecialchars(trim($_POST['membersID']));

  $sil = $DB->prepare("delete from members where id=?");

  $sil->execute(array($membersID));



  }





  if (isset($_POST['alindiEdit'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $alindiTemplate = trim($_POST['alindiTemplate']);

  if (isset($_POST['status'])) {

  $status = '1';

  } else {

  $status = '0';

  }

  $duzenle = $DB->prepare("UPDATE notification_settings set template=?, status=? WHERE id=?");

  $duzenle->execute(array($alindiTemplate, $status, '1'));

  }

  if (isset($_POST['hatirlatmaEdit'])) {



  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $hatirlatmaTemplate = trim($_POST['hatirlatmaTemplate']);

  $status = isset($_POST['status']) ? '1' : '0';



  $rememberTimes = array_values($_POST['rememberTime']);

  $rememberTimeJson = json_encode($rememberTimes);



  $duzenle = $DB->prepare("UPDATE notification_settings set template=?, rememberTime=?, status=? WHERE id=?");

  $duzenle->execute(array($hatirlatmaTemplate, $rememberTimeJson, $status, '2'));

  }







  if (isset($_POST['tekrarlamaEdit'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $tekrarlamaTemplate = trim($_POST['tekrarlamaTemplate']);

  if (isset($_POST['status'])) {

  $status = '1';

  } else {

  $status = '0';

  }

  $duzenle = $DB->prepare("UPDATE notification_settings set template=?, status=? WHERE id=?");

  $duzenle->execute(array($tekrarlamaTemplate, $status, '3'));

  }

  if (isset($_POST['guncellemeEdit'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $guncellemeTemplate = trim($_POST['guncellemeTemplate']);

  if (isset($_POST['status'])) {

  $status = '1';

  } else {

  $status = '0';

  }

  $duzenle = $DB->prepare("UPDATE notification_settings set template=?, status=? WHERE id=?");

  $duzenle->execute(array($guncellemeTemplate, $status, '4'));

  }

  if (isset($_POST['dogumgunuEdit'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $dogumgunuTemplate = trim($_POST['dogumgunuTemplate']);

  if (isset($_POST['status'])) {

  $status = '1';

  } else {

  $status = '0';

  }

  $duzenle = $DB->prepare("UPDATE notification_settings set template=?, status=? WHERE id=?");

  $duzenle->execute(array($dogumgunuTemplate, $status, '5'));

  }

  if (isset($_POST['memnuniyetEdit'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $memnuniyetTemplate = trim($_POST['memnuniyetTemplate']);

  if (isset($_POST['status'])) {

  $status = '1';

  } else {

  $status = '0';

  }

  $rememberTime = htmlspecialchars(trim($_POST['rememberTime']));

  $duzenle = $DB->prepare("UPDATE notification_settings set template=?, rememberTime=?, status=? WHERE id=?");

  $duzenle->execute(array($memnuniyetTemplate, $rememberTime, $status, '6'));

  }

  if (isset($_POST['iptaledildiEdit'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $iptaledildiTemplate = trim($_POST['iptaledildiTemplate']);

  if (isset($_POST['status'])) {

  $status = '1';

  } else {

  $status = '0';

  }

  $duzenle = $DB->prepare("UPDATE notification_settings set template=?, status=? WHERE id=?");

  $duzenle->execute(array($iptaledildiTemplate, $status, '7'));

  }



  if (isset($_POST['ayarKaydet'])) {
  // Hata raporlamasını açalım
  ini_set('display_errors', 1);
  ini_set('display_startup_errors', 1);
  error_reporting(E_ALL);

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  // Debug bilgisi yazalım
  error_log("ayarKaydet çalıştı: " . print_r($_POST, true));

  $siteName = htmlspecialchars(trim($_POST['siteName']));

  $siteDesc = htmlspecialchars(trim($_POST['siteDesc']));

  $siteKeyword = htmlspecialchars(trim($_POST['siteKeyword']));

  $periot = htmlspecialchars(trim($_POST['periot']));

  $timeStart = htmlspecialchars(trim($_POST['timeStart']));

  $timeEnd = htmlspecialchars(trim($_POST['timeEnd']));

  // Tema ayarını kontrol et
  $theme = isset($_POST['theme']) ? $_POST['theme'] : '1';
  error_log("Selected theme from POST: " . $theme);



  if (isset($_POST['emailSystem'])) {

  $emailSystem = '1';

  } else {

  $emailSystem = '0';

  }

  if (isset($_POST['smsSystem'])) {

  $smsSystem = '1';

  } else {

  $smsSystem = '0';

  }

  if (isset($_POST['cancelSystem'])) {

  $cancelSystem = '1';

  } else {

  $cancelSystem = '0';

  }

  $cancelLimit = htmlspecialchars(trim($_POST['cancelLimit']));

  $cancelMessage = htmlspecialchars(trim($_POST['cancelMessage']));

  if (isset($_POST['caseSystem'])) {

  $caseSystem = '1';

  } else {

  $caseSystem = '0';

  }

  if (isset($_POST['orderSystem'])) {

  $orderSystem = '1';

  } else {

  $orderSystem = '0';

  }

  if (isset($_POST['providerSmsSystem'])) {

  $providerSmsSystem = '1';

  } else {

  $providerSmsSystem = '0';

  }

  $providerSmsTime = htmlspecialchars(trim($_POST['providerSmsTime']));



  if (isset($_POST['paytrSystem'])) {

  $paytrSystem = '1';

  } else {

  $paytrSystem = '0';

  }

  $paytrId = htmlspecialchars(trim($_POST['paytrId']));

  $paytrKey = htmlspecialchars(trim($_POST['paytrKey']));

  $paytrSalt = htmlspecialchars(trim($_POST['paytrSalt']));

  if (isset($_POST['paytrTestMode'])) {

  $paytrTestMode = '1';

  } else {

  $paytrTestMode = '0';

  }



  if (isset($_POST['birthdaySystem'])) {

  $birthdaySystem = '1';

  } else {

  $birthdaySystem = '0';

  }

  if (isset($_POST['eftSystem'])) {

  $eftSystem = '1';

  } else {

  $eftSystem = '0';

  }

  if (isset($_POST['salonCreditCardSystem'])) {

  $salonCreditCardSystem = '1';

  } else {

  $salonCreditCardSystem = '0';

  }

  if (isset($_POST['stockSystem'])) {

  $stockSystem = '1';

  } else {

  $stockSystem = '0';

  }

  if (isset($_POST['orderProviderSystem'])) {

  $orderProviderSystem = '1';

  } else {

  $orderProviderSystem = '0';

  }

  // specialDaysSystem kontrolü
  if (isset($_POST['specialDaysSystem'])) {
  $specialDaysSystem = '1';
  echo "
  <!-- specialDaysSystem AÇIK: " . $_POST['specialDaysSystem'] . " -->";
  } else {
  $specialDaysSystem = '0';
  echo "
  <!-- specialDaysSystem KAPALI -->";
  }

  // backupSystem kontrolü
  if (isset($_POST['backupSystem'])) {
  $backupSystem = '1';
  echo "
  <!-- backupSystem AÇIK -->";
  } else {
  $backupSystem = '0';
  echo "
  <!-- backupSystem KAPALI -->";
  }

  if (isset($_POST['vestedSystem'])) {

  $vestedSystem = '1';

  } else {

  $vestedSystem = '0';

  }

  $vestedCommission = $_POST['vestedCommission'];



  if (isset($_POST['providerMonthSystem'])) {

  $providerMonthSystem = '1';

  } else {

  $providerMonthSystem = '0';

  }



  if (isset($_POST['langSystem'])) {

  $langSystem = '1';

  } else {

  $langSystem = '0';

  }

  $defaultLang = $_POST['defaultLang'];



  if (isset($_POST['GoogleCalendarStatus'])) {

  $GoogleCalendarStatus = '1';

  } else {

  $GoogleCalendarStatus = '0';

  }

  $GoogleCalendarClientId = $_POST['GoogleCalendarClientId'];

  $GoogleCalendarClientSecret = $_POST['GoogleCalendarClientSecret'];

  $maxDayForService = $_POST['max_day_for_service'];

  $whatsappApiKey = $_POST['whatsappApiKey'];
  $whatsappSystem = $_POST['whatsappSystem'];




  if (isset($_FILES['files']) || isset($_FILES['filesMobile']) || isset($_POST['resetLogo']) ||
  isset($_POST['resetLogoMobile'])) {
  // Dosya yolu
  $path = $_SERVER['DOCUMENT_ROOT'] . "/admin/app-assets/images/logo";

  // Varsayılan olarak mevcut logoları koru
  $siteLogoDesktop = $settings['siteLogo'];
  $siteLogoMobile = $settings['siteLogoMobile'];

  // Masaüstü logo sıfırlama
  if (isset($_POST['resetLogo']) && $_POST['resetLogo'] == '1') {
  $siteLogoDesktop = 'logo.png';
  }

  // Mobil logo sıfırlama
  if (isset($_POST['resetLogoMobile']) && $_POST['resetLogoMobile'] == '1') {
  $siteLogoMobile = 'logo.png';
  }

  // Masaüstü logo işlemi
  if (isset($_FILES['files']) && $_FILES['files']['type']) {
  $imageType = $_FILES['files']['type'];
  $extension = ".webp";
  $newName = randomCreate(34); // Rastgele dosya adı oluştur
  $newNameDB = $newName . $extension;
  $siteLogoDesktop = $newNameDB; // Masaüstü logo için yeni dosya adı

  // Yükleme işlemi
  if (in_array($imageType, ['image/jpeg', 'image/jpg', 'image/png'])) {
  require 'class.upload.php';
  $image = new \Verot\Upload\Upload($_FILES["files"]);
  if ($image->uploaded) {
  $image->allowed = ['image/*'];
  $image->image_convert = 'webp';
  $image->webp_quality = 70;
  $image->file_new_name_body = $newName;
  $image->Process($path . '/');
  if (!$image->processed) {
  die('Error: ' . $image->error); // Hata durumunda işlemi durdur
  }
  }
  }
  }

  // Mobil logo işlemi
  if (isset($_FILES['filesMobile']) && $_FILES['filesMobile']['type']) {
  $imageTypeMobile = $_FILES['filesMobile']['type'];
  $extensionMobile = ".webp";
  $newNameMobile = randomCreate(34); // Rastgele dosya adı oluştur
  $newNameDBMobile = $newNameMobile . $extensionMobile;
  $siteLogoMobile = $newNameDBMobile; // Mobil logo için yeni dosya adı

  // Yükleme işlemi
  if (in_array($imageTypeMobile, ['image/jpeg', 'image/jpg', 'image/png'])) {
  require 'class.upload.php';
  $imageMobile = new \Verot\Upload\Upload($_FILES["filesMobile"]);
  if ($imageMobile->uploaded) {
  $imageMobile->allowed = ['image/*'];
  $imageMobile->image_convert = 'webp';
  $imageMobile->webp_quality = 70;
  $imageMobile->file_new_name_body = $newNameMobile;
  $imageMobile->Process($path . '/');
  if (!$imageMobile->processed) {
  die('Error: ' . $imageMobile->error); // Hata durumunda işlemi durdur
  }
  }
  }
  }

  // Veritabanı güncellemesi
  $duzenle = $DB->prepare("UPDATE settings SET
  siteLogo = ?,
  siteLogoMobile = ?,
  siteName = ?,
  siteDesc = ?,
  siteKeyword = ?,
  periot = ?,
  timeStart = ?,
  timeEnd = ?,
  emailSystem = ?,
  smsSystem = ?,
  cancelSystem = ?,
  cancelLimit = ?,
  cancelMessage = ?,
  caseSystem = ?,
  orderSystem = ?,
  providerSmsSystem = ?,
  providerSmsTime = ?,
  paytrSystem = ?,
  paytrId = ?,
  paytrKey = ?,
  paytrSalt = ?,
  paytrTestMode = ?,
  birthdaySystem = ?,
  eftSystem = ?,
  salonCreditCardSystem = ?,
  stockSystem = ?,
  orderProviderSystem = ?,
  specialDaysSystem = ?,
  backupSystem = ?,
  vestedSystem = ?,
  vestedCommission = ?,
  providerMonthSystem = ?,
  langSystem = ?,
  defaultLang = ?,
  GoogleCalendarStatus = ?,
  GoogleCalendarClientId = ?,
  GoogleCalendarClientSecret = ?,
  whatsappApiKey = ?,
  whatsappSystem = ?,
  max_day_for_service = ?
  WHERE id = ?");
  $duzenle->execute([
  $siteLogoDesktop, // Masaüstü logo
  $siteLogoMobile, // Mobil logo
  $siteName,
  $siteDesc,
  $siteKeyword,
  $periot,
  $timeStart,
  $timeEnd,
  $emailSystem,
  $smsSystem,
  $cancelSystem,
  $cancelLimit,
  $cancelMessage,
  $caseSystem,
  $orderSystem,
  $providerSmsSystem,
  $providerSmsTime,
  $paytrSystem,
  $paytrId,
  $paytrKey,
  $paytrSalt,
  $paytrTestMode,
  $birthdaySystem,
  $eftSystem,
  $salonCreditCardSystem,
  $stockSystem,
  $orderProviderSystem,
  $specialDaysSystem,
  $backupSystem,
  $vestedSystem,
  $vestedCommission,
  $providerMonthSystem,
  $langSystem,
  $defaultLang,
  $GoogleCalendarStatus,
  $GoogleCalendarClientId,
  $GoogleCalendarClientSecret,
  $whatsappApiKey,
  $whatsappSystem,
  $maxDayForService,
  1 // Ayar ID'si
  ]);

  print 'Success';
  }

  else {

  try {
  // Önce mevcut settings tablosunun sütun bilgilerini kontrol edelim
  echo "<br>Veritabanı tablosu kontrol ediliyor...<br>";
  $checkTable = $DB->query("SHOW COLUMNS FROM settings");
  $columns = $checkTable->fetchAll(PDO::FETCH_COLUMN);

  echo "Settings tablosundaki sütunlar:<br>";
  print_r($columns);
  echo "<br>";

  // specialDaysSystem sütunu var mı kontrol edelim
  if (!in_array('specialDaysSystem', $columns)) {
  echo "specialDaysSystem sütunu bulunamadı! Ekleniyor...<br>";
  $addColumn = $DB->exec("ALTER TABLE `settings` ADD COLUMN `specialDaysSystem` tinyint(1) NOT NULL DEFAULT 0 AFTER
  `vestedSystem`");
  echo "Sütun ekleme sonucu: " . ($addColumn !== false ? "Başarılı" : "Başarısız") . "<br>";
  } else {
  echo "specialDaysSystem sütunu mevcut.<br>";
  }

  // backupSystem sütunu var mı kontrol edelim
  if (!in_array('backupSystem', $columns)) {
  echo "backupSystem sütunu bulunamadı! Ekleniyor...<br>";
  $addBackupColumn = $DB->exec("ALTER TABLE `settings` ADD COLUMN `backupSystem` tinyint(1) NOT NULL DEFAULT 0 AFTER
  `specialDaysSystem`");
  echo "backupSystem sütunu ekleme sonucu: " . ($addBackupColumn !== false ? "Başarılı" : "Başarısız") . "<br>";
  } else {
  echo "backupSystem sütunu mevcut.<br>";
  }

  // SQL sorgusunu debug için yazalım
  $sql = "UPDATE settings set siteName=?, siteDesc=?, siteKeyword=?, periot=?, timeStart=?, timeEnd=?,
  emailSystem=?, smsSystem=?, cancelSystem=?, cancelLimit=?, cancelMessage=?, caseSystem=?, orderSystem=?,
  providerSmsSystem=?, providerSmsTime=?, paytrSystem=?, paytrId=?, paytrKey=?, paytrSalt=?, paytrTestMode=?,
  birthdaySystem=?, eftSystem=?, salonCreditCardSystem=?, stockSystem=?, whatsappApiKey=?, whatsappSystem=?,
  orderProviderSystem=?, specialDaysSystem=?, backupSystem=?,
  vestedSystem=?,
  vestedCommission=?, providerMonthSystem=?, langSystem=?, defaultLang=?, GoogleCalendarStatus=?,
  GoogleCalendarClientId=?, GoogleCalendarClientSecret=?, max_day_for_service=?, theme=? WHERE id=?";

  echo "SQL: " . $sql . "<br>";
  echo "specialDaysSystem değeri: " . $specialDaysSystem . "<br>";
  echo "backupSystem değeri: " . $backupSystem . "<br>";

  $duzenle = $DB->prepare($sql);

  $params = array($siteName, $siteDesc, $siteKeyword, $periot, $timeStart, $timeEnd, $emailSystem, $smsSystem,
  $cancelSystem, $cancelLimit, $cancelMessage, $caseSystem, $orderSystem, $providerSmsSystem, $providerSmsTime,
  $paytrSystem, $paytrId, $paytrKey, $paytrSalt, $paytrTestMode, $birthdaySystem, $eftSystem, $salonCreditCardSystem,
  $stockSystem, $whatsappApiKey, $whatsappSystem, $orderProviderSystem, $specialDaysSystem, $backupSystem,
  $vestedSystem,
  $vestedCommission, $providerMonthSystem,
  $langSystem, $defaultLang,
  $GoogleCalendarStatus, $GoogleCalendarClientId, $GoogleCalendarClientSecret, $maxDayForService, intval($theme),
  '1');

  error_log("Theme value in params array: " . intval($theme) . " (position 35)");

  echo "Parametreler:
  <pre>" . print_r($params, true) . "</pre><br>";

  $result = $duzenle->execute($params);

  if ($result) {
  error_log("Ayarlar başarıyla güncellendi.");
  echo "Success";
  } else {
  error_log("Hata: Ayarlar güncellenemedi. PDO Hata bilgisi: " . print_r($duzenle->errorInfo(), true));
  echo "Error: DB update failed";
  }
  } catch (Exception $e) {
  error_log("Hata yakalandı: " . $e->getMessage());
  echo "Error: " . $e->getMessage();
  }

  }

  }





  if (isset($_POST['smsayarKaydet'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $username = htmlspecialchars(trim($_POST['username']));

  $password = htmlspecialchars(trim($_POST['password']));

  $title = htmlspecialchars(trim($_POST['title']));

  $duzenle = $DB->prepare("UPDATE sms_settings set username=?, password=?, title=? WHERE id=?");

  $duzenle->execute(array($username, $password, $title, '1'));



  }



  if (isset($_POST['mailayarKaydet'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $siteSmtphost = $_POST['siteSmtphost'];

  $siteSmtpmail = $_POST['siteSmtpmail'];

  $siteSmtppass = $_POST['siteSmtppass'];

  $siteSmtpport = $_POST['siteSmtpport'];

  $siteSmtptype = $_POST['siteSmtptype'];

  $duzenle = $DB->prepare("UPDATE mail_settings set siteSmtphost=?, siteSmtpmail=?, siteSmtppass=?, siteSmtpport=?,
  siteSmtptype=? WHERE id=?");

  $duzenle->execute(array($siteSmtphost, $siteSmtpmail, $siteSmtppass, $siteSmtpport, $siteSmtptype, '1'));



  }





  if (isset($_POST['profilDuzenle'])) {

  $name = htmlspecialchars(trim($_POST['name']));

  $email = htmlspecialchars(trim($_POST['email']));

  $password = htmlspecialchars(trim($_POST['password']));

  $hashed_password = password_hash($password, PASSWORD_DEFAULT);

  $services = $_POST['services'];

  $w1 = htmlspecialchars(trim($_POST['w1']));

  $w2 = htmlspecialchars(trim($_POST['w2']));

  $workingTime = $w1 . '-' . $w2;

  $breakTime = $_POST['breakTime'];

  $renk = htmlspecialchars(trim($_POST['renk']));

  session_start();

  $calisanID = $_SESSION['memberId'];







  $sil_sorgu = "DELETE FROM saatler WHERE provid = ?";

  $stmt_sil = $DB->prepare($sil_sorgu);

  $stmt_sil->execute([$calisanID]);



  // hours dizisi var mı kontrol et

  if (isset($_POST["hours"])) {

  // hours dizisinden saatleri al

  $saatler = $_POST["hours"];

  // Diğer verileri de al

  $hizmet = "1";

  $tarih = date("Y-m-d");





  // Şimdi yeni verileri ekleyebiliriz

  foreach ($saatler as $saat) {

  $bold = explode(" ",$saat);

  $tarih1 = $bold[0];

  $tarih2 = $bold[1];



  // Veriyi eklemek için sorgu hazırlama

  $ekle_sorgu = "INSERT INTO saatler (provid, hizmet, tarih, saat) VALUES (?, ?, ?, ?)";

  $stmt = $DB->prepare($ekle_sorgu);

  $stmt->execute([ $calisanID, $hizmet, $tarih1, $tarih2]);

  }



  echo "Veriler başarıyla güncellendi.";

  }



  $services = implode(",", $services);



  if (!empty($breakTime)) {

  $breakTime = implode(",", $breakTime);

  }



  if (isset($_POST['breakstatus'])) {

  $breakstatus = '1';

  } else {

  $breakstatus = '0';

  }

  if (isset($_POST['smsNoti'])) {

  $smsNoti = '1';

  } else {

  $smsNoti = '0';

  }

  $smsNumber = htmlspecialchars(trim($_POST['smsNumber']));



  $break_start_time = htmlspecialchars(trim($_POST['break_start_time']));

  $break_end_time = htmlspecialchars(trim($_POST['break_end_time']));



  if (empty($renk)) {

  $renk = "#000";

  }

  $kontrol = $DB->prepare("SELECT * FROM provider WHERE id = ?");

  $kontrol->execute(array($calisanID));

  $kontrol = $kontrol->fetch(PDO::FETCH_ASSOC);



  if (empty($w1)) {

  $workingTime = $kontrol['workingTime'];

  }

  if (empty($w2)) {

  $workingTime = $kontrol['workingTime'];

  }



  if (isset($_POST['working'])) {

  $working = '1';

  } else {

  $working = '0';

  }



  if (isset($_POST['GoogleCalendarStatus'])) {

  $GoogleCalendarStatus = '1';

  } else {

  $GoogleCalendarStatus = '0';

  }





  if ($_FILES['files']['type']) {

  $path = $_SERVER['DOCUMENT_ROOT'] . "/admin/app-assets/images/profile";

  $imageType = $_FILES['files']['type'];

  $imageName = $_FILES['files']['name'];

  $extension = ".webp";

  $newName = randomCreate(34);

  $newNameDB = $newName . $extension;



  if (empty($password)) {

  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, services=?, workingTime=?, breakTime=?, renk=?,

  working=?, breakstatus=?, break_start_time=?, break_end_time=?, photo=?, smsNoti=?, smsNumber=?,
  GoogleCalendarStatus=?
  WHERE id=?");

  $guncelle->execute(array($name, $email, $services, $workingTime, $breakTime, $renk, $working, $breakstatus,
  $break_start_time, $break_end_time, $newNameDB, $smsNoti, $smsNumber, $GoogleCalendarStatus, $calisanID));

  } else {

  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, password=?, services=?, workingTime=?, breakTime=?,

  renk=?, working=?, breakstatus=?, break_start_time=?, break_end_time=?, photo=?, smsNoti=?, smsNumber=?,
  GoogleCalendarStatus=? WHERE id=?");

  $guncelle->

  execute(array($name, $email, $hashed_password, $services, $workingTime, $breakTime, $renk, $working, $breakstatus,
  $break_start_time, $break_end_time, $newNameDB, $smsNoti, $smsNumber, $GoogleCalendarStatus, $calisanID));

  }

  if ($imageType == 'image/jpeg' || $imageType == 'image/jpg' || $imageType == 'image/png') {

  require 'class.upload.php';

  $image = new \Verot\Upload\Upload($_FILES["files"]["tmp_name"]);

  if ($image->uploaded) {

  $image->allowed = array('image/*');

  $image->image_convert = 'webp';

  $image->webp_quality = 70;

  $image->file_new_name_body = $newName;

  $image->Process($path . '/');

  if ($image->processed) {

  print 'Success';



  } else {

  print 'Error: ' . $image->error;

  }



  }



  }

  } else if (isset($_POST['resetAvatar']) && $_POST['resetAvatar'] === 'true') {
  // Avatar sıfırlama işlemi - varsayılan fotoğrafı kullan
  if (empty($password)) {
  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, services=?, workingTime=?, breakTime=?, renk=?,
  working=?, breakstatus=?, break_start_time=?, break_end_time=?, photo=?, smsNoti=?, smsNumber=?,
  GoogleCalendarStatus=? WHERE
  id=?");
  $guncelle->execute(array($name, $email, $services, $workingTime, $breakTime, $renk, $working, $breakstatus,
  $break_start_time, $break_end_time, 'no-photo.png', $smsNoti, $smsNumber, $GoogleCalendarStatus, $calisanID));
  } else {
  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, password=?, services=?, workingTime=?, breakTime=?,
  renk=?, working=?, breakstatus=?, break_start_time=?, break_end_time=?, photo=?, smsNoti=?, smsNumber=?,
  GoogleCalendarStatus=?
  WHERE id=?");
  $guncelle->execute(array($name, $email, $hashed_password, $services, $workingTime, $breakTime, $renk, $working,
  $breakstatus,
  $break_start_time, $break_end_time, 'no-photo.png', $smsNoti, $smsNumber, $GoogleCalendarStatus, $calisanID));
  }
  } else {

  if (empty($password)) {

  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, services=?, workingTime=?, breakTime=?, renk=?,

  working=?, breakstatus=?, break_start_time=?, break_end_time=?, smsNoti=?, smsNumber=?, GoogleCalendarStatus=? WHERE
  id=?");

  $guncelle->execute(array($name, $email, $services, $workingTime, $breakTime, $renk, $working, $breakstatus,
  $break_start_time, $break_end_time, $smsNoti, $smsNumber, $GoogleCalendarStatus, $calisanID));

  } else {

  $guncelle = $DB->prepare("UPDATE provider set name=?, email=?, password=?, services=?, workingTime=?, breakTime=?,

  renk=?, working=?, breakstatus=?, break_start_time=?, break_end_time=?, smsNoti=?, smsNumber=?,
  GoogleCalendarStatus=?
  WHERE id=?");

  $guncelle->

  execute(array($name, $email, $hashed_password, $services, $workingTime, $breakTime, $renk, $working, $breakstatus,
  $break_start_time, $break_end_time, $smsNoti, $smsNumber, $GoogleCalendarStatus, $calisanID));

  }

  }



  }



  if (isset($_POST['urunEkle'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $ad = htmlspecialchars(trim($_POST['ad']));

  $aciklama = htmlspecialchars(trim($_POST['aciklama']));

  $fiyat = htmlspecialchars(trim($_POST['fiyat']));

  $stok = htmlspecialchars(trim($_POST['stok']));

  $barcode = htmlspecialchars(trim($_POST['barcode']));

  $ekle = $DB->prepare("INSERT into products set ad=?, aciklama=?, barcode=?, fiyat=?, stok=?");

  $ekle->execute(array($ad, $aciklama, $barcode, $fiyat, $stok));

  }



  if (isset($_POST['urunDuzenle'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $ad = htmlspecialchars(trim($_POST['ad']));

  $aciklama = htmlspecialchars(trim($_POST['aciklama']));

  $fiyat = htmlspecialchars(trim($_POST['fiyat']));

  $stok = htmlspecialchars(trim($_POST['stok']));

  $barcode = htmlspecialchars(trim($_POST['barcode']));

  $urunid = htmlspecialchars(trim($_POST['urunid']));

  $ekle = $DB->prepare("UPDATE products set ad=?, aciklama=?, barcode=?, fiyat=?, stok=? WHERE id=?");

  $ekle->execute(array($ad, $aciklama, $barcode, $fiyat, $stok, $urunid));

  }



  if (isset($_POST['urunSil'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $urunid = htmlspecialchars(trim($_POST['urunid']));

  $sil = $DB->prepare("delete from products where id=?");

  $sil->execute(array($urunid));

  }





  if (isset($_POST['orderEkle'])) {

  $products = $_POST['urunler'];

  $productsDeger = implode(",", $products);

  $memberID = $_POST['musteri'];

  $orderDate = $_POST['orderDate'];

  $orderDate = date("d-m-Y H:i:s", strtotime($orderDate));

  $paymentStatus = $_POST['paymentStatus'];

  $paymentMethod = $_POST['paymentMethod'];

  $orderFiyat = $_POST['fiyat'];



  $musteriAd = $_POST['musteriAd'];

  $musteriEposta = $_POST['musteriEposta'];

  $musteriTelefon = $_POST['musteriTelefon'];



  $orderProvider = $_POST['orderProvider'];



  if ($paymentStatus == "1") {

  $kalanBorc = 0;

  } else {

  $kalanBorc = $orderFiyat;

  }



  if (empty($orderProvider)) {

  $orderProvider = '0';

  }

  if (empty($musteriAd)) {

  $ekle = $DB->prepare("INSERT into orders set products=?, memberID=?, orderDate=?, paymentStatus=?, paymentMethod=?,
  orderFiyat=?, orderProvider=?, kalanBorc=?");

  $ekle->execute(array($productsDeger, $memberID, $orderDate, $paymentStatus, $paymentMethod, $orderFiyat,
  $orderProvider,
  $kalanBorc));

  $orderID = $DB->lastInsertId();

  if ($settings['stockSystem'] == '1') {

  foreach ($products as $key => $value) {

  $stokKontrol = $DB->prepare("SELECT * FROM products WHERE id=?");

  $stokKontrol->execute(array($value));

  $stokKontrolDeger = $stokKontrol->fetch(PDO::FETCH_ASSOC);

  $mevcutStok = $stokKontrolDeger['stok'];

  $yeniStok = $mevcutStok - 1;

  $duzen = $DB->prepare("UPDATE products set stok=? WHERE id=?");

  $duzen->execute(array($yeniStok, $value));

  }

  }





  if ($settings['vestedSystem'] == '1') {

  $providerCheck = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerCheck->execute(array($orderProvider));

  $providerCheckVeri = $providerCheck->fetch(PDO::FETCH_ASSOC);

  $mevcutvestedAmount = $providerCheckVeri['vestedAmount'];

  $vestedTutar = ($orderFiyat / 100) * $settings['vestedCommission'];

  $yenivestedAmount = $mevcutvestedAmount + $vestedTutar;

  $update = $DB->prepare("UPDATE provider set vestedAmount=? WHERE id=?");

  $update->execute(array($yenivestedAmount, $orderProvider));

  $ekle = $DB->prepare("INSERT into vested set providerID=?, orderID=?, amount=?, date=?");

  $ekle->execute(array($orderProvider, $orderID, $vestedTutar, $orderDate));

  }



  if ($settings['caseSystem'] == '1') {

  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerKontrol->execute(array($orderProvider));

  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  if ($paymentStatus == '1') {

  $caseDate = date("Y-m-d", strtotime($orderDate));

  $casePaymentMethod = $paymentMethod;

  $caseAmount = $orderFiyat;

  $caseNote = $providerKontrolDeger['name'];

  $caseNote = $caseNote . " - Sipariş Ödemesi |";

  foreach ($products as $key => $value) {

  $productKontrol = $DB->prepare("SELECT * FROM products WHERE id=?");

  $productKontrol->execute(array($value));

  $productKontrolDeger = $productKontrol->fetch(PDO::FETCH_ASSOC);

  $productName = $productKontrolDeger['ad'];

  $caseNote = $caseNote . " " . $productName;

  $caseNote = $caseNote . " | #" . $orderID;

  }

  $caseType = '1';

  $ekle = $DB->prepare("INSERT into business_case set caseDate=?, casePaymentMethod=?, caseAmount=?, caseNote=?,
  caseType=?, member=?");

  $ekle->execute(array($caseDate, $casePaymentMethod, $caseAmount, $caseNote, $caseType, $memberID));

  }

  }





  } else {

  $musteriEkle = $DB->prepare("INSERT into members set name=?, email=?, phone=?");

  $musteriEkle->execute(array($musteriAd, $musteriEposta, $musteriTelefon));

  $musteriID = $DB->lastInsertId();



  $ekle = $DB->prepare("INSERT into orders set products=?, memberID=?, orderDate=?, paymentStatus=?, paymentMethod=?,
  orderFiyat=?, orderProvider=?, kalanBorc=?");

  $ekle->execute(array($productsDeger, $musteriID, $orderDate, $paymentStatus, $paymentMethod, $orderFiyat,
  $orderProvider, $kalanBorc));

  $orderID = $DB->lastInsertId();



  if ($settings['stockSystem'] == '1') {

  foreach ($products as $key => $value) {

  $stokKontrol = $DB->prepare("SELECT * FROM products WHERE id=?");

  $stokKontrol->execute(array($value));

  $stokKontrolDeger = $stokKontrol->fetch(PDO::FETCH_ASSOC);

  $mevcutStok = $stokKontrolDeger['stok'];

  $yeniStok = $mevcutStok - 1;

  $duzen = $DB->prepare("UPDATE products set stok=? WHERE id=?");

  $duzen->execute(array($yeniStok, $value));

  }

  }



  if ($settings['vestedSystem'] == '1') {

  $providerCheck = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerCheck->execute(array($orderProvider));

  $providerCheckVeri = $providerCheck->fetch(PDO::FETCH_ASSOC);

  $mevcutvestedAmount = $providerCheckVeri['vestedAmount'];

  $vestedTutar = ($orderFiyat / 100) * $settings['vestedCommission'];

  $yenivestedAmount = $mevcutvestedAmount + $vestedTutar;

  $update = $DB->prepare("UPDATE provider set vestedAmount=? WHERE id=?");

  $update->execute(array($yenivestedAmount, $orderProvider));

  $ekle = $DB->prepare("INSERT into vested set providerID=?, orderID=?, amount=?, date=?");

  $ekle->execute(array($orderProvider, $orderID, $vestedTutar, $orderDate));

  }



  if ($settings['caseSystem'] == '1') {

  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerKontrol->execute(array($orderProvider));

  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  if ($paymentStatus == '1') {

  $caseDate = date("Y-m-d", strtotime($orderDate));

  $casePaymentMethod = $paymentMethod;

  $caseAmount = $orderFiyat;

  $caseNote = $providerKontrolDeger['name'];

  $caseNote = $caseNote . " - Sipariş Ödemesi |";

  foreach ($products as $key => $value) {

  $productKontrol = $DB->prepare("SELECT * FROM products WHERE id=?");

  $productKontrol->execute(array($value));

  $productKontrolDeger = $productKontrol->fetch(PDO::FETCH_ASSOC);

  $productName = $productKontrolDeger['ad'];

  $caseNote = $caseNote . " " . $productName;

  $caseNote = $caseNote . " | #" . $orderID;

  }

  $caseType = '1';

  $ekle = $DB->prepare("INSERT into business_case set caseDate=?, casePaymentMethod=?, caseAmount=?, caseNote=?,
  caseType=?, member=?");

  $ekle->execute(array($caseDate, $casePaymentMethod, $caseAmount, $caseNote, $caseType, $musteriID));

  }

  }





  }





  }



  if (isset($_POST['orderUpdate'])) {

  $orderID = $_POST['orderID'];

  $products = $_POST['urunler'];

  $productsDeger = implode(",", $products);

  $memberID = $_POST['musteri'];

  $orderDate = date("d-m-Y H:i:s");

  $paymentStatus = $_POST['paymentStatus'];

  $paymentMethod = $_POST['paymentMethod'];

  $orderFiyat = $_POST['fiyat'];



  $musteriAd = $_POST['musteriAd'];

  $musteriEposta = $_POST['musteriEposta'];

  $musteriTelefon = $_POST['musteriTelefon'];

  $orderProvider = $_POST['orderProvider'];



  if (empty($musteriAd)) {



  if ($settings['caseSystem'] == '1') {

  $orderKontrol = $DB->prepare("SELECT * FROM orders WHERE id=?");

  $orderKontrol->execute(array($orderID));

  $orderKontrolDeger = $orderKontrol->fetch(PDO::FETCH_ASSOC);

  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerKontrol->execute(array($orderKontrolDeger['orderProvider']));

  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  if ($orderKontrolDeger['paymentStatus'] == '0') {

  if ($paymentStatus == '1') {

  $caseDate = date("Y-m-d", strtotime($orderDate));

  $casePaymentMethod = $paymentMethod;

  $caseAmount = $orderFiyat;

  $caseNote = $providerKontrolDeger['name'];

  $caseNote = $caseNote . "- Sipariş Ödemesi |";

  foreach ($products as $key => $value) {

  $productKontrol = $DB->prepare("SELECT * FROM products WHERE id=?");

  $productKontrol->execute(array($value));

  $productKontrolDeger = $productKontrol->fetch(PDO::FETCH_ASSOC);

  $productName = $productKontrolDeger['ad'];

  $caseNote = $caseNote . " " . $productName;

  $caseNote = $caseNote . " | #" . $orderID;

  }

  $caseType = '1';

  $ekle = $DB->prepare("INSERT into business_case set caseDate=?, casePaymentMethod=?, caseAmount=?, caseNote=?,
  caseType=?, member=?");

  $ekle->execute(array($caseDate, $casePaymentMethod, $caseAmount, $caseNote, $caseType, $memberID));



  $odemeDuzen = $DB->prepare("UPDATE orders set kalanBorc=? WHERE id=?");

  $odemeDuzen->execute(array('0', $orderID));

  }

  }

  }



  $duzen = $DB->prepare("UPDATE orders set products=?, memberID=?, orderDate=?, paymentStatus=?, paymentMethod=?,
  orderFiyat=?, orderProvider=? WHERE id=?");

  $duzen->execute(array($productsDeger, $memberID, $orderDate, $paymentStatus, $paymentMethod, $orderFiyat,
  $orderProvider, $orderID));





  } else {

  $musteriEkle = $DB->prepare("INSERT into members set name=?, email=?, phone=?");

  $musteriEkle->execute(array($musteriAd, $musteriEposta, $musteriTelefon));

  $musteriID = $DB->lastInsertId();



  if ($settings['caseSystem'] == '1') {

  $orderKontrol = $DB->prepare("SELECT * FROM orders WHERE id=?");

  $orderKontrol->execute(array($orderID));

  $orderKontrolDeger = $orderKontrol->fetch(PDO::FETCH_ASSOC);

  $providerKontrol = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerKontrol->execute(array($orderKontrolDeger['orderProvider']));

  $providerKontrolDeger = $providerKontrol->fetch(PDO::FETCH_ASSOC);

  if ($orderKontrolDeger['paymentStatus'] == '0') {

  if ($paymentStatus == '1') {

  $caseDate = date("Y-m-d", strtotime($orderDate));

  $casePaymentMethod = $paymentMethod;

  $caseAmount = $orderFiyat;

  $caseNote = $providerKontrolDeger['name'];

  $caseNote = $caseNote . " - Sipariş Ödemesi |";

  foreach ($products as $key => $value) {

  $productKontrol = $DB->prepare("SELECT * FROM products WHERE id=?");

  $productKontrol->execute(array($value));

  $productKontrolDeger = $productKontrol->fetch(PDO::FETCH_ASSOC);

  $productName = $productKontrolDeger['ad'];

  $caseNote = $caseNote . " " . $productName;

  $caseNote = $caseNote . " | #" . $orderID;

  }

  $caseType = '1';

  $ekle = $DB->prepare("INSERT into business_case set caseDate=?, casePaymentMethod=?, caseAmount=?, caseNote=?,
  caseType=?, member=?");

  $ekle->execute(array($caseDate, $casePaymentMethod, $caseAmount, $caseNote, $caseType, $musteriID));

  }

  }

  }



  $duzen = $DB->prepare("UPDATE orders set products=?, memberID=?, orderDate=?, paymentStatus=?, paymentMethod=?,
  orderFiyat=?, orderProvider=? WHERE id=?");

  $duzen->execute(array($productsDeger, $musteriID, $orderDate, $paymentStatus, $paymentMethod, $orderFiyat,
  $orderProvider, $orderID));





  }



  }



  if (isset($_POST['orderDelete'])) {

  $orderID = htmlspecialchars(trim($_POST['orderID']));

  $sil = $DB->prepare("delete from orders where id=?");

  $sil->execute(array($orderID));

  }



  if (isset($_POST['caseAdd'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $caseDate = $_POST['caseDate'];

  $casePaymentMethod = $_POST['casePaymentMethod'];

  $caseAmount = $_POST['caseAmount'];

  $caseNote = $_POST['caseNote'];

  $caseType = $_POST['caseType'];

  $musteri = $_POST['musteri'];



  $order = $_POST['order'];

  $orderCheck = $DB->prepare("select * from orders where id=?");

  $orderCheck->execute(array($order));

  $orderVeri = $orderCheck->fetch(PDO::FETCH_ASSOC);

  if ($orderCheck->rowCount()) {

  $kalanBorc = $orderVeri['kalanBorc'];

  if ($kalanBorc > 0) {

  $kalanGuncel = $kalanBorc - $caseAmount;

  $guncelle = $DB->prepare("UPDATE orders set kalanBorc=? WHERE id=?");

  $guncelle->execute(array($kalanGuncel, $order));

  }

  }



  $ekle = $DB->prepare("INSERT into business_case set caseDate=?, casePaymentMethod=?, caseAmount=?, caseNote=?,
  caseType=?, member=?, caseOrder=?");

  $ekle->execute(array($caseDate, $casePaymentMethod, $caseAmount, $caseNote, $caseType, $musteri, $order));

  }



  if (isset($_POST['caseEdit'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $caseID = $_POST['caseID'];

  $caseDate = $_POST['caseDate'];

  $casePaymentMethod = $_POST['casePaymentMethod'];

  $caseAmount = $_POST['caseAmount'];

  $caseNote = $_POST['caseNote'];

  $caseType = $_POST['caseType'];

  $musteri = $_POST['musteri'];

  $order = $_POST['order'];

  $orderCheck = $DB->prepare("select * from orders where id=?");

  $orderCheck->execute(array($order));

  $orderVeri = $orderCheck->fetch(PDO::FETCH_ASSOC);

  if ($orderCheck->rowCount()) {

  $kalanBorc = $orderVeri['kalanBorc'];

  if ($kalanBorc > 0) {

  $kalanGuncel = $kalanBorc - $caseAmount;

  $guncelle = $DB->prepare("UPDATE orders set kalanBorc=? WHERE id=?");

  $guncelle->execute(array($kalanGuncel, $order));

  }

  }

  $ekle = $DB->prepare("UPDATE business_case set caseDate=?, casePaymentMethod=?, caseAmount=?, caseNote=?,
  caseType=?,
  member=?, caseOrder=? WHERE id=?");

  $ekle->execute(array($caseDate, $casePaymentMethod, $caseAmount, $caseNote, $caseType, $musteri, $order, $caseID));

  }





  if (isset($_POST['caseSil'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $caseID = htmlspecialchars(trim($_POST['caseID']));

  $sil = $DB->prepare("delete from business_case where id=?");

  $sil->execute(array($caseID));

  }





  if (isset($_POST['bankAdd'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $bankName = $_POST['bankName'];

  $bankAccountName = $_POST['bankAccountName'];

  $bankCode = $_POST['bankCode'];

  $bankAccountCode = $_POST['bankAccountCode'];

  $bankIban = $_POST['bankIban'];

  if (isset($_POST['bankStatus'])) {

  $bankStatus = '1';

  } else {

  $bankStatus = '0';

  }

  $ekle = $DB->prepare("INSERT into banks set bankName=?, bankAccountName=?, bankCode=?, bankAccountCode=?,
  bankIban=?,
  bankStatus=?");

  $ekle->execute(array($bankName, $bankAccountName, $bankCode, $bankAccountCode, $bankIban, $bankStatus));

  }



  if (isset($_POST['bankEdit'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $bankID = $_POST['bankID'];

  $bankName = $_POST['bankName'];

  $bankAccountName = $_POST['bankAccountName'];

  $bankCode = $_POST['bankCode'];

  $bankAccountCode = $_POST['bankAccountCode'];

  $bankIban = $_POST['bankIban'];

  if (isset($_POST['bankStatus'])) {

  $bankStatus = '1';

  } else {

  $bankStatus = '0';

  }

  $guncelle = $DB->prepare("UPDATE banks set bankName=?, bankAccountName=?, bankCode=?, bankAccountCode=?, bankIban=?,
  bankStatus=? WHERE id=?");

  $guncelle->execute(array($bankName, $bankAccountName, $bankCode, $bankAccountCode, $bankIban, $bankStatus,
  $bankID));

  }





  if (isset($_POST['bankSil'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $bankID = htmlspecialchars(trim($_POST['bankID']));

  $sil = $DB->prepare("DELETE from banks where id=?");

  $sil->execute(array($bankID));

  }





  if (isset($_POST['vestedPayed'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $orderDate = date("d-m-Y H:i:s");

  $orderProvider = $_POST['providerID'];

  $providerCheck = $DB->prepare("SELECT * FROM provider WHERE id=?");

  $providerCheck->execute(array($orderProvider));

  $providerCheckVeri = $providerCheck->fetch(PDO::FETCH_ASSOC);

  $mevcutvestedAmount = $providerCheckVeri['vestedAmount'];



  $ekle = $DB->prepare("INSERT into payed_vested set providerID=?, amount=?, date=?");

  $ekle->execute(array($orderProvider, $mevcutvestedAmount, $orderDate));



  $update = $DB->prepare("UPDATE provider set vestedAmount=? WHERE id=?");

  $update->execute(array('0', $orderProvider));

  }





  if (isset($_POST['langAdd'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $language = $_POST['language'];

  $languageCode = $_POST['languageCode'];

  $default_language = 'tr';



  $langAdd = $DB->prepare("INSERT INTO languages (name,code) VALUES (:language, :code)");

  $langAdd->bindParam(':language', $language);

  $langAdd->bindParam(':code', $languageCode);

  $langAdd->execute();





  $langCheck = $DB->prepare("SELECT * FROM translations WHERE language = :default_language");

  $langCheck->bindParam(':default_language', $default_language);

  $langCheck->execute();



  $translations = $langCheck->fetchAll();



  foreach ($translations as $translation) {

  $langTransAdd = $DB->prepare("INSERT INTO translations (key_name, value, language) VALUES (:key_name, :value,
  :language_code)");

  $langTransAdd->bindParam(':key_name', $translation['key_name']);

  $langTransAdd->bindParam(':value', $translation['value']);

  $langTransAdd->bindParam(':language_code', $languageCode);

  $langTransAdd->execute();

  }



  }



  if (isset($_POST['langUpdate'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $language = $_POST['language'];

  $translations = $_POST['translations'];

  foreach ($translations as $key_name => $value) {

  $langUpdate = $DB->prepare("UPDATE translations SET value = :value WHERE language = :language AND key_name =
  :key_name");

  $langUpdate->bindParam(':value', $value);

  $langUpdate->bindParam(':language', $language);

  $langUpdate->bindParam(':key_name', $key_name);

  $langUpdate->execute();

  }

  }





  if (isset($_POST['langSil'])) {

  require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/AdminCheck.php';

  $langID = htmlspecialchars(trim($_POST['langID']));

  $langCode = htmlspecialchars(trim($_POST['langCode']));



  $sil = $DB->prepare("DELETE from languages where id=?");

  $sil->execute(array($langID));



  $siltrans = $DB->prepare("DELETE from translations where language=?");

  $siltrans->execute(array($langCode));





  }



  if (isset($_POST['case']) && $_POST['case'] === 'yeniNot') {



  $membersID = $_POST['musteri'];

  $notes = $_POST['NewNote'];

  $notes = json_decode($notes, true);



  $note_data = array(

  "membersNote" => $notes

  );



  $data_json = json_encode($note_data, JSON_UNESCAPED_UNICODE);



  $stmt = $DB->prepare("UPDATE members SET members_note = :members_note WHERE id = :id");

  $stmt->bindParam(':members_note', $data_json, PDO::PARAM_STR);

  $stmt->bindParam(':id', $membersID, PDO::PARAM_INT);

  if ($stmt->execute()) {

  echo "Başarılı";

  } else {

  echo "Başarısız";

  }

  }
  ?>
