<?php
/**
 * strftime Fonksiyonu Yerine Geçecek Fonksiyon
 * 
 * PHP 8.1'de kaldırılan strftime fonksiyonu yerine IntlDateFormatter kullanımı için 
 * yardımcı fonksiyon
 * 
 * Bu kodu eral.php'nin başında include edin
 */

if (!function_exists('formatTurkishDate')) {
    /**
     * Tarihi Türkçe formatta biçimlendirir
     * 
     * @param string $dateString Tarih string'i (strtotime uyumlu)
     * @param string $format Format (Varsayılan: d MMMM Y EEEE)
     * @return string Biçimlendirilmiş tarih
     */
    function formatTurkishDate($dateString, $format = ' d MMMM Y EEEE ') {
        setlocale(LC_TIME, 'tr_TR.UTF-8', 'tr_TR', 'tr', 'turkish');
        
        try {
            $dateObj = new DateTime($dateString);
            
            $fmt = new IntlDateFormatter(
                'tr_TR',
                IntlDateFormatter::LONG,
                IntlDateFormatter::NONE,
                null,
                null,
                $format
            );
            
            return $fmt->format($dateObj);
        } catch (Exception $e) {
            // Hata durumunda orjinal string'i dön
            return $dateString;
        }
    }
}

// Açıklama: Bu dosya, tarih formatlama sorunlarını çözmek için yardımcı fonksiyon içerir
// eral.php dosyasının başında include edilmesi gerekir

?>