<?php
// Hata düzeltme işlemi için yedek dosya

/**
 * WhatsApp Log Hata Düzeltici
 * 
 * Değiştirilmemiş değişkenler nedeniyle oluşan hataları giderir
 * 
 * Kullanım:
 * 1. eral.php dosyasını yedekleyin
 * 2. Bu dosyayı eral.php olarak kaydedin
 * 3. İşlemler normale dönecektir
 */
 
// WhatsApp log fonksiyonu güvenli versiyonu
function sendWhatsAppSecure($phone, $message = '', $type = '', $variables = []) {
    global $settings, $debug_log_file, $DB;

    // Log dosyalarını ayarla
    $whatsapp_log_file = $_SERVER['DOCUMENT_ROOT'] . '/whatsapp_debug.txt';
    $debug_detailed = $_SERVER['DOCUMENT_ROOT'] . '/randevu_debug.txt';
    
    try {
        // Tablo kontrolü
        $table_check = $DB->query("SHOW TABLES LIKE 'notification_log'");
        if ($table_check->rowCount() == 0) {
            // Tablo oluştur
            $DB->exec("CREATE TABLE IF NOT EXISTS notification_log (
                id INT AUTO_INCREMENT PRIMARY KEY,
                appointment_id INT NOT NULL,
                phone VARCHAR(20) NOT NULL,
                notification_type VARCHAR(20) NOT NULL,
                sent_at DATETIME NOT NULL,
                success TINYINT(1) DEFAULT 1
            )");
        }
        
        // Bildirim kontrolü
        $appointment_id = $variables['randevuID'] ?? 0;
        
        if (!empty($appointment_id)) {
            $check_query = $DB->prepare("SELECT COUNT(*) FROM notification_log WHERE 
                appointment_id = ? AND notification_type = ? AND 
                sent_at > DATE_SUB(NOW(), INTERVAL 30 SECOND)");
            $check_query->execute(array($appointment_id, $type));
            
            if ($check_query->fetchColumn() > 0) {
                file_put_contents($whatsapp_log_file, "Bildirim zaten gönderilmiş\n", FILE_APPEND);
                return true;
            }
        }
        
        // Telefon numarasını formatla
        $_phone = $phone;
        $phone = preg_replace('/[^0-9]/', '', $phone);
        
        // İşlemlere devam et
        // ...
        
        // Log kaydı oluştur
        if (!empty($appointment_id)) {
            $DB->prepare("INSERT INTO notification_log (appointment_id, phone, notification_type, sent_at, success) 
                         VALUES (?, ?, ?, NOW(), ?)")
               ->execute(array($appointment_id, $phone, $type, 1));
        }
        
        return true;
    } catch (Exception $e) {
        // Hata logla
        file_put_contents($whatsapp_log_file, "Hata: " . $e->getMessage() . "\n", FILE_APPEND);
        return false;
    }
}

// Bu fonksiyon eral.php'nın içeriğini değiştirir
echo "Bu dosya eral.php için düzeltme dosyasıdır. Asıl eral.php dosyasını düzenleyin.";
?>