<?php
/**
 * notification_log tablosunu oluşturan ve kontrol eden araç
 * WhatsApp bildirim sorunu çözümü için oluşturuldu
 */

// Veritabanı bağlantısı
if (file_exists(__DIR__ . '/db.php')) {
    require_once __DIR__ . '/db.php';
} else {
    die("Veritabanı bağlantı dosyası bulunamadı!");
}

echo "notification_log tablosu düzeltme aracı\n";
echo "--------------------------------------\n\n";

// Tablo var mı kontrol et
$table_check = $DB->query("SHOW TABLES LIKE 'notification_log'");
if ($table_check->rowCount() == 0) {
    echo "notification_log tablosu bulunamadı. Oluşturuluyor...\n";
    
    try {
        // Tablo oluştur
        $DB->exec("CREATE TABLE IF NOT EXISTS notification_log (
            id INT AUTO_INCREMENT PRIMARY KEY,
            appointment_id INT NOT NULL,
            phone VARCHAR(20) NOT NULL,
            notification_type VARCHAR(20) NOT NULL,
            sent_at DATETIME NOT NULL,
            success TINYINT(1) DEFAULT 1
        )");
        echo "notification_log tablosu başarıyla oluşturuldu.\n";
    } catch (Exception $e) {
        echo "HATA: notification_log tablosu oluşturulamadı!\n";
        echo "Hata mesajı: " . $e->getMessage() . "\n";
        die();
    }
} else {
    echo "notification_log tablosu zaten mevcut.\n";
}

// Çalışan bildirimi template kontrolü
echo "\nÇalışan bildirimi şablonu kontrol ediliyor...\n";
$template_check = $DB->query("SELECT id FROM notification_settings WHERE id = 8");
if ($template_check->rowCount() == 0) {
    echo "Çalışan bildirimi (ID: 8) bulunamadı. Oluşturuluyor...\n";
    
    try {
        $DB->exec("INSERT INTO notification_settings (id, name, description, type, template, status)
        VALUES (
            8, 
            'Çalışan Bildirim', 
            'Randevu alındığında çalışana gönderilecek bildirim',
            'whatsapp', 
            'Sayın {calisan}, {uyeAdi} adlı müşteri tarafından {tarih} tarihinde saat {saat} için {hizmet} randevusu alınmıştır. İyi çalışmalar dileriz.',
            1
        )");
        echo "Çalışan bildirimi şablonu oluşturuldu.\n";
    } catch (Exception $e) {
        echo "UYARI: Çalışan bildirimi şablonu oluşturulamadı!\n";
        echo "Hata mesajı: " . $e->getMessage() . "\n";
    }
} else {
    echo "Çalışan bildirimi şablonu zaten mevcut.\n";
}

// Hatalı şablonları düzelt
echo "\nHatalı şablonlar kontrol ediliyor...\n";
$templates = $DB->query("SELECT id, template FROM notification_settings WHERE status = 1");
$fixed = 0;

while ($row = $templates->fetch(PDO::FETCH_ASSOC)) {
    if (strpos($row['template'], '{uyeAdi}') !== false && strpos($row['template'], '{uyeAdi}') === 0) {
        // Şablonda boş değişken var, düzelt
        $fixed_template = str_replace('{uyeAdi}', 'Müşteri', $row['template']);
        
        try {
            $update = $DB->prepare("UPDATE notification_settings SET template = ? WHERE id = ?");
            $update->execute([$fixed_template, $row['id']]);
            echo "Şablon düzeltildi (ID: " . $row['id'] . ")\n";
            $fixed++;
        } catch (Exception $e) {
            echo "HATA: Şablon düzeltme başarısız (ID: " . $row['id'] . "): " . $e->getMessage() . "\n";
        }
    }
}

echo "\nToplam " . $fixed . " şablon düzeltildi.\n";
echo "\nİşlem tamamlandı.\n";
?>