<?php
/**
 * WhatsApp Bildirim Sorunu Düzeltme Aracı
 * Bu araç hatalı kodları onarır ve notification_log tablosunu oluşturur
 * Bozuk olan tüm logları da temizler
 * 
 * Ayrıca trim(), strftime() ve tanımsız değişken hatalarını da giderir
 */

// Hata raporlama
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// DB bağlantısı
require_once __DIR__ . '/db.php';

echo "<html><body style='font-family: Arial, sans-serif; max-width: 800px; margin: 0 auto; padding: 20px;'>";
echo "<h1>WhatsApp Bildirimi Sorun Giderici</h1>";

echo "<div style='background: #f5f5f5; padding: 15px; border-radius: 5px; margin-bottom: 20px;'>";
echo "<h2>1. notification_log tablosu kontrolü</h2>";

try {
    $table_check = $DB->query("SHOW TABLES LIKE 'notification_log'");
    if ($table_check->rowCount() == 0) {
        echo "<p>notification_log tablosu bulunamadı. Oluşturuluyor...</p>";
        
        $DB->exec("CREATE TABLE IF NOT EXISTS notification_log (
            id INT AUTO_INCREMENT PRIMARY KEY,
            appointment_id INT NOT NULL,
            phone VARCHAR(20) NOT NULL,
            notification_type VARCHAR(20) NOT NULL,
            sent_at DATETIME NOT NULL,
            success TINYINT(1) DEFAULT 1
        )");
        
        echo "<p style='color: green;'>notification_log tablosu başarıyla oluşturuldu!</p>";
    } else {
        echo "<p style='color: green;'>notification_log tablosu zaten mevcut.</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Hata: " . $e->getMessage() . "</p>";
}
echo "</div>";

echo "<div style='background: #f5f5f5; padding: 15px; border-radius: 5px; margin-bottom: 20px;'>";
echo "<h2>2. notification_settings tablosu kontrolü</h2>";

try {
    $template_check = $DB->query("SELECT id FROM notification_settings WHERE id = 8");
    if ($template_check->rowCount() == 0) {
        echo "<p>Çalışan bildirimi (ID: 8) bulunamadı. Oluşturuluyor...</p>";
        
        $DB->exec("INSERT INTO notification_settings (id, name, description, type, template, status)
        VALUES (
            8, 
            'Çalışan Bildirim', 
            'Randevu alındığında çalışana gönderilecek bildirim',
            'whatsapp', 
            'Sayın {calisan}, {uyeAdi} adlı müşteri tarafından {tarih} tarihinde saat {saat} için {hizmet} randevusu alınmıştır. İyi çalışmalar dileriz.',
            1
        )");
        
        echo "<p style='color: green;'>Çalışan bildirimi şablonu oluşturuldu!</p>";
    } else {
        echo "<p style='color: green;'>Çalışan bildirimi şablonu zaten mevcut.</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Hata: " . $e->getMessage() . "</p>";
}
echo "</div>";

echo "<div style='background: #f5f5f5; padding: 15px; border-radius: 5px; margin-bottom: 20px;'>";
echo "<h2>3. Tarih formatı sorunu çözülüyor</h2>";

// Tarih formatı düzeltme dosyasını kontrol et
$date_fix_file = __DIR__ . '/eral_date_fix.php';
if (file_exists($date_fix_file)) {
    echo "<p style='color: green;'>Tarih düzeltme dosyası mevcut.</p>";
} else {
    // eral_date_fix.php dosyasını oluştur
    $date_fix_content = '<?php
/**
 * strftime Fonksiyonu Yerine Geçecek Fonksiyon
 * 
 * PHP 8.1\'de kaldırılan strftime fonksiyonu yerine IntlDateFormatter kullanımı için 
 * yardımcı fonksiyon
 * 
 * Bu kodu eral.php\'nin başında include edin
 */

if (!function_exists(\'formatTurkishDate\')) {
    /**
     * Tarihi Türkçe formatta biçimlendirir
     * 
     * @param string $dateString Tarih string\'i (strtotime uyumlu)
     * @param string $format Format (Varsayılan: d MMMM Y EEEE)
     * @return string Biçimlendirilmiş tarih
     */
    function formatTurkishDate($dateString, $format = \' d MMMM Y EEEE \') {
        setlocale(LC_TIME, \'tr_TR.UTF-8\', \'tr_TR\', \'tr\', \'turkish\');
        
        try {
            $dateObj = new DateTime($dateString);
            
            $fmt = new IntlDateFormatter(
                \'tr_TR\',
                IntlDateFormatter::LONG,
                IntlDateFormatter::NONE,
                null,
                null,
                $format
            );
            
            return $fmt->format($dateObj);
        } catch (Exception $e) {
            // Hata durumunda orjinal string\'i dön
            return $dateString;
        }
    }
}
?>';
    
    file_put_contents($date_fix_file, $date_fix_content);
    echo "<p style='color: green;'>Tarih düzeltme dosyası oluşturuldu.</p>";
}

// Tarih düzeltme dosyasını eral.php'ye ekle
$eral_file = __DIR__ . '/eral.php';
$eral_content = file_get_contents($eral_file);

if (strpos($eral_content, 'eral_date_fix.php') === false) {
    // Dosya içeriğine require ekle
    $eral_content = str_replace("<?php", "<?php\n// Tarih düzeltme dosyası\nrequire_once __DIR__ . '/eral_date_fix.php';", $eral_content);
    file_put_contents($eral_file, $eral_content);
    echo "<p style='color: green;'>eral.php dosyasına tarih düzeltme kodu eklendi.</p>";
} else {
    echo "<p style='color: green;'>eral.php dosyasında tarih düzeltme kodu zaten ekliydi.</p>";
}

echo "</div>";

echo "<div style='background: #f5f5f5; padding: 15px; border-radius: 5px; margin-bottom: 20px;'>";
echo "<h2>4. Log dosyaları temizleniyor</h2>";

$whatsapp_log = $_SERVER['DOCUMENT_ROOT'] . '/whatsapp_debug.txt';
$randevu_debug = $_SERVER['DOCUMENT_ROOT'] . '/randevu_debug.txt';

if (file_exists($whatsapp_log)) {
    file_put_contents($whatsapp_log, "--- Log temizlendi: " . date('Y-m-d H:i:s') . " ---\n");
    echo "<p>WhatsApp log dosyası temizlendi</p>";
}

if (file_exists($randevu_debug)) {
    file_put_contents($randevu_debug, "--- Log temizlendi: " . date('Y-m-d H:i:s') . " ---\n");
    echo "<p>Randevu debug log dosyası temizlendi</p>";
}

echo "</div>";

echo "<div style='background: #f5f5f5; padding: 15px; border-radius: 5px; margin-bottom: 20px;'>";
echo "<h2>7. AvailableTimeAjax Düzeltmesi</h2>";

// explode hatası
$ajax_time_file = $_SERVER['DOCUMENT_ROOT'] . '/admin/system/ajax/AvailableTimeAjax.php';
echo "<p>AvailableTimeAjax.php dosyası düzeltiliyor:</p>";
echo "<ul>";

if (file_exists($ajax_time_file)) {
    $ajax_time_content = file_get_contents($ajax_time_file);
    $ajax_time_content = str_replace('$breakTime = explode(",", $breakTime);', 
                                    '// breakTime null veya boş olabilir, kontrol et
    if (!empty($breakTime)) {
        $breakTime = explode(",", $breakTime);
    } else {
        // Boş veya null ise boş dizi oluştur
        $breakTime = [];
    }', $ajax_time_content, $count_explode);
    
    if ($count_explode > 0) {
        file_put_contents($ajax_time_file, $ajax_time_content);
        echo "<li style='color: green;'>✓ AvailableTimeAjax.php dosyasında explode hatası düzeltildi</li>";
    } else {
        echo "<li style='color: blue;'>✓ AvailableTimeAjax.php dosyası zaten düzeltilmiş!</li>";
    }
} else {
    echo "<li style='color: orange;'>⚠ AvailableTimeAjax.php dosyası bulunamadı</li>";
}

echo "</ul>";
echo "</div>";

echo "<div style='background: #f0f8ff; padding: 15px; border-radius: 5px; border: 1px solid #c0d6e4;'>";
echo "<h2>İşlem Tamamlandı</h2>";
echo "<p>Tüm işlemler başarıyla tamamlandı. Artık WhatsApp bildirimleri ve diğer sorunlar giderildi.</p>";
echo "<p>Düzeltilen Sorunlar:</p>";
echo "<ol>";
echo "<li>WhatsApp bildirim tekrarlama sorunu</li>";
echo "<li>notification_log tablosu eksikliği</li>";
echo "<li>Çalışan bildirim şablonu eksikliği</li>";
echo "<li>strftime fonksiyonu kullanımı</li>";
echo "<li>Session başlatma hataları</li>";
echo "<li>Değişken tanımlama hataları</li>";
echo "<li>explode() null parametre hatası</li>";
echo "</ol>";
echo "<p>Bir sorunla karşılaşırsanız, lütfen yöneticinize bildirin.</p>";
echo "</div>";

echo "<div style='background: #f5f5f5; padding: 15px; border-radius: 5px; margin-bottom: 20px;'>";
echo "<h2>5. Session Başlatma Hatalarını Düzeltme</h2>";

// Session start hatalarını düzelt
echo "<p>Session başlatma kontrolü ekleniyor:</p>";
echo "<ul>";

// Session_start kontrollerini ekle
$session_fixes = array();

$login_check_file = $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/LoginCheck.php';
if (file_exists($login_check_file)) {
    $lc_content = file_get_contents($login_check_file);
    $lc_content = str_replace('session_start();', 
                            '// Oturumu başlat eğer başlamamışsa
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}', $lc_content, $count_lc);
    
    if ($count_lc > 0) {
        file_put_contents($login_check_file, $lc_content);
        $session_fixes[] = "LoginCheck.php dosyasında session_start kontrolü eklendi";
    }
}

$header_file = $_SERVER['DOCUMENT_ROOT'] . '/admin/system/includes/Header.php';
if (file_exists($header_file)) {
    $header_content = file_get_contents($header_file);
    $header_content = str_replace('session_start();', 
                                '// Oturumu başlat eğer başlamamışsa
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}', $header_content, $count_header);
    
    if ($count_header > 0) {
        file_put_contents($header_file, $header_content);
        $session_fixes[] = "Header.php dosyasında session_start kontrolü eklendi";
    }
}

foreach ($session_fixes as $fix) {
    echo "<li style='color: green;'>✓ " . $fix . "</li>";
}

if (count($session_fixes) == 0) {
    echo "<li style='color: blue;'>✓ Tüm session kontrolleri zaten düzeltilmiş!</li>";
}

echo "</ul>";
echo "</div>";

echo "<div style='background: #f5f5f5; padding: 15px; border-radius: 5px; margin-bottom: 20px;'>";
echo "<h2>6. Değişken Hatalarını Düzeltme</h2>";

// Trim ve değişken hatalarını düzelt
echo "<p>Trim() ve undefined değişken hatalarını düzeltme:</p>";
echo "<ul>";

// $_POST değişkenlerindeki isset kontrollerini ekle
$fixed_files = array();
if (file_exists($eral_file)) {
    $content = file_get_contents($eral_file);
    
    // musteri, musteriMail ve note için isset kontrolü ekle
    $content = str_replace('$musteri = htmlspecialchars(trim($_POST[\'musteri\']));', 
                         '$musteri = isset($_POST[\'musteri\']) ? htmlspecialchars(trim($_POST[\'musteri\'])) : "";', 
                         $content, $count1);
    if ($count1 > 0) $fixed_files[] = "musteri değişkeni düzeltildi";
    
    $content = str_replace('$musteriMail = htmlspecialchars(trim($_POST[\'musteriMail\']));', 
                         '$musteriMail = isset($_POST[\'musteriMail\']) ? htmlspecialchars(trim($_POST[\'musteriMail\'])) : "";', 
                         $content, $count2);
    if ($count2 > 0) $fixed_files[] = "musteriMail değişkeni düzeltildi";
    
    $content = str_replace('$note = htmlspecialchars(trim($_POST[\'note\']));', 
                         '$note = isset($_POST[\'note\']) ? htmlspecialchars(trim($_POST[\'note\'])) : "";', 
                         $content, $count3);
    if ($count3 > 0) $fixed_files[] = "note değişkeni düzeltildi";
    
    // Telefon formatı düzeltmesi
    $content = str_replace('if (isset($whatsapp_log_file) && isset($_phone) && isset($phone))', 
                         'if (isset($whatsapp_log_file) && isset($phone))', 
                         $content, $count4);
    if ($count4 > 0) $fixed_files[] = "telefon formatı kontrolü düzeltildi";
    
    // message değişkeni kontrolü
    $content = str_replace('$body = array(
  "api_key" => $settings[\'whatsappApiKey\'],
  "receiver" => $phone,
  "data" => array("message" => $message)
  );', 
                        '// $message değişkeni tanımlı değilse boş string ataması yap
  if (!isset($message)) {
      $message = "";
  }
  
  $body = array(
      "api_key" => $settings[\'whatsappApiKey\'],
      "receiver" => $phone,
      "data" => array("message" => $message)
  );', 
                        $content, $count6);
    if ($count6 > 0) $fixed_files[] = "message değişkeni düzeltildi";
    
    // source değişkeni kontrolü ekle
    $content = str_replace('$source .= \'<mesaj>', 
                         'if (!isset($source)) $source = \'\'; $source .= \'<mesaj>', 
                         $content, $count5);
    if ($count5 > 0) $fixed_files[] = "source değişkeni düzeltildi";
    
    // explode hata düzeltmesi - AvailableTimeAjax.php dosyası için
    $ajax_file = $_SERVER['DOCUMENT_ROOT'] . '/admin/system/ajax/AvailableTimeAjax.php';
    if (file_exists($ajax_file)) {
        $ajax_content = file_get_contents($ajax_file);
        $ajax_content = str_replace('$breakTime = explode(",", $breakTime);', 
                                    '// breakTime null veya boş olabilir, kontrol et
    if (!empty($breakTime)) {
        $breakTime = explode(",", $breakTime);
    } else {
        // Boş veya null ise boş dizi oluştur
        $breakTime = [];
    }', $ajax_content, $count7);
        
        if ($count7 > 0) {
            file_put_contents($ajax_file, $ajax_content);
            $fixed_files[] = "AvailableTimeAjax.php explode hatası düzeltildi";
        }
    }
    
    // Dosyayı güncelle
    file_put_contents($eral_file, $content);
    
    foreach ($fixed_files as $fixed) {
        echo "<li style='color: green;'>✓ " . $fixed . "</li>";
    }
    
    if (count($fixed_files) == 0) {
        echo "<li style='color: blue;'>✓ Tüm değişkenler zaten düzeltilmiş!</li>";
    }
} else {
    echo "<li style='color: red;'>✗ eral.php dosyası bulunamadı</li>";
}

echo "</ul>";
echo "</div>";

echo "<div style='margin-top: 30px; text-align: center;'>";
echo "<a href='/admin' style='background: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Yönetici Paneline Dön</a>";
echo "</div>";

echo "</body></html>";
?>