<?php
/**
 * Notification Log Temizleme Programı
 * Bu dosya CRON ile çalıştırılarak 30 günden eski log kayıtlarını temizler
 */

// Veritabanı bağlantısı
if (file_exists(__DIR__ . '/db.php')) {
    require_once __DIR__ . '/db.php';
} else {
    die("Veritabanı bağlantı dosyası bulunamadı!");
}

// Log dosyası
$log_file = $_SERVER['DOCUMENT_ROOT'] . '/notification_log_cleanup.log';
file_put_contents($log_file, date('Y-m-d H:i:s') . " - Temizleme işlemi başlatıldı\n", FILE_APPEND);

// 30 günden eski kayıtları temizle
try {
    $stmt = $DB->prepare("DELETE FROM notification_log WHERE sent_at < DATE_SUB(NOW(), INTERVAL 30 DAY)");
    $stmt->execute();
    $deleted_count = $stmt->rowCount();

    file_put_contents($log_file, "Toplam " . $deleted_count . " eski kayıt temizlendi\n", FILE_APPEND);

    // İstatistik kayıtları oluştur
    $stats_query = $DB->query("SELECT
        COUNT(*) as total,
        SUM(CASE WHEN success = 1 THEN 1 ELSE 0 END) as successful,
        SUM(CASE WHEN success = 0 THEN 1 ELSE 0 END) as failed,
        COUNT(DISTINCT phone) as unique_phones,
        COUNT(DISTINCT appointment_id) as unique_appointments
    FROM notification_log");

    $stats = $stats_query->fetch(PDO::FETCH_ASSOC);

    file_put_contents($log_file, "Kalan kayıt istatistikleri:\n", FILE_APPEND);
    file_put_contents($log_file, "Toplam kayıt: " . $stats['total'] . "\n", FILE_APPEND);
    file_put_contents($log_file, "Başarılı: " . $stats['successful'] . "\n", FILE_APPEND);
    file_put_contents($log_file, "Başarısız: " . $stats['failed'] . "\n", FILE_APPEND);
    file_put_contents($log_file, "Benzersiz telefon: " . $stats['unique_phones'] . "\n", FILE_APPEND);
    file_put_contents($log_file, "Benzersiz randevu: " . $stats['unique_appointments'] . "\n", FILE_APPEND);

    // Notification_log tablosunu optimize et
    $DB->exec("OPTIMIZE TABLE notification_log");
    file_put_contents($log_file, "Tablo optimize edildi\n", FILE_APPEND);

} catch (Exception $e) {
    file_put_contents($log_file, "HATA: " . $e->getMessage() . "\n", FILE_APPEND);
}

file_put_contents($log_file, date('Y-m-d H:i:s') . " - Temizleme işlemi tamamlandı\n\n", FILE_APPEND);

echo "İşlem tamamlandı. Log dosyası: " . $log_file;
