<?php
// Özel Günler ile ilgili işlemler

// Doğrudan çağrıldıysa db dosyasını dahil et
if (!isset($DB) || $DB === null) {
    require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
}

// Özel gün ekleme
if (isset($_POST['specialDayAdd'])) {
    // Debug dosyası ve dizini
    $log_dir = $_SERVER['DOCUMENT_ROOT'] . '/admin/specialDays_log';
    if (!is_dir($log_dir)) {
        mkdir($log_dir, 0777, true);
    }
    $debug_log_file = $log_dir . '/debug.txt';
    
    // Başlangıç bilgisini yaz
    file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - specialDayAdd çağrıldı\n", FILE_APPEND);
    file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - POST verileri: " . print_r($_POST, true) . "\n", FILE_APPEND);
    
    // Sistem loglarına da yaz
    error_log("specialDayAdd - POST verileri: " . json_encode($_POST));
    
    // Sunucu ortam bilgilerini logla
    file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Sunucu bilgileri: " . print_r($_SERVER, true) . "\n", FILE_APPEND);
    
    // Başlangıç yanıtı
    echo "BAŞLADI:";
    
    // Veritabanı bağlantısını kontrol et ve bağlanmaya çalış
    if (!isset($DB) || $DB === null) {
        // Veritabanı bağlantısını yeniden oluştur
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Veritabanı bağlantısı kuruluyor...\n", FILE_APPEND);
        require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
        if (!isset($DB) || $DB === null) {
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Veritabanı bağlantısı BAŞARISIZ!\n", FILE_APPEND);
            error_log("specialDayAdd - Veritabanı bağlantısı kurulamadı");
            echo "HATA:Veritabanı bağlantısı kurulamadı";
            exit;
        }
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Veritabanı bağlantısı BAŞARILI\n", FILE_APPEND);
    }
    
    try {
        // Gelen parametrelerin detaylı dökümünü yap
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - POST parametreleri: " . print_r($_POST, true) . "\n", FILE_APPEND);
        
        // Gelen parametreleri kontrol et
        $requiredParams = ['title', 'start_date', 'end_date', 'start_time', 'end_time'];
        $missingParams = [];
        
        foreach ($requiredParams as $param) {
            if (!isset($_POST[$param]) || empty($_POST[$param])) {
                $missingParams[] = $param;
            }
        }
        
        if (!empty($missingParams)) {
            $errorMsg = "Eksik parametreler: " . implode(", ", $missingParams);
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - " . $errorMsg . "\n", FILE_APPEND);
            error_log("specialDayAdd - " . $errorMsg);
            echo 'HATA:' . $errorMsg;
            exit;
        }
        
        $title = htmlspecialchars(trim($_POST['title']));
        $description = htmlspecialchars(trim($_POST['description'] ?? ''));
        $start_date = $_POST['start_date'];
        $end_date = $_POST['end_date'];
        $start_time = $_POST['start_time'];
        $end_time = $_POST['end_time'];
        $status = isset($_POST['status']) ? intval($_POST['status']) : 0;
        
        // Yeni eklemeler - varsayılan değerler ile
        $repeat_type = isset($_POST['repeat_type']) ? $_POST['repeat_type'] : 'none';
        $repeat_interval = isset($_POST['repeat_interval']) ? intval($_POST['repeat_interval']) : 1;
        $repeat_until = isset($_POST['repeat_until']) && !empty($_POST['repeat_until']) ? $_POST['repeat_until'] : null;
        $category = isset($_POST['category']) ? $_POST['category'] : 'default';
        $color = isset($_POST['color']) ? $_POST['color'] : '#7367f0';

        // Verileri loglayalım
        error_log("specialDayAdd - İşlenecek veriler: " . json_encode([
            'title' => $title,
            'start_date' => $start_date,
            'end_date' => $end_date,
            'start_time' => $start_time,
            'end_time' => $end_time,
            'status' => $status,
            'repeat_type' => $repeat_type,
            'repeat_interval' => $repeat_interval,
            'category' => $category,
            'color' => $color
        ]));

        // special_days tablosunun var olup olmadığını kontrol et
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Veritabanı tabloları kontrol ediliyor\n", FILE_APPEND);
    
        $checkTable = $DB->query("SHOW TABLES LIKE 'special_days'");
        $tableExists = ($checkTable->rowCount() > 0);
        
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - special_days tablosu var mı: " . ($tableExists ? "EVET" : "HAYIR") . "\n", FILE_APPEND);
        
        if (!$tableExists) {
            // Tablo yoksa oluşturalım
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - special_days tablosu oluşturuluyor...\n", FILE_APPEND);
            
            $createTableSQL = "CREATE TABLE IF NOT EXISTS `special_days` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `title` varchar(255) NOT NULL,
                `description` text DEFAULT NULL,
                `start_date` date NOT NULL,
                `end_date` date NOT NULL,
                `start_time` varchar(5) NOT NULL,
                `end_time` varchar(5) NOT NULL,
                `status` tinyint(1) NOT NULL DEFAULT 1,
                `repeat_type` enum('none','daily','weekly','monthly','yearly') DEFAULT 'none',
                `repeat_interval` int(11) DEFAULT 1,
                `repeat_until` date DEFAULT NULL,
                `category` varchar(50) DEFAULT 'default',
                `color` varchar(20) DEFAULT '#7367f0',
                `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
            
            $result = $DB->exec($createTableSQL);
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Tablo oluşturma sonucu: " . ($result !== false ? "BAŞARILI" : "BAŞARISIZ") . "\n", FILE_APPEND);
            
            if ($result === false) {
                $errorInfo = $DB->errorInfo();
                file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Tablo oluşturma hatası: " . implode(', ', $errorInfo) . "\n", FILE_APPEND);
                error_log("specialDayAdd - Tablo oluşturma hatası: " . implode(', ', $errorInfo));
                echo 'ERROR: Veritabanı tablosu oluşturulamadı: ' . implode(', ', $errorInfo);
                exit;
            }
        }
        
        // SQL sorgusunu oluştur ve çalıştır
        $stmt = $DB->prepare("INSERT INTO special_days (title, description, start_date, end_date, start_time, end_time, status, repeat_type, repeat_interval, repeat_until, category, color) 
                            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $result = $stmt->execute([
            $title, $description, $start_date, $end_date, $start_time, $end_time, $status, 
            $repeat_type, $repeat_interval, $repeat_until, $category, $color
        ]);
        
        if ($result) {
            $last_id = $DB->lastInsertId();
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Kayıt BAŞARILI. Yeni ID: " . $last_id . "\n", FILE_APPEND);
            error_log("specialDayAdd - Kayıt başarılı. ID: " . $last_id);
            
            // Başarı sonucunu kaydet
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Başarılı yanıt gönderiliyor: BAŞARILI:OK\n", FILE_APPEND);
            
            // Basit başarı yanıtı dön - önce eski format için OK, sonra yeni format için BAŞARILI:OK desteği ekle
            echo "OK";
        } else {
            $errorInfo = $stmt->errorInfo();
            $error_msg = implode(', ', $errorInfo);
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - SQL Hatası: " . $error_msg . "\n", FILE_APPEND);
            error_log("specialDayAdd - SQL Hatası: " . $error_msg);
            
            // Hata sonucunu kaydet
            file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Hata yanıtı gönderiliyor: HATA:" . $error_msg . "\n", FILE_APPEND);
            
            echo 'HATA:Veritabanı hatası: ' . $error_msg;
        }
    } catch (PDOException $e) {
        $error_msg = $e->getMessage();
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - PDOException: " . $error_msg . "\n", FILE_APPEND);
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Hata izi: " . $e->getTraceAsString() . "\n", FILE_APPEND);
        error_log("specialDayAdd - PDOException: " . $error_msg);
        echo 'HATA:' . $error_msg;
    } catch (Exception $e) {
        $error_msg = $e->getMessage();
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Exception: " . $error_msg . "\n", FILE_APPEND);
        file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - Hata izi: " . $e->getTraceAsString() . "\n", FILE_APPEND);
        error_log("specialDayAdd - Exception: " . $error_msg);
        echo 'HATA:' . $error_msg;
    }
    
    // Debug dosyasına süreç tamamlandı bilgisi ekle
    file_put_contents($debug_log_file, date('Y-m-d H:i:s') . " - specialDayAdd işlemi tamamlandı\n", FILE_APPEND);
    file_put_contents($debug_log_file, "-------------- İşlem Sonu --------------\n\n", FILE_APPEND);
    exit;
}

// Özel gün güncelleme
if (isset($_POST['specialDayEdit'])) {
    // SpecialDays.php direkt çağrıldı işareti
    $directCalled = true;
    
    // Başlangıç mesajı yazdır
    echo "BAŞLADI:";
    
    // Tüm hataları göster
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
    
    // Veritabanı bağlantısını kontrol et ve bağlanmaya çalış
    if (!isset($DB) || $DB === null) {
        // Veritabanı bağlantısını yeniden oluştur
        require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
        if (!isset($DB) || $DB === null) {
            echo "HATA:Veritabanı bağlantısı kurulamadı";
            exit;
        }
    }
    
    // Tüm POST verilerini logla
    error_log("specialDays.php - POST verileri: " . json_encode($_POST));
    
    // Debug log dosyasını hazırla
    $logDir = $_SERVER['DOCUMENT_ROOT'] . '/admin/system/logs';
    if (!file_exists($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    $logFile = $logDir . '/special_day_debug.log';
    file_put_contents($logFile, 
        date('Y-m-d H:i:s') . ' - Özel gün güncelleme işlemi başlatıldı' . "\n" . 
        'POST: ' . print_r($_POST, true) . "\n" .
        'Veritabanı bağlantısı: ' . (isset($DB) ? 'BAŞARILI' : 'BAŞARISIZ') . "\n", 
        FILE_APPEND);
    
    // Content type'ı düz text olarak ayarla
    header('Content-Type: text/plain; charset=utf-8');
    
    try {
        file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Parametreler kontrol ediliyor' . "\n", FILE_APPEND);
        
        // Gelen parametreleri kontrol et
        if (!isset($_POST['id']) || !isset($_POST['title']) || !isset($_POST['start_date']) || 
            !isset($_POST['end_date']) || !isset($_POST['start_time']) || !isset($_POST['end_time'])) {
            file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Eksik parametreler tespit edildi' . "\n", FILE_APPEND);
            echo 'HATA:Gerekli parametreler eksik';
            exit;
        }
        
        $id = $_POST['id'];
        $title = htmlspecialchars(trim($_POST['title']));
        $description = htmlspecialchars(trim($_POST['description'] ?? ''));
        $start_date = $_POST['start_date'];
        $end_date = $_POST['end_date'];
        $start_time = $_POST['start_time'];
        $end_time = $_POST['end_time'];
        $status = isset($_POST['status']) ? $_POST['status'] : 0;
        
        // Yeni eklemeler - varsayılan değerler ile
        $repeat_type = isset($_POST['repeat_type']) ? $_POST['repeat_type'] : 'none';
        $repeat_interval = isset($_POST['repeat_interval']) ? intval($_POST['repeat_interval']) : 1;
        $repeat_until = isset($_POST['repeat_until']) && !empty($_POST['repeat_until']) ? $_POST['repeat_until'] : null;
        $category = isset($_POST['category']) ? $_POST['category'] : 'default';
        $color = isset($_POST['color']) ? $_POST['color'] : '#7367f0';

        file_put_contents($logFile, 
            date('Y-m-d H:i:s') . ' - Parametreler alındı, ID: ' . $id . "\n" .
            'Tüm alanlar: ' . json_encode([
                'title' => $title,
                'start_date' => $start_date,
                'end_date' => $end_date,
                'start_time' => $start_time,
                'end_time' => $end_time,
                'status' => $status,
                'repeat_type' => $repeat_type,
                'repeat_interval' => $repeat_interval,
                'category' => $category,
                'color' => $color
            ]) . "\n", 
            FILE_APPEND);
        
        // special_days tablosunun var olup olmadığını kontrol et
        try {
            $checkTable = $DB->query("SHOW TABLES LIKE 'special_days'");
            if ($checkTable->rowCount() == 0) {
                file_put_contents($logFile, date('Y-m-d H:i:s') . ' - special_days tablosu bulunamadı!' . "\n", FILE_APPEND);
                ob_end_clean();
                echo 'ERROR: Veritabanı tablosu bulunamadı. Lütfen patch_special_days.php dosyasını çalıştırın.';
                exit;
            }
            
            // Tablodaki sütunları kontrol et
            $columnsCheck = $DB->query("SHOW COLUMNS FROM special_days");
            $columns = $columnsCheck->fetchAll(PDO::FETCH_COLUMN);
            file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Tablo sütunları: ' . implode(', ', $columns) . "\n", FILE_APPEND);
            
            // Gerekli sütunların var olup olmadığını kontrol et
            $requiredColumns = ['id', 'title', 'start_date', 'end_date', 'start_time', 'end_time', 'status', 'repeat_type', 'repeat_interval', 'category', 'color'];
            $missingColumns = array_diff($requiredColumns, $columns);
            
            if (!empty($missingColumns)) {
                file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Eksik sütunlar: ' . implode(', ', $missingColumns) . "\n", FILE_APPEND);
                ob_end_clean();
                echo 'ERROR: Veritabanı tablosunda eksik sütunlar: ' . implode(', ', $missingColumns) . '. Lütfen patch_special_days_enhance.php dosyasını çalıştırın.';
                exit;
            }
        } catch (Exception $e) {
            file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Tablo kontrol hatası: ' . $e->getMessage() . "\n", FILE_APPEND);
            ob_end_clean();
            echo 'ERROR: Veritabanı tablo kontrolü sırasında hata: ' . $e->getMessage();
            exit;
        }
        
        // ID'nin geçerli olup olmadığını kontrol et
        $checkQuery = $DB->prepare("SELECT COUNT(*) FROM special_days WHERE id = ?");
        $checkQuery->execute([$id]);
        $count = $checkQuery->fetchColumn();
        file_put_contents($logFile, date('Y-m-d H:i:s') . ' - ID kontrolü: ' . $id . ', Sonuç: ' . $count . "\n", FILE_APPEND);
        
        if ($count == 0) {
            file_put_contents($logFile, date('Y-m-d H:i:s') . ' - ID bulunamadı: ' . $id . "\n", FILE_APPEND);
            ob_end_clean(); // Önceki çıktıları temizle
            echo 'ERROR: Belirtilen ID bulunamadı';
            exit;
        }
        
        file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Veritabanı güncelleme işlemi başlatılıyor' . "\n", FILE_APPEND);
        
        $stmt = $DB->prepare("UPDATE special_days SET 
                            title = ?, description = ?, start_date = ?, end_date = ?, 
                            start_time = ?, end_time = ?, status = ?, 
                            repeat_type = ?, repeat_interval = ?, repeat_until = ?, 
                            category = ?, color = ? 
                            WHERE id = ?");
        $result = $stmt->execute([
            $title, $description, $start_date, $end_date, 
            $start_time, $end_time, $status, 
            $repeat_type, $repeat_interval, $repeat_until, 
            $category, $color, $id
        ]);
        
        file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Güncelleme işlemi sonucu: ' . ($result ? 'Başarılı' : 'Başarısız') . "\n", FILE_APPEND);
        
        if ($result) {
            file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Başarılı yanıt gönderiliyor: OK' . "\n", FILE_APPEND);
            echo "BAŞARILI:OK"; // Prefix ile yanıt
            file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Başarılı yanıt gönderildi: BAŞARILI:OK' . "\n", FILE_APPEND);
            
            // Debug dosyasına da yaz
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/admin/specialDays_success.txt', 
                date('Y-m-d H:i:s') . " - Başarılı güncelleme (ID: $id)\n", FILE_APPEND);
        } else {
            $errorInfo = $stmt->errorInfo();
            file_put_contents($logFile, date('Y-m-d H:i:s') . ' - SQL Hatası: ' . implode(', ', $errorInfo) . "\n", FILE_APPEND);
            echo "HATA:Veritabanı güncelleme hatası"; // Prefix ile yanıt
            file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Hata yanıtı gönderildi: HATA:Veritabanı güncelleme hatası' . "\n", FILE_APPEND);
            
            // Debug dosyasına hata bilgisi yaz
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/admin/specialDays_error.txt', 
                date('Y-m-d H:i:s') . " - Veritabanı hatası: " . implode(', ', $errorInfo) . "\n", FILE_APPEND);
        }
    } catch (PDOException $e) {
        file_put_contents($logFile, date('Y-m-d H:i:s') . ' - PDOException: ' . $e->getMessage() . "\n" . $e->getTraceAsString() . "\n", FILE_APPEND);
        echo "HATA:" . $e->getMessage();
        file_put_contents($logFile, date('Y-m-d H:i:s') . ' - PDO Hata yanıtı gönderildi' . "\n", FILE_APPEND);
    } catch (Exception $e) {
        file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Exception: ' . $e->getMessage() . "\n" . $e->getTraceAsString() . "\n", FILE_APPEND);
        echo "HATA:" . $e->getMessage();
        file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Exception Hata yanıtı gönderildi' . "\n", FILE_APPEND);
    }
    
    exit;
}

// Özel gün silme
if (isset($_POST['specialDayDelete'])) {
    // Yanıt header'ları
    header('Content-Type: text/plain; charset=utf-8');
    ob_start(); // Çıktı tamponlamasını başlat
    
    // Debug dosyası
    $logDir = $_SERVER['DOCUMENT_ROOT'] . '/admin/specialDays_log/';
    if (!is_dir($logDir)) {
        mkdir($logDir, 0777, true);
    }
    $debug_log_file = $logDir . 'debug.txt';
    
    // Debug mesajı yazma
    $debugTime = date('Y-m-d H:i:s');
    file_put_contents($debug_log_file, "\n{$debugTime} - specialDayDelete başlatıldı", FILE_APPEND);
    file_put_contents($debug_log_file, "\n{$debugTime} - POST verileri: " . print_r($_POST, true), FILE_APPEND);
    
    // ID kontrolü
    if (!isset($_POST['id'])) {
        file_put_contents($debug_log_file, "\n{$debugTime} - Hata: ID parametresi eksik", FILE_APPEND);
        ob_end_clean(); // Tamponlamayı temizle
        echo 'ERROR: ID parametresi eksik';
        exit;
    }
    
    // Boş ID kontrolü
    if (empty($_POST['id']) || !is_numeric($_POST['id'])) {
        file_put_contents($debug_log_file, "\n{$debugTime} - Hata: ID parametresi geçersiz veya sayısal değil", FILE_APPEND);
        ob_end_clean(); // Tamponlamayı temizle
        echo 'ERROR: ID parametresi geçersiz veya sayısal değil';
        exit;
    }
    
    $id = intval($_POST['id']);
    file_put_contents($debug_log_file, "\n{$debugTime} - Silinecek ID: " . $id, FILE_APPEND);
    
    // Veritabanı bağlantısı kontrolü
    if (!isset($DB) || $DB === null) {
        file_put_contents($debug_log_file, "\n{$debugTime} - DB yeniden yükleniyor", FILE_APPEND);
        try {
            require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
        } catch (Exception $e) {
            file_put_contents($debug_log_file, "\n{$debugTime} - DB yükleme hatası: " . $e->getMessage(), FILE_APPEND);
            ob_end_clean(); // Tamponlamayı temizle
            echo 'ERROR: Veritabanı bağlantı dosyası yüklenemedi';
            exit;
        }
        
        if (!isset($DB) || $DB === null) {
            file_put_contents($debug_log_file, "\n{$debugTime} - DB bağlantısı kurulamadı", FILE_APPEND);
            ob_end_clean(); // Tamponlamayı temizle
            echo 'ERROR: Veritabanı bağlantısı kurulamadı';
            exit;
        }
    }

    try {
        // Tablo varlık kontrolü
        try {
            $tableCheck = $DB->query("SHOW TABLES LIKE 'special_days'");
            if ($tableCheck->rowCount() == 0) {
                file_put_contents($debug_log_file, "\n{$debugTime} - Hata: special_days tablosu yok", FILE_APPEND);
                ob_end_clean(); // Tamponlamayı temizle
                echo 'ERROR: Özel günler tablosu bulunamadı';
                exit;
            }
        } catch (Exception $e) {
            file_put_contents($debug_log_file, "\n{$debugTime} - Tablo kontrolü hatası: " . $e->getMessage(), FILE_APPEND);
            ob_end_clean(); // Tamponlamayı temizle
            echo 'ERROR: Tablo kontrolü sırasında hata: ' . $e->getMessage();
            exit;
        }
        
        // Önce kayıt var mı kontrol et
        $checkStmt = $DB->prepare("SELECT COUNT(*) FROM special_days WHERE id = ?");
        $checkStmt->execute([$id]);
        $recordExists = $checkStmt->fetchColumn();
        
        file_put_contents($debug_log_file, "\n{$debugTime} - Kayıt kontrolü: " . ($recordExists ? "MEVCUT" : "YOK"), FILE_APPEND);
        
        if (!$recordExists) {
            file_put_contents($debug_log_file, "\n{$debugTime} - Hata: ID bulunamadı", FILE_APPEND);
            ob_end_clean(); // Tamponlamayı temizle
            echo 'ERROR: Belirtilen ID ile kayıt bulunamadı';
            exit;
        }
        
        // Silme işlemi
        $stmt = $DB->prepare("DELETE FROM special_days WHERE id = ?");
        $result = $stmt->execute([$id]);
        
        file_put_contents($debug_log_file, "\n{$debugTime} - Silme işlemi sonucu: " . ($result ? "BAŞARILI" : "BAŞARISIZ"), FILE_APPEND);
        
        if ($result) {
            // Silinen satır sayısını kontrol et
            $rowCount = $stmt->rowCount();
            file_put_contents($debug_log_file, "\n{$debugTime} - Silinen satır sayısı: " . $rowCount, FILE_APPEND);
            
            if ($rowCount > 0) {
                // Başarılı silme işlemi
                file_put_contents($debug_log_file, "\n{$debugTime} - Başarılı yanıt gönderiliyor: OK", FILE_APPEND);
                ob_end_clean(); // Tamponlamayı temizle
                echo 'OK';
            } else {
                // İşlem başarılı ama satır etkilenmemiş
                file_put_contents($debug_log_file, "\n{$debugTime} - Uyarı: Kayıt bulunamadı veya değişmedi", FILE_APPEND);
                ob_end_clean(); // Tamponlamayı temizle
                echo 'ERROR: Kayıt bulunamadı veya değişmedi';
            }
        } else {
            // SQL hatası
            $errorInfo = $stmt->errorInfo();
            $errorMsg = implode(', ', $errorInfo);
            file_put_contents($debug_log_file, "\n{$debugTime} - SQL Hatası: " . $errorMsg, FILE_APPEND);
            ob_end_clean(); // Tamponlamayı temizle
            echo 'ERROR: Veritabanı hatası: ' . $errorMsg;
        }
    } catch (PDOException $e) {
        // PDO hatası
        $errorMsg = $e->getMessage();
        file_put_contents($debug_log_file, "\n{$debugTime} - PDOException: " . $errorMsg . "\n" . $e->getTraceAsString(), FILE_APPEND);
        ob_end_clean(); // Tamponlamayı temizle
        echo 'ERROR: ' . $errorMsg;
    } catch (Exception $e) {
        // Genel hata
        $errorMsg = $e->getMessage();
        file_put_contents($debug_log_file, "\n{$debugTime} - Exception: " . $errorMsg . "\n" . $e->getTraceAsString(), FILE_APPEND);
        ob_end_clean(); // Tamponlamayı temizle
        echo 'ERROR: ' . $errorMsg;
    }
    
    // İşlemi tamamla
    file_put_contents($debug_log_file, "\n{$debugTime} - specialDayDelete tamamlandı", FILE_APPEND);
    file_put_contents($debug_log_file, "\n------------------------------------------\n", FILE_APPEND);
    exit;
}

// Özel gün tarihlerini güncelle (takvimden sürükle bırak)
if (isset($_POST['updateSpecialDayDates'])) {
    // İçerik tipini metin olarak ayarla
    header('Content-Type: text/plain; charset=utf-8');
    
    // Debug için logla
    error_log("updateSpecialDayDates - Tüm POST verileri: " . json_encode($_POST));
    
    // Başlangıç mesajı
    echo "BAŞLADI: Tarihleri güncelleme\n";
    
    // Parametre kontrolü
    if (!isset($_POST['id']) || empty($_POST['id']) || !is_numeric($_POST['id'])) {
        error_log("updateSpecialDayDates - ID parametresi geçersiz");
        echo 'ERROR: ID parametresi geçersiz';
        exit;
    }
    
    if (!isset($_POST['start_date']) || empty($_POST['start_date'])) {
        error_log("updateSpecialDayDates - start_date parametresi geçersiz");
        echo 'ERROR: Başlangıç tarihi parametresi geçersiz';
        exit;
    }
    
    if (!isset($_POST['end_date']) || empty($_POST['end_date'])) {
        error_log("updateSpecialDayDates - end_date parametresi geçersiz");
        echo 'ERROR: Bitiş tarihi parametresi geçersiz';
        exit;
    }
    
    $id = intval($_POST['id']);
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    
    try {
        // Tablo varlığı kontrolü
        $tableCheck = $DB->query("SHOW TABLES LIKE 'special_days'");
        if ($tableCheck->rowCount() == 0) {
            error_log("updateSpecialDayDates - special_days tablosu bulunamadı");
            echo 'ERROR: Özel günler tablosu bulunamadı';
            exit;
        }
        
        // Kaydın varlığını kontrol et
        $checkRecord = $DB->prepare("SELECT COUNT(*) as count FROM special_days WHERE id = ?");
        $checkRecord->execute([$id]);
        if ($checkRecord->fetch(PDO::FETCH_ASSOC)['count'] == 0) {
            error_log("updateSpecialDayDates - Kayıt bulunamadı. ID: " . $id);
            echo 'ERROR: Belirtilen ID ile kayıt bulunamadı';
            exit;
        }
        
        // Veritabanına gönderilen tarihleri logla
        error_log("updateSpecialDayDates - ID: $id, Başlangıç: $start_date, Bitiş: $end_date");
        
        $stmt = $DB->prepare("UPDATE special_days SET start_date = ?, end_date = ? WHERE id = ?");
        $result = $stmt->execute([$start_date, $end_date, $id]);
        
        if ($result) {
            error_log("updateSpecialDayDates - Tarih güncelleme başarılı. ID: " . $id);
            echo "OK\n";
            echo "Tarihler başarıyla güncellendi.";
        } else {
            $error = $stmt->errorInfo();
            error_log("updateSpecialDayDates - Güncelleme hatası: " . json_encode($error));
            echo 'ERROR: ' . ($error[2] ?? 'Bilinmeyen bir hata oluştu');
        }
    } catch (PDOException $e) {
        error_log("updateSpecialDayDates - PDO Hatası: " . $e->getMessage());
        echo 'ERROR: ' . $e->getMessage();
    } catch (Exception $e) {
        error_log("updateSpecialDayDates - Genel Hata: " . $e->getMessage());
        echo 'ERROR: ' . $e->getMessage();
    }
    exit;
}

// Özel günleri takvim için getir
if (isset($_GET['getSpecialDaysForCalendar'])) {
    try {
        $events = [];
        
        // Debug - veri alımı için loglama
        error_log("getSpecialDaysForCalendar - Takvim verisi isteniyor");
        
        // Önce özel günler tablosunun varlığını kontrol et
        try {
            $tableCheck = $DB->query("SHOW TABLES LIKE 'special_days'");
            if ($tableCheck->rowCount() == 0) {
                error_log("getSpecialDaysForCalendar - special_days tablosu bulunamadı");
                header('Content-Type: application/json');
                echo json_encode([]);
                exit;
            }
        } catch (Exception $e) {
            error_log("getSpecialDaysForCalendar - Tablo kontrolü hatası: " . $e->getMessage());
            header('Content-Type: application/json');
            echo json_encode([]);
            exit;
        }
        
        // Aktif özel günleri getir
        $specialDaysQuery = $DB->query("SELECT sd.*, sdc.name as category_name, sdc.color as category_color 
                                       FROM special_days sd 
                                       LEFT JOIN special_day_categories sdc ON sd.category = sdc.code
                                       ORDER BY sd.start_date ASC");
        
        error_log("getSpecialDaysForCalendar - Sorgu sonucu: " . $specialDaysQuery->rowCount() . " kayıt bulundu");
        
        while ($day = $specialDaysQuery->fetch(PDO::FETCH_ASSOC)) {
            // Tarih formatları
            $startDate = new DateTime($day['start_date']);
            $endDate = new DateTime($day['end_date']);
            $endDate->modify('+1 day'); // FullCalendar için bitiş günü dahil değil
            
            $formattedStartDate = $startDate->format('d.m.Y');
            $formattedEndDate = (new DateTime($day['end_date']))->format('d.m.Y');
            
            // Renk seçimi
            $color = !empty($day['color']) ? $day['color'] : 
                   (!empty($day['category_color']) ? $day['category_color'] : '#7367f0');
            
            // Her etkinlik için bilgi logla
            error_log("getSpecialDaysForCalendar - İşleniyor: ID=" . $day['id'] . ", Başlık=" . $day['title'] . ", Tarih=" . $day['start_date'] . " - " . $day['end_date']);
            
            // Önce tekrarlama durumunu kontrol et
            if (!empty($day['repeat_type']) && $day['repeat_type'] !== 'none') {
                // Tekrarlama sonu hesapla
                $repeatUntil = !empty($day['repeat_until']) ? new DateTime($day['repeat_until']) : null;
                
                // Tekrarlama tipi
                switch ($day['repeat_type']) {
                    case 'daily':
                        $recurringDef = 'days';
                        break;
                    case 'weekly':
                        $recurringDef = 'weeks';
                        break;
                    case 'monthly':
                        $recurringDef = 'months';
                        break;
                    case 'yearly':
                        $recurringDef = 'years';
                        break;
                    default:
                        $recurringDef = null;
                }
                
                if ($recurringDef) {
                    $events[] = [
                        'id' => 'special_day_' . $day['id'],
                        'title' => $day['title'],
                        'start' => $startDate->format('Y-m-d'),
                        'end' => $endDate->format('Y-m-d'),
                        'backgroundColor' => $color,
                        'borderColor' => $color,
                        'extendedProps' => [
                            'id' => $day['id'],
                            'description' => $day['description'],
                            'startTime' => $day['start_time'],
                            'endTime' => $day['end_time'],
                            'status' => $day['status'],
                            'category' => $day['category'],
                            'categoryName' => $day['category_name'] ?: 'Varsayılan',
                            'categoryColor' => $color,
                            'formattedStartDate' => $formattedStartDate,
                            'formattedEndDate' => $formattedEndDate,
                            'repeatType' => $day['repeat_type'],
                            'repeatInterval' => $day['repeat_interval'],
                            'repeatUntil' => $day['repeat_until'] ? date('d.m.Y', strtotime($day['repeat_until'])) : null
                        ],
                        'display' => $day['status'] == 1 ? 'block' : 'none',
                        'rrule' => [
                            'freq' => strtoupper(rtrim($recurringDef, 's')),
                            'interval' => intval($day['repeat_interval']),
                            'until' => $repeatUntil ? $repeatUntil->format('Y-m-d') : null
                        ]
                    ];
                }
            } else {
                // Tekrarlanmayan normal etkinlik
                $events[] = [
                    'id' => 'special_day_' . $day['id'],
                    'title' => $day['title'],
                    'start' => $day['start_date'],
                    'end' => $endDate->format('Y-m-d'),
                    'backgroundColor' => $color,
                    'borderColor' => $color,
                    'extendedProps' => [
                        'id' => $day['id'],
                        'description' => $day['description'],
                        'startTime' => $day['start_time'],
                        'endTime' => $day['end_time'],
                        'status' => $day['status'],
                        'category' => $day['category'],
                        'categoryName' => $day['category_name'] ?: 'Varsayılan',
                        'categoryColor' => $color,
                        'formattedStartDate' => $formattedStartDate,
                        'formattedEndDate' => $formattedEndDate,
                        'repeatType' => $day['repeat_type'] ?: 'none',
                        'repeatInterval' => $day['repeat_interval'] ?: 1,
                        'repeatUntil' => $day['repeat_until'] ? date('d.m.Y', strtotime($day['repeat_until'])) : null
                    ],
                    'display' => $day['status'] == 1 ? 'block' : 'none'
                ];
            }
        }
        
        // Debug - tüm etkinlik verisini logla
        error_log("getSpecialDaysForCalendar - Toplam " . count($events) . " etkinlik hazırlandı");
        
        header('Content-Type: application/json');
        echo json_encode($events);
    } catch (PDOException $e) {
        error_log("getSpecialDaysForCalendar HATA: " . $e->getMessage());
        header('Content-Type: application/json');
        echo json_encode(['error' => $e->getMessage()]);
    }
    exit;
}

// Kategori Yönetimi
// -----------------

// Kategori ekleme
if (isset($_POST['addSpecialDayCategory'])) {
    // İçerik tipini metin olarak ayarla
    header('Content-Type: text/plain; charset=utf-8');
    
    // Tüm POST verilerini logla
    error_log("addSpecialDayCategory - Tüm POST verileri: " . json_encode($_POST));
    
    // Debug bilgisi
    echo "BAŞLADI: Kategori ekleme işlemi\n";
    
    // Parametre kontrolü
    if (!isset($_POST['name']) || empty($_POST['name'])) {
        error_log("addSpecialDayCategory - Kategori adı boş");
        echo 'ERROR: Kategori adı boş olamaz';
        exit;
    }
    
    if (!isset($_POST['code']) || empty($_POST['code'])) {
        error_log("addSpecialDayCategory - Kategori kodu boş");
        echo 'ERROR: Kategori kodu boş olamaz';
        exit;
    }
    
    $name = htmlspecialchars(trim($_POST['name']));
    $code = htmlspecialchars(trim($_POST['code']));
    $color = isset($_POST['color']) ? $_POST['color'] : '#7367f0';
    $description = isset($_POST['description']) ? htmlspecialchars(trim($_POST['description'])) : '';
    
    try {
        // Tablo varlığı kontrolü
        $tableCheck = $DB->query("SHOW TABLES LIKE 'special_day_categories'");
        if ($tableCheck->rowCount() == 0) {
            error_log("addSpecialDayCategory - Kategori tablosu oluşturuluyor");
            
            // Tablo yoksa oluştur
            $createTableSQL = "CREATE TABLE IF NOT EXISTS `special_day_categories` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `name` varchar(255) NOT NULL,
                `code` varchar(50) NOT NULL,
                `color` varchar(20) NOT NULL DEFAULT '#7367f0',
                `description` text DEFAULT NULL,
                `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
                PRIMARY KEY (`id`),
                UNIQUE KEY `code` (`code`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
            
            $DB->exec($createTableSQL);
            
            // Varsayılan kategori kontrolü
            $defaultCheck = $DB->query("SELECT COUNT(*) as count FROM special_day_categories WHERE code = 'default'");
            if ($defaultCheck->fetch(PDO::FETCH_ASSOC)['count'] == 0) {
                $DB->exec("INSERT INTO special_day_categories (name, code, color, description) 
                           VALUES ('Varsayılan', 'default', '#7367f0', 'Sistem varsayılan kategorisi')");
            }
        }
        
        // Kod benzersiz mi kontrol et
        $checkCode = $DB->prepare("SELECT COUNT(*) as count FROM special_day_categories WHERE code = ?");
        $checkCode->execute([$code]);
        $codeExists = $checkCode->fetch(PDO::FETCH_ASSOC)['count'] > 0;
        
        if ($codeExists) {
            error_log("addSpecialDayCategory - Kategori kodu zaten var: " . $code);
            echo 'DUPLICATE';
            exit;
        }
        
        $stmt = $DB->prepare("INSERT INTO special_day_categories (name, code, color, description) VALUES (?, ?, ?, ?)");
        $result = $stmt->execute([$name, $code, $color, $description]);
        
        if ($result) {
            $lastId = $DB->lastInsertId();
            error_log("addSpecialDayCategory - Kategori başarıyla eklendi. ID: " . $lastId);
            echo "OK\n";
            echo "ID: " . $lastId . "\n";
            echo "Kategori başarıyla eklendi.";
        } else {
            $error = $stmt->errorInfo();
            error_log("addSpecialDayCategory - Ekleme hatası: " . json_encode($error));
            echo 'ERROR: ' . ($error[2] ?? 'Bilinmeyen bir hata oluştu');
        }
    } catch (PDOException $e) {
        error_log("addSpecialDayCategory - PDO Hatası: " . $e->getMessage());
        echo 'ERROR: ' . $e->getMessage();
    } catch (Exception $e) {
        error_log("addSpecialDayCategory - Genel Hata: " . $e->getMessage());
        echo 'ERROR: ' . $e->getMessage();
    }
    exit;
}

// Kategori güncelleme
if (isset($_POST['updateSpecialDayCategory'])) {
    // İçerik tipini metin olarak ayarla
    header('Content-Type: text/plain; charset=utf-8');
    
    error_log("updateSpecialDayCategory - Tüm POST verileri: " . json_encode($_POST));
    
    // Debug bilgisi
    echo "BAŞLADI: Kategori güncelleme işlemi\n";
    
    // Parametre kontrolü
    if (!isset($_POST['id']) || empty($_POST['id'])) {
        error_log("updateSpecialDayCategory - Kategori ID'si boş");
        echo 'ERROR: Kategori ID boş olamaz';
        exit;
    }
    
    if (!isset($_POST['name']) || empty($_POST['name'])) {
        error_log("updateSpecialDayCategory - Kategori adı boş");
        echo 'ERROR: Kategori adı boş olamaz';
        exit;
    }
    
    if (!isset($_POST['code']) || empty($_POST['code'])) {
        error_log("updateSpecialDayCategory - Kategori kodu boş");
        echo 'ERROR: Kategori kodu boş olamaz';
        exit;
    }
    
    $id = intval($_POST['id']);
    $name = htmlspecialchars(trim($_POST['name']));
    $code = htmlspecialchars(trim($_POST['code']));
    $color = isset($_POST['color']) ? $_POST['color'] : '#7367f0';
    $description = isset($_POST['description']) ? htmlspecialchars(trim($_POST['description'])) : '';
    
    try {
        // Tablo varlığı kontrolü
        $tableCheck = $DB->query("SHOW TABLES LIKE 'special_day_categories'");
        if ($tableCheck->rowCount() == 0) {
            error_log("updateSpecialDayCategory - Kategori tablosu bulunamadı");
            echo 'ERROR: Kategori tablosu bulunamadı';
            exit;
        }
        
        // Kategorinin varlığını kontrol et
        $checkCategory = $DB->prepare("SELECT COUNT(*) as count FROM special_day_categories WHERE id = ?");
        $checkCategory->execute([$id]);
        if ($checkCategory->fetch(PDO::FETCH_ASSOC)['count'] == 0) {
            error_log("updateSpecialDayCategory - Kategori bulunamadı. ID: " . $id);
            echo 'ERROR: Belirtilen kategori bulunamadı';
            exit;
        }
        
        // Kod benzersiz mi kontrol et (kendi ID'si hariç)
        $checkCode = $DB->prepare("SELECT COUNT(*) as count FROM special_day_categories WHERE code = ? AND id != ?");
        $checkCode->execute([$code, $id]);
        $codeExists = $checkCode->fetch(PDO::FETCH_ASSOC)['count'] > 0;
        
        if ($codeExists) {
            error_log("updateSpecialDayCategory - Kategori kodu zaten kullanımda: " . $code);
            echo 'DUPLICATE';
            exit;
        }
        
        $stmt = $DB->prepare("UPDATE special_day_categories SET name = ?, code = ?, color = ?, description = ? WHERE id = ?");
        $result = $stmt->execute([$name, $code, $color, $description, $id]);
        
        if ($result) {
            error_log("updateSpecialDayCategory - Kategori başarıyla güncellendi. ID: " . $id);
            echo "OK\n";
            echo "ID: " . $id . "\n";
            echo "Kategori başarıyla güncellendi.";
        } else {
            $error = $stmt->errorInfo();
            error_log("updateSpecialDayCategory - Güncelleme hatası: " . json_encode($error));
            echo 'ERROR: ' . ($error[2] ?? 'Bilinmeyen bir hata oluştu');
        }
    } catch (PDOException $e) {
        error_log("updateSpecialDayCategory - PDO Hatası: " . $e->getMessage());
        echo 'ERROR: ' . $e->getMessage();
    } catch (Exception $e) {
        error_log("updateSpecialDayCategory - Genel Hata: " . $e->getMessage());
        echo 'ERROR: ' . $e->getMessage();
    }
    exit;
}

// Kategori silme
if (isset($_POST['deleteSpecialDayCategory'])) {
    // İçerik tipini metin olarak ayarla
    header('Content-Type: text/plain; charset=utf-8');
    
    // Log için bilgi topla
    error_log("deleteSpecialDayCategory - Tüm POST verileri: " . json_encode($_POST));
    
    // Debug bilgisi
    echo "BAŞLADI: Kategori silme işlemi\n";
    
    // Parametre kontrolü
    if (!isset($_POST['id']) || empty($_POST['id']) || !is_numeric($_POST['id'])) {
        error_log("deleteSpecialDayCategory - Kategori ID'si geçersiz");
        echo 'ERROR: Kategori ID geçersiz';
        exit;
    }
    
    $id = intval($_POST['id']);
    
    try {
        // Tablo varlığı kontrolü
        $tableCheck = $DB->query("SHOW TABLES LIKE 'special_day_categories'");
        if ($tableCheck->rowCount() == 0) {
            error_log("deleteSpecialDayCategory - Kategori tablosu bulunamadı");
            echo 'ERROR: Kategori tablosu bulunamadı';
            exit;
        }
        
        // Önce kategori kodunu kontrol et
        $checkCategory = $DB->prepare("SELECT code FROM special_day_categories WHERE id = ?");
        $checkCategory->execute([$id]);
        $category = $checkCategory->fetch(PDO::FETCH_ASSOC);
        
        if (!$category) {
            error_log("deleteSpecialDayCategory - Kategori bulunamadı. ID: " . $id);
            echo 'ERROR: Belirtilen ID ile kategori bulunamadı';
            exit;
        }
        
        // Varsayılan kategori silinemez
        if ($category && $category['code'] === 'default') {
            error_log("deleteSpecialDayCategory - Varsayılan kategori silme girişimi: " . $id);
            echo 'DEFAULT';
            exit;
        }
        
        // İşlem başlat
        $DB->beginTransaction();
        
        try {
            // Bu kategorideki özel günleri varsayılan kategoriye taşı
            $updateDays = $DB->prepare("UPDATE special_days SET category = 'default' WHERE category = (SELECT code FROM special_day_categories WHERE id = ?)");
            $updateDays->execute([$id]);
            
            // Kategoriyi sil
            $deleteCategory = $DB->prepare("DELETE FROM special_day_categories WHERE id = ?");
            $deleteCategory->execute([$id]);
            
            // İşlemi tamamla
            $DB->commit();
            
            error_log("deleteSpecialDayCategory - Kategori başarıyla silindi. ID: " . $id);
            echo "OK\n";
            echo "Kategori başarıyla silindi.";
        } catch (Exception $innerEx) {
            // Hata durumunda geri al
            $DB->rollBack();
            throw $innerEx; // Ana catch bloğuna aktar
        }
    } catch (PDOException $e) {
        // Hata durumunda geri al
        if ($DB->inTransaction()) {
            $DB->rollBack();
        }
        error_log("deleteSpecialDayCategory - PDO Hatası: " . $e->getMessage());
        echo 'ERROR: ' . $e->getMessage();
    } catch (Exception $e) {
        // Hata durumunda geri al
        if ($DB->inTransaction()) {
            $DB->rollBack();
        }
        error_log("deleteSpecialDayCategory - Genel Hata: " . $e->getMessage());
        echo 'ERROR: ' . $e->getMessage();
    }
    exit;
}

// Kategori bilgilerini getir
if (isset($_POST['getSpecialDayCategory'])) {
    // JSON yanıt tipi ayarla
    header('Content-Type: application/json; charset=utf-8');
    
    // Boş veri kontrolü
    if (!isset($_POST['id']) || empty($_POST['id'])) {
        echo json_encode(['error' => 'Geçersiz kategori ID']);
        exit;
    }
    
    $id = intval($_POST['id']);
    
    try {
        // Tablo varlığı kontrolü
        $tablesQuery = $DB->query("SHOW TABLES LIKE 'special_day_categories'");
        if ($tablesQuery->rowCount() == 0) {
            echo json_encode(['error' => 'Kategori tablosu bulunamadı']);
            exit;
        }
        
        $stmt = $DB->prepare("SELECT * FROM special_day_categories WHERE id = ?");
        $stmt->execute([$id]);
        $category = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($category) {
            echo json_encode($category);
        } else {
            echo json_encode(['error' => 'Kategori bulunamadı']);
        }
    } catch (PDOException $e) {
        error_log("getSpecialDayCategory hatası: " . $e->getMessage());
        echo json_encode(['error' => $e->getMessage()]);
    } catch (Exception $e) {
        error_log("getSpecialDayCategory genel hatası: " . $e->getMessage());
        echo json_encode(['error' => 'Beklenmeyen bir hata oluştu: ' . $e->getMessage()]);
    }
    exit;
}