-- Notification_settings tablosuna çalışan bildirimi için yeni kayıt ekle
-- Önce mevcut kaydın olup olmadığını kontrol et
INSERT INTO notification_settings (id, name, description, type, template, status)
SELECT 8, 'Çalışan Bildirim', 'Randevu alındığında çalışana gönderilecek bildirim', 'whatsapp', 'Sayın {calisan}, {uyeAdi} adlı müşteri tarafından {tarih} tarihinde saat {saat} için {hizmet} randevusu alınmıştır. İyi çalışmalar dileriz.', 1
FROM dual
WHERE NOT EXISTS (
    SELECT 1 FROM notification_settings WHERE id = 8
);

-- Notification_settings tablosunu kontrol et ve boş şablonları düzelt
UPDATE notification_settings 
SET template = REPLACE(template, '{uyeAdi}', 'Müşteri')
WHERE template LIKE '%{uyeAdi}%' AND status = 1;

-- notification_log tablosunu oluştur (eğer yoksa)
CREATE TABLE IF NOT EXISTS notification_log (
    id INT AUTO_INCREMENT PRIMARY KEY,
    appointment_id INT NOT NULL,
    phone VARCHAR(20) NOT NULL,
    notification_type VARCHAR(20) NOT NULL,
    sent_at DATETIME NOT NULL,
    success TINYINT(1) DEFAULT 1
);

-- Son 30 günden eski log kayıtlarını temizle
DELETE FROM notification_log WHERE sent_at < DATE_SUB(NOW(), INTERVAL 30 DAY);