<?php
// WhatsApp API fonksiyonları
// Bu dosya, WhatsApp ile ilgili fonksiyonları içerir ve eral.php tarafından dahil edilir

/**
 * WhatsApp mesajı gönderme fonksiyonu
 * @param string $phone Telefon numarası
 * @param string $message Gönderilecek mesaj
 * @param string $type Bildirim tipi (alindi, hatirlatma, iptal, vb.)
 * @param array $variables Şablonda kullanılacak değişkenler
 * @return bool Gönderim başarılı ise true, değilse false
 */
function sendWhatsAppMessage($phone, $message = '', $type = '', $variables = []) {
    global $settings, $debug_log_file, $DB;
    $whatsapp_log_file = $_SERVER['DOCUMENT_ROOT'] . '/whatsapp_debug.txt';
    $debug_detailed = $_SERVER['DOCUMENT_ROOT'] . '/randevu_debug.txt';

    // İzinleri ayarla
    @chmod($whatsapp_log_file, 0666);
    @chmod($debug_detailed, 0666);

    // Önemli: İlk kontrolde numara ve mesaj tipi (tür) de dikkate alınmalı
    // Aynı randevu için aynı numara ve aynı tipteki bildirimleri önle
    $randevuID = $variables['randevuID'] ?? 0;

    // Doğrudan mesaj gönderimi için randevuID olmasa bile telefon üzerinden kontrol et
    $phoneForCheck = preg_replace('/[^0-9]/', '', $phone); // Sadece rakamları tut

    // Bildirim kontrolü - log tablosuna bakarak
    try {
        if (!empty($randevuID)) {
            // Randevu ID varsa, ID, telefon ve tipe göre kontrol et
            $check_query = $DB->prepare("SELECT COUNT(*) FROM notification_log WHERE
                appointment_id = ? AND phone LIKE ? AND notification_type = ? AND
                sent_at > DATE_SUB(NOW(), INTERVAL 2 MINUTE)");
            $check_query->execute(array($randevuID, '%' . $phoneForCheck . '%', $type));
        } else {
            // Randevu ID yoksa sadece telefon ve tipe göre kontrol et
            $check_query = $DB->prepare("SELECT COUNT(*) FROM notification_log WHERE
                phone LIKE ? AND notification_type = ? AND
                sent_at > DATE_SUB(NOW(), INTERVAL 2 MINUTE)");
            $check_query->execute(array('%' . $phoneForCheck . '%', $type));
        }

        $notification_count = $check_query->fetchColumn();

        if ($notification_count > 0) {
            file_put_contents($whatsapp_log_file, date('Y-m-d H:i:s') . " - Bildirim zaten gönderilmiş, tekrar gönderim atlanıyor (Telefon: " . $phone . ", Tip: " . $type . ", RandevuID: " . $randevuID . ")\n", FILE_APPEND);
            return true; // Önceden gönderilmiş, tekrar göndermeye gerek yok
        }
    } catch (Exception $e) {
        file_put_contents($whatsapp_log_file, "Bildirim geçmişi kontrol edilirken hata: " . $e->getMessage() . " (log tablosu olmayabilir)\n", FILE_APPEND);
        // Tablo yoksa veya başka bir hata varsa, tabloyu oluşturmayı dene
        try {
            $sql = "CREATE TABLE IF NOT EXISTS notification_log (
                id INT AUTO_INCREMENT PRIMARY KEY,
                appointment_id INT NOT NULL,
                phone VARCHAR(20) NOT NULL,
                notification_type VARCHAR(20) NOT NULL,
                sent_at DATETIME NOT NULL,
                success TINYINT(1) DEFAULT 1
            )";
            $DB->exec($sql);
            file_put_contents($whatsapp_log_file, "notification_log tablosu oluşturuldu\n", FILE_APPEND);
        } catch (Exception $tableErr) {
            file_put_contents($whatsapp_log_file, "notification_log tablosu oluşturulamadı: " . $tableErr->getMessage() . "\n", FILE_APPEND);
        }
    }

    // AJAX yanıtı için kullanılacak bilgileri bir diziye topla (echo kullanmadan)
    $debug_info = array(
        "fonksiyon" => "sendWhatsAppMessage",
        "telefon" => $phone,
        "mesaj_tipi" => ($type ? $type : "Doğrudan"),
        "randevu_id" => $randevuID
    );

    // Log başlangıcı
    file_put_contents($whatsapp_log_file, date('Y-m-d H:i:s') . " - WhatsApp gönderimi başlatıldı\n", FILE_APPEND);
    file_put_contents($whatsapp_log_file, "Mesaj tipi: " . ($type ? $type : "Doğrudan") . "\n", FILE_APPEND);

    // Debug log
    file_put_contents($debug_detailed, date('Y-m-d H:i:s') . " - sendWhatsAppMessage fonksiyonu çağrıldı\n", FILE_APPEND);
    file_put_contents($debug_detailed, "Telefon: " . $phone . "\n", FILE_APPEND);
    file_put_contents($debug_detailed, "Mesaj tipi: " . ($type ? $type : "Doğrudan") . "\n", FILE_APPEND);
    file_put_contents($debug_detailed, "Değişkenler: " . print_r($variables, true) . "\n", FILE_APPEND);

    // Ayar kontrolü - settings değişkeni kontrolü
    if (!isset($settings) || empty($settings)) {
        // Settings değişkeni tanımlı değilse veritabanından al
        try {
            if (!isset($DB)) {
                // DB bağlantısı yoksa bağlantıyı kur
                if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php')) {
                    require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
                    file_put_contents($whatsapp_log_file, "DB bağlantısı kuruldu\n", FILE_APPEND);
                } else {
                    file_put_contents($whatsapp_log_file, "HATA: DB dosyası bulunamadı\n", FILE_APPEND);
                    return false;
                }
            }

            $settings_query = $DB->query("SELECT * FROM settings WHERE id = 1");
            if ($settings_query) {
                $settings = $settings_query->fetch(PDO::FETCH_ASSOC);
                file_put_contents($whatsapp_log_file, "Settings veritabanından alındı\n", FILE_APPEND);
            } else {
                file_put_contents($whatsapp_log_file, "Settings veritabanından alınamadı\n", FILE_APPEND);
                return false;
            }
        } catch (Exception $e) {
            file_put_contents($whatsapp_log_file, "Settings alınırken hata: " . $e->getMessage() . "\n", FILE_APPEND);
            return false;
        }
    }

    // Ayar kontrolü
    if (empty($settings['whatsappApiKey'])) {
        file_put_contents($whatsapp_log_file, "WhatsApp API key boş\n", FILE_APPEND);
        file_put_contents($whatsapp_log_file, "API Key: " . ($settings['whatsappApiKey'] ?? 'Yok') . " | whatsappSystem: " . ($settings['whatsappSystem'] ?? '0') . "\n", FILE_APPEND);
        file_put_contents($debug_detailed, "HATA: WhatsApp API key boş\n", FILE_APPEND);
        return false;
    }

    file_put_contents($debug_detailed, "API Key mevcut\n", FILE_APPEND);

    // WhatsApp sistemi kapalıysa ve bu ayara uyulması isteniyorsa gönderme
    if ($settings['whatsappSystem'] != '1' && !isset($variables['ignoreWhatsappSetting'])) {
        file_put_contents($whatsapp_log_file, "WhatsApp sistemi kapalı, mesaj gönderilmiyor\n", FILE_APPEND);
        return false;
    }

    // Eğer bildirim tipi belirtilmişse, ilgili şablonu kullan
    if (!empty($type)) {
        try {
            // Aşağıdaki kodu doğrudan çalıştır - başlatmayı garantiye al
            file_put_contents($whatsapp_log_file, "Doğrudan bildirim şablonu alınıyor: $type\n", FILE_APPEND);

            // notification_settings tablosundan ilgili şablonu al
            $notification_id = 0;

            switch ($type) {
                case 'alindi':
                    $notification_id = 1;
                    break;
                case 'hatirlatma':
                    $notification_id = 2;
                    break;
                case 'tekrarlama':
                    $notification_id = 3;
                    break;
                case 'guncelleme':
                    $notification_id = 4;
                    break;
                case 'dogumgunu':
                    $notification_id = 5;
                    break;
                case 'memnuniyet':
                    $notification_id = 6;
                    break;
                case 'iptal':
                    $notification_id = 7;
                    break;
                case 'calisan_bildirim':
                    $notification_id = 8; // Çalışan bildirimi için ayrı ID (notification_settings tablosunda oluşturulmalı)
                    break;
                case 'dogrudan':
                    // Doğrudan mesaj tipini alindi'ye yönlendir - artık doğrudan mesaj göndermiyoruz
                    $notification_id = 1;
                    $type = 'alindi'; // Tipi de değiştir ki log tutarlı olsun
                    break;
                default:
                    // Bilinmeyen tip, default olarak "alindi" kullan
                    $notification_id = 1;
                    break;
            }

            // DB bağlantısını kontrol et
            if (!isset($DB) || empty($DB)) {
                if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php')) {
                    require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/system/settings/db.php';
                    file_put_contents($whatsapp_log_file, "Şablon alımı için DB bağlantısı kuruldu\n", FILE_APPEND);
                }
            }

            // Settings'i kontrol et
            if (!isset($settings) || empty($settings)) {
                if (isset($DB)) {
                    $settings_query = $DB->query("SELECT * FROM settings WHERE id = 1");
                    if ($settings_query) {
                        $settings = $settings_query->fetch(PDO::FETCH_ASSOC);
                        file_put_contents($whatsapp_log_file, "Settings veritabanından alındı (şablon için)\n", FILE_APPEND);
                    }
                }
            }

            file_put_contents($whatsapp_log_file, "Bildirim ID: $notification_id işleniyor\n", FILE_APPEND);

            if ($notification_id > 0 && isset($DB)) {
                file_put_contents($whatsapp_log_file, "Bildirim şablonu alınıyor (ID: $notification_id)\n", FILE_APPEND);

                $sablon_query = $DB->prepare("SELECT * FROM notification_settings WHERE id = ?");
                $sablon_query->execute(array($notification_id));

                if ($sablon_query->rowCount() > 0) {
                    $sablon = $sablon_query->fetch(PDO::FETCH_ASSOC);
                    file_put_contents($whatsapp_log_file, "Şablon veritabanından alındı\n", FILE_APPEND);

                    if ($sablon['status'] == '1') {
                        // Şablon aktif, kullan
                        $message = $sablon['template'];
                        file_put_contents($whatsapp_log_file, "Bildirim şablonu bulundu: " . substr($message, 0, 50) . "...\n", FILE_APPEND);

                        // Değişkenleri şablona yerleştir
                        if (!empty($variables)) {
                            file_put_contents($whatsapp_log_file, "Şablon değişkenleri değiştiriliyor\n", FILE_APPEND);
                            // Mesajın değişiklik öncesi durumunu kaydet
                            file_put_contents($whatsapp_log_file, "Değişiklik öncesi şablon: " . $message . "\n", FILE_APPEND);
                            file_put_contents($debug_detailed, "Değişiklik öncesi şablon: " . $message . "\n", FILE_APPEND);

                            // Değişken değerlerini kontrol et - boş değerler varsa mesaj gönderme
                            $has_empty_vars = false;
                            $empty_vars = [];

                            foreach ($variables as $key => $value) {
                                if (strpos($message, '{' . $key . '}') !== false && empty($value)) {
                                    $has_empty_vars = true;
                                    $empty_vars[] = $key;
                                    file_put_contents($whatsapp_log_file, "UYARI: {" . $key . "} değişkeni boş!\n", FILE_APPEND);
                                }
                                $message = str_replace('{' . $key . '}', $value, $message);
                                file_put_contents($whatsapp_log_file, "Şablon değişkeni eklendi: {" . $key . "} = " . $value . "\n", FILE_APPEND);
                            }

                            // Şablonda hala değiştirilmemiş değişken kaldı mı kontrol et
                            if (preg_match('/\{[a-zA-Z0-9_]+\}/', $message, $matches)) {
                                $has_empty_vars = true;
                                file_put_contents($whatsapp_log_file, "UYARI: Şablonda değiştirilmemiş değişken var: " . implode(', ', $matches) . "\n", FILE_APPEND);
                            }

                            // Boş değişken varsa mesaj gönderme
                            if ($has_empty_vars) {
                                file_put_contents($whatsapp_log_file, "Boş değişkenler nedeniyle mesaj gönderilmiyor: " . implode(', ', $empty_vars) . "\n", FILE_APPEND);
                                return false;
                            }

                            // Mesajın değişiklik sonrası durumunu kaydet
                            file_put_contents($whatsapp_log_file, "Değişiklik sonrası şablon: " . $message . "\n", FILE_APPEND);
                            file_put_contents($debug_detailed, "Değişiklik sonrası şablon: " . $message . "\n", FILE_APPEND);
                        } else {
                            file_put_contents($debug_detailed, "HATA: Değişkenler boş!\n", FILE_APPEND);
                        }

                        // İptal/değişiklik linki ekle - SMS formatıyla benzer olması için
                        if (isset($variables['randevuID']) && !empty($variables['randevuID'])) {
                            try {
                                $redirect_query = $DB->prepare("SELECT url FROM redirect WHERE appointment = ?");
                                $redirect_query->execute(array($variables['randevuID']));

                                if ($redirect_query->rowCount() > 0) {
                                    $url = $redirect_query->fetchColumn();

                                    if (isset($settings['cancelSystem']) && $settings['cancelSystem'] == '1') {
                                        $redirect = "https://" . $_SERVER['SERVER_NAME'] . "/r/" . $url;
                                        $cancelMessageText = " " . $settings['cancelMessage'] . $redirect;
                                        $message .= $cancelMessageText;

                                        file_put_contents($whatsapp_log_file, "İptal/değişiklik linki eklendi: " . $redirect . "\n", FILE_APPEND);
                                    }
                                } else {
                                    file_put_contents($whatsapp_log_file, "Randevu için redirect URL bulunamadı (ID: " . $variables['randevuID'] . ")\n", FILE_APPEND);
                                }
                            } catch (Exception $e) {
                                file_put_contents($whatsapp_log_file, "Redirect URL alınırken hata: " . $e->getMessage() . "\n", FILE_APPEND);
                            }
                        } else {
                            file_put_contents($whatsapp_log_file, "randevuID değişkeni bulunamadı\n", FILE_APPEND);
                        }
                    } else {
                        file_put_contents($whatsapp_log_file, "Bildirim şablonu pasif (status=0), doğrudan mesaj gönderiliyor\n", FILE_APPEND);
                    }
                } else {
                    file_put_contents($whatsapp_log_file, "Bildirim şablonu bulunamadı (ID: $notification_id), doğrudan mesaj gönderiliyor\n", FILE_APPEND);
                }
            } else {
                file_put_contents($whatsapp_log_file, "Geçersiz bildirim ID veya DB bağlantısı yok\n", FILE_APPEND);
            }
        } catch (Exception $e) {
            file_put_contents($whatsapp_log_file, "Şablon alınırken hata: " . $e->getMessage() . "\n", FILE_APPEND);
            // Hata olsa bile orijinal mesajla devam et
        }
    } else {
        file_put_contents($whatsapp_log_file, "Bildirim tipi belirtilmemiş, doğrudan mesaj gönderiliyor\n", FILE_APPEND);
    }

    // Telefon numarasını formatlama (geliştirilmiş)
    $_phone = $phone; // Orijinal telefon numarasını sakla
    $phone = preg_replace('/[^0-9]/', '', $phone); // Sadece rakamları tut

    file_put_contents($whatsapp_log_file, "Temizlenmiş telefon: " . $phone . " (Uzunluk: " . strlen($phone) . ")\n", FILE_APPEND);

    // Numaranın ilk karakteri 0 ise kaldır
    if (strlen($phone) > 0 && substr($phone, 0, 1) == '0') {
        $phone = substr($phone, 1);
        file_put_contents($whatsapp_log_file, "0 kaldırıldı: " . $phone . "\n", FILE_APPEND);
    }

    // Farklı numara formatlarını ele al
    if (strlen($phone) == 10) {
        // 10 haneli Türkiye numarası (5xx xxx xxxx)
        $phone = '90' . $phone;
        file_put_contents($whatsapp_log_file, "10 haneli numara: 90 eklendi -> " . $phone . "\n", FILE_APPEND);
    }
    else if (strlen($phone) == 11 && substr($phone, 0, 1) == '5') {
        // 11 haneli ve 5 ile başlayan numara (5xx xxx xxxx)
        $phone = '90' . $phone;
        file_put_contents($whatsapp_log_file, "11 haneli 5 ile başlayan numara: 90 eklendi -> " . $phone . "\n", FILE_APPEND);
    }
    else if (strlen($phone) == 12 && substr($phone, 0, 2) == '90') {
        // Zaten tam formatta, dokunma (90xxx)
        file_put_contents($whatsapp_log_file, "12 haneli 90 ile başlayan numara: format korundu -> " . $phone . "\n", FILE_APPEND);
    }
    else {
        // Diğer durumlar için bir kontrol daha ekle
        if (strlen($phone) <= 15 && strlen($phone) >= 10) {
            // Numara zaten uluslararası formatta olabilir, sadece logla
            file_put_contents($whatsapp_log_file, "Özel format: mevcut numara korundu -> " . $phone . "\n", FILE_APPEND);
        } else {
            // Numara beklenmeyen uzunlukta, hata logla
            file_put_contents($whatsapp_log_file, "UYARI: Beklenmeyen numara uzunluğu (" . strlen($phone) . "): " . $phone . "\n", FILE_APPEND);
        }
    }

    // Debug log için telefon formatını kaydet
    file_put_contents($whatsapp_log_file, "TELEFON FORMATLAMA: Orijinal " . $_phone . " -> Formatlanmış " . $phone . "\n", FILE_APPEND);

    // Bildirim log tablosuna önceden kaydet (gönderim başlamadan önce) - bu şekilde eş zamanlı istekler de önlenmiş olur
    $notification_inserted = false;
    if (!empty($randevuID) || !empty($type)) {
        try {
            // Loglama tablosuna ekle - başlangıçta success=0 olarak işaretle
            $DB->prepare("INSERT INTO notification_log (appointment_id, phone, notification_type, sent_at, success)
                          VALUES (?, ?, ?, NOW(), ?)")
               ->execute(array($randevuID, $phone, $type, 0));
            $notification_inserted = true;
            $last_notification_id = $DB->lastInsertId();
            file_put_contents($whatsapp_log_file, "Bildirim gönderim kaydı oluşturuldu (ID: {$last_notification_id})\n", FILE_APPEND);
        } catch (Exception $e) {
            file_put_contents($whatsapp_log_file, "Bildirim log kaydı oluşturulamadı: " . $e->getMessage() . "\n", FILE_APPEND);
        }
    }

    $body = array(
        "api_key" => $settings['whatsappApiKey'],
        "receiver" => $phone,
        "data" => array("message" => $message)
    );

    file_put_contents($whatsapp_log_file, "API isteği gönderiliyor - API Key: " . $settings['whatsappApiKey'] . "\n", FILE_APPEND);
    file_put_contents($whatsapp_log_file, "Alıcı: " . $phone . "\n", FILE_APPEND);
    file_put_contents($whatsapp_log_file, "Mesaj: " . $message . "\n", FILE_APPEND);

    // Detail debug
    file_put_contents($debug_detailed, "API isteği hazırlandı (gönderiliyor)\n", FILE_APPEND);
    file_put_contents($debug_detailed, "Alıcı: " . $phone . "\n", FILE_APPEND);
    file_put_contents($debug_detailed, "Mesaj: " . $message . "\n", FILE_APPEND);

    try {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.wpapi.com.tr/api/send-message",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($body),
            CURLOPT_HTTPHEADER => [
                "Accept: */*",
                "Content-Type: application/json",
            ],
        ]);

        file_put_contents($whatsapp_log_file, "CURL isteği hazırlandı\n", FILE_APPEND);
        file_put_contents($whatsapp_log_file, "POST verisi: " . json_encode($body) . "\n", FILE_APPEND);

        $response = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $err = curl_error($curl);

        file_put_contents($whatsapp_log_file, "HTTP kodu: " . $httpCode . "\n", FILE_APPEND);
        file_put_contents($whatsapp_log_file, "API Yanıtı: " . $response . "\n", FILE_APPEND);

        if ($err) {
            file_put_contents($whatsapp_log_file, "Curl Hatası: " . $err . "\n", FILE_APPEND);
        }

        curl_close($curl);

        if ($err) {
            file_put_contents($whatsapp_log_file, "Hata nedeniyle işlem başarısız\n", FILE_APPEND);
            error_log("WhatsApp API Error: " . $err);

            // Başarısız gönderimi güncelle (eğer önceden eklenmişse)
            if ($notification_inserted && isset($last_notification_id)) {
                try {
                    $DB->prepare("UPDATE notification_log SET success = 0 WHERE id = ?")
                       ->execute(array($last_notification_id));
                    file_put_contents($whatsapp_log_file, "Bildirim logu başarısız olarak güncellendi (ID: {$last_notification_id})\n", FILE_APPEND);
                } catch (Exception $e) {
                    file_put_contents($whatsapp_log_file, "Bildirim log güncellemesi başarısız: " . $e->getMessage() . "\n", FILE_APPEND);
                }
            }

            return false;
        }

        // API yanıtını JSON olarak çözümle
        $responseData = json_decode($response, true);
        if (isset($responseData['status']) && $responseData['status'] === true) {
            file_put_contents($whatsapp_log_file, "WhatsApp mesajı başarıyla gönderildi!\n", FILE_APPEND);
            file_put_contents($debug_detailed, "*** WhatsApp mesajı başarıyla gönderildi! ***\n", FILE_APPEND);

            // Başarılı gönderimi logla/güncelle
            if ($notification_inserted && isset($last_notification_id)) {
                try {
                    // Önceden eklenen kaydı güncelle
                    $DB->prepare("UPDATE notification_log SET success = 1 WHERE id = ?")
                       ->execute(array($last_notification_id));
                    file_put_contents($whatsapp_log_file, "Bildirim logu başarılı olarak güncellendi (ID: {$last_notification_id})\n", FILE_APPEND);
                } catch (Exception $e) {
                    file_put_contents($whatsapp_log_file, "Bildirim log güncellemesi başarısız: " . $e->getMessage() . "\n", FILE_APPEND);
                }
            }
            else if (isset($variables['randevuID']) && !empty($variables['randevuID'])) {
                try {
                    // Yeni kayıt oluştur (önceden eklenemediyse)
                    $DB->prepare("INSERT INTO notification_log (appointment_id, phone, notification_type, sent_at, success)
                                  VALUES (?, ?, ?, NOW(), ?)")
                       ->execute(array($variables['randevuID'], $phone, $type, 1));
                    file_put_contents($whatsapp_log_file, "Bildirim logu oluşturuldu (Randevu: " . $variables['randevuID'] . ")\n", FILE_APPEND);
                } catch (Exception $e) {
                    file_put_contents($whatsapp_log_file, "Bildirim log kaydı oluşturulamadı: " . $e->getMessage() . "\n", FILE_APPEND);
                }
            }

            // Debug bilgilerini döndür (echo yerine)
            if (defined('AJAX_REQUEST') && AJAX_REQUEST === true) {
                $GLOBALS['whatsapp_debug'] = $debug_info;
            }

            return true;
        } else {
            $errorMessage = isset($responseData['message']) ? $responseData['message'] : 'Bilinmeyen hata';
            file_put_contents($whatsapp_log_file, "WhatsApp API hatası: " . $errorMessage . "\n", FILE_APPEND);
            file_put_contents($debug_detailed, "*** WhatsApp API hatası: " . $errorMessage . " ***\n", FILE_APPEND);

            // Başarısız gönderimi güncelle (eğer önceden eklenmişse)
            if ($notification_inserted && isset($last_notification_id)) {
                try {
                    $DB->prepare("UPDATE notification_log SET success = 0 WHERE id = ?")
                       ->execute(array($last_notification_id));
                    file_put_contents($whatsapp_log_file, "Bildirim logu başarısız olarak güncellendi (ID: {$last_notification_id})\n", FILE_APPEND);
                } catch (Exception $e) {
                    file_put_contents($whatsapp_log_file, "Bildirim log güncellemesi başarısız: " . $e->getMessage() . "\n", FILE_APPEND);
                }
            }

            return false;
        }
    } catch (Exception $e) {
        file_put_contents($whatsapp_log_file, "İstisna hatası: " . $e->getMessage() . "\n", FILE_APPEND);

        // Başarısız gönderimi güncelle (eğer önceden eklenmişse)
        if ($notification_inserted && isset($last_notification_id)) {
            try {
                $DB->prepare("UPDATE notification_log SET success = 0 WHERE id = ?")
                   ->execute(array($last_notification_id));
                file_put_contents($whatsapp_log_file, "Bildirim logu başarısız olarak güncellendi (ID: {$last_notification_id})\n", FILE_APPEND);
            } catch (Exception $updateErr) {
                file_put_contents($whatsapp_log_file, "Bildirim log güncellemesi başarısız: " . $updateErr->getMessage() . "\n", FILE_APPEND);
            }
        }

        return false;
    }
}
