<?php
// Debug dosyası - break_start_time ve break_end_time formatlarını test etmek için
$date1 = "20.05.2025 00:00";
$date2 = "2025-05-20 00:00:00";

echo "Test 1 - Orijinal formatlar:<br>";
echo "date1: $date1<br>";
echo "date2: $date2<br><br>";

// Tarih formatı dönüştürme denemeleri
$datetime1 = DateTime::createFromFormat('d.m.Y H:i', $date1);
$datetime2 = DateTime::createFromFormat('Y-m-d H:i:s', $date2);

echo "Test 2 - DateTime::createFromFormat sonuçları:<br>";
echo "datetime1: " . ($datetime1 ? $datetime1->format('Y-m-d H:i:s') : "HATA") . "<br>";
echo "datetime2: " . ($datetime2 ? $datetime2->format('Y-m-d H:i:s') : "HATA") . "<br><br>";

// Farklı bir yaklaşım deneyelim
$timestamp1 = strtotime($date1);
$timestamp2 = strtotime($date2);

echo "Test 3 - strtotime sonuçları:<br>";
echo "timestamp1: " . $timestamp1 . " -> " . ($timestamp1 ? date('Y-m-d H:i:s', $timestamp1) : "HATA") . "<br>";
echo "timestamp2: " . $timestamp2 . " -> " . ($timestamp2 ? date('Y-m-d H:i:s', $timestamp2) : "HATA") . "<br>";
?>
