// Console loglarını devre dışı bırak
console.log = function() {};
console.warn = function() {};
console.error = function() {};
console.info = function() {};

// Servis çalışanını kontrol edin ve kaydedin
if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('/service-worker.js')
        .then(function(registration) {
            // Console log devre dışı
        })
        .catch(function(error) {
            // Console log devre dışı
        });
}

// Uygulama yükleme önerisini kontrol edin
window.addEventListener('beforeinstallprompt', (event) => {
    event.preventDefault(); // Varsayılan tarayıcı yükleme önerisini engelleyin
    window.deferredPrompt = event;

    // Butonu görünür hale getirin
    const installButton = document.getElementById('installButton');
    installButton.classList.add('show');
});

// Buton tıklandığında otomatik olarak prompt göster
document.addEventListener('DOMContentLoaded', function() {
    const installButton = document.getElementById('installButton');
    
    if (installButton) {
        installButton.addEventListener('click', () => {
            if (window.deferredPrompt) {
                window.deferredPrompt.prompt(); // Kullanıcıya yükleme önerisini gösterin
                window.deferredPrompt.userChoice.then((choiceResult) => {
                    window.deferredPrompt = null; // Prompt objesini sıfırlayın
                });
            }
        });
    }
});
