// ==================================================
// Randevu Sistemi JavaScript
// Version: 3.3.0
// ==================================================
$(function () {
  "use strict";
  // ========== Form-select-option ========== //
  $(".step_1").on("click", function () {
    $(".step_1").removeClass("active");
    $(this).addClass("active");
  });
  $(".step_2").on("click", function () {
    $(".step_2").removeClass("active");
    $(this).addClass("active");
  });
  $(".step_3").on("click", function () {
    $(".step_3").removeClass("active");
    $(this).addClass("active");
  });
  $(".step_4").on("click", function () {
    $(".step_4").removeClass("active");
    $(this).addClass("active");
  });
});

// Çalışılmayacak saat uyarısı göster
function showUnavailableTimeWarning() {
  Swal.fire({
    title: "Uyarı",
    text: "Bu saat seçilemez. Çalışılmayacak saat olarak işaretlenmiştir.",
    icon: "warning",
    confirmButtonColor: "#ff950e",
    confirmButtonText: "Tamam",
  });

  // Bu adımda seçili saati temizle
  if (window.selectedTime) {
    window.selectedTime = null;
    $("#nextBtn").prop("disabled", true);
  }

  // Tüm radio butonların işaretlerini kaldır
  $(".custom-option-item-check").prop("checked", false);

  // Tüm etiketlerden active sınıfını kaldır
  $(".custom-option-item:not([data-unavailable='true'])").removeClass("active");

  console.log("Uyarı gösterildi: Çalışılmayacak saat");
  return false;
}

// Saat seçimi için merkezi event handler - sayfa yüklendikten sonra aktif olur
$(document).ready(function () {
  // Tüm saatlerin tıklama olaylarını yönet
  $(document).on("click", ".custom-option-item", function (e) {
    // Çalışılmayacak saatler için engelleme kontrolü
    if (
      $(this).hasClass("unavailable-time") ||
      $(this).attr("data-unavailable") === "true"
    ) {
      // Tıklama olayını engelle
      e.preventDefault();
      e.stopPropagation();

      // İlgili checkbox'ı devre dışı bırak ve seçimi kaldır
      var inputId = $(this).attr("for");
      if (inputId && $("#" + inputId).length > 0) {
        $("#" + inputId)
          .prop("disabled", true)
          .prop("checked", false);
      }

      // Uyarı göster
      showUnavailableTimeWarning();

      // Diğer işlemleri durdur
      return false;
    }

    // Radio buton seçimini değiştir
    var hourId = $(this).attr("data-hour-id");
    var radioId = "customOptionsCheckableRadiosWithIcon" + hourId;
    $("#" + radioId).prop("checked", true);

    // Tüm etiketlerden active sınıfını kaldır ve stillerini sıfırla
    $(".custom-option-item")
      .removeClass("active")
      .each(function () {
        // Çalışılmayacak saatler hariç tüm stil özelliklerini temizle
        if (
          !$(this).hasClass("unavailable-time") &&
          $(this).attr("data-unavailable") !== "true"
        ) {
          $(this).css({
            "border-color": "",
            "background-color": "",
            "box-shadow": "",
          });

          // Özel gün saatleri için renkleri sıfırla
          if ($(this).hasClass("special-day-time")) {
            $(this).find("small").css("color", "#0077be");
            $(this).find(".fa-star-of-life").css("color", "#0077be");
          }
        }
      });

    // Bu etikete active sınıfını ekle
    $(this).addClass("active");

    // Seçilen saati ayarla
    var selectedTime = $(this).attr("data-hour");
    window.selectedTime = selectedTime;

    // Devam butonunu aktifleştir
    $("#nextBtn").prop("disabled", false);

    // Özel gün saati seçildiyse özel stil uygula
    if (
      $(this).hasClass("special-day-time") &&
      $(this).attr("data-special") === "1"
    ) {
      $(this).css({
        "border-color": "#ff3d00",
        "background-color": "#fff2e6",
        "box-shadow": "0 0 10px rgba(255, 100, 0, 0.6)",
      });

      // İçindeki küçük yazı ve simge rengini değiştir
      $(this).find("small").css("color", "#ff3d00");
      $(this).find(".fa-star-of-life").css("color", "#ff3d00");
    }

    // Radio buton için change event tetikle
    $("#" + radioId).trigger("change");

    // Console log
    console.log("Saat seçildi:", selectedTime);
  });

  // Sayfa yüklendiğinde çalışılmayacak saatleri devre dışı bırak
  function disableUnavailableTimes() {
    // data-unavailable="true" veya .unavailable-time class'ına sahip öğeleri bul
    $(
      '.custom-option-item[data-unavailable="true"], .custom-option-item.unavailable-time'
    ).each(function () {
      // İlgili checkbox'ı bul ve devre dışı bırak
      var inputId = $(this).attr("for");
      if (inputId && $("#" + inputId).length > 0) {
        $("#" + inputId)
          .prop("disabled", true)
          .prop("checked", false);
      }
    });
  }

  // Sayfa yüklendiğinde çalıştır
  disableUnavailableTimes();
  
  // DOMNodeInserted yerine MutationObserver kullan (modern yaklaşım)
  const timeSelectObserver = new MutationObserver(function(mutations) {
    setTimeout(disableUnavailableTimes, 100);
  });
  
  // Gözlemciyi başlat
  $(document).ready(function() {
    const timeSelectEl = document.getElementById("timeSelect");
    if (timeSelectEl) {
      timeSelectObserver.observe(timeSelectEl, { 
        childList: true,  // Alt öğe değişimlerini izle
        subtree: true     // Tüm alt ağacı izle
      });
    }
  });
});

// Ana form değişkenleri
var currentTab = 0; // Current tab is set to be the first tab (0)
showTab(currentTab); // Display the current tab

/**
 * Belirtilen form adımını gösterir ve butonları duruma göre ayarlar
 * @param {number} n - Gösterilecek adım numarası
 */
function showTab(n) {
  // Display the specified tab of the form
  var x = document.getElementsByClassName("multisteps_form_panel");
  if (x.length === 0 || n >= x.length) {
    console.error("Panel bulunamadı veya geçersiz indeks:", n);
    return; // Eğer panel yoksa veya indeks geçersizse işlemi durdur
  }
  x[n].style.display = "block";

  // Fix the Previous/Next buttons
  var prevBtn = document.getElementById("prevBtn");
  var nextBtn = document.getElementById("nextBtn");
  
  if (prevBtn) {
    if (n == 0) {
      prevBtn.style.display = "none";
    } else {
      prevBtn.style.display = "inline";
    }
  }

  if (nextBtn) {
    if (n == x.length - 1) {
      nextBtn.innerHTML = "Gönder";
    } else {
      nextBtn.innerHTML =
        'Devam et <span><i class="fas fa-arrow-right"></i></span>';
    }
  }

  // Update the step indicator
  fixStepIndicator(n);
}

/**
 * Form adımları arasında gezinmeyi sağlar ve geçişleri yönetir
 * @param {number} n - İleri (+1) veya geri (-1) yönünde hareket
 * @returns {boolean} - İşlemin başarılı olup olmadığını belirtir
 */
function nextPrev(n) {
  // Get the current form panels
  var x = document.getElementsByClassName("multisteps_form_panel");

  // Determine current step (which panel is visible)
  for (var i = 0; i < x.length; i++) {
    if (window.getComputedStyle(x[i]).display === "block") {
      currentTab = i;
      break;
    }
  }

  console.log(
    "Adım değişimi: Şu anki adım =",
    currentTab,
    "Hedef adım =",
    currentTab + n
  );

  // Last step -> update summary
  if (currentTab + n === 3) {
    console.log("Son adıma geçiliyor, özet güncelleniyor");
    updateSummary();
  }

  // When moving forward, validate the current step
  if (n === 1 && !validateForm(currentTab)) {
    console.log("Doğrulama başarısız, adım değişimi iptal edildi");
    return false;
  }

  // Hide current tab
  x[currentTab].style.display = "none";

  // Update current tab index
  currentTab = currentTab + n;

  // 3. adıma geçiliyorsa (indeks 2) hizmet ve personel bilgilerini güncelle
  if (currentTab === 2) {
    setTimeout(function () {
      // jQuery ile seçilen hizmet adını al
      var selectedServiceName = $("#service option:selected").text();

      // jQuery ile seçilen personel adını al
      var selectedProviderName = $("#providerAdSoyad").val();

      console.log("Hizmet bilgisi:", {
        element: $("#service"),
        selectedText: selectedServiceName,
        options: $("#service option").length,
        selectedOption: $("#service").val(),
      });

      console.log("Personel bilgisi:", {
        element: $("#providerAdSoyad"),
        value: selectedProviderName,
        providerID: $("#providerID").val(),
      });

      // Bilgileri karta aktar
      $("#selectedServiceName").text(selectedServiceName || "-");
      $("#selectedProviderName").text(selectedProviderName || "-");

      // Alternatif yöntem - doğrudan DOM'dan bilgileri al
      if (!selectedServiceName || selectedServiceName === "") {
        var serviceElement = document.getElementById("service");
        if (serviceElement && serviceElement.selectedIndex > -1) {
          selectedServiceName =
            serviceElement.options[serviceElement.selectedIndex].text;
          $("#selectedServiceName").text(selectedServiceName || "-");
        }
      }

      console.log(
        "Hizmet ve personel bilgileri güncellendi (nextPrev):",
        selectedServiceName,
        selectedProviderName
      );
    }, 200);
  }

  // Check if we've reached the end of the form
  if (currentTab >= x.length) {
    console.log("Son tab'a ulaşıldı, form gönderilmeyecek");
    return false;
  }

  // Show the new tab
  console.log("Yeni tab gösteriliyor:", currentTab);
  showTab(currentTab);

  // Special step setup for date/time selection
  if (currentTab == 2) {
    console.log("Adım 3'e geçildi: Tarih ve saat seçimi");

    // Check if provider is selected
    if (!$("#providerID").val()) {
      console.log("Personel seçimi yapılmamış, önceki adıma dönülüyor");
      Swal.fire({
        title: "Hata",
        text: "Lütfen önce personel seçimi yapınız!",
        icon: "warning",
        confirmButtonColor: "#ff950e",
        confirmButtonText: "Tamam",
      }).then((result) => {
        nextPrev(-1);
      });
      return;
    }

    console.log("Personel seçilmiş, ID:", $("#providerID").val());

    // Initialize date picker
    setTimeout(function () {
      console.log("Tarih seçiciyi başlatma işlemi başladı");

      // Initialize global variables
      window.selectedTime = null;

      if (typeof flatpickr !== "undefined") {
        var startDateEl = document.getElementById("start-date");
        if (!startDateEl) {
          console.error("start-date elementi bulunamadı!");
          return;
        }

        console.log("Flatpickr elementi bulundu:", startDateEl);

        // Destroy existing flatpickr instance if exists
        if (startDateEl._flatpickr) {
          console.log("Mevcut flatpickr yıkılıyor");
          startDateEl._flatpickr.destroy();
        }

        // Make date field clickable
        startDateEl.setAttribute("readonly", "readonly");
        $(startDateEl).css("cursor", "pointer");
        $(startDateEl).attr("placeholder", "Tarih seçmek için tıklayın");

        console.log("Yeni flatpickr başlatılıyor");

        // Initialize flatpickr
        var fp = flatpickr(startDateEl, {
          dateFormat: "Y-m-d",
          minDate: "today",
          disableMobile: "true",
          clickOpens: true,
          allowInput: false,
          altInput: true,
          altFormat: "d F Y", // Gün Ay_Adı Yıl formatında (ör: 19 Nisan 2025)
          locale: {
            firstDayOfWeek: 1, // Start with Monday
            weekdays: {
              longhand: [
                "Pazar",
                "Pazartesi",
                "Salı",
                "Çarşamba",
                "Perşembe",
                "Cuma",
                "Cumartesi",
              ],
              shorthand: ["Paz", "Pzt", "Sal", "Çar", "Per", "Cum", "Cmt"],
            },
            months: {
              longhand: [
                "Ocak",
                "Şubat",
                "Mart",
                "Nisan",
                "Mayıs",
                "Haziran",
                "Temmuz",
                "Ağustos",
                "Eylül",
                "Ekim",
                "Kasım",
                "Aralık",
              ],
              shorthand: [
                "Oca",
                "Şub",
                "Mar",
                "Nis",
                "May",
                "Haz",
                "Tem",
                "Ağu",
                "Eyl",
                "Eki",
                "Kas",
                "Ara",
              ],
            },
            today: "Bugün",
            clear: "Temizle",
          },
          onChange: function (selectedDates, dateStr, instance) {
            // Load time slots when date is selected
            var date = dateStr;
            var providerID = $("#providerID").val();
            var hizmetID = $("#service").val();

            // Tarih formatını backend için düzelt (d/m/Y -> Y-m-d)
            var formattedDate = date;
            if (date && date.indexOf("/") !== -1) {
              var dateParts = date.split("/");
              if (dateParts.length === 3) {
                formattedDate =
                  dateParts[2] + "-" + dateParts[1] + "-" + dateParts[0];
                console.log(
                  "Tarih formatı dönüştürüldü:",
                  date,
                  "->",
                  formattedDate
                );
              }
            }

            // Orijinal tarih değerini hidden input olarak sakla
            if ($("#original-date").length === 0) {
              $("<input>")
                .attr({
                  type: "hidden",
                  id: "original-date",
                  name: "original-date",
                  value: formattedDate,
                })
                .appendTo("#multistep_form");
            } else {
              $("#original-date").val(formattedDate);
            }

            console.log(
              "Tarih değiştirildi:",
              date,
              "Backend formatı:",
              formattedDate
            );

            // Show loading indicator
            $("#timeSelect").html(
              "<div class='text-center py-3'><i class='fas fa-clock'></i> Saatler hazırlanıyor...</div>"
            );

            // Load available time slots
            // Log ajax parameters
            var ajaxParams = {
              date: formattedDate, // Backend formatında tarih (Y-m-d)
              providerID: providerID,
              hizmet: hizmetID,
            };

            console.log("AJAX request parameters:", ajaxParams);

            // Kontroller
            if (!date) {
              console.error("HATA: date parametresi boş!");
              $("#timeSelect").html(
                "<div class='alert alert-danger'>Tarih seçimi geçersiz. Lütfen tekrar deneyin.</div>"
              );
              return;
            }

            if (!providerID) {
              console.error("HATA: providerID parametresi boş!");
              $("#timeSelect").html(
                "<div class='alert alert-danger'>Personel seçimi geçersiz. Lütfen baştan başlayın.</div>"
              );
              return;
            }

            if (!hizmetID) {
              console.error("HATA: hizmet parametresi boş!");
              $("#timeSelect").html(
                "<div class='alert alert-danger'>Hizmet seçimi geçersiz. Lütfen baştan başlayın.</div>"
              );
              return;
            }

            $.ajax({
              type: "POST",
              url: "/admin/system/ajax/AvailableTimeAjax.php",
              data: ajaxParams,
              success: function (response) {
                console.log("Saatler başarıyla yüklendi");

                // Remove jQuery references from response
                response = response.replace(
                  /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,
                  ""
                );

                // Update time slots container
                $("#timeSelect").html(response);

                // Special day notification handling
                if (response.includes("alert-info")) {
                  console.log("Özel gün bilgisi tespit edildi");
                  setTimeout(function () {
                    $("html, body").animate(
                      {
                        scrollTop: $(".alert-info").offset().top - 120,
                      },
                      200
                    );
                  }, 300);
                }

                // Ertesi gün özel saatleri kontrol et ve logla
                if (response.includes("ERTESİ GÜN DURUM 1")) {
                  console.log("Ertesi gün özel saatleri tespit edildi");
                } else {
                  console.log("Ertesi gün için özel saatler bulunamadı");
                }

                // Çalışılmayacak saatleri getir ve işaretle
                console.log("Mevcut ProviderID:", providerID);
                console.log("Mevcut Date:", date);

                // Değerlerin tanımlı olduğundan emin ol
                if (providerID && date) {
                  // Çalışılmayacak saatleri getir
                  $.ajax({
                    type: "POST",
                    url: "/admin/system/ajax/GetUnavailableHours.php",
                    data: {
                      date: formattedDate, // Backend formatında tarih (Y-m-d)
                      providerID: providerID,
                    },
                    dataType: "json",
                    success: function (unavailableResponse) {
                      console.log(
                        "Çalışılmayacak saatler yanıtı:",
                        unavailableResponse
                      );

                      if (unavailableResponse.success) {
                        // Çalışılmayacak saatleri işaretle
                        var unavailableHours =
                          unavailableResponse.data.unavailable_hours || [];
                        console.log(
                          "Çalışılmayacak saatler:",
                          unavailableHours
                        );

                        if (unavailableHours.length > 0) {
                          // Her saat etiketi için kontrol et
                          $(".custom-option-item").each(function () {
                            // Etiketin içindeki saat yazısını al (small etiketinden)
                            var timeText = $(this).find("small").text().trim();
                            console.log("Kontrol edilen saat:", timeText);

                            // Çalışılmayacak saatler içinde mi kontrol et
                            if (unavailableHours.includes(timeText)) {
                              console.log("Devre dışı bırakılıyor:", timeText);

                              // Input'u bul ve devre dışı bırak
                              var inputId = $(this).attr("for");
                              if (inputId) {
                                $("#" + inputId)
                                  .prop("disabled", true)
                                  .prop("checked", false);
                              }

                              // Etiketi işaretle ve stil uygula
                              $(this)
                                .addClass("unavailable-time")
                                .attr("data-unavailable", "true")
                                .css({
                                  opacity: "0.6",
                                  "background-color": "#f8f8f8",
                                  color: "#999",
                                  cursor: "not-allowed",
                                  "border-color": "#ddd",
                                  position: "relative",
                                })
                                // Çarpı işareti ekle
                                .append(
                                  '<div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; display: flex; align-items: center; justify-content: center; color: #ff0000; font-size: 18px; pointer-events: none;">⊘</div>'
                                );

                              // İçindeki yazı ve ikonları grileştir
                              $(this).find("small").css("color", "#999");
                              $(this)
                                .find(".fa-star-of-life")
                                .css("color", "#999");
                            }
                          });
                        }
                      } else {
                        console.error(
                          "Çalışılmayacak saatler alınamadı:",
                          unavailableResponse.message
                        );
                      }
                    },
                    error: function (xhr, status, error) {
                      console.error(
                        "Çalışılmayacak saatler yüklenirken hata oluştu:",
                        error
                      );
                      console.error("Durum:", status);
                      console.error("XHR:", xhr.responseText);
                    },
                  });
                } else {
                  console.error("HATA: providerID veya date tanımlı değil", {
                    providerID: providerID,
                    date: date,
                  });
                }

                // Setup time selection handlers
                $(document).off("change", ".custom-option-item-check");
                $(document).on(
                  "change",
                  ".custom-option-item-check",
                  function () {
                    // Devre dışı butonlar için kontrolü engelle
                    if ($(this).is(":disabled")) {
                      return false;
                    }

                    var selectedValue = $(this).val();
                    console.log("Saat seçildi:", selectedValue);

                    // Store selected time globally
                    window.selectedTime = selectedValue;

                    // Enable Continue button
                    $("#nextBtn").prop("disabled", false);

                    // İlgili label'ı bul
                    var selectedLabel = $(
                      'label[for="' + $(this).attr("id") + '"]'
                    );

                    // Reset all labels first
                    $(".custom-option-item")
                      .removeClass("active")
                      .each(function () {
                        // Devre dışı saatler için stili koruyalım, diğerlerini sıfırlayalım
                        if (!$(this).hasClass("unavailable-time")) {
                          // Reset CSS to original values
                          $(this).css({
                            "border-color": "",
                            "background-color": "",
                            "box-shadow": "",
                          });

                          // Reset text and icon colors for special day times
                          if ($(this).hasClass("special-day-time")) {
                            $(this).find("small").css("color", "#0077be");
                            $(this)
                              .find(".fa-star-of-life")
                              .css("color", "#0077be");
                          }
                        } else {
                          // Çalışılmayacak saatlerin stilini koru ve data-unavailable attribute'u olup olmadığını kontrol et
                          if ($(this).attr("data-unavailable") === "true") {
                            $(this).css({
                              opacity: "0.6",
                              "background-color": "#f8f8f8",
                              color: "#999",
                              cursor: "not-allowed",
                              "border-color": "#ddd",
                              position: "relative",
                            });

                            // Çarpı işaretinin de durmasını sağla
                            if (
                              $(this).find('div:contains("⊘")').length === 0
                            ) {
                              $(this).append(
                                '<div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; display: flex; align-items: center; justify-content: center; color: #ff0000; font-size: 18px; pointer-events: none;">⊘</div>'
                              );
                            }
                          }
                        }
                      });

                    // Apply active styles
                    selectedLabel.addClass("active");

                    // Özel gün saati seçili olduğunda
                    if ($(this).hasClass("special-day-time")) {
                      console.log("Özel gün saati seçildi");

                      // Inline style ekle - CSS'ten daha öncelikli olarak uygulanacak
                      selectedLabel.css({
                        border: "3px solid #ff3d00",
                        "background-color": "#fff2e6",
                        "box-shadow": "0 0 10px rgba(255, 100, 0, 0.6)",
                      });

                      // İçindeki küçük yazı ve simge rengini değiştir
                      selectedLabel.find("small").css("color", "#ff3d00");
                      selectedLabel
                        .find(".fa-star-of-life")
                        .css("color", "#ff3d00");
                    }
                  }
                );
              },
              error: function (xhr, status, error) {
                console.error("AJAX Hatası:", error, "Durum:", status);
                console.error("XHR Response Text:", xhr.responseText);

                // Detaylı hata mesajı göster
                let errorMessage =
                  "Saat bilgileri yüklenirken bir hata oluştu. Lütfen tekrar deneyin.";
                let debugInfo = "";

                if (xhr.responseText) {
                  try {
                    // PHP hata mesajı içeriyor mu kontrol et
                    if (
                      xhr.responseText.includes("Fatal error") ||
                      xhr.responseText.includes("Parse error") ||
                      xhr.responseText.includes("Warning")
                    ) {
                      errorMessage += " (Sunucu hatası)";
                      debugInfo = xhr.responseText.substring(0, 500); // İlk 500 karakteri al
                      console.error("PHP Hatası tespit edildi:", debugInfo);
                    }
                  } catch (e) {
                    console.error("Hata analiz edilirken sorun oluştu:", e);
                  }
                }

                // Konsola AJAX istek bilgilerini yazdır
                console.error("AJAX istek durumu:", {
                  url: "/admin/system/ajax/AvailableTimeAjax.php",
                  method: "POST",
                  data: ajaxParams,
                  status: status,
                  error: error,
                  responseLength: xhr.responseText
                    ? xhr.responseText.length
                    : 0,
                });

                // Debugger bilgilerini hazırla
                let debugHTML = "";
                if (debugInfo) {
                  debugHTML =
                    "<div class='mt-2 p-2 bg-light text-dark' style='font-size: 12px; overflow: auto; max-height: 100px;'>" +
                    "<strong>Hata Detayları:</strong><br>" +
                    "<pre>" +
                    debugInfo.replace(/</g, "&lt;").replace(/>/g, "&gt;") +
                    "</pre>" +
                    "</div>";
                }

                $("#timeSelect").html(
                  "<div class='alert alert-danger'>" +
                    errorMessage +
                    "<div class='mt-2'><small>Tarih: " +
                    date +
                    ", Personel ID: " +
                    providerID +
                    ", Hizmet ID: " +
                    hizmetID +
                    "</small></div>" +
                    debugHTML +
                    "</div>"
                );

                // Show error message to user
                Swal.fire({
                  title: "Hata",
                  text: errorMessage,
                  icon: "error",
                  confirmButtonColor: "#ff950e",
                  confirmButtonText: "Tamam",
                });
              },
              timeout: 30000, // 30 second timeout
            });
          },
          onOpen: function (selectedDates, dateStr, instance) {
            console.log("Flatpickr takvimi açıldı");
          },
          onClose: function (selectedDates, dateStr, instance) {
            console.log("Flatpickr takvimi kapandı, seçilen tarih:", dateStr);
          },
        });

        // Open calendar when clicking on date field
        $(document)
          .off("click", "#start-date")
          .on("click", "#start-date", function () {
            console.log("Tarih alanına tıklandı, takvim açılıyor");
            var startDateEl = document.getElementById("start-date");
            if (startDateEl && startDateEl._flatpickr) {
              startDateEl._flatpickr.open();
              console.log("Takvim açıldı (tıklama ile)");
            }
          });

        // Auto-open calendar
        setTimeout(function () {
          console.log("Takvim otomatik açılıyor");
          if (startDateEl && startDateEl._flatpickr) {
            startDateEl._flatpickr.open();
            console.log("Takvim açıldı");
          } else {
            console.error("Takvim açılamadı, flatpickr bulunamadı");
          }
        }, 500);
      } else {
        console.error("flatpickr tanımlı değil!");
      }
    }, 300);
  }

  // Summary page validation
  if (currentTab == 3) {
    // Check if date and time are selected
    if (
      !$("#start-date").val() ||
      !$(".custom-option-item-check:checked").val()
    ) {
      Swal.fire({
        title: "Hata",
        text: "Lütfen tarih ve saat seçimi yapınız!",
        icon: "warning",
        confirmButtonColor: "#ff950e",
        confirmButtonText: "Tamam",
      }).then((result) => {
        nextPrev(-1);
      });
      return;
    }

    // Update summary info
    updateSummary();
  }

  return true;
}

/**
 * Özet ekranını güncelleyen fonksiyon
 */
function updateSummary() {
  console.log("Özet ekranı güncelleniyor");

  // Customer info
  var adSoyad = $("#musteriAd").val() || "Belirtilmedi";
  var telefon = $("#musteriTelefon").val() || "Belirtilmedi";

  // Service and provider info
  var hizmetAd = $("#service option:selected").text() || "Belirtilmedi";
  var calisanAd = $("#providerAdSoyad").val() || "Belirtilmedi";

  // Date and time info
  // Tarih değerini alırken alternatif değeri de kontrol et
  var tarih = "";

  // Eğer altInput kullanılıyorsa, görüntülenen değeri al (Örn: 19 Nisan 2025)
  if (document.querySelector(".flatpickr-input.flatpickr-input.active")) {
    tarih =
      document.querySelector(".flatpickr-input.flatpickr-input.active").value ||
      $("#start-date").val() ||
      "Belirtilmedi";
  } else {
    tarih = $("#start-date").val() || "Belirtilmedi";
  }

  var saat = window.selectedTime || "Belirtilmedi";

  // Format time (H:i:s -> H:i)
  if (saat && saat.length > 5) {
    saat = saat.substr(0, 5);
  }

  console.log("Özet bilgileri:", {
    adSoyad: adSoyad,
    telefon: telefon,
    hizmet: hizmetAd,
    calisan: calisanAd,
    tarih: tarih,
    saat: saat,
  });

  // Update summary fields
  $("#OzetAdSoyad").text(adSoyad);
  $("#OzetTelefon").text(telefon);
  $("#OzetHizmetAd").text(hizmetAd);
  $("#OzetCalisanAd").text(calisanAd);
  $("#OzetTarih").text(tarih);
  $("#OzetSaat").text(saat);

  console.log("Özet ekranı güncellendi");
}

/**
 * Form adımını doğrulayan fonksiyon
 * @param {number} step - Doğrulanacak form adımı
 * @returns {boolean} - Doğrulama sonucu
 */
function validateForm(step) {
  console.log("Form doğrulaması başladı, adım:", step);
  var valid = true;

  // Get current step if not provided
  var currentStep = step !== undefined ? step : currentTab;

  console.log("Form doğrulama, adım:", currentStep);

  // Step 1: Personal information
  if (currentStep === 0) {
    var adSoyadInput = $("#musteriAd");
    var telefonInput = $("#musteriTelefon");

    if (
      !adSoyadInput.val() ||
      adSoyadInput
        .val()
        .trim()
        .split(" ")
        .filter((part) => part.length > 0).length < 2
    ) {
      valid = false;
      console.error("Ad soyad eksik veya geçersiz");
    }

    if (!telefonInput.val() || telefonInput.val().length < 10) {
      valid = false;
      console.error("Telefon eksik veya geçersiz");
    }
  }
  // Step 2: Service and provider selection
  else if (currentStep === 1) {
    if (!$("#service").val() || $("#service").val() === "") {
      valid = false;
      console.error("Hizmet seçilmedi");
    }

    if (!$("#providerID").val() || $("#providerID").val() === "") {
      valid = false;
      console.error("Personel seçilmedi");
    }
  }
  // Step 3: Date and time selection
  else if (currentStep === 2) {
    console.log("Seçilen tarih:", $("#start-date").val());
    console.log("Seçilen saat:", window.selectedTime);
    console.log(
      "Saat radio buton seçimi:",
      $(".custom-option-item-check:checked").length
    );

    // Tarih alanını kontrol et - normal hidden input veya görünen alternatif input
    var dateSelected = false;

    // Eğer altInput kullanılıyorsa, görüntülenen değeri kontrol et
    if (
      document.querySelector(".flatpickr-input.flatpickr-input.active") &&
      document.querySelector(".flatpickr-input.flatpickr-input.active").value
    ) {
      dateSelected = true;
    } else if ($("#start-date").val() && $("#start-date").val() !== "") {
      dateSelected = true;
    }

    if (!dateSelected) {
      valid = false;
      console.error("Tarih seçilmedi");
    }

    if (
      !window.selectedTime ||
      $(".custom-option-item-check:checked").length === 0
    ) {
      valid = false;
      console.error("Saat seçilmedi");
    }
  }

  console.log("Validasyon sonucu:", valid);

  // Mark step as finished if valid
  if (valid) {
    var steps = document.getElementsByClassName("step");
    if (currentStep < steps.length) {
      steps[currentStep].className += " finish";
    }
  } else {
    // Show error message
    Swal.fire({
      title: "Hata",
      text: "Lütfen tüm zorunlu alanları doldurun!",
      icon: "error",
      confirmButtonColor: "#7367f0",
      confirmButtonText: "Tamam",
    });
  }

  return valid;
}

/**
 * Adım göstergelerini güncelleme fonksiyonu
 * @param {number} n - Aktif adım
 */
function fixStepIndicator(n) {
  // Remove "active" class from all steps
  var i,
    x = document.getElementsByClassName("step");
  
  // Adımlar yoksa işlemi durdur
  if (x.length === 0) {
    console.log("fixStepIndicator: Adım göstergeleri bulunamadı");
    return;
  }
  
  for (i = 0; i < x.length; i++) {
    x[i].className = x[i].className.replace(" active", "");
  }
  
  // Geçersiz indeks kontrolü
  if (n < 0 || n >= x.length) {
    console.error("fixStepIndicator: Geçersiz adım indeksi", n);
    return;
  }
  
  // Add "active" class to current step
  x[n].className += " active";
}
