<?php

require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/db.php';

// notification_log tablosunu oluştur (eğer yoksa)
try {
    $table_check = $DB->query("SHOW TABLES LIKE 'notification_log'");
    if ($table_check->rowCount() == 0) {
        // Tablo yoksa oluştur
        $DB->exec("CREATE TABLE IF NOT EXISTS notification_log (
            id INT AUTO_INCREMENT PRIMARY KEY,
            appointment_id INT NOT NULL,
            phone VARCHAR(20) NOT NULL,
            notification_type VARCHAR(20) NOT NULL,
            sent_at DATETIME NOT NULL,
            success TINYINT(1) DEFAULT 1
        )");
    }
} catch (Exception $e) {
    // Sessizce devam et
}

require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/eral.php';


$settingsCheck = $DB->prepare("select * from settings where id=?");

$settingsCheck->execute(array('1'));

$settings = $settingsCheck->fetch(PDO::FETCH_ASSOC);

$default = $settings['defaultLang'];

$defaultLangCheck = $DB->prepare("select * from languages where code=?");

$defaultLangCheck->execute(array($default));

$defaultLangValue = $defaultLangCheck->fetch(PDO::FETCH_ASSOC);

// id fonksiyonu ana index.php'de tanımlanmış olabilir, o yüzden kontrol ediyoruz
if (!function_exists('id')) {
    function id($text) {
        $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
        $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
        $text = strtolower(str_replace($find, $replace, $text));
        $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
        $text = trim(preg_replace('/\s+/', ' ', $text));
        $text = str_replace(' ', '', $text);
        return $text;
    }
}

?>

<!DOCTYPE html>
<html lang="tr">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?=$translations['sitetitle']?></title>
  <meta name="description" content="<?=$settings['siteDesc']?>">
  <meta name="keywords" content="<?=$settings['siteKeyword']?>">

  <!-- jQuery EN BAŞTA yüklenmeli -->
  <script src="./assets/js/jquery-3.6.0.min.js"></script>

  <!-- intlTelInput utils.js için CDN bağlantısı -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js"></script>

  <!-- Tarayıcı ve mobil cihaz meta etiketleri -->
  <meta name="mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black">
  <meta name="apple-mobile-web-app-title" content="<?=$settings['siteName']?>">
  <meta name="msapplication-TileImage" content="../assets/144x144.png">
  <meta name="msapplication-TileColor" content="#2F3BA2">

  <!-- CSS Kütüphaneleri -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Jost:wght@400;500;600;700;800&family=Lato&display=swap"
    rel="stylesheet">
  <link rel="stylesheet" href="./assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="./assets/css/animate.min.css">
  <link rel="stylesheet" href="./assets/css/style.css?v=1.2">
  <link rel="stylesheet" href="./assets/css/intlTelInput.css">

  <!-- Ek CSS Kütüphaneleri -->
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/forms/select/select2.min.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/plugins/forms/pickers/form-flat-pickr.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/calendars/fullcalendar.min.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/pages/app-calendar.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/plugins/forms/form-validation.css">
  <link href="https://afeld.github.io/emoji-css/emoji.css" rel="stylesheet">

  <!-- Favicon ve Manifest -->
  <link rel="manifest" href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/manifest.json?v=1.1">
  <link rel="apple-touch-icon" href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/144x144.png">
  <link rel="apple-touch-icon" href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/192x192.png">
  <link rel="icon" sizes="192x192" href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/192x192.png">
  <link rel="icon" sizes="128x128" href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/assets/128x128.png">

  <style>
  /* Bayrak stil kodları */
  .iti__flag {
    background-image: url("assets/images/flags/flags.png");
  }

  @media (-webkit-min-device-pixel-ratio: 2),
  (min-resolution: 192dpi) {
    .iti__flag {
      background-image: url("assets/images/flags/flags@2x.png");
    }
  }

  /* Select2 alan stillemeleri */
  .select2-container .select2-selection--single {
    height: 50px;
  }

  .select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 45px;
  }

  /* Özel seçenekler ve form elemanları için stil */
  .custom-options-checkable .custom-option-item {
    width: 100%;
    cursor: pointer;
    border-radius: 0.42rem;
    color: #82868b;
    background-color: rgba(130, 134, 139, 0.06);
    border: 1px solid #ebe9f1;
  }

  .custom-options-checkable .custom-option-item .custom-option-item-title {
    color: #82868b;
  }

  /* Checkbox stil ayarlamaları */
  .custom-option-item-check {
    position: absolute;
    clip: rect(0, 0, 0, 0);
  }

  .custom-option-item-check:checked+.custom-option-item {
    color: #ff950e;
    background-color: rgba(255, 149, 14, 0.1);
    border-color: #ff950e;
  }

  .custom-option-item-check:checked+.custom-option-item .custom-option-item-title {
    color: #ff950e;
  }

  /* Provider checkbox için stil */
  .custom-option-item-check-provider {
    position: absolute;
    clip: rect(0, 0, 0, 0);
  }

  .custom-option-item-check-provider:checked+.custom-option-item {
    color: #ff950e;
    background-color: rgba(255, 149, 14, 0.1);
    border-color: #ff950e;
  }

  .custom-option-item-check-provider:checked+.custom-option-item .custom-option-item-title {
    color: #ff950e;
  }

  /* Flatpickr tarih seçici stil */
  .flatpickr-calendar .flatpickr-day.selected,
  .flatpickr-calendar .flatpickr-day.selected:hover {
    background: #ff950e;
    color: #fff;
    border-color: #ff950e;
  }

  .flatpickr-calendar .flatpickr-day.today {
    border-color: #ff950e;
  }

  /* Form doğrulama için stil */
  .invalid {
    border-color: red;
  }

  /* Başlık rengi gradient */
  .titleColor {
    background: -webkit-linear-gradient(top right, #ffaf15, #fe6300);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }

  /* Duyarlı logo gösterimi */
  .logo-desktop {
    display: block;
  }

  .logo-mobile {
    display: none;
  }

  @media screen and (max-width: 1199px) {
    .logo-desktop {
      display: none;
    }

    .logo-mobile {
      display: block;
    }
  }

  /* Dil menüsü için stil */
  .dropdown-menu {
    min-width: 70px !important;
  }

  .flags {
    cursor: pointer;
  }

  /* Müşteri form alanı stilleri */
  .musteri {
    padding: 10px;
  }

  .musteriB {
    border-radius: 0.525rem;
  }

  /* Uygulama yükleme butonu */
  /* Modern PWA yükleme butonu */
  .install-button {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: linear-gradient(to right, #ff950e, #ff7600);
    color: white;
    border: none;
    border-radius: 50px;
    box-shadow: 0 4px 16px rgba(255, 149, 14, 0.4);
    padding: 12px 24px;
    font-size: 16px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1050;
    transition: all 0.3s ease;
    transform: translateY(100px);
    opacity: 0;
    display: none;
    /* Başlangıçta gizli */
    cursor: pointer;
    text-decoration: none;
  }

  .install-button.pwa-button-visible {
    transform: translateY(0);
    opacity: 1;
    animation: pulse 2s infinite;
  }

  .install-button:hover {
    box-shadow: 0 6px 20px rgba(255, 118, 0, 0.5);
    transform: translateY(-3px);
    opacity: 1;
    animation: none;
  }

  .install-button i {
    margin-right: 8px;
    font-size: 18px;
  }

  .install-button:active {
    transform: translateY(1px);
    box-shadow: 0 2px 10px rgba(255, 118, 0, 0.4);
  }

  .button-clicked {
    transform: scale(0.95) !important;
    box-shadow: 0 2px 8px rgba(255, 118, 0, 0.3) !important;
  }

  /* Pulse animasyonu */
  @keyframes pulse {
    0% {
      box-shadow: 0 4px 16px rgba(255, 149, 14, 0.4);
    }

    50% {
      box-shadow: 0 4px 24px rgba(255, 149, 14, 0.7);
    }

    100% {
      box-shadow: 0 4px 16px rgba(255, 149, 14, 0.4);
    }
  }

  /* Mobil için uyarlamalar */
  @media (max-width: 767px) {
    .install-button {
      bottom: 15px;
      right: 15px;
      padding: 10px 20px;
      font-size: 14px;
      border-radius: 50px;
    }
  }

  /* Tablet için uyarlamalar */
  @media (min-width: 768px) and (max-width: 991px) {
    .install-button {
      bottom: 30px;
      right: 30px;
    }
  }
  </style>
</head>

<body>
  <!-- Service Worker Kayıt Scripti -->
  <script>
  if ('serviceWorker' in navigator) {
    window.addEventListener('load', function() {
      navigator.serviceWorker.register('service-worker.js')
        .then(function(registration) {})
        .catch(function(err) {});
    });
  } else {}
  </script>

  <!-- Feather Icons Kütüphanesi -->
  <script src="https://unpkg.com/feather-icons"></script>

  <div class="wrapper position-relative overflow-hidden">
    <div class="container-md-fluid p-3 p-lg-0 me-5">
      <div class="row">
        <!-- Sol Sütun - Logo ve Adımlar -->
        <div class="col-xl-4">
          <div class="form_logo position-absolute">
            <a href="#">
              <img
                src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/images/logo/<?=$settings['siteLogo']?>"
                class="logo-desktop" alt="<?=$settings['siteName']?> Logo">
              <img
                src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/images/logo/<?=$settings['siteLogoMobile']?>"
                class="logo-mobile" alt="<?=$settings['siteName']?> Logo">
            </a>
          </div>

          <!-- Adım Göstergeleri - Sadece XL ekranlarda görünür -->
          <div class="steps_area step_area_fixed d-none d-xl-block">
            <div class="image_holder">
              <img class="overflow-hidden" src="assets/images/background/bg_0.png" alt="Adım Arkaplanı">
            </div>
            <div class="step_items position-absolute">
              <div class="step d-block text-center bg-white position-relative current active">1</div>
              <div class="step d-block text-center bg-white position-relative">2</div>
              <div class="step d-block text-center bg-white position-relative">3</div>
              <div class="step d-block text-center bg-white position-relative last">4</div>
            </div>
          </div>
        </div>

        <!-- Sağ Sütun - Form Alanı -->
        <div class="col-xl-7 ps-5 pt-5">
          <form class="multisteps_form" id="wizard" method="POST">

            <!-- Adım 1: Müşteri Bilgileri -->
            <div class="multisteps_form_panel" style="display: block;">
              <?php if($settings['langSystem']=='1'){ ?>
              <select style="width: 150px;margin-bottom:20px;" class="form-control" name="lang" id="lang">
                <?php $langs = $DB->query("SELECT * from languages order by id")->fetchAll(PDO::FETCH_ASSOC);
                foreach ($langs as $langsCek) { ?>
                <option <?php if($language==$langsCek['code']){echo 'selected';} ?> value="<?=$langsCek['code']?>">
                  <?=$langsCek['name']?></option>
                <?php }?>
              </select>
              <?php }?>

              <div class="step_content d-flex justify-content-between pt-5 pb-2">
                <h4><?=$translations['sitetitle']?></h4>
                <span class="text-end text-uppercase">1. <?=$translations['step']?> | 1/4</span>
              </div>

              <div class="step_progress_bar">
                <div class="progress rounded-pill">
                  <div class="progress-bar" style="width:25%"></div>
                </div>
              </div>

              <div class="form_content">
                <div class="question_title py-5">
                  <h1 class="text-capitalize"><?=$translations['info']?></h1>
                </div>

                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-1 form_items">
                  <div class="col">
                    <div class="input-group input-group-merge musteri">
                      <span class="input-group-text musteriB"><i data-feather="user"></i></span>
                      <input type="text" id="musteriAd" class="form-control musteri musteriB" name="musteriAd"
                        placeholder="<?=$translations['namesurname']?>" required aria-required="true"
                        onblur="validateName(this)" />
                    </div>
                  </div>

                  <?php if($settings['emailSystem']=='1'){ ?>
                  <div class="col">
                    <div class="input-group input-group-merge musteri">
                      <span class="input-group-text musteriB"><i data-feather="mail"></i></span>
                      <input type="email" id="musteriMail" class="form-control musteri musteriB" name="musteriMail"
                        placeholder="Mail Adresi" />
                    </div>
                  </div>
                  <?php } ?>

                  <div class="col">
                    <div class="input-group input-group-merge musteri">
                      <input type="tel" id="musteriTelefon" class="form-control musteri musteriB" name="musteriTelefon"
                        placeholder="5459548706" autocomplete="off" maxlength="10"
                        oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required
                        aria-required="true" />
                    </div>
                  </div>
                </div>
              </div>

              <div class="form_btn pt-5 d-flex justify-content-between">
                <button type="button" class="prev_btn text-uppercase bg-white" id="prevBtn" onclick="nextPrev(-1)"
                  style="display: none;"><span><i class="fas fa-arrow-left"></i></span>
                  <?=$translations['back']?></button>
                <button type="button" class="next_btn text-uppercase text-white" id="nextBtn"
                  onclick="nextPrev(1)"><?=$translations['continue']?> <span><i
                      class="fas fa-arrow-right"></i></span></button>
              </div>
            </div>

            <!-- Adım 2: Hizmet Seçimi -->
            <div class="multisteps_form_panel">
              <div class="step_content d-flex justify-content-between pt-5 pb-2">
                <h4><?=$translations['sitetitle']?></h4>
                <span class="text-end text-uppercase">2. <?=$translations['step']?> | 2/4</span>
              </div>

              <div class="step_progress_bar">
                <div class="progress rounded-pill">
                  <div class="progress-bar" style="width:50%"></div>
                </div>
              </div>

              <div class="form_content">
                <div class="question_title py-5">
                  <h1 class="text-capitalize"><?=$translations['chooseservice']?></h1>
                </div>

                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                  <div class="col-12">
                    <div class="mb-1">
                      <select class="select2 select-label form-select w-100" id="service" name="service" required
                        aria-required="true">
                        <option selected="" disabled="" value=""><?=$translations['select']?></option>
                        <?php $services = $DB->query("select * from services order by sira ASC")->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($services as $service) { ?>
                        <option id="service<?=$service['id']?>" data-label="<?=id($service['serviceName'])?>"
                          data-duration="<?=$service['hour']?>" value="<?=$service['id']?>">
                          <?=$service['serviceName']?> | <?=$service['price']?>₺ (<?=$service['hour']?> dk)
                        </option>
                        <?php } ?>
                      </select>
                    </div>
                  </div>

                  <div class="col-12">
                    <div class="mb-1">
                      <div class="card">
                        <div class="card-body">
                          <div id="providerList" class="row custom-options-checkable g-1">
                            <!-- Servis seçildiğinde AJAX ile doldurulacak -->
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- Hizmet seçimi işleyicisi -->
                  <script type="text/javascript">
                  // jQuery yüklendikten sonra çalıştır
                  window.addEventListener("load", function() {
                    // Service değiştiğinde
                    $("#service").on("change", function() {
                      var serviceID = $(this).val();
                      console.log("Hizmet seçildi, ID:", serviceID);

                      // Yükleniyor göstergesi ekle
                      $("#providerList").html(
                        '<div class="col-12 text-center py-3"><i class="fas fa-spinner fa-spin"></i> Personel listesi yükleniyor...</div>'
                      );

                      $.ajax({
                        type: "POST",
                        url: "/admin/system/ajax/ProviderAjaxMusteri.php",
                        data: {
                          "serviceID": serviceID
                        },
                        success: function(response) {
                          console.log("Personel listesi başarıyla yüklendi");
                          $("#providerList").html(response);
                          $("#timeSelect").html(""); // Saat seçimini temizle
                        },
                        error: function(xhr, status, error) {
                          console.error("Personel yükleme hatası:", error);
                          $("#providerList").html(
                            '<div class="col-12 text-center py-3"><div class="alert alert-danger">Personel listesi yüklenirken bir hata oluştu. Lütfen tekrar deneyin.</div></div>'
                          );
                        },
                        timeout: 30000 // 30 saniye zaman aşımı
                      });
                    });
                  });
                  </script>

                  <!-- Personel seçimi işleyicisi -->
                  <script type="text/javascript">
                  // jQuery yüklendikten sonra çalıştır
                  window.addEventListener("load", function() {
                    // Personel seçimi için event delegation kullanılıyor
                    $(document).on("change", "input[type='radio'][name='provider']", function() {
                      var providerId = $(this).val();
                      var providerName = $(this).data('name') || '';

                      $('#providerID').val(providerId);
                      $('#providerAdSoyad').val(providerName);

                      console.log("Personel seçildi: " + providerId + " - " + providerName);

                      var date = $('#start-date').val();
                      var hizmetID = $('#service').val();

                      // Eğer tarih seçilmişse saatleri yükle
                      if (date) {
                        loadAvailableTimes(date, providerId, hizmetID);
                      }
                    });

                    // Saatleri yükleme fonksiyonu
                    window.loadAvailableTimes = function(date, providerId, hizmetID) {
                      // Yükleniyor göstergesi
                      $("#timeSelect").html(
                        '<div class="text-center py-3"><i class="fas fa-clock"></i> Saatler hazırlanıyor...</div>'
                      );

                      $.ajax({
                        type: "POST",
                        url: "/admin/system/ajax/AvailableTimeAjax.php",
                        data: {
                          "date": date,
                          "providerID": providerId,
                          "hizmet": hizmetID
                        },
                        success: function(response) {
                          console.log("Saatler başarıyla yüklendi");
                          $("#timeSelect").html(response);
                        },
                        error: function(xhr, status, error) {
                          console.error("Saat yükleme hatası:", error);
                          $("#timeSelect").html(
                            '<div class="alert alert-danger">Saat bilgileri yüklenirken bir hata oluştu. Lütfen tekrar deneyin.</div>'
                          );
                        },
                        timeout: 30000 // 30 saniye zaman aşımı
                      });
                    };
                  });
                  </script>
                </div>
              </div>

              <div class="form_btn pt-5 d-flex justify-content-between">
                <button type="button" class="prev_btn text-uppercase bg-white" id="prevBtn"
                  onclick="nextPrev(-1)"><span><i class="fas fa-arrow-left"></i></span>
                  <?=$translations['back']?></button>
                <button type="button" class="next_btn text-uppercase text-white" id="nextBtn"
                  onclick="nextPrev(1)"><?=$translations['continue']?> <span><i
                      class="fas fa-arrow-right"></i></span></button>
              </div>
            </div>

            <!-- Adım 3: Tarih ve Saat Seçimi -->
            <div class="multisteps_form_panel">
              <div class="step_content d-flex justify-content-between pt-5 pb-2">
                <h4><?=$translations['sitetitle']?></h4>
                <span class="text-end text-uppercase">3. <?=$translations['step']?> | 3/4</span>
              </div>

              <div class="step_progress_bar">
                <div class="progress rounded-pill">
                  <div class="progress-bar" style="width:75%"></div>
                </div>
              </div>

              <div class="form_content">
                <div class="question_title py-5">
                  <h1 class="text-capitalize"><?=$translations['selectdate']?></h1>
                </div>

                <!-- Seçilen hizmet ve personel bilgisi -->
                <div class="selected-info-card mb-4">
                  <div class="card border-0 shadow-sm">
                    <div class="card-body p-3">
                      <div class="d-flex justify-content-between align-items-center mb-2">
                        <h5 class="mb-0 fw-bold" style="color: #ff950e;">Seçilen Bilgiler</h5>
                        <i class="fas fa-check-circle text-success"></i>
                      </div>
                      <div class="row">
                        <div class="col-md-6 mb-2">
                          <div class="d-flex align-items-center">
                            <i class="fas fa-cut me-2" style="color: #ff950e;"></i>
                            <div>
                              <small class="text-muted d-block">Hizmet</small>
                              <strong id="selectedServiceName">-</strong>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-6 mb-2">
                          <div class="d-flex align-items-center">
                            <i class="fas fa-user me-2" style="color: #ff950e;"></i>
                            <div>
                              <small class="text-muted d-block">Personel</small>
                              <strong id="selectedProviderName">-</strong>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                  <div class="col-12">
                    <div class="mb-1 position-relative">
                      <input type="text" class="form-control" id="start-date" name="start-date"
                        placeholder="<?=$translations['appointmentdate']?>" readonly required aria-required="true" />
                    </div>
                  </div>

                  <div style="margin-top:15px"></div>

                  <div class="col-12">
                    <div class="mb-1">
                      <div class="row custom-options-checkable g-1" id="timeSelect">
                        <!-- Tarih seçildiğinde AJAX ile doldurulacak -->
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Seçilen bilgileri güncelleme script -->
              <script>
              $(document).ready(function() {
                // Bilgileri güncelleme fonksiyonu
                function updateSelectedInfo() {
                  try {
                    // Doğrudan DOM'dan değerleri alalım (daha güvenilir)
                    var serviceEl = document.getElementById('service');
                    var serviceText = '';
                    if (serviceEl && serviceEl.selectedIndex > -1) {
                      serviceText = serviceEl.options[serviceEl.selectedIndex].text;
                    }

                    // Provider değerini al
                    var providerNameEl = document.getElementById('providerAdSoyad');
                    var providerText = providerNameEl ? providerNameEl.value : '';

                    // Debug bilgisi
                    console.log('DOM elementleri:', {
                      serviceEl: serviceEl,
                      providerNameEl: providerNameEl,
                      serviceText: serviceText,
                      providerText: providerText,
                      serviceSelectedIndex: serviceEl ? serviceEl.selectedIndex : 'N/A',
                      providerID: document.getElementById('providerID') ? document.getElementById('providerID')
                        .value : 'N/A'
                    });

                    // Bilgileri güncelle
                    document.getElementById('selectedServiceName').textContent = serviceText || '-';
                    document.getElementById('selectedProviderName').textContent = providerText || '-';

                    console.log('Hizmet ve personel bilgileri güncellendi:', serviceText, providerText);
                  } catch (e) {
                    console.error('Bilgi güncelleme hatası:', e);
                  }
                }

                // Adım 3'e geçildiğinde seçilen bilgileri güncelle
                $(document).on('DOMNodeInserted', function(e) {
                  // Adım 3 görünür olduğunda
                  if ($(e.target).hasClass('multisteps_form_panel') && $(e.target).css('display') === 'block') {
                    var currentStep = 0;
                    $('.multisteps_form_panel').each(function(index) {
                      if ($(this).css('display') === 'block') {
                        currentStep = index;
                      }
                    });

                    // Eğer 3. adıma geçilmişse (indeks 2)
                    if (currentStep === 2) {
                      // Bilgileri güncelle
                      setTimeout(updateSelectedInfo, 100);
                    }
                  }
                });

                // Personel veya hizmet seçimi değiştiğinde de bilgileri güncelle
                $(document).on('change', '#service, input[name="provider"]', function() {
                  setTimeout(function() {
                    // Mevcut adımı tespit et
                    var currentStep = 0;
                    $('.multisteps_form_panel').each(function(index) {
                      if ($(this).css('display') === 'block') {
                        currentStep = index;
                      }
                    });

                    // 3. adımda isek bilgileri güncelle
                    if (currentStep === 2) {
                      updateSelectedInfo();
                    }
                  }, 100);
                });

                // nextBtn, prevBtn tıklamalarını izle
                $(document).on('click', '#nextBtn, #prevBtn', function() {
                  // Bilgi güncelleme işlemini sıraya al
                  setTimeout(function() {
                    // Mevcut adımı tespit et
                    var currentStep = 0;
                    $('.multisteps_form_panel').each(function(index) {
                      if ($(this).css('display') === 'block') {
                        currentStep = index;
                      }
                    });

                    // 3. adımda isek bilgileri güncelle
                    if (currentStep === 2) {
                      updateSelectedInfo();
                    }
                  }, 200);
                });

                // Sayfa ilk yüklendiğinde de kontrol et
                setTimeout(function() {
                  var currentStep = 0;
                  $('.multisteps_form_panel').each(function(index) {
                    if ($(this).css('display') === 'block') {
                      currentStep = index;
                    }
                  });

                  if (currentStep === 2) {
                    updateSelectedInfo();
                  }
                }, 500);
              });
              </script>

              <!-- Tarih seçimi işleyicisi -->
              <script type="text/javascript">
              // jQuery yüklendikten sonra çalıştır
              window.addEventListener("load", function() {
                console.log("Tarih adımı script yüklendi");

                // Takvim açılması için click handler ekle
                $(document).off('click', '#start-date').on('click', '#start-date', function() {
                  console.log("Tarih inputuna tıklandı, takvim açılıyor");

                  // Flatpickr hazır mı kontrol et
                  if (typeof flatpickr === 'undefined') {
                    console.error("flatpickr yüklenemedi!");
                    return;
                  }

                  var startDateEl = document.getElementById('start-date');

                  // Flatpickr yoksa yeni oluştur
                  if (!startDateEl._flatpickr) {
                    console.log("Flatpickr bulunamadı, yeniden oluşturuluyor");
                    flatpickr(startDateEl, {
                      dateFormat: "Y-m-d",
                      minDate: "today",
                      disableMobile: true,
                      clickOpens: true,
                      altInput: true,
                      altFormat: "d F Y", // Görüntülenen format: 19 Nisan 2025
                      locale: {
                        firstDayOfWeek: 1,
                        weekdays: {
                          longhand: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma',
                            'Cumartesi'
                          ],
                          shorthand: ['Paz', 'Pzt', 'Sal', 'Çar', 'Per', 'Cum', 'Cmt']
                        },
                        months: {
                          longhand: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz',
                            'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'
                          ],
                          shorthand: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki',
                            'Kas', 'Ara'
                          ]
                        }
                      },
                      onChange: function(selectedDates, dateStr) {
                        // Tarih değiştiğinde çağrılır
                        handleDateChange(dateStr);
                      }
                    });
                  }

                  // Takvimi aç
                  if (startDateEl && startDateEl._flatpickr) {
                    startDateEl._flatpickr.open();
                    console.log("Takvim açıldı (tıklama ile)");
                  } else {
                    console.error("Flatpickr hala yüklenemedi!");
                  }
                });

                // Tarih değişimi işleyicisi
                function handleDateChange(date) {
                  var providerID = $('#providerID').val();
                  var hizmetID = $('#service').val();

                  // Tarih formatını kontrol et ve gerekirse dönüştür (d/m/Y -> Y-m-d)
                  var formattedDate = date;
                  if (date && date.indexOf('/') !== -1) {
                    var dateParts = date.split('/');
                    if (dateParts.length === 3) {
                      formattedDate = dateParts[2] + '-' + dateParts[1] + '-' + dateParts[0];
                      console.log("Tarih formatı dönüştürüldü:", date, "->", formattedDate);

                      // Orijinal tarih değerini hidden input olarak sakla
                      if ($("#original-date").length === 0) {
                        $('<input>').attr({
                          type: 'hidden',
                          id: 'original-date',
                          name: 'original-date',
                          value: formattedDate
                        }).appendTo('#wizard');
                      } else {
                        $("#original-date").val(formattedDate);
                      }
                    }
                  }

                  console.log("Tarih değişti:", date, "Backend format:", formattedDate);
                  console.log("Provider ID:", providerID);
                  console.log("Hizmet ID:", hizmetID);

                  // Personel seçili değilse, kullanıcıyı uyar
                  if (!providerID) {
                    console.log("Personel seçilmemiş");
                    $("#timeSelect").html(
                      "<div class='alert alert-warning'>Lütfen önce hizmet ve personel seçimi yapınız!</div>");
                    return;
                  }

                  // Saatleri yükle - formattedDate kullan (backend formatı)
                  if (typeof window.loadAvailableTimes === 'function') {
                    window.loadAvailableTimes(formattedDate, providerID, hizmetID);
                  } else {
                    console.error("loadAvailableTimes fonksiyonu bulunamadı");
                  }
                }

                // Change event için de aynı işlemi yap (flatpickr çalışmazsa yedek)
                $("#start-date").on("change", function() {
                  handleDateChange($(this).val());
                });

                // Saat seçim fonksiyonu - başlangıç ve bitiş zamanlarını kaydet
                window.selectTime = function(startTime, endTime) {
                  console.log("Saat seçildi:", startTime, "Bitiş:", endTime);

                  // Global değişkenlere kaydet
                  window.selectedTime = startTime;
                  window.selectedEndTime = endTime;

                  // Form input değerlerini güncelle
                  if ($('#selectedTimeHidden').length) {
                    $('#selectedTimeHidden').val(startTime);
                  }

                  if ($('#selectedEndTimeHidden').length) {
                    $('#selectedEndTimeHidden').val(endTime);
                  } else {
                    // Bitiş zamanı için gizli bir alan oluştur eğer yoksa
                    $('<input>').attr({
                      type: 'hidden',
                      id: 'selectedEndTimeHidden',
                      name: 'selectedEndTime',
                      value: endTime
                    }).appendTo('#wizard');
                  }

                  // Devam et butonunu aktif hale getir
                  $("#nextBtn").prop("disabled", false);
                };

                // Event delegation ile dinamik oluşturulan saat seçeneklerini dinle
                $(document).on('change', '.custom-option-item-check', function() {
                  var selectedValue = $(this).val();
                  var selectedEndTime = $(this).data('end-time');

                  // Seçim fonksiyonunu çağır
                  if (typeof window.selectTime === 'function') {
                    window.selectTime(selectedValue, selectedEndTime);
                  } else {
                    // Yoksa manuel olarak değerleri kaydet
                    window.selectedTime = selectedValue;
                    window.selectedEndTime = selectedEndTime;

                    // Form elemanlarını güncelle
                    $('#selectedTimeBackup').val(selectedValue);
                    $('#selectedTimeHidden').val(selectedValue);

                    if ($('#selectedEndTimeHidden').length) {
                      $('#selectedEndTimeHidden').val(selectedEndTime);
                    } else {
                      $('<input>').attr({
                        type: 'hidden',
                        id: 'selectedEndTimeHidden',
                        name: 'selectedEndTime',
                        value: selectedEndTime
                      }).appendTo('#wizard');
                    }

                    // Devam et butonunu aktif hale getir
                    $("#nextBtn").prop("disabled", false);
                  }
                });
              });
              </script>

              <!-- Gizli alanlar -->
              <input type="hidden" id="providerAdSoyad" name="providerAdSoyad">
              <input type="hidden" id="providerID" name="providerID" value="">

              <div class="form_btn pt-5 d-flex justify-content-between">
                <button type="button" class="prev_btn text-uppercase bg-white" id="prevBtn"
                  onclick="nextPrev(-1)"><span><i class="fas fa-arrow-left"></i></span>
                  <?=$translations['back']?></button>
                <button type="button" class="next_btn text-uppercase text-white" id="nextBtn"
                  onclick="nextPrev(1)"><?=$translations['continue']?> <span><i
                      class="fas fa-arrow-right"></i></span></button>
              </div>
            </div>

            <!-- Adım 4: Özet ve Onay -->
            <div class="multisteps_form_panel">
              <div class="step_content d-flex justify-content-between pt-5 pb-2">
                <h4><?=$translations['sitetitle']?></h4>
                <span class="text-end text-uppercase">4. <?=$translations['step']?> | 4/4</span>
              </div>

              <div class="step_progress_bar">
                <div class="progress rounded-pill">
                  <div class="progress-bar" style="width: 100%"></div>
                </div>

              </div>

              <div class="form_content">
                <div class="question_title py-5">
                  <h1 class="text-capitalize"><?=$translations['summary']?></h1>
                </div>

                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                  <div class="col">
                    <h3 class="titleColor"><?=$translations['perfonelinfo']?></h3><br>
                    <h5 id="OzetAdSoyad"></h5>
                    <h5 id="OzetTelefon"></h5>
                  </div>

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['serviceinfo']?></h3><br>
                    <h5 id="OzetHizmetAd"></h5>
                    <h5 id="OzetCalisanAd"></h5>
                  </div>

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['appointmentinfo']?></h3><br>
                    <h5 id="OzetTarih"></h5>
                    <h5 id="OzetSaat"></h5>
                  </div>
                </div>

                <?php if($settings['paytrSystem']=='1' || $settings['eftSystem']=='1' || $settings['salonCreditCardSystem']=='1'){ ?>
                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                  <div class="col-12">
                    <div class="mb-1">
                      <h3 style="margin-top: 30px;" class="titleColor"><?=$translations['paymentmethod']?></h3>
                      <select class="form-select w-100" id="odemeYontemi" name="odemeYontemi" required>
                        <option selected="" value="Nakit"><?=$translations['cash']?></option>

                        <?php if($settings['salonCreditCardSystem']=='1'){ ?>
                        <option value="SalonKrediKarti"><?=$translations['saloncreditcard']?></option>
                        <?php }?>

                        <?php if($settings['paytrSystem']=='1'){ ?>
                        <option value="Kredi"><?=$translations['nowcreditcard']?></option>
                        <?php }?>

                        <?php if($settings['eftSystem']=='1'){ ?>
                        <option value="Havale"><?=$translations['transfer']?></option>
                        <?php }?>
                      </select>
                    </div>
                  </div>
                </div>
                <?php }?>

                <?php if($settings['backupSystem'] == '1'){ ?>
                <div class="row">
                  <div class="col-12">
                    <div class="form-check mt-3">
                      <input class="form-check-input" type="checkbox" value="1" id="backup" name="backup">
                      <label class="form-check-label" for="backup">
                        <strong>Yedek randevu olarak listeye ekle</strong>
                      </label>
                    </div>
                  </div>
                </div>
                <?php }?>
              </div>

              <!-- Gizli alanlar -->
              <input type="hidden" value="0" name="randevuDuzenle" id="randevuDuzenle">
              <input type="hidden" value="1" name="randevuEkle" id="randevuEkle">

              <div class="form_btn pt-5 d-flex justify-content-between">
                <button type="button" class="prev_btn text-uppercase bg-white" id="prevBtn"
                  onclick="nextPrev(-1)"><span><i class="fas fa-arrow-left"></i></span>
                  <?=$translations['back']?></button>
                <button id="randevuEkleBtn" type="submit" class="next_btn text-uppercase text-white">
                  <?=$translations['create']?> <span><i class="fas fa-arrow-right"></i></span>
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <!-- Uygulama yükleme butonu -->
  <button id="installButton" class="install-button">
    <i class="fas fa-download"></i> Uygulamayı Yükle
  </button>

  <!-- Mobil cihazlar için sabit PWA yükleme butonu -->
  <button id="mobileInstallButton" class="mobile-install-button">
    <div class="button-content">
      <i class="fas fa-mobile-alt"></i>
      <span>Uygulamayı Yükle</span>
    </div>
    <div class="button-subtitle">Hızlı Erişim</div>
  </button>

  <!-- Özet bilgilerini güncelleme script'i -->
  <script>
  function updateSummary() {
    // Müşteri bilgileri
    var adSoyad = $("#musteriAd").val() || "Belirtilmedi";
    var telefon = $("#musteriTelefon").val() || "Belirtilmedi";

    // Hizmet ve personel bilgileri
    var hizmetAd = $("#service option:selected").text() || "Belirtilmedi";
    var calisanAd = $("#providerAdSoyad").val() || "Belirtilmedi";

    // Tarih ve saat bilgileri
    var tarih = $("#start-date").val() || "Belirtilmedi";
    var baslangicSaat = window.selectedTime || "Belirtilmedi";
    var bitisSaat = window.selectedEndTime || "Belirtilmedi";

    // Hizmet süresi bilgisini al (süre dakikasını)
    var hizmetID = $("#service").val();
    var serviceDakika = "";
    if (hizmetID) {
      // Hizmet option elemanından süre bilgisini çıkar
      var selectedOption = $("#service option:selected");
      serviceDakika = selectedOption.data("duration") || "";
    }

    // Saat bilgisini formatla
    var saatGosterim = baslangicSaat;
    if (bitisSaat && bitisSaat !== "Belirtilmedi") {
      saatGosterim = baslangicSaat.substring(0, 5) + " - " + bitisSaat.substring(0, 5);

      // Süre dakikası varsa, parantez içinde ekle
      if (serviceDakika) {
        saatGosterim += " (" + serviceDakika + " dk)";
      }
    }

    // Özet alanlarını güncelle
    $("#OzetAdSoyad").text(adSoyad);
    $("#OzetTelefon").text(telefon);

    // Hizmet adı düzenlemesi (süre bilgisini kaldır)
    if (hizmetAd && hizmetAd.indexOf(" |") > -1) {
      hizmetAd = hizmetAd.split(" |")[0]; // Fiyat bilgisini kaldır
    }

    $("#OzetHizmetAd").text(hizmetAd);
    $("#OzetCalisanAd").text(calisanAd);
    $("#OzetTarih").text(tarih);
    $("#OzetSaat").text(saatGosterim);
  }

  // Form adımları arasında geçiş yapıldığında özeti güncelle
  function nextPrev(n) {
    var x = document.getElementsByClassName("multisteps_form_panel");
    var currentTab = 0;

    // Aktif paneli bul
    for (var i = 0; i < x.length; i++) {
      if (window.getComputedStyle(x[i]).display === "block") {
        currentTab = i;
        break;
      }
    }

    // Son adıma geçiliyorsa özeti güncelle
    if (currentTab + n === 3) {
      updateSummary();
    }

    // Doğrulama işlemleri
    if (n === 1 && !validateForm(currentTab)) return false;

    // Mevcut adımı gizle
    x[currentTab].style.display = "none";

    // Yeni adımı göster
    currentTab = currentTab + n;
    if (currentTab >= x.length) {
      // Form tamamlandıysa submit et
      document.getElementById("wizard").submit();
      return false;
    }

    x[currentTab].style.display = "block";

    // İleri/geri butonlarını ayarla
    if (currentTab === 0) {
      document.getElementById("prevBtn").style.display = "none";
    } else {
      document.getElementById("prevBtn").style.display = "inline";
    }

    if (currentTab === (x.length - 1)) {
      document.getElementById("nextBtn").style.display = "none";
    } else {
      document.getElementById("nextBtn").style.display = "inline";
      document.getElementById("nextBtn").innerHTML =
        '<?=$translations['continue']?> <span><i class="fas fa-arrow-right"></i></span>';
    }

    // İlerleme çubuğunu güncelle
    var progressBars = document.getElementsByClassName("progress-bar");
    progressBars[0].style.width = ((currentTab + 1) * 25) + "%";
  }

  // Form doğrulama
  function validateForm(step) {
    var valid = true;
    var x, y, i;

    // Geçerli adımdaki input alanlarını kontrol et
    x = document.getElementsByClassName("multisteps_form_panel")[step];
    y = x.querySelectorAll("input[required], select[required]");

    // Adıma göre özel doğrulama
    if (step === 0) {
      // Ad soyad kontrolü - şimdi geliştirilmiş validateName fonksiyonunu kullanıyoruz
      var adSoyadInput = document.getElementById("musteriAd");
      if (adSoyadInput && adSoyadInput.value.trim()) {
        if (!validateName(adSoyadInput)) {
          adSoyadInput.classList.add("invalid");
          valid = false;
          // validateName zaten hata mesajını gösteriyor
        } else {
          adSoyadInput.classList.remove("invalid");
        }
      }

      // Telefon kontrolü
      var telefonInput = document.getElementById("musteriTelefon");
      if (telefonInput && telefonInput.value.trim()) {
        if (telefonInput.value.length < 10) {
          telefonInput.classList.add("invalid");
          valid = false;

          Swal.fire({
            title: "<?=$translations['error']?>",
            text: "Lütfen geçerli bir telefon numarası giriniz.",
            icon: 'error',
            confirmButtonColor: '#7367f0',
            confirmButtonText: "<?=$translations['okey']?>"
          });
        } else {
          telefonInput.classList.remove("invalid");
        }
      }
    } else if (step === 1) {
      // Hizmet ve personel seçimi kontrolü
      var serviceSelect = document.getElementById("service");
      var providerID = document.getElementById("providerID");

      if (!serviceSelect.value) {
        serviceSelect.classList.add("invalid");
        valid = false;

        Swal.fire({
          title: "<?=$translations['error']?>",
          text: "<?=$translations['pleaseservice']?>",
          icon: 'error',
          confirmButtonColor: '#7367f0',
          confirmButtonText: "<?=$translations['okey']?>"
        });
      } else {
        serviceSelect.classList.remove("invalid");
      }

      if (!providerID.value) {
        valid = false;

        Swal.fire({
          title: "<?=$translations['error']?>",
          text: "<?=$translations['pleaseemp']?>",
          icon: 'error',
          confirmButtonColor: '#7367f0',
          confirmButtonText: "<?=$translations['okey']?>"
        });
      }
    } else if (step === 2) {
      // Tarih ve saat seçimi kontrolü
      var startDate = document.getElementById("start-date");

      if (!startDate.value) {
        startDate.classList.add("invalid");
        valid = false;

        Swal.fire({
          title: "<?=$translations['error']?>",
          text: "<?=$translations['pleaseappdate']?>",
          icon: 'error',
          confirmButtonColor: '#7367f0',
          confirmButtonText: "<?=$translations['okey']?>"
        });
      } else {
        startDate.classList.remove("invalid");
      }

      // Saat seçimi kontrolü
      if (!$(".custom-option-item-check:checked").val()) {
        valid = false;

        Swal.fire({
          title: "<?=$translations['error']?>",
          text: "<?=$translations['pleaseapptime']?>",
          icon: 'error',
          confirmButtonColor: '#7367f0',
          confirmButtonText: "<?=$translations['okey']?>"
        });
      }
    }

    // Genel required alanlar kontrolü
    for (i = 0; i < y.length; i++) {
      if (y[i].value === "") {
        y[i].classList.add("invalid");
        valid = false;
      } else {
        y[i].classList.remove("invalid");
      }
    }

    return valid;
  }
  </script>

  <!-- Form submission handler -->
  <script>
  // Form gönderim işlemlerini izlemek için flag
  var formSubmitInProgress = false;

  $(document).ready(function() {
    // Form submit olayını dinle
    $('#wizard').on('submit', function(e) {
      e.preventDefault();

      // Form zaten işlenmekteyse çık
      if (formSubmitInProgress) {
        console.log("Form zaten işleniyor, çift gönderim engellendi");
        return false;
      }

      // Randevu oluştur butonunu hemen devre dışı bırak
      var $btn = $('#randevuEkleBtn');
      $btn.prop('disabled', true).html(
        '<i class="fas fa-spinner fa-spin"></i> <?=$translations["processing"]?>');

      // İşlem başladı olarak işaretle
      formSubmitInProgress = true;

      // Form işleme fonksiyonunu çağır
      processForm($btn);

      return false;
    });

    // Eski click handler'ı koruyalım (uyumluluk için)
    $(document).on('click', '#randevuEkleBtn', function(e) {
      e.preventDefault();

      // Click ile form submit tetikle - yeni implementasyona yönlendir
      $('#wizard').submit();
    });

    // Form işleme fonksiyonu
    function processForm($btn) {
      // Zorunlu alanların kontrolü
      if (!$("#musteriAd").val()) {
        showError("<?=$translations['error']?>", "<?=$translations['pleasename']?>");
        resetButton($btn);
        return false;
      } else if (!$("#musteriTelefon").val()) {
        showError("<?=$translations['error']?>", "<?=$translations['pleasephone']?>");
        resetButton($btn);
        return false;
      } else if ($('#service').val() == undefined) {
        showError("<?=$translations['error']?>", "<?=$translations['pleaseservice']?>");
        resetButton($btn);
        return false;
      } else if (!$('#providerID').val()) {
        showError("<?=$translations['error']?>", "<?=$translations['pleaseemp']?>");
        resetButton($btn);
        return false;
      } else if (!$('#start-date').val()) {
        showError("<?=$translations['error']?>", "<?=$translations['pleaseappdate']?>");
        resetButton($btn);
        return false;
      } else if ($(".custom-option-item-check:checked").length === 0) {
        showError("<?=$translations['error']?>", "<?=$translations['pleaseapptime']?>");
        resetButton($btn);
        return false;
      }

      // Yükleniyor göstergesi
      Swal.fire({
        title: '<?=$translations["processing"]?>',
        html: '<?=$translations["wait"]?>',
        allowOutsideClick: false,
        showConfirmButton: false,
        willOpen: () => {
          Swal.showLoading();
        }
      });

      var form = $('#wizard')[0];
      var formData = new FormData(form);
      var odemeYontemi = $('#odemeYontemi').val();
      var ajaxUrl = '';

      // Ödeme yöntemine göre AJAX ayarları
      if (odemeYontemi === 'Kredi') {
        ajaxUrl = '/admin/system/settings/paymentCreate.php';

        $.ajax({
          type: 'post',
          url: ajaxUrl,
          data: formData,
          enctype: 'multipart/form-data',
          processData: false,
          contentType: false,
          cache: false,
          timeout: 30000, // 30 saniye zaman aşımı
          success: function(response) {
            if (response === 'varvar') {
              showErrorAndReload("<?=$translations['sorry']?>", "<?=$translations['otherselect']?>");
            } else {
              formSubmitInProgress = true; // Kesin olarak engellemek için flag'i true bırak
              console.log("Ödeme sayfasına yönlendiriliyor: " + response);
              // Butonu kalıcı olarak devre dışı bırak
              $btn.prop('disabled', true).html(
                '<i class="fas fa-check-circle"></i> <?=$translations["redirecting"]?>');
              // Yönlendirme
              location.href = "payment/" + response;
            }
          },
          error: function(xhr, status, error) {
            handleAjaxError(xhr, status, error, $btn);
          }
        });
      } else {
        ajaxUrl = '/admin/system/settings/eral.php';

        $.ajax({
          type: 'post',
          url: ajaxUrl,
          data: formData,
          enctype: 'multipart/form-data',
          processData: false,
          contentType: false,
          cache: false,
          timeout: 30000, // 30 saniye zaman aşımı
          success: function(response) {
            if (response === 'varvar') {
              showErrorAndReload("<?=$translations['sorry']?>", "<?=$translations['otherselect']?>");
            } else {
              formSubmitInProgress = true; // Kesin olarak engellemek için flag'i true bırak
              console.log("Başarı sayfasına yönlendiriliyor: " + odemeYontemi);
              // Butonu kalıcı olarak devre dışı bırak
              $btn.prop('disabled', true).html(
                '<i class="fas fa-check-circle"></i> <?=$translations["redirecting"]?>');

              // Yönlendirme
              if (odemeYontemi === 'Havale') {
                location.href = "hsuccess.php";
              } else {
                location.href = "success.php";
              }
            }
          },
          error: function(xhr, status, error) {
            handleAjaxError(xhr, status, error, $btn);
          },
          complete: function() {
            // İşlem bittiğinde, eğer sayfada hala kalındıysa butonu sıfırla
            // Yönlendirme yapılmadıysa
            if (window.location.href.indexOf("success.php") === -1 &&
              window.location.href.indexOf("hsuccess.php") === -1 &&
              window.location.href.indexOf("payment/") === -1) {
              resetButton($btn);
            }
          }
        });
      }
    }
  });

  // Hata gösterme fonksiyonu
  function showError(title, text) {
    Swal.fire({
      title: title,
      text: text,
      icon: 'error',
      confirmButtonColor: '#7367f0',
      confirmButtonText: "<?=$translations['okey']?>"
    });
  }

  // Hata gösterme ve sayfayı yenileme
  function showErrorAndReload(title, text) {
    Swal.fire({
      title: title,
      text: text,
      icon: 'error',
      confirmButtonColor: '#7367f0',
      confirmButtonText: "<?=$translations['okey']?>"
    }).then(() => {
      location.reload();
    });
  }

  // AJAX hatası yönetimi
  function handleAjaxError(xhr, status, error, $btn) {
    console.error("İşlem hatası:", error);
    showError("<?=$translations['error']?>", "<?=$translations['processerror']?>" + error);
    resetButton($btn);
  }

  // Butonu sıfırlama
  function resetButton($btn) {
    $btn.html('<?=$translations['create']?><span><i class="fas fa-arrow-right"></i></span>').prop('disabled',
      false);
    Swal.close();
    formSubmitInProgress = false;
  }

  // Sayfa yüklendiğinde ve yeniden yüklendiğinde butonu resetle
  $(window).on('pageshow', function() {
    resetButton($('#randevuEkleBtn'));
    formSubmitInProgress = false;
  });
  </script>

  <!-- Telefon numarası girişi için intlTelInput -->
  <script>
  window.addEventListener('load', function() {
    var input = document.querySelector("#musteriTelefon");
    if (input && window.intlTelInput) {
      window.intlTelInput(input, {
        initialCountry: 'tr',
        separateDialCode: true,
        utilsScript: "./assets/js/utils.js", // Telefon formatı için gerekli
        formatOnDisplay: true,
        autoPlaceholder: "aggressive",
        nationalMode: false, // Ulusal format yerine uluslararası format kullan
        // Başında 0 olması durumunda onu kaldır
        customPlaceholder: function() {
          return "Telefon numarası";
        }
      });

      // Girilen numarada başta 0 varsa kaldır
      input.addEventListener("input", function() {
        var currentNumber = input.value;
        // Eğer ilk karakter 0 ise kaldır (ama kod kısmını etkileme)
        if (currentNumber.startsWith("0")) {
          input.value = currentNumber.substring(1);
        }
      });
    } else {
      console.warn("Telefon input elemanı veya intlTelInput kütüphanesi bulunamadı");
    }
  });
  </script>

  <!-- Feather icons kütüphanesi -->
  <script>
  window.addEventListener('load', function() {
    if (typeof feather !== 'undefined' && feather.replace) {
      feather.replace();
    } else {
      console.warn("Feather Icons kütüphanesi bulunamadı");
    }
  });
  </script>

  <!-- Dil ve ülke seçimi işlemleri -->
  <script>
  $(document).ready(function() {
    // Dil değişikliği
    $('#lang').change(function() {
      var lang = $(this).val();
      if (typeof Cookies !== 'undefined' && Cookies.set) {
        Cookies.set('lang', lang);
        location.reload();
      } else {
        console.error("js.cookie.min.js kütüphanesi yüklenemedi");
      }
    });

    // Ülke seçici başlatma
    if ($.fn.countrypicker) {
      $('.countrypicker').countrypicker();
    }
  });
  </script>

  <!-- URL parametresiyle dil ayarlama -->
  <?php if(isset($_GET['lang']) && $_GET['lang']){ ?>
  <script>
  window.addEventListener('load', function() {
    if (typeof Cookies !== 'undefined' && Cookies.set) {
      var lang = '<?=$_GET['lang']?>';
      var flag = '<?=isset($_GET['flag']) ? $_GET['flag'] : ""?>';

      Cookies.set('lang', lang);
      Cookies.set('flag', flag);

      window.location.replace(window.location.pathname);
    } else {
      console.error("js.cookie.min.js kütüphanesi yüklenemedi");
    }
  });
  </script>
  <?php }?>

  <!-- Varsayılan dil ayarı -->
  <?php if(empty($_COOKIE['lang'])){ ?>
  <script>
  window.addEventListener('load', function() {
    if (typeof Cookies !== 'undefined' && Cookies.set) {
      var lang = '<?php echo $defaultLangValue['code'];?>';
      var flag = '<?php echo $defaultLangValue['flag'];?>';

      Cookies.set('lang', lang);
      Cookies.set('flag', flag);

      window.location.replace(window.location.pathname);
    } else {
      console.error("js.cookie.min.js kütüphanesi yüklenemedi");
    }
  });
  </script>
  <?php }?>

  <!-- PWA uygulama yükleme işleyicisi - İyileştirilmiş mobil desteği ile -->
  <script>
  window.addEventListener('load', function() {
    let deferredPrompt;
    const installButton = document.getElementById('installButton');
    const mobileInstallButton = document.getElementById('mobileInstallButton');

    // Mobil cihaz tespiti
    const isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    console.log("Mobil cihaz tespiti:", isMobile ? "Mobil cihaz" : "Masaüstü");

    // Kurulum butonları başlangıçta gizli
    if (installButton) {
      installButton.style.display = 'none';
    }

    if (mobileInstallButton) {
      mobileInstallButton.style.display = 'none';
    }

    // Tarayıcı PWA kurulumu için promosyon gösterebilir
    window.addEventListener('beforeinstallprompt', (e) => {
      // Tarayıcının varsayılan davranışını engelle
      e.preventDefault();
      console.log("PWA kurulum olayı yakalandı");

      // Promosyon olayını daha sonra kullanmak üzere sakla
      deferredPrompt = e;

      // Mobil cihazlarda sabit buton, masaüstünde ise normal buton göster
      if (isMobile) {
        if (mobileInstallButton) {
          mobileInstallButton.style.display = 'flex';

          // Animasyonlu giriş için timeout
          setTimeout(() => {
            mobileInstallButton.classList.add('mobile-button-visible');
          }, 300);

          console.log("Mobil kurulum butonu gösterildi");
        }
      } else {
        if (installButton) {
          installButton.style.display = 'flex';

          // Animasyonlu giriş için timeout
          setTimeout(() => {
            installButton.classList.add('pwa-button-visible');
          }, 300);

          console.log("Masaüstü kurulum butonu gösterildi");
        }
      }
    });

    // Masaüstü kurulum butonu tıklandığında
    if (installButton) {
      installButton.addEventListener('click', async () => {
        if (!deferredPrompt) {
          console.log("Kurulum için deferredPrompt mevcut değil");
          return;
        }

        console.log("Kurulum butonu tıklandı");

        // Buton tıklama animasyonu
        installButton.classList.add('button-clicked');

        // Kurulum arayüzünü göster
        deferredPrompt.prompt();

        // Kullanıcının ne seçtiğini öğren
        const {
          outcome
        } = await deferredPrompt.userChoice;
        console.log(`Kullanıcı tercihi: ${outcome}`);

        // deferredPrompt'u temizle
        deferredPrompt = null;

        // Kurulum butonunu animasyonla kaldır
        installButton.style.transform = 'translateY(100px)';
        installButton.style.opacity = '0';

        // Animasyon tamamlandıktan sonra gizle
        setTimeout(() => {
          installButton.style.display = 'none';
          installButton.classList.remove('pwa-button-visible');
          installButton.classList.remove('button-clicked');
        }, 300);
      });
    }

    // Mobil kurulum butonu tıklandığında
    if (mobileInstallButton) {
      mobileInstallButton.addEventListener('click', async () => {
        if (!deferredPrompt) {
          console.log("Kurulum için deferredPrompt mevcut değil");
          return;
        }

        console.log("Mobil kurulum butonu tıklandı");

        // Buton tıklama animasyonu
        mobileInstallButton.classList.add('button-clicked');

        // Kurulum arayüzünü göster
        deferredPrompt.prompt();

        // Kullanıcının ne seçtiğini öğren
        const {
          outcome
        } = await deferredPrompt.userChoice;
        console.log(`Kullanıcı tercihi: ${outcome}`);

        // deferredPrompt'u temizle
        deferredPrompt = null;

        // Kurulum butonunu animasyonla kaldır
        setTimeout(() => {
          mobileInstallButton.classList.remove('button-clicked');

          if (outcome === 'accepted') {
            mobileInstallButton.style.transform = 'translateY(100px)';
            mobileInstallButton.style.opacity = '0';

            setTimeout(() => {
              mobileInstallButton.style.display = 'none';
              mobileInstallButton.classList.remove('mobile-button-visible');
            }, 300);
          }
        }, 100);
      });
    }

    // Uygulama zaten kuruluysa
    window.addEventListener('appinstalled', () => {
      console.log('PWA Uygulaması başarıyla kuruldu');

      // Başarı mesajını göster
      Swal.fire({
        title: 'Başarılı!',
        text: 'Uygulama başarıyla yüklendi. Artık ana ekranınızdan erişebilirsiniz.',
        icon: 'success',
        confirmButtonColor: '#ff950e',
        confirmButtonText: 'Tamam'
      });

      // Kurulum butonlarını animasyonla kaldır
      if (installButton) {
        installButton.style.transform = 'translateY(100px)';
        installButton.style.opacity = '0';

        setTimeout(() => {
          installButton.style.display = 'none';
          installButton.classList.remove('pwa-button-visible');
        }, 300);
      }

      if (mobileInstallButton) {
        mobileInstallButton.style.transform = 'translateY(100px)';
        mobileInstallButton.style.opacity = '0';

        setTimeout(() => {
          mobileInstallButton.style.display = 'none';
          mobileInstallButton.classList.remove('mobile-button-visible');
        }, 300);
      }
    });

    // Apple cihazlar için özel işleme (iOS için)
    const isIOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;
    if (isIOS && mobileInstallButton) {
      // iOS PWA kurulumu farklı çalışır (web sayfası olarak ekle)
      mobileInstallButton.style.display = 'flex';

      mobileInstallButton.addEventListener('click', () => {
        // iOS için kurulum talimatları modali
        Swal.fire({
          title: 'iOS Kurulum',
          html: `
            <div style="text-align: left;">
              <p>iOS cihazlarda uygulamayı kurmak için:</p>
              <ol>
                <li>Safari tarayıcı menüsünde <b>Paylaş</b> <i class="fas fa-share-square"></i> simgesine dokunun</li>
                <li><b>Ana Ekrana Ekle</b> <i class="fas fa-plus-square"></i> seçeneğine dokunun</li>
                <li><b>Ekle</b> butonuna dokunun</li>
              </ol>
              <p>Artık uygulamaya ana ekranınızdan erişebilirsiniz!</p>
            </div>
          `,
          icon: 'info',
          confirmButtonColor: '#ff950e',
          confirmButtonText: 'Anladım'
        });
      });

      // Animasyonlu giriş için timeout
      setTimeout(() => {
        mobileInstallButton.classList.add('mobile-button-visible');
      }, 300);

      console.log("iOS cihaz algılandı, özel kurulum butonu gösterildi");
    }
  });
  </script>

  <!-- PWA uygulama kodunu yükle -->
  <script src="app.js?v=1.0.4"></script>




  </div>

  </div>

  </div>
  <!-- Bootstrap-js include -->
  <script src="./assets/js/bootstrap.min.js"></script>

  <!-- jQuery-validate-js include -->
  <script src="./assets/js/jquery.validate.min.js"></script>

  <!-- Custom-js include -->
  <script src="./assets/js/script.js"></script>

  <!-- jQuery sürüm kontrolü ve sayfa hazır olduğunda yapılacaklar -->
  <script>
  $(document).ready(function() {
    console.log("jQuery sürümü: " + $.fn.jquery);
  });
  </script>

  <!-- International Telephone Input kütüphanesi -->
  <script src="./assets/js/intlTelInput.js"></script>

  <!-- Mock nesneleri tanımlama - Gerekli kütüphaneler yüklenmediğinde hata vermemesi için -->
  <script>
  // Picker modülü eksikse oluştur
  if (typeof Picker === 'undefined') {
    window.Picker = function() {};
    Picker.prototype = {
      set: function() {
        return this;
      },
      get: function() {
        return this;
      },
      on: function() {
        return this;
      }
    };

    Picker.klasses = function() {
      return {};
    };

    Picker.extend = function(target, object) {
      for (var prop in object) {
        if (object.hasOwnProperty(prop)) {
          target[prop] = object[prop];
        }
      }
      return target;
    };
  }

  // FullCalendar modülü eksikse oluştur
  if (typeof FullCalendar === 'undefined') {
    window.FullCalendar = {
      Calendar: function() {
        return {
          render: function() {},
          on: function() {}
        };
      }
    };
  }

  // jQuery için çeşitli eklenti mock'ları
  $.fn.pickadate = $.fn.pickadate || function() {
    return this;
  };
  $.fn.countrypicker = $.fn.countrypicker || function() {
    return this;
  };
  $.fn.pickatime = $.fn.pickatime || function() {
    return this;
  };
  $.fn.select2 = $.fn.select2 || function() {
    return this;
  };
  </script>

  <!-- Select2 başlatma - ilk deneme -->
  <script>
  $(document).ready(function() {
    if ($.fn.select2) {
      try {
        $("#service").select2({
          placeholder: "Hizmet seçiniz...",
          allowClear: true,
          width: '100%'
        });
      } catch (e) {}
    }
  });
  </script>

  <!-- Select2 kütüphanesinin yüklenmesi -->
  <script type="text/javascript"
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/forms/select/select2.full.min.js">
  </script>

  <!-- Select2 yeniden başlatma - gecikme ile -->
  <script>
  $(document).ready(function() {
    var select2InitTimeout = setTimeout(function() {
      if ($.fn.select2) {
        try {
          // Önce mevcut olanı kaldır, sonra yeniden başlat
          var $serviceSelect = $("#service");
          if ($serviceSelect.length) {
            $serviceSelect.select2('destroy').select2({
              placeholder: "Hizmet seçiniz...",
              allowClear: true,
              width: '100%'
            });
          } else {}
        } catch (e) {}
      } else {}
    }, 500);

    // Sayfa kapandığında zamanlayıcıyı temizle
    $(window).on('beforeunload', function() {
      clearTimeout(select2InitTimeout);
    });
  });
  </script>

  <!-- Flatpickr ve diğer JS bağımlılıkları -->
  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js">
  </script>


  <!-- Diğer picker ve takvim bileşenleri -->
  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/pickadate/picker.time.js">
  </script>
  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/scripts/forms/pickers/form-pickers.js">
  </script>
  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/scripts/pages/app-calendar-events.js">
  </script>
  <script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/scripts/pages/app-calendar.js">
  </script>
  <script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/js.cookie.min.js"></script>

  <!-- Flatpickr manüel başlatma -->
  <script type="text/javascript">
  window.addEventListener("load", function() {
    if (typeof flatpickr !== 'undefined') {
      var dateEl = document.getElementById('start-date');
      if (dateEl && !dateEl._flatpickr) {
        flatpickr(dateEl, {
          dateFormat: "Y-m-d",
          minDate: "today",
          disableMobile: true,
          locale: {
            firstDayOfWeek: 1,
            weekdays: {
              longhand: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi'],
              shorthand: ['Paz', 'Pzt', 'Sal', 'Çar', 'Per', 'Cum', 'Cmt']
            },
            months: {
              longhand: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz',
                'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'
              ],
              shorthand: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas',
                'Ara'
              ]
            }
          }
        });
      } else if (!dateEl) {
        console.warn("'start-date' ID'li eleman bulunamadı");
      }
    } else {
      console.warn("flatpickr kütüphanesi yüklenemedi");
    }
  });
  </script>

  <?php require $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/script.php'; ?>

  <!-- SweetAlert2 kütüphanesi -->
  <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- Form doğrulama ve gönderim işlemleri -->
  <script>
  // Minimum uzunluk doğrulama fonksiyonu
  function validateMinLength(input) {
    var nextBtn = document.getElementById("nextBtn");

    if (input.value.length > 0 && input.value.length < 10) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "Lütfen geçerli bir numara giriniz.",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });

      if (nextBtn) {
        nextBtn.disabled = true;
      }
    } else {
      if (nextBtn) {
        nextBtn.disabled = false;
      }
    }
  }

  // İsim doğrulama fonksiyonu
  function validateName(input) {
    var nextBtn = document.getElementById("nextBtn");
    const adSoyad = input.value ? input.value.trim() : "";
    const adSoyadArray = adSoyad.split(' ').filter(item => item.length > 0);

    // Ad soyad en az iki kelimeden oluşmalı
    if (adSoyadArray.length < 2) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "Lütfen Geçerli Ad Soyad giriniz.",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });

      if (nextBtn) {
        nextBtn.disabled = true;
      }
      return false;
    }

    // İsim kontrolü için regex pattern - Türkçe karakterleri destekler
    // Sadece harflere, boşluklara ve noktalara izin verir (Dr. gibi kısaltmalar için)
    const namePattern = /^[a-zA-ZçÇğĞıİöÖşŞüÜ\s.]+$/;
    if (!namePattern.test(adSoyad)) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "Ad Soyad sadece harflerden oluşmalıdır. Rakam veya özel karakter kullanılamaz.",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });

      if (nextBtn) {
        nextBtn.disabled = true;
      }
      return false;
    }

    // Makul uzunluk kontrolü (5-50 karakter)
    if (adSoyad.length < 5 || adSoyad.length > 50) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "Ad Soyad çok kısa veya çok uzun. Lütfen geçerli bir ad soyad giriniz.",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });

      if (nextBtn) {
        nextBtn.disabled = true;
      }
      return false;
    }

    // Geçerli ad soyad
    if (nextBtn) {
      nextBtn.disabled = false;
    }
    return true;
  }

  // Form gönderim kontrolü için değişken
  var formSubmitInProgress = false;

  // Randevu ekleme butonu için olay dinleyici
  $(document).on('click', '#randevuEkleBtn', function(e) {
    // Çift tıklama kontrolü
    if (formSubmitInProgress) {
      console.log("Form gönderimi zaten devam ediyor.");
      e.preventDefault();
      return false;
    }

    // Form alanlarını doğrula
    if (!$("#musteriAd").val()) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "<?=$translations['pleasename']?>",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });
    } else if (!$("#musteriTelefon").val()) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "<?=$translations['pleasephone']?>",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });
    } else if ($('#service').val() == undefined) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "<?=$translations['pleaseservice']?>",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });
    } else if (!$('#providerID').val()) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "<?=$translations['pleaseemp']?>",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });
    } else if (!$('#start-date').val()) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "<?=$translations['pleaseappdate']?>",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });
    } else if ($(".custom-option-item-check:checked").length === 0) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "<?=$translations['pleaseapptime']?>",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      });
    } else {
      // Form gönderimi başladı işaretini koy
      formSubmitInProgress = true;

      // Butonu yükleniyor durumuna getir ve devre dışı bırak
      var $btn = $(this);
      $btn.html('<i class="fas fa-spinner fa-spin"></i> <?=$translations["processing"]?>').prop('disabled', true);

      // Yükleniyor göstergesi
      Swal.fire({
        title: '<?=$translations["processing"]?>',
        html: '<?=$translations["wait"]?>',
        allowOutsideClick: false,
        showConfirmButton: false,
        willOpen: () => {
          Swal.showLoading();
        }
      });

      var form = $('#wizard')[0];
      var data = new FormData(form);
      var odemeYontemi = $('#odemeYontemi').val();
      var ajaxUrl = '';
      var successUrl = '';

      // Ödeme yöntemine göre AJAX ayarları
      if (odemeYontemi === 'Kredi') {
        ajaxUrl = '/admin/system/settings/paymentCreate.php';

        // Başarılı işlem sonrası yönlendirme, payment/ + yanıt olacak
        var handleSuccess = function(data) {
          if (data === 'varvar') {
            showErrorAndReload("<?=$translations['sorry']?>", "<?=$translations['otherselect']?>");
          } else {
            location.href = "payment/" + data;
          }
        };
      } else {
        ajaxUrl = '/admin/system/settings/eral.php';

        // Başarılı işlem sonrası yönlendirme
        var handleSuccess = function(data) {
          if (data === 'varvar') {
            showErrorAndReload("<?=$translations['sorry']?>", "<?=$translations['otherselect']?>");
          } else {
            if (odemeYontemi === 'Havale') {
              location.href = "hsuccess";
            } else {
              location.href = "success";
            }
          }
        };
      }

      // Yedek randevu seçimi kontrolü
      var backup = $('#backup').is(':checked') ? 1 : 0;
      data.append('backup', backup);

      // AJAX isteği
      $.ajax({
        type: 'post',
        url: ajaxUrl,
        data: data,
        enctype: 'multipart/form-data',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 30000, // 30 saniye zaman aşımı
        success: handleSuccess,
        error: function(xhr, status, error) {
          console.error("İşlem hatası:", error);
          Swal.fire({
            title: "<?=$translations['error']?>",
            text: "<?=$translations['processerror']?>" + error,
            icon: 'error',
            confirmButtonColor: '#7367f0',
            confirmButtonText: "<?=$translations['okey']?>"
          });
          resetButton();
        },
        complete: function() {
          // İşlem bittiğinde, eğer sayfada hala kalındıysa butonu sıfırla
          // Yönlendirme yapılmadıysa
          if (window.location.href.indexOf("success") === -1 &&
            window.location.href.indexOf("hsuccess") === -1 &&
            window.location.href.indexOf("payment/") === -1) {
            resetButton();
          }
        }
      });
    }

    // Hata gösterme ve sayfayı yenileme
    function showErrorAndReload(title, text) {
      Swal.fire({
        title: title,
        text: text,
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"
      }).then(() => {
        location.reload();
      });
    }

    // Butonu sıfırlama
    function resetButton() {
      $btn.html('<?=$translations['create']?><span><i class="fas fa-arrow-right"></i></span>').prop('disabled',
        false);
      Swal.close();
      formSubmitInProgress = false;
    }
  });
  </script>

  <!-- International Telephone Input başlatma -->
  <script>
  var input = document.querySelector("#musteriTelefon");
  if (input && window.intlTelInput) {
    var iti = window.intlTelInput(input, {
      initialCountry: 'tr',
      separateDialCode: true,
      utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js"
    });

    // Telefon numarası değiştiğinde form doğrulamasını güncelle
    input.addEventListener("input", function() {
      if (iti.isValidNumber()) {
        input.classList.remove("invalid");
        input.classList.add("valid");
      } else {
        input.classList.remove("valid");
        input.classList.add("invalid");
      }
    });
  } else {
    console.warn("Telefon input elemanı veya intlTelInput kütüphanesi bulunamadı");
  }
  </script>

  <!-- Feather icons -->
  <script>
  if (typeof feather !== 'undefined' && feather.replace) {
    feather.replace()
  } else {
    console.warn("Feather Icons kütüphanesi bulunamadı");
  }
  </script>

  <!-- Dil değişikliği ve ülke seçimi -->
  <script>
  $(document).ready(function() {
    // Dil değişikliği
    $('#lang').change(function() {
      var lang = $(this).val();
      if (Cookies && typeof Cookies.set === 'function') {
        Cookies.set('lang', lang);
        location.reload();
      } else {
        console.error("js.cookie.min.js kütüphanesi yüklenemedi");
      }
    });

    // Ülke seçici başlatma
    if ($.fn.countrypicker) {
      $('.countrypicker').countrypicker();
    }
  });
  </script>

  <!-- URL parametresiyle dil ayarlama -->
  <?php if(isset($_GET['lang']) && $_GET['lang']){ ?>
  <script>
  if (Cookies && typeof Cookies.set === 'function') {
    var lang = '<?=$_GET['lang']?>';
    var flag = '<?=isset($_GET['flag']) ? $_GET['flag'] : ""?>';

    Cookies.set('lang', lang);
    Cookies.set('flag', flag);

    window.location.replace(window.location.pathname);
  } else {
    console.error("js.cookie.min.js kütüphanesi yüklenemedi");
  }
  </script>
  <?php }?>

  <!-- Varsayılan dil ayarı -->
  <?php if(empty($_COOKIE['lang'])){ ?>
  <script>
  if (Cookies && typeof Cookies.set === 'function') {
    var lang = '<?php echo $defaultLangValue['code'];?>';
    var flag = '<?php echo $defaultLangValue['flag'];?>';

    Cookies.set('lang', lang);
    Cookies.set('flag', flag);

    window.location.replace(window.location.pathname);
  } else {
    console.error("js.cookie.min.js kütüphanesi yüklenemedi");
  }
  </script>
  <?php }?>

  <!-- PWA yükleme butonları için stil -->
  <style>
  /* Uygulama yükleme butonu - masaüstü */
  .install-button {
    position: fixed;
    right: 30px;
    bottom: 30px;
    background-color: #ff950e;
    color: white;
    border: none;
    border-radius: 50px;
    padding: 10px 20px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
    transition: all 0.3s ease-in-out;
    cursor: pointer;
    z-index: 9999;
    opacity: 0;
  }

  .install-button i {
    margin-right: 8px;
  }

  .install-button:hover {
    background-color: #e67e00;
    transform: translateY(-5px) !important;
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.25);
  }

  .pwa-button-visible {
    transform: translateY(-100px);
    opacity: 1;
  }

  /* Mobil cihazlar için özel yükleme butonu */
  .mobile-install-button {
    position: fixed;
    bottom: -100px;
    left: 0;
    right: 0;
    width: 100%;
    background-color: #ff950e;
    color: white;
    border: none;
    border-radius: 0;
    padding: 14px 20px;
    font-weight: 600;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.15);
    transition: all 0.3s ease-in-out;
    cursor: pointer;
    z-index: 9999;
    opacity: 0;
  }

  .mobile-install-button .button-content {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 100%;
  }

  .mobile-install-button .button-content i {
    margin-right: 10px;
    font-size: 1.2em;
  }

  .mobile-install-button .button-subtitle {
    font-size: 0.75em;
    opacity: 0.9;
    margin-top: 3px;
  }

  .mobile-button-visible {
    transform: translateY(0);
    bottom: 0;
    opacity: 1;
  }

  /* Buton tıklama animasyonu */
  .button-clicked {
    transform: scale(0.95);
    opacity: 0.9;
  }
  </style>
</body>

</html>
