<?php
// Hata ayıklama için
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Hatalar için log dosyası oluştur
$logFile = __DIR__ . '/debug_' . date('Y-m-d') . '.log';
function customLogError($message) {
    global $logFile;
    $time = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$time] $message" . PHP_EOL, FILE_APPEND);
}

// Önemli değişkenleri logla
customLogError("Sayfa yükleniyor: " . $_SERVER['REQUEST_URI']);
if(isset($_GET['id'])) {
    customLogError("Randevu ID: " . $_GET['id']);
}

require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/db.php';
require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/eral.php';
$settingsCheck = $DB->prepare("select * from settings where id=?");
$settingsCheck->execute(array('1'));
$settings = $settingsCheck->fetch(PDO::FETCH_ASSOC);
function id($text) {
    $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
    $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
    $text = strtolower(str_replace($find, $replace, $text));
    $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
    $text = trim(preg_replace('/\s+/', ' ', $text));
    $text = str_replace(' ', '', $text);

    return $text;
}
$cancelLimit = $settings['cancelLimit'];

// URL parametre kontrolü
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: /index.php');
    exit;
}

$rid= $_GET['id'];
$redirectCheck= $DB->prepare("SELECT * from redirect where url=? ORDER BY id DESC");
$redirectCheck->execute(array($rid));

// Randevu URL'si geçerli mi kontrolü
if ($redirectCheck->rowCount() === 0) {
    $redirectExistsError = true;
} else {
    $redirect = $redirectCheck->fetch(PDO::FETCH_ASSOC);

    // Randevu ID'si geçerli mi kontrolü
    if (!isset($redirect['appointment']) || empty($redirect['appointment'])) {
        $appointmentIdError = true;
    } else {
        $appointmentID = $redirect['appointment'];

        $appointmentCheck= $DB->prepare("SELECT * from appointments where id=?");
        $appointmentCheck->execute(array($appointmentID));

        // Randevu kaydı var mı kontrolü
        if ($appointmentCheck->rowCount() === 0) {
            $appointmentRecordError = true;
        } else {
            $appointment = $appointmentCheck->fetch(PDO::FETCH_ASSOC);
            $serviceID = $appointment['service'];
            $service = $appointment['service'];
            $providerID = $appointment['providerID'];
            $appDate = $appointment['appDate'];
            $startTime = $appointment['startTime'];
            $endTime = $appointment['endTime'];
            $member = $appointment['member'];
        }
    }
}




// Hata yoksa diğer sorguları yap
$serviceName = "";
$providerName = "";
$appMemberName = "";
$appMemberPhone = "";

if (!isset($redirectExistsError) && !isset($appointmentIdError) && !isset($appointmentRecordError)) {
    // İptal edilmiş randevu kontrolü
    $canceledCheck = $DB->prepare("SELECT * FROM canceled WHERE
                                  service = ? AND
                                  providerID = ? AND
                                  appDate = ? AND
                                  startTime = ? AND
                                  member = ?");
    $canceledCheck->execute(array($serviceID, $providerID, $appDate, $startTime, $member));

    if ($canceledCheck->rowCount() > 0) {
        $canceledError = true;
    }

    // Servis bilgileri
    $serviceCheck= $DB->prepare("SELECT * from services where id=?");
    $serviceCheck->execute(array($service));
    if ($serviceCheck->rowCount() > 0) {
        $service = $serviceCheck->fetch(PDO::FETCH_ASSOC);
        $serviceName = $service['serviceName'];
    } else {
        $serviceError = true;
    }

    // Personel bilgileri
    $providerCheck= $DB->prepare("SELECT * from provider where id=?");
    $providerCheck->execute(array($providerID));
    if ($providerCheck->rowCount() > 0) {
        $provider = $providerCheck->fetch(PDO::FETCH_ASSOC);
        $providerName = $provider['name'];
    } else {
        $providerError = true;
    }

    // Müşteri bilgileri
    $appMemberCheck= $DB->prepare("SELECT * from members where id=?");
    $appMemberCheck->execute(array($member));
    if ($appMemberCheck->rowCount() > 0) {
        $appMember = $appMemberCheck->fetch(PDO::FETCH_ASSOC);
        $appMemberName = $appMember['name'];
        $appMemberPhone = $appMember['phone'];
    } else {
        $memberError = true;
    }
}
?>


<!DOCTYPE html>
<html lang="tr">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?=$translations['appsuccess']?> - <?=$settings['siteName']?></title>
  <meta name="description" content="<?=$settings['siteDesc']?>">
  <meta name="keywords" content="<?=$settings['siteKeyword']?>">
  <!-- FontAwesome-cdn include -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
  <!-- Google fonts include -->
  <link href="https://fonts.googleapis.com/css2?family=Jost:wght@400;500;600;700;800&family=Lato&display=swap"
    rel="stylesheet">
  <!-- Bootstrap-css include -->
  <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
  <!-- Animate-css include -->
  <link rel="stylesheet" href="../assets/css/animate.min.css">
  <!-- Main-StyleSheet include -->
  <link rel="stylesheet" href="../assets/css/style.css">

  <link rel="stylesheet" href="../assets/css/intlTelInput.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/forms/select/select2.min.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/forms/select/select2.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/plugins/forms/pickers/form-flat-pickr.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/calendars/fullcalendar.min.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/pages/app-calendar.css">
  <link rel="stylesheet" type="text/css"
    href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/plugins/forms/form-validation.css">

  <style>
  .iti__flag {
    background-image: url("../assets/images/flags/flags.png");
  }

  @media (-webkit-min-device-pixel-ratio: 2),
  (min-resolution: 192dpi) {
    .iti__flag {
      background-image: url("../assets/images/flags/flags@2x.png");
    }
  }

  .select2-container .select2-selection--single {
    height: 50px;
  }

  .select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 45px;
  }

  .custom-options-checkable .custom-option-item {
    width: 100%;
    cursor: pointer;
    border-radius: 0.42rem;
    color: #82868b;
    background-color: rgba(130, 134, 139, 0.06);
    border: 1px solid #ebe9f1;
  }

  .custom-options-checkable .custom-option-item .custom-option-item-title {
    color: #82868b;
  }

  .custom-option-item-check {
    position: absolute;
    clip: rect(0, 0, 0, 0);
  }

  .custom-option-item-check:checked+.custom-option-item,
  .custom-option-item.active {
    color: #ff950e;
    background-color: rgba(255, 149, 14, 0.12);
    border-color: #ff950e;
    box-shadow: 0 0 5px rgba(255, 149, 14, 0.5);
  }

  .custom-option-item-check:checked+.custom-option-item .custom-option-item-title,
  .custom-option-item.active .custom-option-item-title {
    color: #ff950e;
  }

  .custom-option-item-check:checked+.custom-option-item span,
  .custom-option-item.active span {
    color: #ff950e;
    font-weight: bold;
  }

  .custom-option-item-check-provider {
    position: absolute;
    clip: rect(0, 0, 0, 0);
  }

  .custom-option-item-check-provider:checked+.custom-option-item {
    color: #ff950e;
    background-color: rgba(255, 149, 14, 0.12);
    border-color: #ff950e;
  }

  .custom-option-item-check-provider:checked+.custom-option-item .custom-option-item-title {
    color: #ff950e;
  }

  .custom-option-item {
    transition: all 0.2s ease;
    padding: 10px 5px !important;
    cursor: pointer;
  }

  .custom-option-item:hover {
    background-color: rgba(255, 149, 14, 0.08);
    border-color: rgba(255, 149, 14, 0.5);
  }

  .flatpickr-calendar .flatpickr-day.selected,
  .flatpickr-calendar .flatpickr-day.selected:hover {
    background: #ff950e;
    color: #fff;
    border-color: #ff950e;
  }

  .flatpickr-calendar .flatpickr-day.today {
    border-color: #ff950e;
  }

  .invalid {
    border-color: red;
  }

  .titleColor {
    background: -webkit-linear-gradient(top right, #ffaf15, #fe6300);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }

  label:after {
    display: none;
  }
  </style>

</head>
<script src="https://unpkg.com/feather-icons"></script>

<body>
  <div class="wrapper position-relative overflow-hidden">
    <div class="container-md-fluid p-3 p-lg-0 me-5">
      <div class="row">
        <div class="col-xl-4">
          <div class="form_logo position-absolute">
            <a href="#">
              <img
                src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/images/logo/<?=$settings['siteLogo']?>"
                alt="image-not-found">
            </a>
          </div>
          <div class="steps_area step_area_fixed d-none d-xl-block">
            <div class="image_holder">
              <img class="overflow-hidden" src="../assets/images/background/bg_0.png" alt="image-not-found">
            </div>
            <div class="step_items position-absolute">
              <div class="step d-block text-center bg-white position-relative current active">1</div>
              <div class="step d-block text-center bg-white position-relative">2
              </div>
              <div class="step d-block text-center bg-white position-relative">3
              </div>
              <div class="step d-block text-center bg-white position-relative last">4
              </div>
            </div>

          </div>
        </div>
        <div class="col-xl-7 ps-5 pt-5">
          <?php if(isset($redirectExistsError) || isset($appointmentIdError) || isset($appointmentRecordError) || isset($serviceError) || isset($providerError) || isset($memberError) || isset($canceledError)){?>
          <form class="multisteps_form" id="wizard" method="POST" action="../success.php">
            <!-- ------------------ Step-1 ------------------- -->
            <div class="multisteps_form_panel" style="display: block;">
              <div class="step_content d-flex justify-content-between pt-5 pb-2">
                <h4><?=$translations['sitetitle']?></h4>
                <span class="text-end text-uppercase"><?=$translations['update']?></span>
              </div>
              <div class="step_progress_bar">
                <div class="progress rounded-pill">
                  <div class="progress-bar" style="width: 100%"></div>
                </div>
              </div>
              <style>
              .musteri {
                padding: 10px;
              }

              .musteriB {
                border-radius: 0.525rem;
              }
              </style>
              <div class="form_content">
                <div class="question_title py-5">
                  <h1 class="text-capitalize"><?=$translations['appupdate']?></h1>
                </div>
                <?php if(isset($canceledError)){ ?>
                <h3 class="titleColor" style="color: #ff5252 !important;">Bu randevu daha önce iptal edilmiştir</h3><br>
                <?php } else { ?>
                <h3 class="titleColor"><?=$translations['appupdatenotfound']?></h3><br>
                <?php } ?>
                <div class="form_btn pt-5 d-flex justify-content-between">

                  <a href="../index.php"><button type="button"
                      class="next_btn text-uppercase text-white"><?=$translations['newappointment']?> <span><i
                          class="fas fa-arrow-right"></i></span></button></a>
                </div>
              </div>
            </div>
          </form>
          <?php }else{?>
          <?php
                    $baslangic     = strtotime(date('Y/m/d H').':00:00');
                    $bitis     = strtotime(''.$appDate.''.$startTime.'');
                    $fark        = abs($bitis-$baslangic);
                    $kalansaat = $fark/60/60;

                    $baslangicgun=date('Y-m-d');
                    $bitisgun= date("Y-m-d",strtotime($appDate));
                    ?>

          <?php if(strtotime($baslangicgun)>strtotime($bitisgun)){ ?>
          <form class="multisteps_form" id="wizard" method="POST" action="success.php">
            <!-- ------------------ Step-1 ------------------- -->
            <div class="multisteps_form_panel" style="display: block;">
              <div class="step_content d-flex justify-content-between pt-5 pb-2">
                <h4><?=$translations['sitetitle']?></h4>
                <span class="text-end text-uppercase"><?=$translations['update']?></span>
              </div>
              <div class="step_progress_bar">
                <div class="progress rounded-pill">
                  <div class="progress-bar" style="width: 100%"></div>
                </div>
              </div>
              <style>
              .musteri {
                padding: 10px;
              }

              .musteriB {
                border-radius: 0.525rem;
              }
              </style>
              <div class="form_content">
                <div class="question_title py-5">
                  <h1 class="text-capitalize"><?=$translations['appupdate']?></h1>
                </div>
                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['perfonelinfo']?></h3><br>
                    <h5 id="OzetAdSoyad"><?=$appMemberName?></h5>
                    <h5 id="OzetTelefon"><?=$appMemberPhone?></h5>
                  </div>

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['serviceinfo']?></h3><br>
                    <h5 id="OzetHizmetAd"><?=$serviceName?></h5>
                    <h5 id="OzetCalisanAd"><?=$providerName?></h5>
                  </div>

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['appointmentinfo']?></h3><br>
                    <h5 id="OzetTarih"><?=date("d.m.Y",strtotime($appDate))?></h5>
                    <h5 id="OzetSaat"><?=date("H:i",strtotime($startTime))?></h5>
                  </div>

                </div>
                <h3 style="margin-top:30px" class="titleColor"><?=$translations['appupdatedate']?><br>
                  <?=$translations['appupdatethanks']?></h3><br>
              </div>
            </div>
          </form>
          <?php }else{ ?>
          <?php if($kalansaat>=$cancelLimit){ ?>
          <form class="multisteps_form" id="wizard" method="POST" action="success.php">
            <!-- ------------------ Step-1 ------------------- -->
            <div class="multisteps_form_panel" style="display: block;">
              <div class="step_content d-flex justify-content-between pt-5 pb-2">

                <h4><?=$translations['sitetitle']?>x</h4>
                <span class="text-end text-uppercase"><?=$translations['update']?></span>
              </div>
              <div class="step_progress_bar">
                <div class="progress rounded-pill">
                  <div class="progress-bar" style="width: 100%"></div>
                </div>
              </div>
              <style>
              .musteri {
                padding: 10px;
              }

              .musteriB {
                border-radius: 0.525rem;
              }
              </style>


              <div class="form_content">
                <div class="question_title py-5">
                  <h1 class="text-capitalize"><?=$translations['appupdate']?></h1>
                </div>
                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['perfonelinfo']?></h3><br>
                    <h5 id="OzetAdSoyad"><?=$appMemberName?></h5>
                    <h5 id="OzetTelefon"><?=$appMemberPhone?></h5>
                  </div>

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['serviceinfo']?></h3><br>
                    <h5 id="OzetHizmetAd"><?=$serviceName?></h5>
                    <h5 id="OzetCalisanAd"><?=$providerName?></h5>
                  </div>


                  <div class="col">
                    <h3 class="titleColor"><?=$translations['appointmentinfo']?></h3><br>
                    <h5 id="OzetTarih"><?=date("d.m.Y",strtotime($appDate))?></h5>
                    <h5 id="OzetSaat"><?=date("H:i",strtotime($startTime))?></h5>
                  </div>

                </div>
                <div style="margin-top:20px" class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                  <h4 class="titleColor"><?=$translations['newappdate']?></h4><br>
                  <div class="col-12">
                    <div class="mb-1 position-relative">
                      <input type="text" class="form-control" id="start-date" name="start-date"
                        placeholder="<?=$translations['newappdate']?>" />
                    </div>
                  </div>
                  <div style="margin-top:15px"></div>
                  <div class="col-12">
                    <div class="mb-1">
                      <div id="timeSelectContainer">
                        <div class="row custom-options-checkable g-1" id="timeSelect"
                          style="min-height: 100px; border: 1px solid #eee; border-radius: 5px; padding: 10px;">
                          <div class="col-12 text-center p-4">
                            <p class="text-muted mb-0">Lütfen önce bir tarih seçin, ardından uygun saatler burada
                              görüntülenecektir.</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <!-- Seçilen saatin değerini tutmak için gizli input -->
                  <input type="hidden" id="selectedTimeInput" name="selectedTime" value="">
                </div>
              </div>
              <input type="hidden" name="randevuGuncelle" value="1">
              <input type="hidden" name="randevuR" value="<?=$_GET['id']?>">
              <input type="hidden" name="rDuzenle" value="1">
              <input type="hidden" name="smsSendSystem" value="1">


              <div class="form_btn pt-5 d-flex">
                <button id="randevuGuncelle" type="button" class="next_btn text-uppercase text-white"><i
                    style="margin-right:5px;color: green;"
                    class="fas fa-sync-alt"></i><?=$translations['updatebutton']?>
                  <span></span></button>
                <button onclick="return iptal('<?php echo $rid; ?>')" type="button"
                  class="next_btn text-uppercase text-white"><i style="margin-right:5px;color: red;"
                    class="far fa-window-close"></i><?=$translations['appcancel']?>
                  <span></span></button>
              </div>
            </div>

          </form>
          <?php }else{?>
          <form class="multisteps_form" id="wizard" method="POST" action="success.php">
            <!-- ------------------ Step-1 ------------------- -->
            <div class="multisteps_form_panel" style="display: block;">
              <div class="step_content d-flex justify-content-between pt-5 pb-2">
                <h4><?=$translations['sitetitle']?></h4>
                <span class="text-end text-uppercase"><?=$translations['update']?></span>
              </div>
              <div class="step_progress_bar">
                <div class="progress rounded-pill">
                  <div class="progress-bar" style="width: 100%"></div>
                </div>
              </div>
              <style>
              .musteri {
                padding: 10px;
              }

              .musteriB {
                border-radius: 0.525rem;
              }
              </style>
              <div class="form_content">
                <div class="question_title py-5">
                  <h1 class="text-capitalize"><?=$translations['appupdate']?></h1>
                </div>
                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['perfonelinfo']?></h3><br>
                    <h5 id="OzetAdSoyad"><?=$appMemberName?></h5>
                    <h5 id="OzetTelefon"><?=$appMemberPhone?></h5>
                  </div>

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['serviceinfo']?></h3><br>
                    <h5 id="OzetHizmetAd"><?=$serviceName?></h5>
                    <h5 id="OzetCalisanAd"><?=$providerName?></h5>
                  </div>

                  <div class="col">
                    <h3 class="titleColor"><?=$translations['appointmentinfo']?></h3><br>
                    <h5 id="OzetTarih"><?=date("d.m.Y",strtotime($appDate))?></h5>
                    <h5 id="OzetSaat"><?=date("H:i",strtotime($startTime))?></h5>
                  </div>

                </div>
                <h3 style="margin-top:30px" class="titleColor"><?=$translations['appdatelast']?> <?=$kalansaat?>
                  <?=$translations['appdatelast2']?><br> <?=$translations['appdatelast3']?> <?=$cancelLimit?>
                  <?=$translations['appdatelast4']?></h3><br>
              </div>
            </div>
          </form>
          <?php }?>
          <?php }?>
          <?php }?>
        </div>
      </div>
    </div>
  </div>

  <!-- jQuery-js include -->
  <script src="../assets/js/jquery-3.6.0.min.js"></script>
  <!-- Bootstrap-js include -->
  <script src="../assets/js/bootstrap.min.js"></script>
  <!-- jQuery-validate-js include -->
  <script src="../assets/js/jquery.validate.min.js"></script>
  <!-- Custom-js include -->
  <script src="../assets/js/script.js"></script>
  <script src="../assets/js/intlTelInput.js"></script>
  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/forms/select/select2.full.min.js">
  </script>
  <script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/scripts/forms/form-wizard.js">
  </script>

  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js">
  </script>
  <!-- Pickadate temel kütüphanesi -->
  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/pickadate/picker.js">
  </script>

  <!-- Pickadate zaman/saat picker -->
  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/pickadate/picker.time.js">
  </script>

  <!-- Form pickers script - hata düzeltmesi ile -->
  <script>
    $(function() {
      // form-pickers.js içindeki pickadate fonksiyonu çağrısını düzeltiyoruz
      // Elemanların var olduğundan emin olalım ve sonra fonksiyonu çağıralım
      if (typeof $.fn.pickadate === 'function') {
        // Pickadate fonksiyonu varsa çalıştır
        if ($('.pickadate').length) {
          $('.pickadate').pickadate();
        }
      } else {
        console.log("pickadate fonksiyonu yüklenmemiş, atlıyoruz");
      }
      
      // Benzer şekilde diğer picker fonksiyonlarını kontrol et
      if (typeof $.fn.flatpickr === 'function') {
        if ($('.flatpickr-basic').length) {
          $('.flatpickr-basic').flatpickr();
        }
      }
    });
  </script>

  <!-- FullCalendar kütüphanesi -->
  <script
    src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/calendar/fullcalendar.min.js">
  </script>
  
  <!-- Tarih seçici ve FullCalendar için düzeltme scripti -->
  <script>
  $(document).ready(function() {
    // Tarih seçiciyi başlat - randevu.php için düzeltme
    var startDateEl = document.getElementById('start-date');
    if (startDateEl && typeof flatpickr !== 'undefined') {
      console.log('Flatpickr başlatılıyor...');
      
      // Başlangıç değeri olarak bugünü ayarla
      var today = new Date();
      var formattedDate = today.getFullYear() + '-' +
        String(today.getMonth() + 1).padStart(2, '0') + '-' +
        String(today.getDate()).padStart(2, '0');
      
      // Önce flatpickr'ı başlat
      var flatpickrInstance = flatpickr(startDateEl, {
        dateFormat: "Y-m-d",
        minDate: "today",
        disableMobile: "true",
        clickOpens: true,
        allowInput: false,
        altInput: true,
        altFormat: "d F Y", // Gün Ay_Adı Yıl formatında (ör: 19 Nisan 2025)
        locale: {
          firstDayOfWeek: 1, // Start with Monday
          weekdays: {
            longhand: [
              "Pazar", "Pazartesi", "Salı", "Çarşamba",
              "Perşembe", "Cuma", "Cumartesi"
            ],
            shorthand: ["Paz", "Pzt", "Sal", "Çar", "Per", "Cum", "Cmt"],
          },
          months: {
            longhand: [
              "Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran",
              "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"
            ],
            shorthand: [
              "Oca", "Şub", "Mar", "Nis", "May", "Haz",
              "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"
            ],
          },
          today: "Bugün",
          clear: "Temizle",
        },
        onChange: function(selectedDates, dateStr, instance) {
          console.log("Tarih değiştirildi:", dateStr);
          loadTimes(dateStr);
        },
        onOpen: function(selectedDates, dateStr, instance) {
          console.log("Flatpickr takvimi açıldı");
        },
        onClose: function(selectedDates, dateStr, instance) {
          console.log("Flatpickr takvimi kapandı, seçilen tarih:", dateStr);
        }
      });
      
      // Sonra bugünün tarihini ayarla
      flatpickrInstance.setDate(formattedDate);
      
      // Tarih alanına tıklandığında takvimi aç
      $(startDateEl).on('click', function() {
        flatpickrInstance.open();
      });
      
      // Otomatik olarak saatleri yükle
      setTimeout(function() {
        loadTimes(formattedDate);
      }, 500);
    } else {
      console.error("Flatpickr veya tarih alanı bulunamadı!");
    }
    
    // FullCalendar için güvenli başlatma
    try {
      if ($("#calendar").length) {
        var calendarEl = document.getElementById('calendar');
        if (calendarEl) {
          var calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth'
          });
          calendar.render();
        }
      }
    } catch (e) {
      console.log("FullCalendar başlatma hatası:", e);
    }
  });
  </script>

  <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
  $("#randevuGuncelle").click(function() {
    if ($('#start-date').val() == '') {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "<?=$translations['pleasenewappdate']?>",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"

      });
    } else if ($(".custom-option-item-check:checked").val() == undefined) {
      Swal.fire({
        title: "<?=$translations['error']?>",
        text: "<?=$translations['pleasenewapptime']?>",
        icon: 'error',
        confirmButtonColor: '#7367f0',
        confirmButtonText: "<?=$translations['okey']?>"

      });
    } else {
      // Seçilen saati ve diğer değerleri alıyoruz
      var selectedTime = $(".custom-option-item-check:checked").val();
      var selectedDate = $('#start-date').val();
      var urlId = "<?=$_GET['id']?>";

      console.log("Randevu güncellemesi - Seçilen tarih: " + selectedDate + ", Saat: " + selectedTime);

      // Çok basit bir yaklaşım deneyelim - İptal işlemine benzer direkt AJAX
      console.log("AJAX isteği doğrudan params ile gönderiliyor...");

      // Farkı tüm parametreleri tek seferde gönderelim
      var data = "randevuR=" + urlId +
        "&rDuzenle=1" +
        "&start-date=" + selectedDate +
        "&selectedTime=" + selectedTime +
        "&forceWhatsapp=1" + // Zorla WhatsApp bildirimi
        "&debug=1" +
        "&directWebUpdate=1"; // Ek kontrol parametresi

      console.log("Form data:", data);

      // AJAX isteğini gönder (XML Http Request stili) - Debug modunda
      $.ajax({
        url: '/admin/system/settings/eral.php',
        type: "POST",
        data: data,
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function(response) {
          console.log("Güncelleme yanıtı:", response);

          // Yanıt içeriğini göster (Debug)
          Swal.fire({
            title: "Sunucu Yanıtı",
            html: '<pre>' + response + '</pre>',
            icon: 'info',
            confirmButtonColor: '#7367f0',
            confirmButtonText: "Tamam"
          });

          // Normal kontrolü devre dışı bırak

          if (response && response.indexOf('varvar') !== -1) {
            Swal.fire({
              title: "<?=$translations['sorry']?>",
              text: "<?=$translations['otherselect']?>",
              icon: 'error',
              confirmButtonColor: '#7367f0',
              confirmButtonText: "<?=$translations['okey']?>"
            }).then((result) => {
              location.reload();
            });
          } else {
            location.href = "../rsuccess.php";
          }

        }

      });

    }

  });
  </script>

  <script>
  // Telefon input elemanını kontrol ederek intlTelInput'u başlat
  $(document).ready(function() {
    var input = document.querySelector("#musteriTelefon");
    if (input && typeof window.intlTelInput === 'function') {
      window.intlTelInput(input, {
        initialCountry: 'tr',
        separateDialCode: true,
      });
    } else {
      console.log("intlTelInput için gerekli eleman veya fonksiyon bulunamadı");
    }
  });
  </script>
  <script>
  feather.replace()
  </script>

  <script>
  // Global değişkenler
  var providerID = '<?=$providerID?>';
  var hizmetID = '<?=$serviceID?>';

  // Saatleri yükleme fonksiyonu
  function loadTimes(date) {
    console.log("loadTimes fonksiyonu çağrıldı: " + date);
    var timeSelect = document.getElementById('timeSelect');

    if (!timeSelect) {
      console.error("timeSelect elementi bulunamadı!");
      return;
    }

    // Yükleniyor göster
    timeSelect.innerHTML =
      '<div class="col-12 text-center"><i class="fas fa-spinner fa-spin"></i> Saatler yükleniyor...</div>';

    // AJAX parametrelerini kontrol et
    if (!date || !providerID || !hizmetID) {
      console.error("HATA: AJAX için gerekli parametreler eksik!", {
        date: date,
        providerID: providerID,
        hizmetID: hizmetID
      });

      timeSelect.innerHTML =
        '<div class="col-12 text-center text-danger">Parametre hatası! Lütfen sayfayı yenileyin.</div>';
      return;
    }

    // Uygun saatleri yükle
    loadAvailableTimes(date, []);
  }

  // Uygun randevu saatlerini yükleme fonksiyonu
  function loadAvailableTimes(date, unavailableHours) {
    var timeSelect = document.getElementById('timeSelect');

    console.log("Randevu saatleri yükleniyor:", {
      date: date,
      providerID: providerID,
      hizmetID: hizmetID
    });

    // AJAX isteği
    $.ajax({
      type: 'POST',
      url: '../admin/system/ajax/AvailableTimeAjax.php',
      data: {
        date: date,
        providerID: providerID,
        hizmet: hizmetID,
        unavailableHours: JSON.stringify(unavailableHours || []),
        client_debug: "true"
      },
      success: function(response) {
        console.log("AJAX başarılı, yanıt alındı");

        // HTML içeriğini ayarla
        timeSelect.innerHTML = response;

        // Saat butonlarını işlevsel hale getir
        setupTimeButtons();
      },
      error: function(xhr, status, error) {
        console.error("AJAX hatası:", error, "Durum:", status);
        timeSelect.innerHTML =
          '<div class="col-12 text-center text-danger">Saat bilgileri yüklenirken bir hata oluştu. <button type="button" class="btn btn-sm btn-outline-primary" id="retryTimes">Tekrar Dene</button></div>';

        var retryButton = document.getElementById('retryTimes');
        if (retryButton) {
          retryButton.addEventListener('click', function() {
            loadTimes(date);
          });
        }
      }
    });
  }

  // Saat butonlarını ayarla
  function setupTimeButtons() {
    var radioButtons = document.querySelectorAll('.custom-option-item-check');
    console.log(radioButtons.length + " adet saat seçeneği bulundu");

    radioButtons.forEach(function(radio) {
      radio.addEventListener('change', function() {
        // Seçimi güncelle
        var allLabels = document.querySelectorAll('.custom-option-item');
        allLabels.forEach(function(label) {
          label.classList.remove('active');
        });

        if (this.nextElementSibling) {
          this.nextElementSibling.classList.add('active');
        }

        // Seçilen saati güncelle
        var selectedTime = this.value;
        var hiddenInput = document.getElementById('selectedTimeInput');
        if (hiddenInput) {
          hiddenInput.value = selectedTime;
          console.log("Seçilen saat: " + selectedTime);
        }
      });
    });
  }

  // Sayfa yüklendikten sonra
  $(document).ready(function() {
    console.log("Sayfa yüklendi");
    console.log("ProviderID: " + providerID);
    console.log("HizmetID: " + hizmetID);
  });
  </script>

  <script>
  // Randevu iptal fonksiyonu
  iptal = function(val) {
    Swal.fire({
      icon: 'question',
      title: '<?=$translations['cancelquest']?>',
      text: "<?=$translations['cancelquesttext']?>",
      showDenyButton: true,
      confirmButtonText: '<?=$translations['yes']?>',
      confirmButtonColor: 'green',
      denyButtonText: `<?=$translations['no']?>`,
    }).then((result) => {
      if (result.isConfirmed) {
        var pID = val;
        $.ajax({
          url: '/admin/system/settings/eral.php', // Mutlak yol kullanıyoruz
          type: "POST",
          data: {
            randevuR: pID,
            rIptal: "1"
          },
          success: function(response) {
            console.log("İptal yanıtı:", response);
            location.href = "../risuccess.php";
          },
          error: function(xhr, status, error) {
            console.log("İptal hatası: ", error);
            console.log("İptal durum: ", status);
            console.log("İptal XHR: ", xhr);

            // Ama işlemin başarılı olduğunu tahmin ediyoruz,
            // 500 hatası olsa bile sunucu işlemi yapıyor olabilir
            if (xhr.status === 500) {
              console.log("500 hatası, ama iptal işlemi muhtemelen başarılı oldu");
              location.href = "../risuccess.php";
              return;
            }

            // Diğer hata durumlarında kullanıcıya bilgi ver
            Swal.fire({
              icon: 'error',
              title: '<?=$translations['error']?>',
              text: '<?=$translations['systemerror']?>',
              confirmButtonText: '<?=$translations['okey']?>'
            });
          }
        });
        return false;
      } else if (result.isDenied) {
        Swal.fire({
          icon: 'info',
          title: "<?=$translations['cancelnot']?>",
          confirmButtonText: '<?=$translations['okey']?>',
          confirmButtonColor: 'green',
        })
      }
    })
    return false;
  }
  </script>


</body>

</html>
